/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.List;
import javax.annotation.Nullable;
import org.glowroot.common.ChunkSource;
import org.glowroot.local.ui.ChunkedInputs;
import org.glowroot.local.ui.HttpService;
import org.glowroot.local.ui.HttpServices;
import org.glowroot.local.ui.TraceCommonService;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.netty.channel.ChannelFuture;
import org.glowroot.shaded.netty.channel.ChannelHandlerContext;
import org.glowroot.shaded.netty.handler.codec.http.DefaultFullHttpResponse;
import org.glowroot.shaded.netty.handler.codec.http.DefaultHttpResponse;
import org.glowroot.shaded.netty.handler.codec.http.FullHttpResponse;
import org.glowroot.shaded.netty.handler.codec.http.HttpHeaders;
import org.glowroot.shaded.netty.handler.codec.http.HttpRequest;
import org.glowroot.shaded.netty.handler.codec.http.HttpResponseStatus;
import org.glowroot.shaded.netty.handler.codec.http.HttpVersion;
import org.glowroot.shaded.netty.handler.codec.http.QueryStringDecoder;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

class TraceDetailHttpService
implements HttpService {
    private static final Logger logger = LoggerFactory.getLogger(TraceDetailHttpService.class);
    private final TraceCommonService traceCommonService;

    TraceDetailHttpService(TraceCommonService traceCommonService) {
        this.traceCommonService = traceCommonService;
    }

    @Override
    @Nullable
    public FullHttpResponse handleRequest(ChannelHandlerContext ctx, HttpRequest request) throws Exception {
        QueryStringDecoder decoder = new QueryStringDecoder(request.getUri());
        String path = decoder.path();
        String traceComponent = path.substring(path.lastIndexOf(47) + 1);
        List<String> traceIds = decoder.parameters().get("trace-id");
        Preconditions.checkNotNull(traceIds, "Missing trace id in query string: %s", request.getUri());
        String traceId = traceIds.get(0);
        logger.debug("handleRequest(): traceComponent={}, traceId={}", (Object)traceComponent, (Object)traceId);
        ChunkSource chunkSource = this.getDetailChunkSource(traceComponent, traceId);
        if (chunkSource == null) {
            return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
        }
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.headers().set("Transfer-Encoding", (Object)"chunked");
        response.headers().set("Content-Type", (Object)"application/json; charset=UTF-8");
        boolean keepAlive = HttpHeaders.isKeepAlive(request);
        if (keepAlive && !request.getProtocolVersion().isKeepAliveDefault()) {
            response.headers().set("Connection", (Object)"keep-alive");
        }
        HttpServices.preventCaching(response);
        ctx.write(response);
        ChannelFuture future = ctx.write(ChunkedInputs.from(chunkSource));
        HttpServices.addErrorListener(future);
        if (!keepAlive) {
            HttpServices.addCloseListener(future);
        }
        return null;
    }

    @Nullable
    private ChunkSource getDetailChunkSource(String traceComponent, String traceId) throws Exception {
        if (traceComponent.equals("entries")) {
            return this.traceCommonService.getEntries(traceId);
        }
        if (traceComponent.equals("profile")) {
            return this.traceCommonService.getProfile(traceId);
        }
        throw new IllegalStateException("Unexpected trace component: " + traceComponent);
    }
}

