/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.glowroot.collector.Trace;
import org.glowroot.common.ChunkSource;
import org.glowroot.local.ui.ChunkedInputs;
import org.glowroot.local.ui.HttpService;
import org.glowroot.local.ui.HttpServices;
import org.glowroot.local.ui.TraceCommonService;
import org.glowroot.local.ui.TraceExport;
import org.glowroot.shaded.google.common.base.Charsets;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.io.CharSource;
import org.glowroot.shaded.google.common.io.Resources;
import org.glowroot.shaded.google.common.net.MediaType;
import org.glowroot.shaded.netty.channel.ChannelFuture;
import org.glowroot.shaded.netty.channel.ChannelHandlerContext;
import org.glowroot.shaded.netty.handler.codec.http.DefaultFullHttpResponse;
import org.glowroot.shaded.netty.handler.codec.http.DefaultHttpResponse;
import org.glowroot.shaded.netty.handler.codec.http.FullHttpResponse;
import org.glowroot.shaded.netty.handler.codec.http.HttpContent;
import org.glowroot.shaded.netty.handler.codec.http.HttpHeaders;
import org.glowroot.shaded.netty.handler.codec.http.HttpRequest;
import org.glowroot.shaded.netty.handler.codec.http.HttpResponseStatus;
import org.glowroot.shaded.netty.handler.codec.http.HttpVersion;
import org.glowroot.shaded.netty.handler.stream.ChunkedInput;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

class TraceExportHttpService
implements HttpService {
    private static final Logger logger = LoggerFactory.getLogger(TraceExportHttpService.class);
    private final TraceCommonService traceCommonService;
    private final String version;

    TraceExportHttpService(TraceCommonService traceCommonService, String version) {
        this.traceCommonService = traceCommonService;
        this.version = version;
    }

    @Override
    @Nullable
    public FullHttpResponse handleRequest(ChannelHandlerContext ctx, HttpRequest request) throws Exception {
        String uri = request.getUri();
        String id = uri.substring(uri.lastIndexOf(47) + 1);
        logger.debug("handleRequest(): id={}", (Object)id);
        TraceExport export = this.traceCommonService.getExport(id);
        if (export == null) {
            logger.warn("no trace found for id: {}", (Object)id);
            return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
        }
        ChunkedInput<HttpContent> in = this.getExportChunkedInput(export);
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.headers().set("Transfer-Encoding", (Object)"chunked");
        response.headers().set("Content-Type", (Object)MediaType.ZIP.toString());
        response.headers().set("Content-Disposition", (Object)("attachment; filename=" + TraceExportHttpService.getFilename(export.trace()) + ".zip"));
        boolean keepAlive = HttpHeaders.isKeepAlive(request);
        if (keepAlive && !request.getProtocolVersion().isKeepAliveDefault()) {
            response.headers().set("Connection", (Object)"keep-alive");
        }
        HttpServices.preventCaching(response);
        ctx.write(response);
        ChannelFuture future = ctx.write(in);
        HttpServices.addErrorListener(future);
        if (!keepAlive) {
            HttpServices.addCloseListener(future);
        }
        return null;
    }

    private ChunkedInput<HttpContent> getExportChunkedInput(TraceExport export) throws IOException {
        ChunkSource chunkSource = this.render(export);
        return ChunkedInputs.fromChunkSourceToZipFileDownload(chunkSource, TraceExportHttpService.getFilename(export.trace()));
    }

    private ChunkSource render(TraceExport traceExport) throws IOException {
        String htmlStartTag = "<html>";
        String exportCssPlaceholder = "<link rel=\"stylesheet\" href=\"styles/export.css\">";
        String exportJsPlaceholder = "<script src=\"scripts/export.js\"></script>";
        String tracePlaceholder = "<script type=\"text/json\" id=\"traceJson\"></script>";
        String entriesPlaceholder = "<script type=\"text/json\" id=\"entriesJson\"></script>";
        String profilePlaceholder = "<script type=\"text/json\" id=\"profileJson\"></script>";
        String footerMessagePlaceholder = "<span id=\"footerMessage\"></span>";
        String templateContent = TraceExportHttpService.asCharSource("trace-export.html").read();
        Pattern pattern = Pattern.compile("(" + htmlStartTag + "|" + exportCssPlaceholder + "|" + exportJsPlaceholder + "|" + tracePlaceholder + "|" + entriesPlaceholder + "|" + profilePlaceholder + "|" + footerMessagePlaceholder + ")");
        Matcher matcher = pattern.matcher(templateContent);
        int curr = 0;
        ArrayList<ChunkSource> chunkSources = Lists.newArrayList();
        while (matcher.find()) {
            chunkSources.add(ChunkSource.wrap(templateContent.substring(curr, matcher.start())));
            curr = matcher.end();
            String match = matcher.group();
            if (match.equals(htmlStartTag)) {
                chunkSources.add(ChunkSource.wrap("<!-- saved from url=(0014)about:internet -->\r\n<html>"));
                continue;
            }
            if (match.equals(exportCssPlaceholder)) {
                chunkSources.add(ChunkSource.wrap("<style>"));
                chunkSources.add(TraceExportHttpService.asChunkSource("styles/export.css"));
                chunkSources.add(ChunkSource.wrap("</style>"));
                continue;
            }
            if (match.equals(exportJsPlaceholder)) {
                chunkSources.add(ChunkSource.wrap("<script>"));
                chunkSources.add(TraceExportHttpService.asChunkSource("scripts/export.js"));
                chunkSources.add(ChunkSource.wrap("</script>"));
                continue;
            }
            if (match.equals(tracePlaceholder)) {
                chunkSources.add(ChunkSource.wrap("<script type=\"text/json\" id=\"traceJson\">"));
                chunkSources.add(ChunkSource.wrap(traceExport.traceJson()));
                chunkSources.add(ChunkSource.wrap("</script>"));
                continue;
            }
            if (match.equals(entriesPlaceholder)) {
                chunkSources.add(ChunkSource.wrap("<script type=\"text/json\" id=\"entriesJson\">"));
                ChunkSource entries = traceExport.entries();
                if (entries != null) {
                    chunkSources.add(entries);
                }
                chunkSources.add(ChunkSource.wrap("</script>"));
                continue;
            }
            if (match.equals(profilePlaceholder)) {
                chunkSources.add(ChunkSource.wrap("<script type=\"text/json\" id=\"profileJson\">"));
                ChunkSource profile = traceExport.profile();
                if (profile != null) {
                    chunkSources.add(profile);
                }
                chunkSources.add(ChunkSource.wrap("</script>"));
                continue;
            }
            if (match.equals(footerMessagePlaceholder)) {
                chunkSources.add(ChunkSource.wrap("Glowroot version " + this.version));
                continue;
            }
            logger.error("unexpected match: {}", (Object)match);
        }
        chunkSources.add(ChunkSource.wrap(templateContent.substring(curr)));
        return ChunkSource.concat(chunkSources);
    }

    private static String getFilename(Trace trace) {
        return "trace-" + new SimpleDateFormat("yyyyMMdd-HHmmss-SSS").format(trace.startTime());
    }

    private static ChunkSource asChunkSource(String exportResourceName) {
        return ChunkSource.from(TraceExportHttpService.asCharSource(exportResourceName));
    }

    private static CharSource asCharSource(String exportResourceName) {
        URL url = Resources.getResource("org/glowroot/local/ui/export-dist/" + exportResourceName);
        return Resources.asCharSource(url, Charsets.UTF_8);
    }
}

