/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.TransactionJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Doubles;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
final class TransactionDataRequest
extends TransactionJsonService.TransactionDataRequestBase {
    private final long from;
    private final long to;
    private final String transactionType;
    @Nullable
    private final String transactionName;
    private final ImmutableList<Double> percentile;

    private TransactionDataRequest(long from, long to, String transactionType, @Nullable String transactionName, ImmutableList<Double> percentile) {
        this.from = from;
        this.to = to;
        this.transactionType = transactionType;
        this.transactionName = transactionName;
        this.percentile = percentile;
    }

    @Override
    @JsonProperty(value="from")
    public long from() {
        return this.from;
    }

    @Override
    @JsonProperty(value="to")
    public long to() {
        return this.to;
    }

    @Override
    @JsonProperty(value="transactionType")
    public String transactionType() {
        return this.transactionType;
    }

    @Override
    @JsonProperty(value="transactionName")
    public String transactionName() {
        return this.transactionName;
    }

    @Override
    @JsonProperty(value="percentile")
    public ImmutableList<Double> percentile() {
        return this.percentile;
    }

    public final TransactionDataRequest withFrom(long value) {
        if (this.from == value) {
            return this;
        }
        long newValue = value;
        return new TransactionDataRequest(newValue, this.to, this.transactionType, this.transactionName, this.percentile);
    }

    public final TransactionDataRequest withTo(long value) {
        if (this.to == value) {
            return this;
        }
        long newValue = value;
        return new TransactionDataRequest(this.from, newValue, this.transactionType, this.transactionName, this.percentile);
    }

    public final TransactionDataRequest withTransactionType(String value) {
        if (this.transactionType == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new TransactionDataRequest(this.from, this.to, newValue, this.transactionName, this.percentile);
    }

    public final TransactionDataRequest withTransactionName(@Nullable String value) {
        if (this.transactionName == value) {
            return this;
        }
        String newValue = value;
        return new TransactionDataRequest(this.from, this.to, this.transactionType, newValue, this.percentile);
    }

    public final TransactionDataRequest withPercentile(double ... elements) {
        ImmutableList<Double> newValue = ImmutableList.copyOf(Doubles.asList(elements));
        return new TransactionDataRequest(this.from, this.to, this.transactionType, this.transactionName, newValue);
    }

    public final TransactionDataRequest withPercentile(Iterable<Double> elements) {
        if (this.percentile == elements) {
            return this;
        }
        ImmutableList<Double> newValue = ImmutableList.copyOf(elements);
        return new TransactionDataRequest(this.from, this.to, this.transactionType, this.transactionName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof TransactionDataRequest && this.equalTo((TransactionDataRequest)another);
    }

    private boolean equalTo(TransactionDataRequest another) {
        return this.from == another.from && this.to == another.to && this.transactionType.equals(another.transactionType) && Objects.equal(this.transactionName, another.transactionName) && this.percentile.equals(another.percentile);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode(this.from);
        h = h * 17 + Longs.hashCode(this.to);
        h = h * 17 + this.transactionType.hashCode();
        h = h * 17 + Objects.hashCode(this.transactionName);
        h = h * 17 + this.percentile.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TransactionDataRequest").add("from", this.from).add("to", this.to).add("transactionType", this.transactionType).add("transactionName", this.transactionName).add("percentile", this.percentile).toString();
    }

    @JsonCreator
    public static TransactionDataRequest fromAllAttributes(@JsonProperty(value="from") @Nullable Long from, @JsonProperty(value="to") @Nullable Long to, @JsonProperty(value="transactionType") @Nullable String transactionType, @JsonProperty(value="transactionName") @Nullable String transactionName, @JsonProperty(value="percentile") @Nullable ImmutableList<Double> percentile) {
        Builder builder = TransactionDataRequest.builder();
        if (from != null) {
            builder.from(from);
        }
        if (to != null) {
            builder.to(to);
        }
        if (transactionType != null) {
            builder.transactionType(transactionType);
        }
        if (transactionName != null) {
            builder.transactionName(transactionName);
        }
        if (percentile != null) {
            builder.addAllPercentile(percentile);
        }
        return builder.build();
    }

    static TransactionDataRequest copyOf(TransactionJsonService.TransactionDataRequestBase instance) {
        if (instance instanceof TransactionDataRequest) {
            return (TransactionDataRequest)instance;
        }
        return TransactionDataRequest.builder().all(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 7L;
        private static final long INITIALIZED_BIT_FROM = 1L;
        private static final long INITIALIZED_BIT_TO = 2L;
        private static final long INITIALIZED_BIT_TRANSACTION_TYPE = 4L;
        private long initializedBitset;
        private long from;
        private long to;
        @Nullable
        private String transactionType;
        @Nullable
        private String transactionName;
        private ImmutableList.Builder<Double> percentileBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder all(TransactionJsonService.TransactionDataRequestBase instance) {
            Preconditions.checkNotNull(instance);
            this.from(instance.from());
            this.to(instance.to());
            this.transactionType(instance.transactionType());
            String transactionNameValue = instance.transactionName();
            if (transactionNameValue != null) {
                this.transactionName(transactionNameValue);
            }
            this.addAllPercentile(instance.percentile());
            return this;
        }

        public final Builder from(long from) {
            this.from = from;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder to(long to) {
            this.to = to;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder transactionType(String transactionType) {
            this.transactionType = Preconditions.checkNotNull(transactionType);
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder transactionName(@Nullable String transactionName) {
            this.transactionName = transactionName;
            return this;
        }

        public final Builder addPercentile(double element) {
            this.percentileBuilder.add((Object)element);
            return this;
        }

        public final Builder addPercentile(double ... elements) {
            this.percentileBuilder.addAll(Doubles.asList(elements));
            return this;
        }

        public final Builder percentile(Iterable<Double> elements) {
            this.percentileBuilder = ImmutableList.builder();
            return this.addAllPercentile(elements);
        }

        public final Builder addAllPercentile(Iterable<Double> elements) {
            this.percentileBuilder.addAll((Iterable)elements);
            return this;
        }

        public TransactionDataRequest build() {
            this.checkRequiredAttributes();
            return new TransactionDataRequest(this.from, this.to, this.transactionType, this.transactionName, (ImmutableList)this.percentileBuilder.build());
        }

        private boolean fromIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean toIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean transactionTypeIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 7L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.fromIsSet()) {
                attributes.add("from");
            }
            if (!this.toIsSet()) {
                attributes.add("to");
            }
            if (!this.transactionTypeIsSet()) {
                attributes.add("transactionType");
            }
            return "Cannot build TransactionDataRequest, some of required attributes are not set " + attributes;
        }
    }
}

