/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.glowroot.collector.Aggregate;
import org.glowroot.collector.AggregateTimer;
import org.glowroot.collector.LazyHistogram;
import org.glowroot.collector.QueryComponent;
import org.glowroot.collector.TransactionSummary;
import org.glowroot.common.Clock;
import org.glowroot.common.ObjectMappers;
import org.glowroot.local.store.AggregateDao;
import org.glowroot.local.store.AlertingService;
import org.glowroot.local.store.QueryResult;
import org.glowroot.local.store.TraceDao;
import org.glowroot.local.store.TransactionSummaryQuery;
import org.glowroot.local.ui.AggregateMerging;
import org.glowroot.local.ui.DataSeries;
import org.glowroot.local.ui.DataSeriesHelper;
import org.glowroot.local.ui.FlameGraphRequest;
import org.glowroot.local.ui.GET;
import org.glowroot.local.ui.JsonService;
import org.glowroot.local.ui.PercentileMergedAggregate;
import org.glowroot.local.ui.Query;
import org.glowroot.local.ui.QueryStrings;
import org.glowroot.local.ui.ThreadInfoAggregate;
import org.glowroot.local.ui.TimerMergedAggregate;
import org.glowroot.local.ui.TransactionCommonService;
import org.glowroot.local.ui.TransactionDataRequest;
import org.glowroot.local.ui.TransactionProfileRequest;
import org.glowroot.local.ui.TransactionSummaryRequest;
import org.glowroot.shaded.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.shaded.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.shaded.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.glowroot.shaded.google.common.annotations.VisibleForTesting;
import org.glowroot.shaded.google.common.base.Function;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.Maps;
import org.glowroot.shaded.google.common.collect.Ordering;
import org.glowroot.shaded.google.common.io.CharStreams;
import org.glowroot.shaded.google.common.primitives.Longs;
import org.glowroot.transaction.TransactionCollector;
import org.glowroot.transaction.TransactionRegistry;
import org.glowroot.transaction.model.ProfileNode;
import org.glowroot.transaction.model.Transaction;
import org.immutables.value.Value;

@JsonService
class TransactionJsonService {
    private static final ObjectMapper mapper = ObjectMappers.create();
    private static final double MICROSECONDS_PER_MILLISECOND = 1000.0;
    private final TransactionCommonService transactionCommonService;
    private final TraceDao traceDao;
    private final TransactionRegistry transactionRegistry;
    private final TransactionCollector transactionCollector;
    private final Clock clock;
    private final long fixedAggregateIntervalMillis;
    private final long fixedAggregateRollupMillis;

    TransactionJsonService(TransactionCommonService transactionCommonService, TraceDao traceDao, TransactionRegistry transactionRegistry, TransactionCollector transactionCollector, Clock clock, long fixedAggregateIntervalSeconds, long fixedAggregateRollupSeconds) {
        this.transactionCommonService = transactionCommonService;
        this.traceDao = traceDao;
        this.transactionRegistry = transactionRegistry;
        this.transactionCollector = transactionCollector;
        this.clock = clock;
        this.fixedAggregateIntervalMillis = fixedAggregateIntervalSeconds * 1000L;
        this.fixedAggregateRollupMillis = fixedAggregateRollupSeconds * 1000L;
    }

    @GET(value="/backend/transaction/percentiles")
    String getPercentiles(String queryString) throws Exception {
        TransactionDataRequest request = QueryStrings.decode(queryString, TransactionDataRequest.class);
        long liveCaptureTime = this.clock.currentTimeMillis();
        List<Aggregate> aggregates = this.transactionCommonService.getAggregates(request.transactionType(), request.transactionName(), request.from(), request.to(), liveCaptureTime);
        List<DataSeries> dataSeriesList = this.getDataSeriesForPercentileChart(request, aggregates, request.percentile());
        Map<Long, Long> transactionCounts = this.getTransactionCounts(aggregates);
        if (!aggregates.isEmpty() && aggregates.get(0).captureTime() == request.from()) {
            aggregates = aggregates.subList(1, aggregates.size());
        }
        PercentileMergedAggregate mergedAggregate = AggregateMerging.getPercentileMergedAggregate(aggregates, request.percentile());
        StringBuilder sb = new StringBuilder();
        JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter(sb));
        jg.writeStartObject();
        jg.writeObjectField("dataSeries", dataSeriesList);
        jg.writeObjectField("transactionCounts", transactionCounts);
        jg.writeObjectField("mergedAggregate", mergedAggregate);
        jg.writeEndObject();
        jg.close();
        return sb.toString();
    }

    private Map<Long, Long> getTransactionCounts(List<Aggregate> aggregates) {
        HashMap<Long, Long> transactionCounts = Maps.newHashMap();
        for (Aggregate aggregate : aggregates) {
            transactionCounts.put(aggregate.captureTime(), aggregate.transactionCount());
        }
        return transactionCounts;
    }

    @GET(value="/backend/transaction/metrics")
    String getMetrics(String queryString) throws Exception {
        TransactionDataRequest request = QueryStrings.decode(queryString, TransactionDataRequest.class);
        long liveCaptureTime = this.clock.currentTimeMillis();
        List<Aggregate> aggregates = this.transactionCommonService.getAggregates(request.transactionType(), request.transactionName(), request.from(), request.to(), liveCaptureTime);
        List<DataSeries> dataSeriesList = this.getDataSeriesForMetricsChart(request, aggregates);
        Map<Long, Long> transactionCounts = this.getTransactionCounts(aggregates);
        if (!aggregates.isEmpty() && aggregates.get(0).captureTime() == request.from()) {
            aggregates = aggregates.subList(1, aggregates.size());
        }
        TimerMergedAggregate timerMergedAggregate = AggregateMerging.getTimerMergedAggregate(aggregates);
        ThreadInfoAggregate threadInfoAggregate = AggregateMerging.getThreadInfoAggregate(aggregates);
        StringBuilder sb = new StringBuilder();
        JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter(sb));
        jg.writeStartObject();
        jg.writeObjectField("dataSeries", dataSeriesList);
        jg.writeObjectField("transactionCounts", transactionCounts);
        jg.writeObjectField("mergedAggregate", timerMergedAggregate);
        if (!threadInfoAggregate.isEmpty()) {
            jg.writeObjectField("threadInfoAggregate", threadInfoAggregate);
        }
        jg.writeEndObject();
        jg.close();
        return sb.toString();
    }

    @GET(value="/backend/transaction/queries")
    String getQueries(String queryString) throws Exception {
        TransactionDataRequest request = QueryStrings.decode(queryString, TransactionDataRequest.class);
        Map<String, List<QueryComponent.AggregateQuery>> queries = this.transactionCommonService.getQueries(request.transactionType(), request.transactionName(), request.from(), request.to());
        ArrayList<Query> queryList = Lists.newArrayList();
        for (Map.Entry<String, List<QueryComponent.AggregateQuery>> entry : queries.entrySet()) {
            List<QueryComponent.AggregateQuery> queriesForQueryType = entry.getValue();
            for (QueryComponent.AggregateQuery aggregateQuery : queriesForQueryType) {
                queryList.add(Query.builder().queryType(entry.getKey()).queryText(aggregateQuery.getQueryText()).totalMicros(aggregateQuery.getTotalMicros()).executionCount(aggregateQuery.getExecutionCount()).totalRows(aggregateQuery.getTotalRows()).build());
            }
        }
        Collections.sort(queryList, new Comparator<Query>(){

            @Override
            public int compare(@Nullable Query left, @Nullable Query right) {
                Preconditions.checkNotNull(left);
                Preconditions.checkNotNull(right);
                return Longs.compare(right.totalMicros(), left.totalMicros());
            }
        });
        if (queryList.isEmpty() && this.transactionCommonService.shouldHaveQueries(request.transactionType(), request.transactionName(), request.from(), request.to())) {
            return "{\"overwritten\":true}";
        }
        StringBuilder sb = new StringBuilder();
        JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter(sb));
        jg.writeObject(queryList);
        jg.close();
        return sb.toString();
    }

    @GET(value="/backend/transaction/profile")
    String getProfile(String queryString) throws Exception {
        TransactionProfileRequest request = QueryStrings.decode(queryString, TransactionProfileRequest.class);
        ProfileNode profile = this.transactionCommonService.getProfile(request.transactionType(), request.transactionName(), request.from(), request.to(), request.truncateLeafPercentage());
        if (profile.getSampleCount() == 0 && this.transactionCommonService.shouldHaveProfile(request.transactionType(), request.transactionName(), request.from(), request.to())) {
            return "{\"overwritten\":true}";
        }
        StringBuilder sb = new StringBuilder();
        JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter(sb));
        jg.writeObject(profile);
        jg.close();
        return sb.toString();
    }

    @GET(value="/backend/transaction/summaries")
    String getSummaries(String queryString) throws Exception {
        TransactionSummaryRequest request = QueryStrings.decode(queryString, TransactionSummaryRequest.class);
        TransactionSummary overallSummary = this.transactionCommonService.readOverallSummary(request.transactionType(), request.from() + 1L, request.to());
        TransactionSummaryQuery query = TransactionSummaryQuery.builder().transactionType(request.transactionType()).from(request.from() + 1L).to(request.to()).sortOrder(request.sortOrder()).limit(request.limit()).build();
        QueryResult<TransactionSummary> queryResult = this.transactionCommonService.readTransactionSummaries(query);
        StringBuilder sb = new StringBuilder();
        JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter(sb));
        jg.writeStartObject();
        jg.writeFieldName("overall");
        jg.writeObject(overallSummary);
        jg.writeFieldName("transactions");
        jg.writeObject(queryResult.records());
        jg.writeBooleanField("moreAvailable", queryResult.moreAvailable());
        jg.writeEndObject();
        jg.close();
        return sb.toString();
    }

    @GET(value="/backend/transaction/tab-bar-data")
    String getTabBarData(String queryString) throws Exception {
        TransactionDataRequest request = QueryStrings.decode(queryString, TransactionDataRequest.class);
        String transactionName = request.transactionName();
        long traceCount = transactionName == null ? this.traceDao.readOverallCount(request.transactionType(), request.from(), request.to()) : this.traceDao.readTransactionCount(request.transactionType(), transactionName, request.from(), request.to());
        boolean includeActiveTraces = this.shouldIncludeActiveTraces(request);
        if (includeActiveTraces) {
            for (Transaction transaction : this.transactionRegistry.getTransactions()) {
                if (!this.matchesActive(transaction, request) || transaction.isPartiallyStored()) continue;
                ++traceCount;
            }
        }
        StringBuilder sb = new StringBuilder();
        JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter(sb));
        jg.writeStartObject();
        jg.writeNumberField("traceCount", traceCount);
        jg.writeEndObject();
        jg.close();
        return sb.toString();
    }

    @GET(value="/backend/transaction/flame-graph")
    String getFlameGraph(String queryString) throws Exception {
        ProfileNode profile;
        FlameGraphRequest request = QueryStrings.decode(queryString, FlameGraphRequest.class);
        ProfileNode interestingNode = profile = this.transactionCommonService.getProfile(request.transactionType(), request.transactionName(), request.from(), request.to(), request.truncateLeafPercentage());
        while (interestingNode.hasOneChildNode()) {
            interestingNode = interestingNode.getOnlyChildNode();
        }
        if (interestingNode.isChildNodesEmpty()) {
            interestingNode = profile;
        }
        StringBuilder sb = new StringBuilder();
        JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter(sb));
        jg.writeStartObject();
        jg.writeObjectFieldStart("");
        jg.writeNumberField("svUnique", 0);
        jg.writeNumberField("svTotal", interestingNode.getSampleCount());
        jg.writeObjectFieldStart("svChildren");
        TransactionJsonService.writeFlameGraphNode(interestingNode, jg);
        jg.writeEndObject();
        jg.writeEndObject();
        jg.close();
        return sb.toString();
    }

    private List<DataSeries> getDataSeriesForPercentileChart(TransactionDataRequest request, List<Aggregate> aggregates, List<Double> percentiles) throws Exception {
        if (aggregates.isEmpty()) {
            return Lists.newArrayList();
        }
        DataSeriesHelper dataSeriesHelper = new DataSeriesHelper(this.clock, this.getDataPointIntervalMillis(request));
        ArrayList<DataSeries> dataSeriesList = Lists.newArrayList();
        for (double percentile : percentiles) {
            dataSeriesList.add(new DataSeries(AlertingService.getPercentileWithSuffix(percentile) + " percentile"));
        }
        Aggregate lastAggregate = null;
        for (Aggregate aggregate : aggregates) {
            if (lastAggregate == null) {
                dataSeriesHelper.addInitialUpslopeIfNeeded(request.from(), aggregate.captureTime(), dataSeriesList, null);
            } else {
                dataSeriesHelper.addGapIfNeeded(lastAggregate.captureTime(), aggregate.captureTime(), dataSeriesList, null);
            }
            lastAggregate = aggregate;
            LazyHistogram histogram = new LazyHistogram();
            histogram.decodeFromByteBuffer(ByteBuffer.wrap(aggregate.histogram()));
            for (int i = 0; i < percentiles.size(); ++i) {
                DataSeries dataSeries = (DataSeries)dataSeriesList.get(i);
                double percentile = percentiles.get(i);
                dataSeries.add(aggregate.captureTime(), (double)histogram.getValueAtPercentile(percentile) / 1000.0);
            }
        }
        if (lastAggregate != null) {
            dataSeriesHelper.addFinalDownslopeIfNeeded(request.to(), dataSeriesList, null, lastAggregate.captureTime());
        }
        return dataSeriesList;
    }

    private List<DataSeries> getDataSeriesForMetricsChart(TransactionDataRequest request, List<Aggregate> aggregates) throws IOException {
        if (aggregates.isEmpty()) {
            return Lists.newArrayList();
        }
        ArrayList<StackedPoint> stackedPoints = Lists.newArrayList();
        for (Aggregate aggregate : aggregates) {
            stackedPoints.add(StackedPoint.create(aggregate));
        }
        return this.getMetricDataSeries(request, stackedPoints);
    }

    private List<DataSeries> getMetricDataSeries(TransactionDataRequest request, List<StackedPoint> stackedPoints) {
        DataSeriesHelper dataSeriesHelper = new DataSeriesHelper(this.clock, this.getDataPointIntervalMillis(request));
        int topX = 5;
        List<String> timerNames = TransactionJsonService.getTopTimerNames(stackedPoints, 6);
        ArrayList<DataSeries> dataSeriesList = Lists.newArrayList();
        for (int i = 0; i < Math.min(timerNames.size(), 5); ++i) {
            dataSeriesList.add(new DataSeries(timerNames.get(i)));
        }
        DataSeries otherDataSeries = new DataSeries(null);
        Aggregate lastAggregate = null;
        for (StackedPoint stackedPoint : stackedPoints) {
            Aggregate aggregate = stackedPoint.getAggregate();
            if (lastAggregate == null) {
                dataSeriesHelper.addInitialUpslopeIfNeeded(request.from(), aggregate.captureTime(), dataSeriesList, otherDataSeries);
            } else {
                dataSeriesHelper.addGapIfNeeded(lastAggregate.captureTime(), aggregate.captureTime(), dataSeriesList, otherDataSeries);
            }
            lastAggregate = aggregate;
            MutableLongMap stackedTimers = stackedPoint.getStackedTimers();
            long totalOtherMicros = aggregate.totalMicros();
            for (DataSeries dataSeries : dataSeriesList) {
                MutableLong totalMicros = (MutableLong)stackedTimers.get(dataSeries.getName());
                if (totalMicros == null) {
                    dataSeries.add(aggregate.captureTime(), 0.0);
                    continue;
                }
                dataSeries.add(aggregate.captureTime(), (double)totalMicros.longValue() / (double)aggregate.transactionCount() / 1000.0);
                totalOtherMicros -= totalMicros.longValue();
            }
            if (aggregate.transactionCount() == 0L) {
                otherDataSeries.add(aggregate.captureTime(), 0.0);
                continue;
            }
            otherDataSeries.add(aggregate.captureTime(), (double)totalOtherMicros / (double)aggregate.transactionCount() / 1000.0);
        }
        if (lastAggregate != null) {
            dataSeriesHelper.addFinalDownslopeIfNeeded(request.to(), dataSeriesList, otherDataSeries, lastAggregate.captureTime());
        }
        dataSeriesList.add(otherDataSeries);
        return dataSeriesList;
    }

    private long getDataPointIntervalMillis(TransactionDataRequest request) {
        if (request.to() - request.from() > AggregateDao.ROLLUP_THRESHOLD_MILLIS) {
            return this.fixedAggregateRollupMillis;
        }
        return this.fixedAggregateIntervalMillis;
    }

    private static List<String> getTopTimerNames(List<StackedPoint> stackedPoints, int topX) {
        MutableLongMap timerTotals = new MutableLongMap();
        for (StackedPoint stackedPoint : stackedPoints) {
            for (Map.Entry entry : stackedPoint.getStackedTimers().entrySet()) {
                timerTotals.add(entry.getKey(), ((MutableLong)entry.getValue()).longValue());
            }
        }
        Ordering<Map.Entry<String, MutableLong>> valueOrdering = Ordering.natural().onResultOf(new Function<Map.Entry<String, MutableLong>, Long>(){

            @Override
            public Long apply(@Nullable Map.Entry<String, MutableLong> entry) {
                Preconditions.checkNotNull(entry);
                return entry.getValue().longValue();
            }
        });
        ArrayList<String> timerNames = Lists.newArrayList();
        List topTimerTotals = valueOrdering.greatestOf(timerTotals.entrySet(), topX);
        for (Map.Entry entry : topTimerTotals) {
            timerNames.add((String)entry.getKey());
        }
        return timerNames;
    }

    private boolean shouldIncludeActiveTraces(TransactionDataRequest request) {
        long currentTimeMillis = this.clock.currentTimeMillis();
        return (request.to() == 0L || request.to() > currentTimeMillis) && request.from() < currentTimeMillis;
    }

    @VisibleForTesting
    boolean matchesActive(Transaction transaction, TransactionDataRequest request) {
        if (!this.transactionCollector.shouldStore(transaction)) {
            return false;
        }
        if (!request.transactionType().equals(transaction.getTransactionType())) {
            return false;
        }
        String transactionName = request.transactionName();
        return transactionName == null || transactionName.equals(transaction.getTransactionName());
    }

    private static void writeFlameGraphNode(ProfileNode node, JsonGenerator jg) throws IOException {
        jg.writeObjectFieldStart(node.getStackTraceElementStr());
        int svUnique = node.getSampleCount();
        for (ProfileNode childNode : node.getChildNodes()) {
            svUnique -= childNode.getSampleCount();
        }
        jg.writeNumberField("svUnique", svUnique);
        jg.writeNumberField("svTotal", node.getSampleCount());
        jg.writeObjectFieldStart("svChildren");
        for (ProfileNode childNode : node.getChildNodes()) {
            TransactionJsonService.writeFlameGraphNode(childNode, jg);
        }
        jg.writeEndObject();
        jg.writeEndObject();
    }

    @JsonSerialize
    @Value.Immutable
    static abstract class QueryBase {
        QueryBase() {
        }

        abstract String queryType();

        abstract String queryText();

        abstract long totalMicros();

        abstract long executionCount();

        abstract long totalRows();
    }

    @JsonSerialize
    @Value.Immutable
    static abstract class FlameGraphRequestBase {
        FlameGraphRequestBase() {
        }

        abstract long from();

        abstract long to();

        abstract String transactionType();

        @Nullable
        abstract String transactionName();

        abstract double truncateLeafPercentage();
    }

    @JsonSerialize
    @Value.Immutable
    static abstract class TransactionProfileRequestBase {
        TransactionProfileRequestBase() {
        }

        abstract long from();

        abstract long to();

        abstract String transactionType();

        @Nullable
        abstract String transactionName();

        abstract double truncateLeafPercentage();
    }

    @JsonSerialize
    @Value.Immutable
    static abstract class TransactionDataRequestBase {
        TransactionDataRequestBase() {
        }

        abstract long from();

        abstract long to();

        abstract String transactionType();

        @Nullable
        abstract String transactionName();

        abstract ImmutableList<Double> percentile();
    }

    @JsonSerialize
    @Value.Immutable
    static abstract class TransactionSummaryRequestBase {
        TransactionSummaryRequestBase() {
        }

        abstract long from();

        abstract long to();

        abstract String transactionType();

        abstract AggregateDao.TransactionSummarySortOrder sortOrder();

        abstract int limit();
    }

    private static class MutableLong {
        private long value;

        private MutableLong(long value) {
            this.value = value;
        }

        private long longValue() {
            return this.value;
        }
    }

    private static class MutableLongMap<K>
    extends HashMap<K, MutableLong> {
        private MutableLongMap() {
        }

        private void add(K key, long delta) {
            MutableLong existing = (MutableLong)this.get(key);
            if (existing == null) {
                this.put(key, new MutableLong(delta));
            } else {
                MutableLong mutableLong = existing;
                mutableLong.value = mutableLong.value + delta;
            }
        }
    }

    private static class StackedPoint {
        private final Aggregate aggregate;
        private final MutableLongMap<String> stackedTimers;

        private static StackedPoint create(Aggregate aggregate) throws IOException {
            String timers = aggregate.timers();
            MutableLongMap<String> stackedTimers = new MutableLongMap<String>();
            AggregateTimer syntheticRootTimer = mapper.readValue(timers, AggregateTimer.class);
            for (AggregateTimer realRootTimer : syntheticRootTimer.getNestedTimers()) {
                for (AggregateTimer topLevelTimer : realRootTimer.getNestedTimers()) {
                    StackedPoint.addToStackedTimer(topLevelTimer, stackedTimers);
                }
            }
            return new StackedPoint(aggregate, stackedTimers);
        }

        private StackedPoint(Aggregate aggregate, MutableLongMap<String> stackedTimers) {
            this.aggregate = aggregate;
            this.stackedTimers = stackedTimers;
        }

        private Aggregate getAggregate() {
            return this.aggregate;
        }

        private MutableLongMap<String> getStackedTimers() {
            return this.stackedTimers;
        }

        private static void addToStackedTimer(AggregateTimer timer, MutableLongMap<String> stackedTimers) {
            long totalNestedMicros = 0L;
            for (AggregateTimer nestedTimer : timer.getNestedTimers()) {
                totalNestedMicros += nestedTimer.getTotalMicros();
                StackedPoint.addToStackedTimer(nestedTimer, stackedTimers);
            }
            String timerName = Preconditions.checkNotNull(timer.getName());
            ((MutableLongMap)stackedTimers).add(timerName, timer.getTotalMicros() - totalNestedMicros);
        }
    }
}

