/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.UiAnalyzedMethodBase;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;

@ParametersAreNonnullByDefault
@Immutable
final class UiAnalyzedMethod
extends UiAnalyzedMethodBase {
    private final String name;
    private final ImmutableList<String> parameterTypes;
    private final String returnType;
    private final int modifiers;
    @Nullable
    private final String signature;
    private final ImmutableList<String> exceptions;
    private final int hashCode;

    private UiAnalyzedMethod(String name, ImmutableList<String> parameterTypes, String returnType, int modifiers, @Nullable String signature, ImmutableList<String> exceptions) {
        this.name = name;
        this.parameterTypes = parameterTypes;
        this.returnType = returnType;
        this.modifiers = modifiers;
        this.signature = signature;
        this.exceptions = exceptions;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ImmutableList<String> parameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public String returnType() {
        return this.returnType;
    }

    @Override
    public int modifiers() {
        return this.modifiers;
    }

    @Override
    public String signature() {
        return this.signature;
    }

    @Override
    public ImmutableList<String> exceptions() {
        return this.exceptions;
    }

    public final UiAnalyzedMethod withName(String value) {
        if (this.name == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new UiAnalyzedMethod(newValue, this.parameterTypes, this.returnType, this.modifiers, this.signature, this.exceptions);
    }

    public final UiAnalyzedMethod withParameterTypes(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new UiAnalyzedMethod(this.name, newValue, this.returnType, this.modifiers, this.signature, this.exceptions);
    }

    public final UiAnalyzedMethod withParameterTypes(Iterable<String> elements) {
        if (this.parameterTypes == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new UiAnalyzedMethod(this.name, newValue, this.returnType, this.modifiers, this.signature, this.exceptions);
    }

    public final UiAnalyzedMethod withReturnType(String value) {
        if (this.returnType == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new UiAnalyzedMethod(this.name, this.parameterTypes, newValue, this.modifiers, this.signature, this.exceptions);
    }

    public final UiAnalyzedMethod withModifiers(int value) {
        if (this.modifiers == value) {
            return this;
        }
        int newValue = value;
        return new UiAnalyzedMethod(this.name, this.parameterTypes, this.returnType, newValue, this.signature, this.exceptions);
    }

    public final UiAnalyzedMethod withSignature(@Nullable String value) {
        if (this.signature == value) {
            return this;
        }
        String newValue = value;
        return new UiAnalyzedMethod(this.name, this.parameterTypes, this.returnType, this.modifiers, newValue, this.exceptions);
    }

    public final UiAnalyzedMethod withExceptions(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new UiAnalyzedMethod(this.name, this.parameterTypes, this.returnType, this.modifiers, this.signature, newValue);
    }

    public final UiAnalyzedMethod withExceptions(Iterable<String> elements) {
        if (this.exceptions == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new UiAnalyzedMethod(this.name, this.parameterTypes, this.returnType, this.modifiers, this.signature, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof UiAnalyzedMethod && this.equalTo((UiAnalyzedMethod)another);
    }

    private boolean equalTo(UiAnalyzedMethod another) {
        return this.name.equals(another.name) && this.parameterTypes.equals(another.parameterTypes) && this.returnType.equals(another.returnType) && this.modifiers == another.modifiers && Objects.equal(this.signature, another.signature) && this.exceptions.equals(another.exceptions);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.parameterTypes.hashCode();
        h = h * 17 + this.returnType.hashCode();
        h = h * 17 + this.modifiers;
        h = h * 17 + Objects.hashCode(this.signature);
        h = h * 17 + this.exceptions.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("UiAnalyzedMethod").add("name", this.name).add("parameterTypes", this.parameterTypes).add("returnType", this.returnType).add("modifiers", this.modifiers).add("signature", this.signature).add("exceptions", this.exceptions).toString();
    }

    static UiAnalyzedMethod copyOf(UiAnalyzedMethodBase instance) {
        if (instance instanceof UiAnalyzedMethod) {
            return (UiAnalyzedMethod)instance;
        }
        return UiAnalyzedMethod.builder().all(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 7L;
        private static final long INITIALIZED_BIT_NAME = 1L;
        private static final long INITIALIZED_BIT_RETURN_TYPE = 2L;
        private static final long INITIALIZED_BIT_MODIFIERS = 4L;
        private long initializedBitset;
        @Nullable
        private String name;
        private ImmutableList.Builder<String> parameterTypesBuilder = ImmutableList.builder();
        @Nullable
        private String returnType;
        private int modifiers;
        @Nullable
        private String signature;
        private ImmutableList.Builder<String> exceptionsBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder all(UiAnalyzedMethodBase instance) {
            Preconditions.checkNotNull(instance);
            this.name(instance.name());
            this.addAllParameterTypes(instance.parameterTypes());
            this.returnType(instance.returnType());
            this.modifiers(instance.modifiers());
            String signatureValue = instance.signature();
            if (signatureValue != null) {
                this.signature(signatureValue);
            }
            this.addAllExceptions(instance.exceptions());
            return this;
        }

        public final Builder name(String name) {
            this.name = Preconditions.checkNotNull(name);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder addParameterTypes(String element) {
            this.parameterTypesBuilder.add((Object)element);
            return this;
        }

        public final Builder addParameterTypes(String ... elements) {
            this.parameterTypesBuilder.add(elements);
            return this;
        }

        public final Builder parameterTypes(Iterable<String> elements) {
            this.parameterTypesBuilder = ImmutableList.builder();
            return this.addAllParameterTypes(elements);
        }

        public final Builder addAllParameterTypes(Iterable<String> elements) {
            this.parameterTypesBuilder.addAll((Iterable)elements);
            return this;
        }

        public final Builder returnType(String returnType) {
            this.returnType = Preconditions.checkNotNull(returnType);
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder modifiers(int modifiers) {
            this.modifiers = modifiers;
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder signature(@Nullable String signature) {
            this.signature = signature;
            return this;
        }

        public final Builder addExceptions(String element) {
            this.exceptionsBuilder.add((Object)element);
            return this;
        }

        public final Builder addExceptions(String ... elements) {
            this.exceptionsBuilder.add(elements);
            return this;
        }

        public final Builder exceptions(Iterable<String> elements) {
            this.exceptionsBuilder = ImmutableList.builder();
            return this.addAllExceptions(elements);
        }

        public final Builder addAllExceptions(Iterable<String> elements) {
            this.exceptionsBuilder.addAll((Iterable)elements);
            return this;
        }

        public UiAnalyzedMethod build() {
            this.checkRequiredAttributes();
            return new UiAnalyzedMethod(this.name, (ImmutableList)this.parameterTypesBuilder.build(), this.returnType, this.modifiers, this.signature, (ImmutableList)this.exceptionsBuilder.build());
        }

        private boolean nameIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean returnTypeIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean modifiersIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 7L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.returnTypeIsSet()) {
                attributes.add("returnType");
            }
            if (!this.modifiersIsSet()) {
                attributes.add("modifiers");
            }
            return "Cannot build UiAnalyzedMethod, some of required attributes are not set " + attributes;
        }
    }
}

