/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.lang.reflect.Modifier;
import javax.annotation.Nullable;
import org.glowroot.local.ui.UiAnalyzedMethod;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ComparisonChain;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Ordering;
import org.immutables.value.Value;

@Value.Immutable(prehash=true)
abstract class UiAnalyzedMethodBase {
    static final Ordering<UiAnalyzedMethod> ordering = new UiAnalyzedMethodOrdering();

    UiAnalyzedMethodBase() {
    }

    public abstract String name();

    public abstract ImmutableList<String> parameterTypes();

    public abstract String returnType();

    public abstract int modifiers();

    @Nullable
    abstract String signature();

    abstract ImmutableList<String> exceptions();

    private static class UiAnalyzedMethodOrdering
    extends Ordering<UiAnalyzedMethod> {
        private UiAnalyzedMethodOrdering() {
        }

        @Override
        public int compare(@Nullable UiAnalyzedMethod left, @Nullable UiAnalyzedMethod right) {
            Preconditions.checkNotNull(left);
            Preconditions.checkNotNull(right);
            return ComparisonChain.start().compare(UiAnalyzedMethodOrdering.getAccessibility(left), UiAnalyzedMethodOrdering.getAccessibility(right)).compare((Comparable<?>)((Object)left.name()), (Comparable<?>)((Object)right.name())).compare(left.parameterTypes().size(), right.parameterTypes().size()).result();
        }

        private static int getAccessibility(UiAnalyzedMethod analyzedMethod) {
            int modifiers = analyzedMethod.modifiers();
            if (Modifier.isPublic(modifiers)) {
                return 1;
            }
            if (Modifier.isProtected(modifiers)) {
                return 2;
            }
            if (Modifier.isPrivate(modifiers)) {
                return 4;
            }
            return 3;
        }
    }
}

