/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.ConfigJsonService;
import org.glowroot.local.ui.UserInterfaceConfigDto;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;

@ParametersAreNonnullByDefault
@Immutable
final class UserInterfaceConfigResponse
extends ConfigJsonService.UserInterfaceConfigResponseBase {
    private final UserInterfaceConfigDto config;
    private final int activePort;
    private final boolean portChangeFailed;

    private UserInterfaceConfigResponse(UserInterfaceConfigDto config, int activePort, boolean portChangeFailed) {
        this.config = config;
        this.activePort = activePort;
        this.portChangeFailed = portChangeFailed;
    }

    @Override
    @JsonProperty(value="config")
    public UserInterfaceConfigDto config() {
        return this.config;
    }

    @Override
    @JsonProperty(value="activePort")
    public int activePort() {
        return this.activePort;
    }

    @Override
    @JsonProperty(value="portChangeFailed")
    public boolean portChangeFailed() {
        return this.portChangeFailed;
    }

    public final UserInterfaceConfigResponse withConfig(UserInterfaceConfigDto value) {
        if (this.config == value) {
            return this;
        }
        UserInterfaceConfigDto newValue = Preconditions.checkNotNull(value);
        return new UserInterfaceConfigResponse(newValue, this.activePort, this.portChangeFailed);
    }

    public final UserInterfaceConfigResponse withActivePort(int value) {
        if (this.activePort == value) {
            return this;
        }
        int newValue = value;
        return new UserInterfaceConfigResponse(this.config, newValue, this.portChangeFailed);
    }

    public final UserInterfaceConfigResponse withPortChangeFailed(boolean value) {
        if (this.portChangeFailed == value) {
            return this;
        }
        boolean newValue = value;
        return new UserInterfaceConfigResponse(this.config, this.activePort, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof UserInterfaceConfigResponse && this.equalTo((UserInterfaceConfigResponse)another);
    }

    private boolean equalTo(UserInterfaceConfigResponse another) {
        return this.config.equals(another.config) && this.activePort == another.activePort && this.portChangeFailed == another.portChangeFailed;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.config.hashCode();
        h = h * 17 + this.activePort;
        h = h * 17 + Booleans.hashCode(this.portChangeFailed);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("UserInterfaceConfigResponse").add("config", this.config).add("activePort", this.activePort).add("portChangeFailed", this.portChangeFailed).toString();
    }

    @JsonCreator
    public static UserInterfaceConfigResponse fromAllAttributes(@JsonProperty(value="config") @Nullable UserInterfaceConfigDto config, @JsonProperty(value="activePort") @Nullable Integer activePort, @JsonProperty(value="portChangeFailed") @Nullable Boolean portChangeFailed) {
        Builder builder = UserInterfaceConfigResponse.builder();
        if (config != null) {
            builder.config(config);
        }
        if (activePort != null) {
            builder.activePort(activePort);
        }
        if (portChangeFailed != null) {
            builder.portChangeFailed(portChangeFailed);
        }
        return builder.build();
    }

    static UserInterfaceConfigResponse copyOf(ConfigJsonService.UserInterfaceConfigResponseBase instance) {
        if (instance instanceof UserInterfaceConfigResponse) {
            return (UserInterfaceConfigResponse)instance;
        }
        return UserInterfaceConfigResponse.builder().all(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 7L;
        private static final long INITIALIZED_BIT_CONFIG = 1L;
        private static final long INITIALIZED_BIT_ACTIVE_PORT = 2L;
        private static final long INITIALIZED_BIT_PORT_CHANGE_FAILED = 4L;
        private long initializedBitset;
        @Nullable
        private UserInterfaceConfigDto config;
        private int activePort;
        private boolean portChangeFailed;

        private Builder() {
        }

        public final Builder all(ConfigJsonService.UserInterfaceConfigResponseBase instance) {
            Preconditions.checkNotNull(instance);
            this.config(instance.config());
            this.activePort(instance.activePort());
            this.portChangeFailed(instance.portChangeFailed());
            return this;
        }

        public final Builder config(UserInterfaceConfigDto config) {
            this.config = Preconditions.checkNotNull(config);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder activePort(int activePort) {
            this.activePort = activePort;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder portChangeFailed(boolean portChangeFailed) {
            this.portChangeFailed = portChangeFailed;
            this.initializedBitset |= 4L;
            return this;
        }

        public UserInterfaceConfigResponse build() {
            this.checkRequiredAttributes();
            return new UserInterfaceConfigResponse(this.config, this.activePort, this.portChangeFailed);
        }

        private boolean configIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean activePortIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean portChangeFailedIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 7L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.configIsSet()) {
                attributes.add("config");
            }
            if (!this.activePortIsSet()) {
                attributes.add("activePort");
            }
            if (!this.portChangeFailedIsSet()) {
                attributes.add("portChangeFailed");
            }
            return "Cannot build UserInterfaceConfigResponse, some of required attributes are not set " + attributes;
        }
    }
}

