/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.fasterxml.jackson.databind.ser;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonFormat;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonInclude;
import org.glowroot.shaded.fasterxml.jackson.databind.AnnotationIntrospector;
import org.glowroot.shaded.fasterxml.jackson.databind.BeanDescription;
import org.glowroot.shaded.fasterxml.jackson.databind.JavaType;
import org.glowroot.shaded.fasterxml.jackson.databind.JsonMappingException;
import org.glowroot.shaded.fasterxml.jackson.databind.JsonSerializable;
import org.glowroot.shaded.fasterxml.jackson.databind.JsonSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.MapperFeature;
import org.glowroot.shaded.fasterxml.jackson.databind.SerializationConfig;
import org.glowroot.shaded.fasterxml.jackson.databind.SerializerProvider;
import org.glowroot.shaded.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.glowroot.shaded.fasterxml.jackson.databind.cfg.SerializerFactoryConfig;
import org.glowroot.shaded.fasterxml.jackson.databind.ext.OptionalHandlerFactory;
import org.glowroot.shaded.fasterxml.jackson.databind.introspect.Annotated;
import org.glowroot.shaded.fasterxml.jackson.databind.introspect.AnnotatedClass;
import org.glowroot.shaded.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import org.glowroot.shaded.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import org.glowroot.shaded.fasterxml.jackson.databind.jsontype.NamedType;
import org.glowroot.shaded.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import org.glowroot.shaded.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.ContainerSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.SerializerFactory;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.Serializers;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.impl.IndexedListSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.impl.IndexedStringListSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.impl.IteratorSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.impl.MapEntrySerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.impl.StringArraySerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.impl.StringCollectionSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.std.AtomicReferenceSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.std.BooleanSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.std.ByteBufferSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.std.CalendarSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.std.CollectionSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.std.DateSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.std.EnumSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.std.EnumSetSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.std.InetAddressSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.std.InetSocketAddressSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.std.IterableSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.std.JsonValueSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.std.MapSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.std.NumberSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.std.NumberSerializers;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.std.ObjectArraySerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.std.SerializableSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.std.SqlDateSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.std.SqlTimeSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.std.StdArraySerializers;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.std.StdJdkSerializers;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.std.StdKeySerializers;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.std.StringSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.std.TimeZoneSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.ser.std.TokenBufferSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.type.ArrayType;
import org.glowroot.shaded.fasterxml.jackson.databind.type.CollectionLikeType;
import org.glowroot.shaded.fasterxml.jackson.databind.type.CollectionType;
import org.glowroot.shaded.fasterxml.jackson.databind.type.MapLikeType;
import org.glowroot.shaded.fasterxml.jackson.databind.type.MapType;
import org.glowroot.shaded.fasterxml.jackson.databind.type.ReferenceType;
import org.glowroot.shaded.fasterxml.jackson.databind.type.TypeFactory;
import org.glowroot.shaded.fasterxml.jackson.databind.util.ClassUtil;
import org.glowroot.shaded.fasterxml.jackson.databind.util.Converter;
import org.glowroot.shaded.fasterxml.jackson.databind.util.TokenBuffer;

public abstract class BasicSerializerFactory
extends SerializerFactory
implements Serializable {
    protected static final HashMap<String, JsonSerializer<?>> _concrete = new HashMap();
    protected static final HashMap<String, Class<? extends JsonSerializer<?>>> _concreteLazy = new HashMap();
    protected final SerializerFactoryConfig _factoryConfig;

    protected BasicSerializerFactory(SerializerFactoryConfig config) {
        this._factoryConfig = config == null ? new SerializerFactoryConfig() : config;
    }

    public SerializerFactoryConfig getFactoryConfig() {
        return this._factoryConfig;
    }

    public abstract SerializerFactory withConfig(SerializerFactoryConfig var1);

    @Override
    public final SerializerFactory withAdditionalSerializers(Serializers additional) {
        return this.withConfig(this._factoryConfig.withAdditionalSerializers(additional));
    }

    @Override
    public final SerializerFactory withAdditionalKeySerializers(Serializers additional) {
        return this.withConfig(this._factoryConfig.withAdditionalKeySerializers(additional));
    }

    @Override
    public final SerializerFactory withSerializerModifier(BeanSerializerModifier modifier) {
        return this.withConfig(this._factoryConfig.withSerializerModifier(modifier));
    }

    @Override
    public abstract JsonSerializer<Object> createSerializer(SerializerProvider var1, JavaType var2) throws JsonMappingException;

    @Override
    public JsonSerializer<Object> createKeySerializer(SerializationConfig config, JavaType keyType, JsonSerializer<Object> defaultImpl) {
        BeanDescription beanDesc = config.introspectClassAnnotations(keyType.getRawClass());
        JsonValueSerializer ser = null;
        if (this._factoryConfig.hasKeySerializers()) {
            Serializers serializers;
            Iterator<Object> i$ = this._factoryConfig.keySerializers().iterator();
            while (i$.hasNext() && (ser = (serializers = i$.next()).findSerializer(config, keyType, beanDesc)) == null) {
            }
        }
        if (ser == null && (ser = defaultImpl) == null && (ser = StdKeySerializers.getStdKeySerializer(config, keyType.getRawClass(), false)) == null) {
            beanDesc = config.introspect(keyType);
            AnnotatedMethod am = beanDesc.findJsonValueMethod();
            if (am != null) {
                Class<?> rawType = am.getRawReturnType();
                JsonSerializer<Object> delegate = StdKeySerializers.getStdKeySerializer(config, rawType, true);
                Method m = am.getAnnotated();
                if (config.canOverrideAccessModifiers()) {
                    ClassUtil.checkAndFixAccess(m);
                }
                ser = new JsonValueSerializer(m, delegate);
            } else {
                ser = StdKeySerializers.getDefault();
            }
        }
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                ser = mod.modifyKeySerializer(config, keyType, beanDesc, ser);
            }
        }
        return ser;
    }

    @Override
    public TypeSerializer createTypeSerializer(SerializationConfig config, JavaType baseType) {
        BeanDescription bean = config.introspectClassAnnotations(baseType.getRawClass());
        AnnotatedClass ac = bean.getClassInfo();
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        TypeResolverBuilder<?> b = ai.findTypeResolver(config, ac, baseType);
        Collection<NamedType> subtypes = null;
        if (b == null) {
            b = config.getDefaultTyper(baseType);
        } else {
            subtypes = config.getSubtypeResolver().collectAndResolveSubtypesByClass(config, ac);
        }
        if (b == null) {
            return null;
        }
        return b.buildTypeSerializer(config, baseType, subtypes);
    }

    protected abstract Iterable<Serializers> customSerializers();

    protected final JsonSerializer<?> findSerializerByLookup(JavaType type, SerializationConfig config, BeanDescription beanDesc, boolean staticTyping) {
        Class<JsonSerializer<?>> serClass;
        Class<?> raw = type.getRawClass();
        String clsName = raw.getName();
        if (type.isReferenceType() && type.isTypeOrSubTypeOf(AtomicReference.class)) {
            return new AtomicReferenceSerializer((ReferenceType)type);
        }
        JsonSerializer<?> ser = _concrete.get(clsName);
        if (ser == null && (serClass = _concreteLazy.get(clsName)) != null) {
            try {
                return serClass.newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to instantiate standard serializer (of type " + serClass.getName() + "): " + e.getMessage(), e);
            }
        }
        return ser;
    }

    protected final JsonSerializer<?> findSerializerByAnnotations(SerializerProvider prov, JavaType type, BeanDescription beanDesc) throws JsonMappingException {
        Class<?> raw = type.getRawClass();
        if (JsonSerializable.class.isAssignableFrom(raw)) {
            return SerializableSerializer.instance;
        }
        AnnotatedMethod valueMethod = beanDesc.findJsonValueMethod();
        if (valueMethod != null) {
            Method m = valueMethod.getAnnotated();
            if (prov.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(m);
            }
            JsonSerializer<Object> ser = this.findSerializerFromAnnotation(prov, valueMethod);
            return new JsonValueSerializer(m, ser);
        }
        return null;
    }

    protected final JsonSerializer<?> findSerializerByPrimaryType(SerializerProvider prov, JavaType type, BeanDescription beanDesc, boolean staticTyping) throws JsonMappingException {
        Class<?> raw = type.getRawClass();
        JsonSerializer<?> ser = this.findOptionalStdSerializer(prov, type, beanDesc, staticTyping);
        if (ser != null) {
            return ser;
        }
        if (Calendar.class.isAssignableFrom(raw)) {
            return CalendarSerializer.instance;
        }
        if (Date.class.isAssignableFrom(raw)) {
            return DateSerializer.instance;
        }
        if (Map.Entry.class.isAssignableFrom(raw)) {
            JavaType vt;
            JavaType kt = type.containedType(0);
            if (kt == null) {
                kt = TypeFactory.unknownType();
            }
            if ((vt = type.containedType(1)) == null) {
                vt = TypeFactory.unknownType();
            }
            return this.buildMapEntrySerializer(prov.getConfig(), type, beanDesc, staticTyping, kt, vt);
        }
        if (ByteBuffer.class.isAssignableFrom(raw)) {
            return new ByteBufferSerializer();
        }
        if (InetAddress.class.isAssignableFrom(raw)) {
            return new InetAddressSerializer();
        }
        if (InetSocketAddress.class.isAssignableFrom(raw)) {
            return new InetSocketAddressSerializer();
        }
        if (TimeZone.class.isAssignableFrom(raw)) {
            return new TimeZoneSerializer();
        }
        if (Charset.class.isAssignableFrom(raw)) {
            return ToStringSerializer.instance;
        }
        if (Number.class.isAssignableFrom(raw)) {
            JsonFormat.Value format = beanDesc.findExpectedFormat(null);
            if (format != null) {
                switch (format.getShape()) {
                    case STRING: {
                        return ToStringSerializer.instance;
                    }
                    case OBJECT: 
                    case ARRAY: {
                        return null;
                    }
                }
            }
            return NumberSerializer.instance;
        }
        if (Enum.class.isAssignableFrom(raw)) {
            return this.buildEnumSerializer(prov.getConfig(), type, beanDesc);
        }
        return null;
    }

    protected JsonSerializer<?> findOptionalStdSerializer(SerializerProvider prov, JavaType type, BeanDescription beanDesc, boolean staticTyping) throws JsonMappingException {
        return OptionalHandlerFactory.instance.findSerializer(prov.getConfig(), type, beanDesc);
    }

    protected final JsonSerializer<?> findSerializerByAddonType(SerializationConfig config, JavaType javaType, BeanDescription beanDesc, boolean staticTyping) throws JsonMappingException {
        Class<?> type = javaType.getRawClass();
        if (Iterator.class.isAssignableFrom(type)) {
            JavaType[] params = config.getTypeFactory().findTypeParameters(javaType, Iterator.class);
            JavaType vt = params == null || params.length != 1 ? TypeFactory.unknownType() : params[0];
            return this.buildIteratorSerializer(config, javaType, beanDesc, staticTyping, vt);
        }
        if (Iterable.class.isAssignableFrom(type)) {
            JavaType[] params = config.getTypeFactory().findTypeParameters(javaType, Iterable.class);
            JavaType vt = params == null || params.length != 1 ? TypeFactory.unknownType() : params[0];
            return this.buildIterableSerializer(config, javaType, beanDesc, staticTyping, vt);
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return ToStringSerializer.instance;
        }
        return null;
    }

    protected JsonSerializer<Object> findSerializerFromAnnotation(SerializerProvider prov, Annotated a) throws JsonMappingException {
        Object serDef = prov.getAnnotationIntrospector().findSerializer(a);
        if (serDef == null) {
            return null;
        }
        JsonSerializer<Object> ser = prov.serializerInstance(a, serDef);
        return this.findConvertingSerializer(prov, a, ser);
    }

    protected JsonSerializer<?> findConvertingSerializer(SerializerProvider prov, Annotated a, JsonSerializer<?> ser) throws JsonMappingException {
        Converter<Object, Object> conv = this.findConverter(prov, a);
        if (conv == null) {
            return ser;
        }
        JavaType delegateType = conv.getOutputType(prov.getTypeFactory());
        return new StdDelegatingSerializer(conv, delegateType, ser);
    }

    protected Converter<Object, Object> findConverter(SerializerProvider prov, Annotated a) throws JsonMappingException {
        Object convDef = prov.getAnnotationIntrospector().findSerializationConverter(a);
        if (convDef == null) {
            return null;
        }
        return prov.converterInstance(a, convDef);
    }

    protected JsonSerializer<?> buildContainerSerializer(SerializerProvider prov, JavaType type, BeanDescription beanDesc, boolean staticTyping) throws JsonMappingException {
        JavaType elementType;
        TypeSerializer elementTypeSerializer;
        SerializationConfig config = prov.getConfig();
        if (!(staticTyping || !type.useStaticType() || type.isContainerType() && type.getContentType().getRawClass() == Object.class)) {
            staticTyping = true;
        }
        if ((elementTypeSerializer = this.createTypeSerializer(config, elementType = type.getContentType())) != null) {
            staticTyping = false;
        }
        JsonSerializer<Object> elementValueSerializer = this._findContentSerializer(prov, beanDesc.getClassInfo());
        if (type.isMapLikeType()) {
            MapLikeType mlt = (MapLikeType)type;
            JsonSerializer<Object> keySerializer = this._findKeySerializer(prov, beanDesc.getClassInfo());
            if (mlt.isTrueMapType()) {
                return this.buildMapSerializer(config, (MapType)mlt, beanDesc, staticTyping, keySerializer, elementTypeSerializer, elementValueSerializer);
            }
            for (Serializers serializers : this.customSerializers()) {
                MapLikeType mlType;
                JsonSerializer<?> ser = serializers.findMapLikeSerializer(config, mlType = (MapLikeType)type, beanDesc, keySerializer, elementTypeSerializer, elementValueSerializer);
                if (ser == null) continue;
                if (this._factoryConfig.hasSerializerModifiers()) {
                    for (BeanSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                        ser = mod.modifyMapLikeSerializer(config, mlType, beanDesc, ser);
                    }
                }
                return ser;
            }
            return null;
        }
        if (type.isCollectionLikeType()) {
            CollectionLikeType clt = (CollectionLikeType)type;
            if (clt.isTrueCollectionType()) {
                return this.buildCollectionSerializer(config, (CollectionType)clt, beanDesc, staticTyping, elementTypeSerializer, elementValueSerializer);
            }
            CollectionLikeType clType = (CollectionLikeType)type;
            for (Serializers serializers : this.customSerializers()) {
                JsonSerializer<?> ser = serializers.findCollectionLikeSerializer(config, clType, beanDesc, elementTypeSerializer, elementValueSerializer);
                if (ser == null) continue;
                if (this._factoryConfig.hasSerializerModifiers()) {
                    for (BeanSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                        ser = mod.modifyCollectionLikeSerializer(config, clType, beanDesc, ser);
                    }
                }
                return ser;
            }
            return null;
        }
        if (type.isArrayType()) {
            return this.buildArraySerializer(config, (ArrayType)type, beanDesc, staticTyping, elementTypeSerializer, elementValueSerializer);
        }
        return null;
    }

    protected JsonSerializer<?> buildCollectionSerializer(SerializationConfig config, CollectionType type, BeanDescription beanDesc, boolean staticTyping, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) throws JsonMappingException {
        Serializers serializers;
        StdSerializer ser = null;
        Iterator<Object> i$ = this.customSerializers().iterator();
        while (i$.hasNext() && (ser = (serializers = i$.next()).findCollectionSerializer(config, type, beanDesc, elementTypeSerializer, elementValueSerializer)) == null) {
        }
        if (ser == null) {
            JsonFormat.Value format = beanDesc.findExpectedFormat(null);
            if (format != null && format.getShape() == JsonFormat.Shape.OBJECT) {
                return null;
            }
            Class<?> raw = type.getRawClass();
            if (EnumSet.class.isAssignableFrom(raw)) {
                JavaType enumType = type.getContentType();
                if (!enumType.isEnumType()) {
                    enumType = null;
                }
                ser = this.buildEnumSetSerializer(enumType);
            } else {
                Class<?> elementRaw = type.getContentType().getRawClass();
                if (this.isIndexedList(raw)) {
                    if (elementRaw == String.class) {
                        if (elementValueSerializer == null || ClassUtil.isJacksonStdImpl(elementValueSerializer)) {
                            ser = IndexedStringListSerializer.instance;
                        }
                    } else {
                        ser = this.buildIndexedListSerializer(type.getContentType(), staticTyping, elementTypeSerializer, elementValueSerializer);
                    }
                } else if (elementRaw == String.class && (elementValueSerializer == null || ClassUtil.isJacksonStdImpl(elementValueSerializer))) {
                    ser = StringCollectionSerializer.instance;
                }
                if (ser == null) {
                    ser = this.buildCollectionSerializer(type.getContentType(), staticTyping, elementTypeSerializer, elementValueSerializer);
                }
            }
        }
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                ser = mod.modifyCollectionSerializer(config, type, beanDesc, ser);
            }
        }
        return ser;
    }

    protected boolean isIndexedList(Class<?> cls) {
        return RandomAccess.class.isAssignableFrom(cls);
    }

    public ContainerSerializer<?> buildIndexedListSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, JsonSerializer<Object> valueSerializer) {
        return new IndexedListSerializer(elemType, staticTyping, vts, valueSerializer);
    }

    public ContainerSerializer<?> buildCollectionSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, JsonSerializer<Object> valueSerializer) {
        return new CollectionSerializer(elemType, staticTyping, vts, valueSerializer);
    }

    public JsonSerializer<?> buildEnumSetSerializer(JavaType enumType) {
        return new EnumSetSerializer(enumType);
    }

    protected JsonSerializer<?> buildMapSerializer(SerializationConfig config, MapType type, BeanDescription beanDesc, boolean staticTyping, JsonSerializer<Object> keySerializer, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) throws JsonMappingException {
        Serializers serializers;
        MapSerializer ser = null;
        Iterator<Object> i$ = this.customSerializers().iterator();
        while (i$.hasNext() && (ser = (serializers = i$.next()).findMapSerializer(config, type, beanDesc, keySerializer, elementTypeSerializer, elementValueSerializer)) == null) {
        }
        if (ser == null) {
            Object filterId = this.findFilterId(config, beanDesc);
            AnnotationIntrospector ai = config.getAnnotationIntrospector();
            MapSerializer mapSer = MapSerializer.construct(ai.findPropertiesToIgnore(beanDesc.getClassInfo(), true), type, staticTyping, elementTypeSerializer, keySerializer, elementValueSerializer, filterId);
            Object suppressableValue = this.findSuppressableContentValue(config, type.getContentType(), beanDesc);
            if (suppressableValue != null) {
                mapSer = mapSer.withContentInclusion(suppressableValue);
            }
            ser = mapSer;
        }
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                ser = mod.modifyMapSerializer(config, type, beanDesc, ser);
            }
        }
        return ser;
    }

    protected Object findSuppressableContentValue(SerializationConfig config, JavaType contentType, BeanDescription beanDesc) throws JsonMappingException {
        JsonInclude.Include incl = beanDesc.findSerializationInclusionForContent(null);
        if (incl != null) {
            switch (incl) {
                case NON_DEFAULT: {
                    incl = JsonInclude.Include.NON_EMPTY;
                    break;
                }
            }
            return incl;
        }
        return null;
    }

    protected JsonSerializer<?> buildArraySerializer(SerializationConfig config, ArrayType type, BeanDescription beanDesc, boolean staticTyping, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) throws JsonMappingException {
        Serializers serializers;
        JsonSerializer ser = null;
        Iterator<Object> i$ = this.customSerializers().iterator();
        while (i$.hasNext() && (ser = (serializers = i$.next()).findArraySerializer(config, type, beanDesc, elementTypeSerializer, elementValueSerializer)) == null) {
        }
        if (ser == null) {
            Class<?> raw = type.getRawClass();
            if (elementValueSerializer == null || ClassUtil.isJacksonStdImpl(elementValueSerializer)) {
                ser = String[].class == raw ? StringArraySerializer.instance : StdArraySerializers.findStandardImpl(raw);
            }
            if (ser == null) {
                ser = new ObjectArraySerializer(type.getContentType(), staticTyping, elementTypeSerializer, elementValueSerializer);
            }
        }
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                ser = mod.modifyArraySerializer(config, type, beanDesc, ser);
            }
        }
        return ser;
    }

    protected JsonSerializer<?> buildIteratorSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc, boolean staticTyping, JavaType valueType) throws JsonMappingException {
        return new IteratorSerializer(valueType, staticTyping, this.createTypeSerializer(config, valueType));
    }

    @Deprecated
    protected JsonSerializer<?> buildIteratorSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc, boolean staticTyping) throws JsonMappingException {
        JavaType[] params = config.getTypeFactory().findTypeParameters(type, Iterator.class);
        JavaType vt = params == null || params.length != 1 ? TypeFactory.unknownType() : params[0];
        return this.buildIteratorSerializer(config, type, beanDesc, staticTyping, vt);
    }

    protected JsonSerializer<?> buildIterableSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc, boolean staticTyping, JavaType valueType) throws JsonMappingException {
        return new IterableSerializer(valueType, staticTyping, this.createTypeSerializer(config, valueType));
    }

    @Deprecated
    protected JsonSerializer<?> buildIterableSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc, boolean staticTyping) throws JsonMappingException {
        JavaType[] params = config.getTypeFactory().findTypeParameters(type, Iterable.class);
        JavaType vt = params == null || params.length != 1 ? TypeFactory.unknownType() : params[0];
        return this.buildIterableSerializer(config, type, beanDesc, staticTyping, vt);
    }

    protected JsonSerializer<?> buildMapEntrySerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc, boolean staticTyping, JavaType keyType, JavaType valueType) throws JsonMappingException {
        return new MapEntrySerializer(valueType, keyType, valueType, staticTyping, this.createTypeSerializer(config, valueType), null);
    }

    protected JsonSerializer<?> buildEnumSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) throws JsonMappingException {
        JsonFormat.Value format = beanDesc.findExpectedFormat(null);
        if (format != null && format.getShape() == JsonFormat.Shape.OBJECT) {
            ((BasicBeanDescription)beanDesc).removeProperty("declaringClass");
            return null;
        }
        Class<?> enumClass = type.getRawClass();
        JsonSerializer ser = EnumSerializer.construct(enumClass, config, beanDesc, format);
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                ser = mod.modifyEnumSerializer(config, type, beanDesc, ser);
            }
        }
        return ser;
    }

    protected <T extends JavaType> T modifyTypeByAnnotation(SerializationConfig config, Annotated a, T type) {
        Class<?> superclass = config.getAnnotationIntrospector().findSerializationType(a);
        if (superclass != null) {
            try {
                type = type.widenBy(superclass);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Failed to widen type " + type + " with concrete-type annotation (value " + superclass.getName() + "), method '" + a.getName() + "': " + iae.getMessage());
            }
        }
        return BasicSerializerFactory.modifySecondaryTypesByAnnotation(config, a, type);
    }

    protected static <T extends JavaType> T modifySecondaryTypesByAnnotation(SerializationConfig config, Annotated a, T type) {
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        if (((JavaType)type).isContainerType()) {
            Class<?> cc;
            Class<?> keyClass = intr.findSerializationKeyType(a, ((JavaType)type).getKeyType());
            if (keyClass != null) {
                if (!(type instanceof MapType)) {
                    throw new IllegalArgumentException("Illegal key-type annotation: type " + type + " is not a Map type");
                }
                try {
                    type = ((MapType)type).widenKey(keyClass);
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException("Failed to narrow key type " + type + " with key-type annotation (" + keyClass.getName() + "): " + iae.getMessage());
                }
            }
            if ((cc = intr.findSerializationContentType(a, ((JavaType)type).getContentType())) != null) {
                try {
                    type = ((JavaType)type).widenContentsBy(cc);
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException("Failed to narrow content type " + type + " with content-type annotation (" + cc.getName() + "): " + iae.getMessage());
                }
            }
        }
        return (T)type;
    }

    protected JsonSerializer<Object> _findKeySerializer(SerializerProvider prov, Annotated a) throws JsonMappingException {
        AnnotationIntrospector intr = prov.getAnnotationIntrospector();
        Object serDef = intr.findKeySerializer(a);
        if (serDef != null) {
            return prov.serializerInstance(a, serDef);
        }
        return null;
    }

    protected JsonSerializer<Object> _findContentSerializer(SerializerProvider prov, Annotated a) throws JsonMappingException {
        AnnotationIntrospector intr = prov.getAnnotationIntrospector();
        Object serDef = intr.findContentSerializer(a);
        if (serDef != null) {
            return prov.serializerInstance(a, serDef);
        }
        return null;
    }

    protected Object findFilterId(SerializationConfig config, BeanDescription beanDesc) {
        return config.getAnnotationIntrospector().findFilterId((Annotated)beanDesc.getClassInfo());
    }

    protected boolean usesStaticTyping(SerializationConfig config, BeanDescription beanDesc, TypeSerializer typeSer) {
        if (typeSer != null) {
            return false;
        }
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        JsonSerialize.Typing t = intr.findSerializationTyping(beanDesc.getClassInfo());
        if (t != null && t != JsonSerialize.Typing.DEFAULT_TYPING) {
            return t == JsonSerialize.Typing.STATIC;
        }
        return config.isEnabled(MapperFeature.USE_STATIC_TYPING);
    }

    protected Class<?> _verifyAsClass(Object src, String methodName, Class<?> noneClass) {
        if (src == null) {
            return null;
        }
        if (!(src instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector." + methodName + "() returned value of type " + src.getClass().getName() + ": expected type JsonSerializer or Class<JsonSerializer> instead");
        }
        Class cls = (Class)src;
        if (cls == noneClass || ClassUtil.isBogusClass(cls)) {
            return null;
        }
        return cls;
    }

    static {
        _concrete.put(String.class.getName(), new StringSerializer());
        ToStringSerializer sls = ToStringSerializer.instance;
        _concrete.put(StringBuffer.class.getName(), sls);
        _concrete.put(StringBuilder.class.getName(), sls);
        _concrete.put(Character.class.getName(), sls);
        _concrete.put(Character.TYPE.getName(), sls);
        NumberSerializers.addAll(_concrete);
        _concrete.put(Boolean.TYPE.getName(), new BooleanSerializer(true));
        _concrete.put(Boolean.class.getName(), new BooleanSerializer(false));
        _concrete.put(BigInteger.class.getName(), new NumberSerializer((Class<? extends Number>)BigInteger.class));
        _concrete.put(BigDecimal.class.getName(), new NumberSerializer((Class<? extends Number>)BigDecimal.class));
        _concrete.put(Calendar.class.getName(), CalendarSerializer.instance);
        DateSerializer dateSer = DateSerializer.instance;
        _concrete.put(Date.class.getName(), dateSer);
        _concrete.put(Timestamp.class.getName(), dateSer);
        _concreteLazy.put(java.sql.Date.class.getName(), SqlDateSerializer.class);
        _concreteLazy.put(Time.class.getName(), SqlTimeSerializer.class);
        for (Map.Entry<Class<?>, Object> en : StdJdkSerializers.all()) {
            Object value = en.getValue();
            if (value instanceof JsonSerializer) {
                _concrete.put(en.getKey().getName(), (JsonSerializer)value);
                continue;
            }
            if (value instanceof Class) {
                Class cls = (Class)value;
                _concreteLazy.put(en.getKey().getName(), cls);
                continue;
            }
            throw new IllegalStateException("Internal error: unrecognized value of type " + en.getClass().getName());
        }
        _concreteLazy.put(TokenBuffer.class.getName(), TokenBufferSerializer.class);
    }
}

