/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.h2.command.ddl;

import java.util.ArrayList;
import java.util.HashSet;
import org.glowroot.shaded.h2.command.ddl.SchemaCommand;
import org.glowroot.shaded.h2.constraint.Constraint;
import org.glowroot.shaded.h2.constraint.ConstraintCheck;
import org.glowroot.shaded.h2.constraint.ConstraintReferential;
import org.glowroot.shaded.h2.constraint.ConstraintUnique;
import org.glowroot.shaded.h2.engine.Database;
import org.glowroot.shaded.h2.engine.Session;
import org.glowroot.shaded.h2.expression.Expression;
import org.glowroot.shaded.h2.index.Index;
import org.glowroot.shaded.h2.index.IndexType;
import org.glowroot.shaded.h2.message.DbException;
import org.glowroot.shaded.h2.schema.Schema;
import org.glowroot.shaded.h2.table.Column;
import org.glowroot.shaded.h2.table.IndexColumn;
import org.glowroot.shaded.h2.table.Table;
import org.glowroot.shaded.h2.table.TableFilter;
import org.glowroot.shaded.h2.util.New;

public class AlterTableAddConstraint
extends SchemaCommand {
    private int type;
    private String constraintName;
    private String tableName;
    private IndexColumn[] indexColumns;
    private int deleteAction;
    private int updateAction;
    private Schema refSchema;
    private String refTableName;
    private IndexColumn[] refIndexColumns;
    private Expression checkExpression;
    private Index index;
    private Index refIndex;
    private String comment;
    private boolean checkExisting;
    private boolean primaryKeyHash;
    private final boolean ifNotExists;
    private ArrayList<Index> createdIndexes = New.arrayList();

    public AlterTableAddConstraint(Session session, Schema schema, boolean bl) {
        super(session, schema);
        this.ifNotExists = bl;
    }

    private String generateConstraintName(Table table) {
        if (this.constraintName == null) {
            this.constraintName = this.getSchema().getUniqueConstraintName(this.session, table);
        }
        return this.constraintName;
    }

    @Override
    public int update() {
        try {
            int n = this.tryUpdate();
            return n;
        }
        catch (DbException dbException) {
            for (Index index : this.createdIndexes) {
                this.session.getDatabase().removeSchemaObject(this.session, index);
            }
            throw dbException;
        }
        finally {
            this.getSchema().freeUniqueName(this.constraintName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int tryUpdate() {
        Constraint constraint;
        if (!this.transactional) {
            this.session.commit(true);
        }
        Database database = this.session.getDatabase();
        Table table = this.getSchema().getTableOrView(this.session, this.tableName);
        if (this.getSchema().findConstraint(this.session, this.constraintName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw DbException.get(90045, this.constraintName);
        }
        this.session.getUser().checkRight(table, 15);
        database.lockMeta(this.session);
        table.lock(this.session, true, true);
        switch (this.type) {
            case 6: {
                int n;
                IndexColumn.mapColumns(this.indexColumns, table);
                this.index = table.findPrimaryKey();
                ArrayList<Constraint> arrayList = table.getConstraints();
                for (n = 0; arrayList != null && n < arrayList.size(); ++n) {
                    Constraint constraint2 = arrayList.get(n);
                    if (!"PRIMARY KEY".equals(constraint2.getConstraintType())) continue;
                    throw DbException.get(90017);
                }
                if (this.index != null) {
                    IndexColumn[] indexColumnArray = this.index.getIndexColumns();
                    if (indexColumnArray.length != this.indexColumns.length) {
                        throw DbException.get(90017);
                    }
                    for (int i = 0; i < indexColumnArray.length; ++i) {
                        if (indexColumnArray[i].column == this.indexColumns[i].column) continue;
                        throw DbException.get(90017);
                    }
                }
                if (this.index == null) {
                    IndexType indexType = IndexType.createPrimaryKey(table.isPersistIndexes(), this.primaryKeyHash);
                    String string = table.getSchema().getUniqueIndexName(this.session, table, "PRIMARY_KEY_");
                    int n2 = this.getObjectId();
                    try {
                        this.index = table.addIndex(this.session, string, n2, this.indexColumns, indexType, true, null);
                    }
                    finally {
                        this.getSchema().freeUniqueName(string);
                    }
                }
                this.index.getIndexType().setBelongsToConstraint(true);
                n = this.getObjectId();
                String string = this.generateConstraintName(table);
                ConstraintUnique constraintUnique = new ConstraintUnique(this.getSchema(), n, string, table, true);
                constraintUnique.setColumns(this.indexColumns);
                constraintUnique.setIndex(this.index, true);
                constraint = constraintUnique;
                break;
            }
            case 4: {
                IndexColumn.mapColumns(this.indexColumns, table);
                boolean bl = false;
                if (this.index != null && AlterTableAddConstraint.canUseUniqueIndex(this.index, table, this.indexColumns)) {
                    bl = true;
                    this.index.getIndexType().setBelongsToConstraint(true);
                } else {
                    this.index = AlterTableAddConstraint.getUniqueIndex(table, this.indexColumns);
                    if (this.index == null) {
                        this.index = this.createIndex(table, this.indexColumns, true);
                        bl = true;
                    }
                }
                int n = this.getObjectId();
                String string = this.generateConstraintName(table);
                ConstraintUnique constraintUnique = new ConstraintUnique(this.getSchema(), n, string, table, false);
                constraintUnique.setColumns(this.indexColumns);
                constraintUnique.setIndex(this.index, bl);
                constraint = constraintUnique;
                break;
            }
            case 3: {
                int n = this.getObjectId();
                String string = this.generateConstraintName(table);
                ConstraintCheck constraintCheck = new ConstraintCheck(this.getSchema(), n, string, table);
                TableFilter tableFilter = new TableFilter(this.session, table, null, false, null);
                this.checkExpression.mapColumns(tableFilter, 0);
                this.checkExpression = this.checkExpression.optimize(this.session);
                constraintCheck.setExpression(this.checkExpression);
                constraintCheck.setTableFilter(tableFilter);
                constraint = constraintCheck;
                if (!this.checkExisting) break;
                constraintCheck.checkExistingData(this.session);
                break;
            }
            case 5: {
                Table table2 = this.refSchema.getTableOrView(this.session, this.refTableName);
                this.session.getUser().checkRight(table2, 15);
                if (!table2.canReference()) {
                    throw DbException.getUnsupportedException("Reference " + table2.getSQL());
                }
                boolean bl = false;
                IndexColumn.mapColumns(this.indexColumns, table);
                if (this.index != null && AlterTableAddConstraint.canUseIndex(this.index, table, this.indexColumns)) {
                    bl = true;
                    this.index.getIndexType().setBelongsToConstraint(true);
                } else {
                    this.index = AlterTableAddConstraint.getIndex(table, this.indexColumns);
                    if (this.index == null) {
                        this.index = this.createIndex(table, this.indexColumns, false);
                        bl = true;
                    }
                }
                if (this.refIndexColumns == null) {
                    Index index = table2.getPrimaryKey();
                    this.refIndexColumns = index.getIndexColumns();
                } else {
                    IndexColumn.mapColumns(this.refIndexColumns, table2);
                }
                if (this.refIndexColumns.length != this.indexColumns.length) {
                    throw DbException.get(21002);
                }
                boolean bl2 = false;
                if (this.refIndex != null && this.refIndex.getTable() == table2 && AlterTableAddConstraint.canUseIndex(this.refIndex, table2, this.refIndexColumns)) {
                    bl2 = true;
                    this.refIndex.getIndexType().setBelongsToConstraint(true);
                } else {
                    this.refIndex = null;
                }
                if (this.refIndex == null) {
                    this.refIndex = AlterTableAddConstraint.getIndex(table2, this.refIndexColumns);
                    if (this.refIndex == null) {
                        this.refIndex = this.createIndex(table2, this.refIndexColumns, true);
                        bl2 = true;
                    }
                }
                int n = this.getObjectId();
                String string = this.generateConstraintName(table);
                ConstraintReferential constraintReferential = new ConstraintReferential(this.getSchema(), n, string, table);
                constraintReferential.setColumns(this.indexColumns);
                constraintReferential.setIndex(this.index, bl);
                constraintReferential.setRefTable(table2);
                constraintReferential.setRefColumns(this.refIndexColumns);
                constraintReferential.setRefIndex(this.refIndex, bl2);
                if (this.checkExisting) {
                    constraintReferential.checkExistingData(this.session);
                }
                constraint = constraintReferential;
                table2.addConstraint(constraint);
                constraintReferential.setDeleteAction(this.deleteAction);
                constraintReferential.setUpdateAction(this.updateAction);
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + this.type);
            }
        }
        constraint.setComment(this.comment);
        if (table.isTemporary() && !table.isGlobalTemporary()) {
            this.session.addLocalTempTableConstraint(constraint);
        } else {
            database.addSchemaObject(this.session, constraint);
        }
        table.addConstraint(constraint);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Index createIndex(Table table, IndexColumn[] indexColumnArray, boolean bl) {
        int n = this.getObjectId();
        IndexType indexType = bl ? IndexType.createUnique(table.isPersistIndexes(), false) : IndexType.createNonUnique(table.isPersistIndexes());
        indexType.setBelongsToConstraint(true);
        String string = this.constraintName == null ? "CONSTRAINT" : this.constraintName;
        String string2 = table.getSchema().getUniqueIndexName(this.session, table, string + "_INDEX_");
        try {
            Index index = table.addIndex(this.session, string2, n, indexColumnArray, indexType, true, null);
            this.createdIndexes.add(index);
            Index index2 = index;
            return index2;
        }
        finally {
            this.getSchema().freeUniqueName(string2);
        }
    }

    public void setDeleteAction(int n) {
        this.deleteAction = n;
    }

    public void setUpdateAction(int n) {
        this.updateAction = n;
    }

    private static Index getUniqueIndex(Table table, IndexColumn[] indexColumnArray) {
        for (Index index : table.getIndexes()) {
            if (!AlterTableAddConstraint.canUseUniqueIndex(index, table, indexColumnArray)) continue;
            return index;
        }
        return null;
    }

    private static Index getIndex(Table table, IndexColumn[] indexColumnArray) {
        for (Index index : table.getIndexes()) {
            if (!AlterTableAddConstraint.canUseIndex(index, table, indexColumnArray)) continue;
            return index;
        }
        return null;
    }

    private static boolean canUseUniqueIndex(Index index, Table table, IndexColumn[] indexColumnArray) {
        if (index.getTable() != table || !index.getIndexType().isUnique()) {
            return false;
        }
        Column[] columnArray = index.getColumns();
        if (columnArray.length > indexColumnArray.length) {
            return false;
        }
        HashSet hashSet = New.hashSet();
        for (IndexColumn object : indexColumnArray) {
            hashSet.add(object.column);
        }
        for (Column column : columnArray) {
            if (hashSet.contains(column)) continue;
            return false;
        }
        return true;
    }

    private static boolean canUseIndex(Index index, Table table, IndexColumn[] indexColumnArray) {
        if (index.getTable() != table || index.getCreateSQL() == null) {
            return false;
        }
        Column[] columnArray = index.getColumns();
        if (columnArray.length != indexColumnArray.length) {
            return false;
        }
        for (IndexColumn indexColumn : indexColumnArray) {
            int n = index.getColumnIndex(indexColumn.column);
            if (n >= 0) continue;
            return false;
        }
        return true;
    }

    public void setConstraintName(String string) {
        this.constraintName = string;
    }

    public void setType(int n) {
        this.type = n;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void setCheckExpression(Expression expression) {
        this.checkExpression = expression;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public void setIndexColumns(IndexColumn[] indexColumnArray) {
        this.indexColumns = indexColumnArray;
    }

    public IndexColumn[] getIndexColumns() {
        return this.indexColumns;
    }

    public void setRefTableName(Schema schema, String string) {
        this.refSchema = schema;
        this.refTableName = string;
    }

    public void setRefIndexColumns(IndexColumn[] indexColumnArray) {
        this.refIndexColumns = indexColumnArray;
    }

    public void setIndex(Index index) {
        this.index = index;
    }

    public void setRefIndex(Index index) {
        this.refIndex = index;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setCheckExisting(boolean bl) {
        this.checkExisting = bl;
    }

    public void setPrimaryKeyHash(boolean bl) {
        this.primaryKeyHash = bl;
    }
}

