/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.h2.command.ddl;

import org.glowroot.shaded.h2.command.ddl.SchemaCommand;
import org.glowroot.shaded.h2.engine.DbObject;
import org.glowroot.shaded.h2.engine.Session;
import org.glowroot.shaded.h2.message.DbException;
import org.glowroot.shaded.h2.schema.Schema;
import org.glowroot.shaded.h2.table.Table;
import org.glowroot.shaded.h2.table.TableView;

public class DropView
extends SchemaCommand {
    private String viewName;
    private boolean ifExists;
    private int dropAction;

    public DropView(Session session, Schema schema) {
        super(session, schema);
        this.dropAction = session.getDatabase().getSettings().dropRestrict ? 0 : 1;
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }

    public void setDropAction(int n) {
        this.dropAction = n;
    }

    public void setViewName(String string) {
        this.viewName = string;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Table table = this.getSchema().findTableOrView(this.session, this.viewName);
        if (table == null) {
            if (!this.ifExists) {
                throw DbException.get(90037, this.viewName);
            }
        } else {
            if (!"VIEW".equals(table.getTableType())) {
                throw DbException.get(90037, this.viewName);
            }
            this.session.getUser().checkRight(table, 15);
            if (this.dropAction == 0) {
                for (DbObject dbObject : table.getChildren()) {
                    if (!(dbObject instanceof TableView)) continue;
                    throw DbException.get(90107, this.viewName, dbObject.getName());
                }
            }
            table.lock(this.session, true, true);
            this.session.getDatabase().removeSchemaObject(this.session, table);
        }
        return 0;
    }

    @Override
    public int getType() {
        return 48;
    }
}

