/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.h2.result;

import org.glowroot.shaded.h2.result.SearchRow;
import org.glowroot.shaded.h2.util.StatementBuilder;
import org.glowroot.shaded.h2.value.Value;

public class SimpleRow
implements SearchRow {
    private long key;
    private int version;
    private final Value[] data;
    private int memory;

    public SimpleRow(Value[] valueArray) {
        this.data = valueArray;
    }

    @Override
    public int getColumnCount() {
        return this.data.length;
    }

    @Override
    public long getKey() {
        return this.key;
    }

    @Override
    public void setKey(long l) {
        this.key = l;
    }

    @Override
    public void setKeyAndVersion(SearchRow searchRow) {
        this.key = searchRow.getKey();
        this.version = searchRow.getVersion();
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setValue(int n, Value value) {
        this.data[n] = value;
    }

    @Override
    public Value getValue(int n) {
        return this.data[n];
    }

    public String toString() {
        StatementBuilder statementBuilder = new StatementBuilder("( /* key:");
        statementBuilder.append(this.getKey());
        if (this.version != 0) {
            statementBuilder.append(" v:" + this.version);
        }
        statementBuilder.append(" */ ");
        for (Value value : this.data) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(value == null ? "null" : value.getTraceSQL());
        }
        return statementBuilder.append(')').toString();
    }

    @Override
    public int getMemory() {
        if (this.memory == 0) {
            int n = this.data.length;
            this.memory = 24 + n * 8;
            for (int i = 0; i < n; ++i) {
                Value value = this.data[i];
                if (value == null) continue;
                this.memory += value.getMemory();
            }
        }
        return this.memory;
    }
}

