/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.h2.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.glowroot.shaded.h2.Driver;
import org.glowroot.shaded.h2.message.DbException;
import org.glowroot.shaded.h2.message.TraceSystem;
import org.glowroot.shaded.h2.server.Service;
import org.glowroot.shaded.h2.server.ShutdownHandler;
import org.glowroot.shaded.h2.server.TcpServerThread;
import org.glowroot.shaded.h2.util.JdbcUtils;
import org.glowroot.shaded.h2.util.NetUtils;
import org.glowroot.shaded.h2.util.New;
import org.glowroot.shaded.h2.util.StringUtils;
import org.glowroot.shaded.h2.util.Tool;

public class TcpServer
implements Service {
    private static final int SHUTDOWN_NORMAL = 0;
    private static final int SHUTDOWN_FORCE = 1;
    private static final String MANAGEMENT_DB_PREFIX = "management_db_";
    private static final Map<Integer, TcpServer> SERVERS = Collections.synchronizedMap(new HashMap());
    private int port;
    private boolean portIsSet;
    private boolean trace;
    private boolean ssl;
    private boolean stop;
    private ShutdownHandler shutdownHandler;
    private ServerSocket serverSocket;
    private final Set<TcpServerThread> running = Collections.synchronizedSet(new HashSet());
    private String baseDir;
    private boolean allowOthers;
    private boolean isDaemon;
    private boolean ifExists;
    private Connection managementDb;
    private PreparedStatement managementDbAdd;
    private PreparedStatement managementDbRemove;
    private String managementPassword = "";
    private Thread listenerThread;
    private int nextThreadId;
    private String key;
    private String keyDatabase;

    public static String getManagementDbName(int n) {
        return "mem:management_db_" + n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initManagementDb() throws SQLException {
        Connection connection;
        Properties properties = new Properties();
        properties.setProperty("user", "");
        properties.setProperty("password", this.managementPassword);
        this.managementDb = connection = Driver.load().connect("jdbc:h2:" + TcpServer.getManagementDbName(this.port), properties);
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.execute("CREATE ALIAS IF NOT EXISTS STOP_SERVER FOR \"" + TcpServer.class.getName() + ".stopServer\"");
            statement.execute("CREATE TABLE IF NOT EXISTS SESSIONS(ID INT PRIMARY KEY, URL VARCHAR, USER VARCHAR, CONNECTED TIMESTAMP)");
            this.managementDbAdd = connection.prepareStatement("INSERT INTO SESSIONS VALUES(?, ?, ?, NOW())");
            this.managementDbRemove = connection.prepareStatement("DELETE FROM SESSIONS WHERE ID=?");
        }
        finally {
            JdbcUtils.closeSilently(statement);
        }
        SERVERS.put(this.port, this);
    }

    void shutdown() {
        if (this.shutdownHandler != null) {
            this.shutdownHandler.shutdown();
        }
    }

    public void setShutdownHandler(ShutdownHandler shutdownHandler) {
        this.shutdownHandler = shutdownHandler;
    }

    synchronized void addConnection(int n, String string, String string2) {
        try {
            this.managementDbAdd.setInt(1, n);
            this.managementDbAdd.setString(2, string);
            this.managementDbAdd.setString(3, string2);
            this.managementDbAdd.execute();
        }
        catch (SQLException sQLException) {
            TraceSystem.traceThrowable(sQLException);
        }
    }

    synchronized void removeConnection(int n) {
        try {
            this.managementDbRemove.setInt(1, n);
            this.managementDbRemove.execute();
        }
        catch (SQLException sQLException) {
            TraceSystem.traceThrowable(sQLException);
        }
    }

    private synchronized void stopManagementDb() {
        if (this.managementDb != null) {
            try {
                this.managementDb.close();
            }
            catch (SQLException sQLException) {
                TraceSystem.traceThrowable(sQLException);
            }
            this.managementDb = null;
        }
    }

    @Override
    public void init(String ... stringArray) {
        this.port = 9092;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (Tool.isOption(string, "-trace")) {
                this.trace = true;
                continue;
            }
            if (Tool.isOption(string, "-tcpSSL")) {
                this.ssl = true;
                continue;
            }
            if (Tool.isOption(string, "-tcpPort")) {
                this.port = Integer.decode(stringArray[++i]);
                this.portIsSet = true;
                continue;
            }
            if (Tool.isOption(string, "-tcpPassword")) {
                this.managementPassword = stringArray[++i];
                continue;
            }
            if (Tool.isOption(string, "-baseDir")) {
                this.baseDir = stringArray[++i];
                continue;
            }
            if (Tool.isOption(string, "-key")) {
                this.key = stringArray[++i];
                this.keyDatabase = stringArray[++i];
                continue;
            }
            if (Tool.isOption(string, "-tcpAllowOthers")) {
                this.allowOthers = true;
                continue;
            }
            if (Tool.isOption(string, "-tcpDaemon")) {
                this.isDaemon = true;
                continue;
            }
            if (!Tool.isOption(string, "-ifExists")) continue;
            this.ifExists = true;
        }
        Driver.load();
    }

    @Override
    public String getURL() {
        return (this.ssl ? "ssl" : "tcp") + "://" + NetUtils.getLocalAddress() + ":" + this.port;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    boolean allow(Socket socket) {
        if (this.allowOthers) {
            return true;
        }
        try {
            return NetUtils.isLocalAddress(socket);
        }
        catch (UnknownHostException unknownHostException) {
            this.traceError(unknownHostException);
            return false;
        }
    }

    @Override
    public synchronized void start() throws SQLException {
        this.stop = false;
        try {
            this.serverSocket = NetUtils.createServerSocket(this.port, this.ssl);
        }
        catch (DbException dbException) {
            if (!this.portIsSet) {
                this.serverSocket = NetUtils.createServerSocket(0, this.ssl);
            }
            throw dbException;
        }
        this.port = this.serverSocket.getLocalPort();
        this.initManagementDb();
    }

    @Override
    public void listen() {
        block3: {
            this.listenerThread = Thread.currentThread();
            String string = this.listenerThread.getName();
            try {
                while (!this.stop) {
                    Socket socket = this.serverSocket.accept();
                    TcpServerThread tcpServerThread = new TcpServerThread(socket, this, this.nextThreadId++);
                    this.running.add(tcpServerThread);
                    Thread thread = new Thread((Runnable)tcpServerThread, string + " thread");
                    thread.setDaemon(this.isDaemon);
                    tcpServerThread.setThread(thread);
                    thread.start();
                }
                this.serverSocket = NetUtils.closeSilently(this.serverSocket);
            }
            catch (Exception exception) {
                if (this.stop) break block3;
                TraceSystem.traceThrowable(exception);
            }
        }
        this.stopManagementDb();
    }

    @Override
    public synchronized boolean isRunning(boolean bl) {
        if (this.serverSocket == null) {
            return false;
        }
        try {
            Socket socket = NetUtils.createLoopbackSocket(this.port, this.ssl);
            socket.close();
            return true;
        }
        catch (Exception exception) {
            if (bl) {
                this.traceError(exception);
            }
            return false;
        }
    }

    @Override
    public void stop() {
        SERVERS.remove(this.port);
        if (!this.stop) {
            this.stopManagementDb();
            this.stop = true;
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    TraceSystem.traceThrowable(iOException);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.serverSocket = null;
            }
            if (this.listenerThread != null) {
                try {
                    this.listenerThread.join(1000L);
                }
                catch (InterruptedException interruptedException) {
                    TraceSystem.traceThrowable(interruptedException);
                }
            }
        }
        for (TcpServerThread tcpServerThread : New.arrayList(this.running)) {
            if (tcpServerThread == null) continue;
            tcpServerThread.close();
            try {
                tcpServerThread.getThread().join(100L);
            }
            catch (Exception exception) {
                TraceSystem.traceThrowable(exception);
            }
        }
    }

    public static void stopServer(int n, String string, int n2) {
        if (n == 0) {
            Integer[] integerArray = SERVERS.keySet().toArray(new Integer[0]);
            int n3 = integerArray.length;
            for (int i = 0; i < n3; ++i) {
                int n4 = integerArray[i];
                if (n4 == 0) continue;
                TcpServer.stopServer(n4, string, n2);
            }
            return;
        }
        TcpServer tcpServer = SERVERS.get(n);
        if (tcpServer == null) {
            return;
        }
        if (!tcpServer.managementPassword.equals(string)) {
            return;
        }
        if (n2 == 0) {
            tcpServer.stopManagementDb();
            tcpServer.stop = true;
            try {
                Socket socket = NetUtils.createLoopbackSocket(n, false);
                socket.close();
            }
            catch (Exception exception) {}
        } else if (n2 == 1) {
            tcpServer.stop();
        }
        tcpServer.shutdown();
    }

    void remove(TcpServerThread tcpServerThread) {
        this.running.remove(tcpServerThread);
    }

    String getBaseDir() {
        return this.baseDir;
    }

    void trace(String string) {
        if (this.trace) {
            System.out.println(string);
        }
    }

    void traceError(Throwable throwable) {
        if (this.trace) {
            throwable.printStackTrace();
        }
    }

    @Override
    public boolean getAllowOthers() {
        return this.allowOthers;
    }

    @Override
    public String getType() {
        return "TCP";
    }

    @Override
    public String getName() {
        return "H2 TCP Server";
    }

    boolean getIfExists() {
        return this.ifExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void shutdown(String string, String string2, boolean bl, boolean bl2) throws SQLException {
        try {
            String string3;
            int n = 9092;
            int n2 = string.lastIndexOf(58);
            if (n2 >= 0 && StringUtils.isNumber(string3 = string.substring(n2 + 1))) {
                n = Integer.decode(string3);
            }
            string3 = TcpServer.getManagementDbName(n);
            try {
                Driver.load();
            }
            catch (Throwable throwable) {
                throw DbException.convert(throwable);
            }
            for (int i = 0; i < 2; ++i) {
                Connection connection = null;
                PreparedStatement preparedStatement = null;
                try {
                    block13: {
                        connection = DriverManager.getConnection("jdbc:h2:" + string + "/" + string3, "", string2);
                        preparedStatement = connection.prepareStatement("CALL STOP_SERVER(?, ?, ?)");
                        preparedStatement.setInt(1, bl2 ? 0 : n);
                        preparedStatement.setString(2, string2);
                        preparedStatement.setInt(3, bl ? 1 : 0);
                        try {
                            preparedStatement.execute();
                        }
                        catch (SQLException sQLException) {
                            if (bl || sQLException.getErrorCode() == 90067) break block13;
                            throw sQLException;
                        }
                    }
                    JdbcUtils.closeSilently(preparedStatement);
                }
                catch (SQLException sQLException) {
                    if (i != 1) continue;
                    throw sQLException;
                }
                finally {
                    JdbcUtils.closeSilently(preparedStatement);
                    JdbcUtils.closeSilently(connection);
                }
                JdbcUtils.closeSilently(connection);
                break;
            }
        }
        catch (Exception exception) {
            throw DbException.toSQLException(exception);
        }
    }

    void cancelStatement(String string, int n) {
        for (TcpServerThread tcpServerThread : New.arrayList(this.running)) {
            if (tcpServerThread == null) continue;
            tcpServerThread.cancelStatement(string, n);
        }
    }

    public String checkKeyAndGetDatabaseName(String string) {
        if (this.key == null) {
            return string;
        }
        if (this.key.equals(string)) {
            return this.keyDatabase;
        }
        throw DbException.get(28000);
    }

    @Override
    public boolean isDaemon() {
        return this.isDaemon;
    }
}

