/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.h2.store.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.glowroot.shaded.h2.message.DbException;
import org.glowroot.shaded.h2.store.fs.FileChannelInputStream;
import org.glowroot.shaded.h2.store.fs.FilePath;
import org.glowroot.shaded.h2.store.fs.FilePathDisk;
import org.glowroot.shaded.h2.store.fs.FileZip;
import org.glowroot.shaded.h2.util.New;

public class FilePathZip
extends FilePath {
    @Override
    public FilePathZip getPath(String string) {
        FilePathZip filePathZip = new FilePathZip();
        filePathZip.name = string;
        return filePathZip;
    }

    @Override
    public void createDirectory() {
    }

    @Override
    public boolean createFile() {
        throw DbException.getUnsupportedException("write");
    }

    @Override
    public void delete() {
        throw DbException.getUnsupportedException("write");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() {
        boolean bl;
        String string = this.getEntryName();
        if (string.length() == 0) {
            return true;
        }
        ZipFile zipFile = this.openZipFile();
        try {
            bl = zipFile.getEntry(string) != null;
        }
        catch (Throwable throwable) {
            try {
                zipFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        zipFile.close();
        return bl;
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    @Override
    public FilePath getParent() {
        int n = this.name.lastIndexOf(47);
        return n < 0 ? null : this.getPath(this.name.substring(0, n));
    }

    @Override
    public boolean isAbsolute() {
        String string = FilePathZip.translateFileName(this.name);
        return FilePath.get(string).isAbsolute();
    }

    @Override
    public FilePath unwrap() {
        return FilePath.get(this.name.substring(this.getScheme().length() + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isDirectory() {
        try {
            String string = this.getEntryName();
            if (string.length() == 0) {
                return true;
            }
            ZipFile zipFile = this.openZipFile();
            try {
                String string2;
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                do {
                    if (!enumeration.hasMoreElements()) return false;
                    ZipEntry zipEntry = enumeration.nextElement();
                    string2 = zipEntry.getName();
                    if (!string2.equals(string)) continue;
                    boolean bl = zipEntry.isDirectory();
                    return bl;
                } while (!string2.startsWith(string) || string2.length() != string.length() + 1 || !string2.equals(string + "/"));
                boolean bl = true;
                return bl;
            }
            finally {
                zipFile.close();
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public boolean setReadOnly() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() {
        long l;
        ZipFile zipFile = this.openZipFile();
        try {
            ZipEntry zipEntry = zipFile.getEntry(this.getEntryName());
            l = zipEntry == null ? 0L : zipEntry.getSize();
        }
        catch (Throwable throwable) {
            try {
                zipFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                return 0L;
            }
        }
        zipFile.close();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<FilePath> newDirectoryStream() {
        String string = this.name;
        ArrayList<FilePath> arrayList = New.arrayList();
        try {
            if (string.indexOf(33) < 0) {
                string = string + "!";
            }
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            ZipFile zipFile = this.openZipFile();
            try {
                String string2 = this.getEntryName();
                String string3 = string.substring(0, string.length() - string2.length());
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    int n;
                    ZipEntry zipEntry = enumeration.nextElement();
                    String string4 = zipEntry.getName();
                    if (!string4.startsWith(string2) || string4.length() <= string2.length() || (n = string4.indexOf(47, string2.length())) >= 0 && n < string4.length() - 1) continue;
                    arrayList.add(this.getPath(string3 + string4));
                }
            }
            finally {
                zipFile.close();
            }
            return arrayList;
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, "listFiles " + string);
        }
    }

    @Override
    public InputStream newInputStream() throws IOException {
        return new FileChannelInputStream(this.open("r"), true);
    }

    @Override
    public FileChannel open(String string) throws IOException {
        ZipFile zipFile = this.openZipFile();
        ZipEntry zipEntry = zipFile.getEntry(this.getEntryName());
        if (zipEntry == null) {
            zipFile.close();
            throw new FileNotFoundException(this.name);
        }
        return new FileZip(zipFile, zipEntry);
    }

    @Override
    public OutputStream newOutputStream(boolean bl) throws IOException {
        throw new IOException("write");
    }

    @Override
    public void moveTo(FilePath filePath) {
        throw DbException.getUnsupportedException("write");
    }

    private static String translateFileName(String string) {
        int n;
        if (string.startsWith("zip:")) {
            string = string.substring("zip:".length());
        }
        if ((n = string.indexOf(33)) >= 0) {
            string = string.substring(0, n);
        }
        return FilePathDisk.expandUserHomeDirectory(string);
    }

    @Override
    public FilePath toRealPath() {
        return this;
    }

    private String getEntryName() {
        int n = this.name.indexOf(33);
        String string = n <= 0 ? "" : this.name.substring(n + 1);
        if ((string = string.replace('\\', '/')).startsWith("/")) {
            string = string.substring(1);
        }
        return string;
    }

    private ZipFile openZipFile() throws IOException {
        String string = FilePathZip.translateFileName(this.name);
        return new ZipFile(string);
    }

    @Override
    public FilePath createTempFile(String string, boolean bl, boolean bl2) throws IOException {
        if (!bl2) {
            throw new IOException("File system is read-only");
        }
        return new FilePathDisk().getPath(this.name).createTempFile(string, bl, true);
    }

    @Override
    public String getScheme() {
        return "zip";
    }
}

