/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.glowroot.common.ScheduledRunnable;
import org.glowroot.common.Tickers;
import org.glowroot.config.ConfigService;
import org.glowroot.shaded.google.common.base.Ticker;
import org.glowroot.transaction.ImmediateTraceStoreRunnable;
import org.glowroot.transaction.TransactionCollector;
import org.glowroot.transaction.TransactionRegistry;
import org.glowroot.transaction.model.Transaction;

class ImmediateTraceStoreWatcher
extends ScheduledRunnable {
    static final int PERIOD_MILLIS = 1000;
    private final ScheduledExecutorService scheduledExecutor;
    private final TransactionRegistry transactionRegistry;
    private final TransactionCollector transactionCollector;
    private final ConfigService configService;
    private final Ticker ticker;

    ImmediateTraceStoreWatcher(ScheduledExecutorService scheduledExecutor, TransactionRegistry transactionRegistry, TransactionCollector transactionCollector, ConfigService configService, Ticker ticker) {
        this.scheduledExecutor = scheduledExecutor;
        this.transactionRegistry = transactionRegistry;
        this.transactionCollector = transactionCollector;
        this.configService = configService;
        this.ticker = ticker;
    }

    @Override
    protected void runInternal() {
        int immediatePartialStoreThresholdSeconds = this.configService.getAdvancedConfig().immediatePartialStoreThresholdSeconds();
        long immediatePartialStoreTick = this.ticker.read() - TimeUnit.SECONDS.toNanos(immediatePartialStoreThresholdSeconds) + TimeUnit.MILLISECONDS.toNanos(1000L);
        for (Transaction transaction : this.transactionRegistry.getTransactions()) {
            if (!Tickers.lessThanOrEqual(transaction.getStartTick(), immediatePartialStoreTick) || transaction.getImmedateTraceStoreRunnable() != null) continue;
            long initialDelayMillis = Math.max(0L, TimeUnit.SECONDS.toMillis(immediatePartialStoreThresholdSeconds) - TimeUnit.NANOSECONDS.toMillis(transaction.getDuration()));
            ImmediateTraceStoreRunnable immediateTraceStoreRunnable = new ImmediateTraceStoreRunnable(transaction, this.transactionCollector);
            long repeatingIntervalSeconds = Math.max(60, immediatePartialStoreThresholdSeconds);
            immediateTraceStoreRunnable.scheduleAtFixedRate(this.scheduledExecutor, initialDelayMillis, TimeUnit.SECONDS.toMillis(repeatingIntervalSeconds), TimeUnit.MILLISECONDS);
            transaction.setImmediateTraceStoreRunnable(immediateTraceStoreRunnable);
        }
    }
}

