/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.api.ErrorMessage;
import org.glowroot.api.MessageSupplier;
import org.glowroot.api.PluginServices;
import org.glowroot.api.QueryEntry;
import org.glowroot.api.Timer;
import org.glowroot.api.TimerName;
import org.glowroot.api.TraceEntry;
import org.glowroot.api.internal.ReadableErrorMessage;
import org.glowroot.common.Clock;
import org.glowroot.config.AdvancedConfig;
import org.glowroot.config.ConfigService;
import org.glowroot.config.GeneralConfig;
import org.glowroot.config.PluginConfig;
import org.glowroot.config.PluginDescriptor;
import org.glowroot.jvm.ThreadAllocatedBytes;
import org.glowroot.shaded.google.common.base.Joiner;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.base.Strings;
import org.glowroot.shaded.google.common.base.Ticker;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.MapMaker;
import org.glowroot.shaded.google.common.primitives.Ints;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.glowroot.transaction.TimerNameCache;
import org.glowroot.transaction.TransactionCollector;
import org.glowroot.transaction.TransactionRegistry;
import org.glowroot.transaction.UserProfileScheduler;
import org.glowroot.transaction.model.QueryData;
import org.glowroot.transaction.model.TimerImpl;
import org.glowroot.transaction.model.TimerNameImpl;
import org.glowroot.transaction.model.TraceEntryImpl;
import org.glowroot.transaction.model.Transaction;

class PluginServicesImpl
extends PluginServices
implements PluginServices.ConfigListener {
    private static final Logger logger = LoggerFactory.getLogger(PluginServicesImpl.class);
    private final TransactionRegistry transactionRegistry;
    private final TransactionCollector transactionCollector;
    private final ConfigService configService;
    private final TimerNameCache timerNameCache;
    @Nullable
    private final ThreadAllocatedBytes threadAllocatedBytes;
    private final UserProfileScheduler userProfileScheduler;
    private final Clock clock;
    private final Ticker ticker;
    private final TransactionCompletionCallback transactionCompletionCallback = new TransactionCompletionCallback();
    @Nullable
    private final String pluginId;
    private boolean enabled;
    private boolean captureThreadInfo;
    private boolean captureGcInfo;
    private int maxAggregateQueriesPerQueryType;
    private int maxTraceEntriesPerTransaction;
    @MonotonicNonNull
    private PluginConfig pluginConfig;
    private final Map<PluginServices.ConfigListener, Boolean> weakConfigListeners = new MapMaker().weakKeys().makeMap();
    private volatile boolean memoryBarrier;

    static PluginServicesImpl create(TransactionRegistry transactionRegistry, TransactionCollector transactionCollector, ConfigService configService, TimerNameCache timerNameCache, @Nullable ThreadAllocatedBytes threadAllocatedBytes, UserProfileScheduler userProfileScheduler, Ticker ticker, Clock clock, List<PluginDescriptor> pluginDescriptors, @Nullable String pluginId) {
        PluginServicesImpl pluginServices = new PluginServicesImpl(transactionRegistry, transactionCollector, configService, timerNameCache, threadAllocatedBytes, userProfileScheduler, ticker, clock, pluginDescriptors, pluginId);
        if (pluginId != null) {
            configService.addPluginConfigListener(pluginId, pluginServices);
        }
        configService.addConfigListener(pluginServices);
        return pluginServices;
    }

    private PluginServicesImpl(TransactionRegistry transactionRegistry, TransactionCollector transactionCollector, ConfigService configService, TimerNameCache timerNameCache, @Nullable ThreadAllocatedBytes threadAllocatedBytes, UserProfileScheduler userProfileScheduler, Ticker ticker, Clock clock, List<PluginDescriptor> pluginDescriptors, @Nullable String pluginId) {
        this.transactionRegistry = transactionRegistry;
        this.transactionCollector = transactionCollector;
        this.configService = configService;
        this.timerNameCache = timerNameCache;
        this.threadAllocatedBytes = threadAllocatedBytes;
        this.userProfileScheduler = userProfileScheduler;
        this.clock = clock;
        this.ticker = ticker;
        if (pluginId == null) {
            this.pluginId = null;
        } else {
            PluginConfig pluginConfig = configService.getPluginConfig(pluginId);
            if (pluginConfig == null) {
                ArrayList<String> ids = Lists.newArrayList();
                for (PluginDescriptor pluginDescriptor : pluginDescriptors) {
                    ids.add(pluginDescriptor.id());
                }
                logger.warn("unexpected plugin id: {} (available plugin ids are {})", (Object)pluginId, (Object)Joiner.on(", ").join(ids));
                this.pluginId = null;
            } else {
                this.pluginId = pluginId;
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public PluginServices.StringProperty getStringProperty(String name) {
        if (name == null) {
            logger.error("getStringProperty(): argument 'name' must be non-null");
            return new StringPropertyImpl("");
        }
        StringPropertyImpl stringProperty = new StringPropertyImpl(name);
        this.weakConfigListeners.put(stringProperty, true);
        return stringProperty;
    }

    @Override
    public PluginServices.BooleanProperty getBooleanProperty(String name) {
        if (name == null) {
            logger.error("getBooleanProperty(): argument 'name' must be non-null");
            return new BooleanPropertyImpl("");
        }
        BooleanPropertyImpl booleanProperty = new BooleanPropertyImpl(name);
        this.weakConfigListeners.put(booleanProperty, true);
        return booleanProperty;
    }

    @Override
    public PluginServices.DoubleProperty getDoubleProperty(String name) {
        if (name == null) {
            logger.error("getDoubleProperty(): argument 'name' must be non-null");
            return new DoublePropertyImpl("");
        }
        DoublePropertyImpl doubleProperty = new DoublePropertyImpl(name);
        this.weakConfigListeners.put(doubleProperty, true);
        return doubleProperty;
    }

    @Override
    public PluginServices.BooleanProperty getEnabledProperty(String name) {
        if (name == null) {
            logger.error("getEnabledProperty(): argument 'name' must be non-null");
            return new BooleanPropertyImpl("");
        }
        EnabledPropertyImpl enabledProperty = new EnabledPropertyImpl(name);
        this.weakConfigListeners.put(enabledProperty, true);
        return enabledProperty;
    }

    @Override
    public void registerConfigListener(PluginServices.ConfigListener listener) {
        if (this.pluginId == null) {
            return;
        }
        if (listener == null) {
            logger.error("registerConfigListener(): argument 'listener' must be non-null");
            return;
        }
        this.configService.addPluginConfigListener(this.pluginId, listener);
        listener.onChange();
    }

    @Override
    public TimerName getTimerName(Class<?> adviceClass) {
        return this.timerNameCache.getName(adviceClass);
    }

    @Override
    public TraceEntry startTransaction(String transactionType, String transactionName, MessageSupplier messageSupplier, TimerName timerName) {
        if (transactionType == null) {
            logger.error("startTransaction(): argument 'transactionType' must be non-null");
            return NopTraceEntry.INSTANCE;
        }
        if (transactionName == null) {
            logger.error("startTransaction(): argument 'transactionName' must be non-null");
            return NopTraceEntry.INSTANCE;
        }
        if (messageSupplier == null) {
            logger.error("startTransaction(): argument 'messageSupplier' must be non-null");
            return NopTraceEntry.INSTANCE;
        }
        if (timerName == null) {
            logger.error("startTransaction(): argument 'timerName' must be non-null");
            return NopTraceEntry.INSTANCE;
        }
        this.readMemoryBarrier();
        return this.startTransactionInternal(transactionType, transactionName, messageSupplier, timerName);
    }

    @Override
    public TraceEntry startTraceEntry(MessageSupplier messageSupplier, TimerName timerName) {
        if (messageSupplier == null) {
            logger.error("startTraceEntry(): argument 'messageSupplier' must be non-null");
            return NopTraceEntry.INSTANCE;
        }
        if (timerName == null) {
            logger.error("startTraceEntry(): argument 'timerName' must be non-null");
            return NopTraceEntry.INSTANCE;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction == null) {
            return NopTraceEntry.INSTANCE;
        }
        return this.startTraceEntryInternal(transaction, messageSupplier, null, null, 0L, timerName);
    }

    @Override
    public QueryEntry startQueryEntry(String queryType, String queryText, MessageSupplier messageSupplier, TimerName timerName) {
        return this.startQueryEntry(queryType, queryText, 1L, messageSupplier, timerName);
    }

    @Override
    public QueryEntry startQueryEntry(String queryType, String queryText, long queryExecutionCount, MessageSupplier messageSupplier, TimerName timerName) {
        if (queryType == null) {
            logger.error("startQuery(): argument 'queryType' must be non-null");
            return NopQuery.INSTANCE;
        }
        if (queryText == null) {
            logger.error("startQuery(): argument 'queryText' must be non-null");
            return NopQuery.INSTANCE;
        }
        if (messageSupplier == null) {
            logger.error("startQuery(): argument 'messageSupplier' must be non-null");
            return NopQuery.INSTANCE;
        }
        if (timerName == null) {
            logger.error("startQuery(): argument 'timerName' must be non-null");
            return NopQuery.INSTANCE;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction == null) {
            return NopQuery.INSTANCE;
        }
        return this.startTraceEntryInternal(transaction, messageSupplier, queryType, queryText, queryExecutionCount, timerName);
    }

    @Override
    public Timer startTimer(TimerName timerName) {
        if (timerName == null) {
            logger.error("startTimer(): argument 'timerName' must be non-null");
            return NopTimer.INSTANCE;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction == null) {
            return NopTimer.INSTANCE;
        }
        TimerImpl currentTimer = transaction.getCurrentTimer();
        if (currentTimer == null) {
            return NopTimer.INSTANCE;
        }
        return currentTimer.startNestedTimer(timerName);
    }

    @Override
    public void addTraceEntry(ErrorMessage errorMessage) {
        if (errorMessage == null) {
            logger.error("addTraceEntry(): argument 'errorMessage' must be non-null");
            return;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction != null && transaction.getEntryCount() < 2 * this.maxTraceEntriesPerTransaction) {
            long currTick = this.ticker.read();
            TraceEntryImpl entry = transaction.addEntry(currTick, currTick, null, errorMessage, true);
            if (((ReadableErrorMessage)((Object)errorMessage)).getThrowable() == null) {
                StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                entry.setStackTrace((ImmutableList<StackTraceElement>)ImmutableList.copyOf(stackTrace).subList(3, stackTrace.length));
            }
        }
    }

    @Override
    public void setTransactionType(@Nullable String transactionType) {
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction != null) {
            transaction.setTransactionType(transactionType);
        }
    }

    @Override
    public void setTransactionName(@Nullable String transactionName) {
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction != null) {
            transaction.setTransactionName(transactionName);
        }
    }

    @Override
    public void setTransactionError(ErrorMessage errorMessage) {
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction != null) {
            transaction.setError(errorMessage);
        }
    }

    @Override
    public void setTransactionUser(@Nullable String user) {
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction != null && !Strings.isNullOrEmpty(user)) {
            transaction.setUser(user);
            if (transaction.getUserProfileRunnable() == null) {
                this.userProfileScheduler.maybeScheduleUserProfiling(transaction, user);
            }
        }
    }

    @Override
    public void addTransactionCustomAttribute(String name, @Nullable String value) {
        if (name == null) {
            logger.error("addTransactionCustomAttribute(): argument 'name' must be non-null");
            return;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction != null) {
            transaction.addCustomAttribute(name, value);
        }
    }

    @Override
    public void setTraceStoreThreshold(long threshold, TimeUnit unit) {
        if (threshold < 0L) {
            logger.error("setTraceStoreThreshold(): argument 'threshold' must be non-negative");
            return;
        }
        if (unit == null) {
            logger.error("setTraceStoreThreshold(): argument 'unit' must be non-null");
            return;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction != null) {
            int thresholdMillis = Ints.saturatedCast(unit.toMillis(threshold));
            transaction.setTraceStoreThresholdMillisOverride(thresholdMillis);
        }
    }

    @Override
    public boolean isInTransaction() {
        return this.transactionRegistry.getCurrentTransaction() != null;
    }

    @Override
    public void onChange() {
        GeneralConfig generalConfig = this.configService.getGeneralConfig();
        if (this.pluginId == null) {
            this.enabled = generalConfig.enabled();
        } else {
            PluginConfig pluginConfig = this.configService.getPluginConfig(this.pluginId);
            Preconditions.checkNotNull(pluginConfig);
            this.enabled = generalConfig.enabled() && pluginConfig.enabled();
            this.pluginConfig = pluginConfig;
        }
        AdvancedConfig advancedConfig = this.configService.getAdvancedConfig();
        this.maxAggregateQueriesPerQueryType = advancedConfig.maxAggregateQueriesPerQueryType();
        this.maxTraceEntriesPerTransaction = advancedConfig.maxTraceEntriesPerTransaction();
        this.captureThreadInfo = advancedConfig.captureThreadInfo();
        this.captureGcInfo = advancedConfig.captureGcInfo();
        for (PluginServices.ConfigListener weakConfigListener : this.weakConfigListeners.keySet()) {
            weakConfigListener.onChange();
        }
        this.memoryBarrier = true;
    }

    private TraceEntry startTransactionInternal(String transactionType, String transactionName, MessageSupplier messageSupplier, TimerName timerName) {
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction == null) {
            long startTick = this.ticker.read();
            transaction = new Transaction(this.clock.currentTimeMillis(), transactionType, transactionName, messageSupplier, timerName, startTick, this.captureThreadInfo, this.captureGcInfo, this.maxAggregateQueriesPerQueryType, this.threadAllocatedBytes, this.transactionCompletionCallback, this.ticker);
            this.transactionRegistry.addTransaction(transaction);
            return transaction.getRootEntry();
        }
        return this.startTraceEntryInternal(transaction, messageSupplier, null, null, 0L, timerName);
    }

    private QueryEntry startTraceEntryInternal(Transaction transaction, MessageSupplier messageSupplier, @Nullable String queryType, @Nullable String queryText, long queryExecutionCount, TimerName timerName) {
        long startTick = this.ticker.read();
        if (transaction.getEntryCount() < this.maxTraceEntriesPerTransaction) {
            TimerImpl timer = this.startTimer(timerName, startTick, transaction);
            return transaction.pushEntry(startTick, messageSupplier, queryType, queryText, queryExecutionCount, timer);
        }
        return this.startDummyTraceEntry(transaction, timerName, messageSupplier, queryType, queryText, queryExecutionCount, startTick);
    }

    private QueryEntry startDummyTraceEntry(Transaction transaction, TimerName timerName, MessageSupplier messageSupplier, @Nullable String queryType, @Nullable String queryText, long queryExecutionCount, long startTick) {
        QueryData queryData = null;
        if (queryType != null && queryText != null) {
            queryData = transaction.getOrCreateQueryDataIfPossible(queryType, queryText);
        }
        transaction.addEntryLimitExceededMarkerIfNeeded();
        TimerImpl timer = this.startTimer(timerName, startTick, transaction);
        return new DummyTraceEntryOrQuery(timer, startTick, transaction, messageSupplier, queryData, queryExecutionCount);
    }

    private TimerImpl startTimer(TimerName timerName, long startTick, Transaction transaction) {
        TimerImpl currentTimer = transaction.getCurrentTimer();
        if (currentTimer == null) {
            return TimerImpl.createRootTimer(transaction, (TimerNameImpl)timerName);
        }
        return currentTimer.startNestedTimer(timerName, startTick);
    }

    private boolean readMemoryBarrier() {
        return this.memoryBarrier;
    }

    private static class NopTimer
    implements Timer {
        private static final NopTimer INSTANCE = new NopTimer();

        private NopTimer() {
        }

        @Override
        public void stop() {
        }
    }

    private static class NopQuery
    extends NopTraceEntry
    implements QueryEntry {
        private static final NopQuery INSTANCE = new NopQuery();

        private NopQuery() {
        }

        @Override
        public void incrementCurrRow() {
        }

        @Override
        public void setCurrRow(long row) {
        }
    }

    private static class NopTraceEntry
    implements TraceEntry {
        private static final NopTraceEntry INSTANCE = new NopTraceEntry();

        private NopTraceEntry() {
        }

        @Override
        public void end() {
        }

        @Override
        public void endWithStackTrace(long threshold, TimeUnit unit) {
        }

        @Override
        public void endWithError(ErrorMessage errorMessage) {
        }

        @Override
        public Timer extend() {
            return NopTimer.INSTANCE;
        }

        @Override
        @Nullable
        public MessageSupplier getMessageSupplier() {
            return null;
        }
    }

    private class EnabledPropertyImpl
    implements PluginServices.BooleanProperty,
    PluginServices.ConfigListener {
        private final String name;
        private boolean value;

        private EnabledPropertyImpl(String name) {
            this.name = name;
            if (PluginServicesImpl.this.pluginConfig != null) {
                this.value = PluginServicesImpl.this.enabled && PluginServicesImpl.this.pluginConfig.getBooleanProperty(name);
            }
        }

        @Override
        public boolean value() {
            return this.value;
        }

        @Override
        public void onChange() {
            if (PluginServicesImpl.this.pluginConfig != null) {
                this.value = PluginServicesImpl.this.enabled && PluginServicesImpl.this.pluginConfig.getBooleanProperty(this.name);
            }
        }
    }

    private class DoublePropertyImpl
    implements PluginServices.DoubleProperty,
    PluginServices.ConfigListener {
        private final String name;
        @Nullable
        private Double value;

        private DoublePropertyImpl(String name) {
            this.name = name;
            if (PluginServicesImpl.this.pluginConfig != null) {
                this.value = PluginServicesImpl.this.pluginConfig.getDoubleProperty(name);
            }
        }

        @Override
        @Nullable
        public Double value() {
            return this.value;
        }

        @Override
        public void onChange() {
            if (PluginServicesImpl.this.pluginConfig != null) {
                this.value = PluginServicesImpl.this.pluginConfig.getDoubleProperty(this.name);
            }
        }
    }

    private class BooleanPropertyImpl
    implements PluginServices.BooleanProperty,
    PluginServices.ConfigListener {
        private final String name;
        private boolean value;

        private BooleanPropertyImpl(String name) {
            this.name = name;
            if (PluginServicesImpl.this.pluginConfig != null) {
                this.value = PluginServicesImpl.this.pluginConfig.getBooleanProperty(name);
            }
        }

        @Override
        public boolean value() {
            return this.value;
        }

        @Override
        public void onChange() {
            if (PluginServicesImpl.this.pluginConfig != null) {
                this.value = PluginServicesImpl.this.pluginConfig.getBooleanProperty(this.name);
            }
        }
    }

    private class StringPropertyImpl
    implements PluginServices.StringProperty,
    PluginServices.ConfigListener {
        private final String name;
        private String value = "";

        private StringPropertyImpl(String name) {
            this.name = name;
            if (PluginServicesImpl.this.pluginConfig != null) {
                this.value = PluginServicesImpl.this.pluginConfig.getStringProperty(name);
            }
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public void onChange() {
            if (PluginServicesImpl.this.pluginConfig != null) {
                this.value = PluginServicesImpl.this.pluginConfig.getStringProperty(this.name);
            }
        }
    }

    private class DummyTraceEntryOrQuery
    implements QueryEntry,
    Timer {
        private final TimerImpl timer;
        private final long startTick;
        private final Transaction transaction;
        private final MessageSupplier messageSupplier;
        private int selfNestingLevel;
        @MonotonicNonNull
        private TimerImpl extendedTimer;
        @Nullable
        private final QueryData queryData;
        private long currRow = -1L;
        private long maxRow;

        public DummyTraceEntryOrQuery(TimerImpl timer, long startTick, Transaction transaction, @Nullable MessageSupplier messageSupplier, QueryData queryData, long queryExecutionCount) {
            this.timer = timer;
            this.startTick = startTick;
            this.transaction = transaction;
            this.messageSupplier = messageSupplier;
            this.queryData = queryData;
            if (queryData != null) {
                queryData.start(startTick, queryExecutionCount);
            }
        }

        @Override
        public void end() {
            this.endInternal(PluginServicesImpl.this.ticker.read());
        }

        @Override
        public void endWithStackTrace(long threshold, TimeUnit unit) {
            if (threshold < 0L) {
                logger.error("endWithStackTrace(): argument 'threshold' must be non-negative");
                this.end();
                return;
            }
            this.endInternal(PluginServicesImpl.this.ticker.read());
        }

        @Override
        public void endWithError(ErrorMessage errorMessage) {
            if (errorMessage == null) {
                logger.error("endWithError(): argument 'errorMessage' must be non-null");
                this.end();
                return;
            }
            long endTick = PluginServicesImpl.this.ticker.read();
            this.endInternal(endTick);
            if (this.transaction.getEntryCount() < 2 * PluginServicesImpl.this.maxTraceEntriesPerTransaction) {
                this.transaction.addEntry(this.startTick, endTick, this.messageSupplier, errorMessage, true);
            }
        }

        private void endInternal(long endTick) {
            this.timer.end(endTick);
            if (this.queryData != null) {
                this.queryData.end(endTick);
            }
        }

        @Override
        public Timer extend() {
            if (this.selfNestingLevel++ == 0) {
                long currTick = PluginServicesImpl.this.ticker.read();
                this.extendedTimer = this.timer.extend(currTick);
                if (this.queryData != null) {
                    this.queryData.extend(currTick);
                }
            }
            return this;
        }

        @Override
        public void stop() {
            if (--this.selfNestingLevel == 0) {
                long stopTick = PluginServicesImpl.this.ticker.read();
                Preconditions.checkNotNull(this.extendedTimer);
                this.extendedTimer.end(stopTick);
                if (this.queryData != null) {
                    this.queryData.end(stopTick);
                }
            }
        }

        @Override
        public MessageSupplier getMessageSupplier() {
            return this.messageSupplier;
        }

        @Override
        public void incrementCurrRow() {
            if (this.currRow == -1L) {
                this.currRow = 1L;
                this.maxRow = 1L;
                if (this.queryData != null) {
                    this.queryData.incrementRowCount(1L);
                }
            } else if (this.currRow == this.maxRow) {
                ++this.currRow;
                this.maxRow = this.currRow;
                if (this.queryData != null) {
                    this.queryData.incrementRowCount(1L);
                }
            } else {
                ++this.currRow;
            }
        }

        @Override
        public void setCurrRow(long row) {
            if (row > this.maxRow) {
                if (this.queryData != null) {
                    this.queryData.incrementRowCount(row - this.maxRow);
                }
                this.maxRow = row;
            }
            this.currRow = row;
        }
    }

    private class TransactionCompletionCallback
    implements Transaction.CompletionCallback {
        private TransactionCompletionCallback() {
        }

        @Override
        public void completed(Transaction transaction) {
            PluginServicesImpl.this.transactionCollector.onCompletedTransaction(transaction);
            PluginServicesImpl.this.transactionRegistry.removeTransaction(transaction);
        }
    }
}

