/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import org.glowroot.common.ScheduledRunnable;
import org.glowroot.config.ConfigService;
import org.glowroot.transaction.model.Transaction;

class UserProfileRunnable
extends ScheduledRunnable {
    private final Transaction transaction;
    private final ConfigService configService;

    UserProfileRunnable(Transaction transaction, ConfigService configService) {
        this.transaction = transaction;
        this.configService = configService;
    }

    @Override
    public void runInternal() {
        if (this.transaction.isCompleted()) {
            throw new ScheduledRunnable.TerminateSubsequentExecutionsException();
        }
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        ThreadInfo threadInfo = threadBean.getThreadInfo(this.transaction.getThreadId(), Integer.MAX_VALUE);
        this.transaction.captureStackTrace(threadInfo, this.configService.getAdvancedConfig().maxStackTraceSamplesPerTransaction(), this.configService.getAdvancedConfig().timerWrapperMethods());
    }
}

