/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction.model;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;
import org.glowroot.transaction.model.GcInfoComponent;

@ParametersAreNonnullByDefault
@Immutable
final class GcSnapshot
extends GcInfoComponent.GcSnapshotBase {
    private final long collectionCount;
    private final long collectionTime;

    private GcSnapshot(long collectionCount, long collectionTime) {
        this.collectionCount = collectionCount;
        this.collectionTime = collectionTime;
    }

    @Override
    public long collectionCount() {
        return this.collectionCount;
    }

    @Override
    public long collectionTime() {
        return this.collectionTime;
    }

    public final GcSnapshot withCollectionCount(long value) {
        if (this.collectionCount == value) {
            return this;
        }
        long newValue = value;
        return new GcSnapshot(newValue, this.collectionTime);
    }

    public final GcSnapshot withCollectionTime(long value) {
        if (this.collectionTime == value) {
            return this;
        }
        long newValue = value;
        return new GcSnapshot(this.collectionCount, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof GcSnapshot && this.equalTo((GcSnapshot)another);
    }

    private boolean equalTo(GcSnapshot another) {
        return this.collectionCount == another.collectionCount && this.collectionTime == another.collectionTime;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode(this.collectionCount);
        h = h * 17 + Longs.hashCode(this.collectionTime);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("GcSnapshot").add("collectionCount", this.collectionCount).add("collectionTime", this.collectionTime).toString();
    }

    static GcSnapshot copyOf(GcInfoComponent.GcSnapshotBase instance) {
        if (instance instanceof GcSnapshot) {
            return (GcSnapshot)instance;
        }
        return GcSnapshot.builder().all(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_COLLECTION_COUNT = 1L;
        private static final long INITIALIZED_BIT_COLLECTION_TIME = 2L;
        private long initializedBitset;
        private long collectionCount;
        private long collectionTime;

        private Builder() {
        }

        public final Builder all(GcInfoComponent.GcSnapshotBase instance) {
            Preconditions.checkNotNull(instance);
            this.collectionCount(instance.collectionCount());
            this.collectionTime(instance.collectionTime());
            return this;
        }

        public final Builder collectionCount(long collectionCount) {
            this.collectionCount = collectionCount;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder collectionTime(long collectionTime) {
            this.collectionTime = collectionTime;
            this.initializedBitset |= 2L;
            return this;
        }

        public GcSnapshot build() {
            this.checkRequiredAttributes();
            return new GcSnapshot(this.collectionCount, this.collectionTime);
        }

        private boolean collectionCountIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean collectionTimeIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.collectionCountIsSet()) {
                attributes.add("collectionCount");
            }
            if (!this.collectionTimeIsSet()) {
                attributes.add("collectionTime");
            }
            return "Cannot build GcSnapshot, some of required attributes are not set " + attributes;
        }
    }
}

