/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction.model;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.primitives.Longs;
import org.glowroot.transaction.model.ThreadInfoComponent;

@ParametersAreNonnullByDefault
@Immutable
final class ThreadInfoSnapshot
extends ThreadInfoComponent.ThreadInfoSnapshotBase {
    private final long threadCpuTime;
    private final long threadBlockedTimeMillis;
    private final long threadWaitedTimeMillis;
    private final long threadAllocatedBytes;

    private ThreadInfoSnapshot(Builder builder) {
        this.threadCpuTime = builder.threadCpuTimeIsSet() ? builder.threadCpuTime : super.threadCpuTime();
        this.threadBlockedTimeMillis = builder.threadBlockedTimeMillisIsSet() ? builder.threadBlockedTimeMillis : super.threadBlockedTimeMillis();
        this.threadWaitedTimeMillis = builder.threadWaitedTimeMillisIsSet() ? builder.threadWaitedTimeMillis : super.threadWaitedTimeMillis();
        this.threadAllocatedBytes = builder.threadAllocatedBytesIsSet() ? builder.threadAllocatedBytes : super.threadAllocatedBytes();
    }

    private ThreadInfoSnapshot(long threadCpuTime, long threadBlockedTimeMillis, long threadWaitedTimeMillis, long threadAllocatedBytes) {
        this.threadCpuTime = threadCpuTime;
        this.threadBlockedTimeMillis = threadBlockedTimeMillis;
        this.threadWaitedTimeMillis = threadWaitedTimeMillis;
        this.threadAllocatedBytes = threadAllocatedBytes;
    }

    @Override
    public long threadCpuTime() {
        return this.threadCpuTime;
    }

    @Override
    public long threadBlockedTimeMillis() {
        return this.threadBlockedTimeMillis;
    }

    @Override
    public long threadWaitedTimeMillis() {
        return this.threadWaitedTimeMillis;
    }

    @Override
    public long threadAllocatedBytes() {
        return this.threadAllocatedBytes;
    }

    public final ThreadInfoSnapshot withThreadCpuTime(long value) {
        if (this.threadCpuTime == value) {
            return this;
        }
        long newValue = value;
        return new ThreadInfoSnapshot(newValue, this.threadBlockedTimeMillis, this.threadWaitedTimeMillis, this.threadAllocatedBytes);
    }

    public final ThreadInfoSnapshot withThreadBlockedTimeMillis(long value) {
        if (this.threadBlockedTimeMillis == value) {
            return this;
        }
        long newValue = value;
        return new ThreadInfoSnapshot(this.threadCpuTime, newValue, this.threadWaitedTimeMillis, this.threadAllocatedBytes);
    }

    public final ThreadInfoSnapshot withThreadWaitedTimeMillis(long value) {
        if (this.threadWaitedTimeMillis == value) {
            return this;
        }
        long newValue = value;
        return new ThreadInfoSnapshot(this.threadCpuTime, this.threadBlockedTimeMillis, newValue, this.threadAllocatedBytes);
    }

    public final ThreadInfoSnapshot withThreadAllocatedBytes(long value) {
        if (this.threadAllocatedBytes == value) {
            return this;
        }
        long newValue = value;
        return new ThreadInfoSnapshot(this.threadCpuTime, this.threadBlockedTimeMillis, this.threadWaitedTimeMillis, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof ThreadInfoSnapshot && this.equalTo((ThreadInfoSnapshot)another);
    }

    private boolean equalTo(ThreadInfoSnapshot another) {
        return this.threadCpuTime == another.threadCpuTime && this.threadBlockedTimeMillis == another.threadBlockedTimeMillis && this.threadWaitedTimeMillis == another.threadWaitedTimeMillis && this.threadAllocatedBytes == another.threadAllocatedBytes;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode(this.threadCpuTime);
        h = h * 17 + Longs.hashCode(this.threadBlockedTimeMillis);
        h = h * 17 + Longs.hashCode(this.threadWaitedTimeMillis);
        h = h * 17 + Longs.hashCode(this.threadAllocatedBytes);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ThreadInfoSnapshot").add("threadCpuTime", this.threadCpuTime).add("threadBlockedTimeMillis", this.threadBlockedTimeMillis).add("threadWaitedTimeMillis", this.threadWaitedTimeMillis).add("threadAllocatedBytes", this.threadAllocatedBytes).toString();
    }

    static ThreadInfoSnapshot copyOf(ThreadInfoComponent.ThreadInfoSnapshotBase instance) {
        if (instance instanceof ThreadInfoSnapshot) {
            return (ThreadInfoSnapshot)instance;
        }
        return ThreadInfoSnapshot.builder().all(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long NONDEFAULT_BIT_THREAD_CPU_TIME = 1L;
        private static final long NONDEFAULT_BIT_THREAD_BLOCKED_TIME_MILLIS = 2L;
        private static final long NONDEFAULT_BIT_THREAD_WAITED_TIME_MILLIS = 4L;
        private static final long NONDEFAULT_BIT_THREAD_ALLOCATED_BYTES = 8L;
        private long nondefaultBitset;
        private long threadCpuTime;
        private long threadBlockedTimeMillis;
        private long threadWaitedTimeMillis;
        private long threadAllocatedBytes;

        private Builder() {
        }

        public final Builder all(ThreadInfoComponent.ThreadInfoSnapshotBase instance) {
            Preconditions.checkNotNull(instance);
            this.threadCpuTime(instance.threadCpuTime());
            this.threadBlockedTimeMillis(instance.threadBlockedTimeMillis());
            this.threadWaitedTimeMillis(instance.threadWaitedTimeMillis());
            this.threadAllocatedBytes(instance.threadAllocatedBytes());
            return this;
        }

        public final Builder threadCpuTime(long threadCpuTime) {
            this.threadCpuTime = threadCpuTime;
            this.nondefaultBitset |= 1L;
            return this;
        }

        public final Builder threadBlockedTimeMillis(long threadBlockedTimeMillis) {
            this.threadBlockedTimeMillis = threadBlockedTimeMillis;
            this.nondefaultBitset |= 2L;
            return this;
        }

        public final Builder threadWaitedTimeMillis(long threadWaitedTimeMillis) {
            this.threadWaitedTimeMillis = threadWaitedTimeMillis;
            this.nondefaultBitset |= 4L;
            return this;
        }

        public final Builder threadAllocatedBytes(long threadAllocatedBytes) {
            this.threadAllocatedBytes = threadAllocatedBytes;
            this.nondefaultBitset |= 8L;
            return this;
        }

        public ThreadInfoSnapshot build() {
            return new ThreadInfoSnapshot(this);
        }

        private boolean threadCpuTimeIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean threadBlockedTimeMillisIsSet() {
            return (this.nondefaultBitset & 2L) != 0L;
        }

        private boolean threadWaitedTimeMillisIsSet() {
            return (this.nondefaultBitset & 4L) != 0L;
        }

        private boolean threadAllocatedBytesIsSet() {
            return (this.nondefaultBitset & 8L) != 0L;
        }
    }
}

