/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction.model;

import java.lang.management.ThreadInfo;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.api.ErrorMessage;
import org.glowroot.api.MessageSupplier;
import org.glowroot.api.TimerName;
import org.glowroot.api.internal.ReadableErrorMessage;
import org.glowroot.api.internal.ReadableMessage;
import org.glowroot.common.ScheduledRunnable;
import org.glowroot.jvm.ThreadAllocatedBytes;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.base.Strings;
import org.glowroot.shaded.google.common.base.Ticker;
import org.glowroot.shaded.google.common.collect.HashMultimap;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.ImmutableSetMultimap;
import org.glowroot.shaded.google.common.collect.SetMultimap;
import org.glowroot.shaded.google.common.collect.TreeMultimap;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.glowroot.transaction.model.GcInfo;
import org.glowroot.transaction.model.GcInfoComponent;
import org.glowroot.transaction.model.Profile;
import org.glowroot.transaction.model.QueryData;
import org.glowroot.transaction.model.ThreadInfoComponent;
import org.glowroot.transaction.model.ThreadInfoData;
import org.glowroot.transaction.model.TimerImpl;
import org.glowroot.transaction.model.TimerNameImpl;
import org.glowroot.transaction.model.TraceEntryComponent;
import org.glowroot.transaction.model.TraceEntryImpl;
import org.glowroot.transaction.model.TraceUniqueId;

public class Transaction {
    private static final Logger logger = LoggerFactory.getLogger(Transaction.class);
    public static final int USE_GENERAL_STORE_THRESHOLD = -1;
    private static final int CUSTOM_ATTRIBUTE_KEYS_INITIAL_CAPACITY = 16;
    private static final long CUSTOM_ATTRIBUTE_VALUES_PER_KEY_LIMIT = 10000L;
    private final TraceUniqueId id;
    private final long startTime;
    private volatile String transactionType;
    private volatile boolean explicitSetTransactionType;
    private volatile String transactionName;
    private volatile boolean explicitSetTransactionName;
    @Nullable
    private volatile String user;
    @GuardedBy(value="customAttributes")
    @MonotonicNonNull
    private volatile SetMultimap<String, String> customAttributes;
    @Nullable
    private volatile ErrorMessage errorMessage;
    private final TimerImpl rootTimer;
    @Nullable
    private TimerImpl currentTimer;
    @Nullable
    private final ThreadInfoComponent threadInfoComponent;
    @Nullable
    private final GcInfoComponent gcInfoComponent;
    private final TraceEntryComponent traceEntryComponent;
    @MonotonicNonNull
    private QueryData headQueryData;
    @MonotonicNonNull
    private Map<String, QueryData> firstQueryTypeQueries;
    @MonotonicNonNull
    private Map<String, Map<String, QueryData>> allQueryTypesMap;
    private final int maxAggregateQueriesPerQueryType;
    @MonotonicNonNull
    private volatile Profile profile;
    private final long threadId;
    private volatile int traceStoreThresholdMillisOverride = -1;
    @MonotonicNonNull
    private volatile ScheduledRunnable userProfileRunnable;
    @MonotonicNonNull
    private volatile ScheduledRunnable immedateTraceStoreRunnable;
    private volatile boolean partiallyStored;
    private long captureTime;
    private volatile boolean memoryBarrier;
    private final CompletionCallback completionCallback;

    public Transaction(long startTime, String transactionType, String transactionName, MessageSupplier messageSupplier, TimerName timerName, long startTick, boolean captureThreadInfo, boolean captureGcInfo, int maxAggregateQueriesPerQueryType, @Nullable ThreadAllocatedBytes threadAllocatedBytes, CompletionCallback completionCallback, Ticker ticker) {
        TimerImpl rootTimer;
        this.startTime = startTime;
        this.transactionType = transactionType;
        this.transactionName = transactionName;
        this.id = new TraceUniqueId(startTime);
        this.rootTimer = rootTimer = TimerImpl.createRootTimer(this, (TimerNameImpl)timerName);
        rootTimer.start(startTick);
        this.traceEntryComponent = new TraceEntryComponent(messageSupplier, rootTimer, startTick, ticker);
        this.threadId = Thread.currentThread().getId();
        this.threadInfoComponent = captureThreadInfo ? new ThreadInfoComponent(threadAllocatedBytes) : null;
        this.gcInfoComponent = captureGcInfo ? new GcInfoComponent() : null;
        this.maxAggregateQueriesPerQueryType = maxAggregateQueriesPerQueryType;
        this.completionCallback = completionCallback;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getId() {
        return this.id.get();
    }

    public long getStartTick() {
        return this.traceEntryComponent.getStartTick();
    }

    public boolean isCompleted() {
        return this.traceEntryComponent.isCompleted();
    }

    public long getEndTick() {
        return this.traceEntryComponent.getEndTick();
    }

    public long getDuration() {
        return this.traceEntryComponent.getDuration();
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public String getTransactionName() {
        return this.transactionName;
    }

    public String getHeadline() {
        MessageSupplier messageSupplier = this.traceEntryComponent.getRootEntry().getMessageSupplier();
        Preconditions.checkNotNull(messageSupplier);
        return ((ReadableMessage)((Object)messageSupplier.get())).getText();
    }

    @Nullable
    public String getUser() {
        return this.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableSetMultimap<String, String> getCustomAttributes() {
        if (this.customAttributes == null) {
            return ImmutableSetMultimap.of();
        }
        TreeMultimap<String, String> orderedCustomAttributes = TreeMultimap.create(String.CASE_INSENSITIVE_ORDER, String.CASE_INSENSITIVE_ORDER);
        SetMultimap<String, String> setMultimap = this.customAttributes;
        synchronized (setMultimap) {
            orderedCustomAttributes.putAll(this.customAttributes);
        }
        return ImmutableSetMultimap.copyOf(orderedCustomAttributes);
    }

    public Map<String, ? extends Object> getCustomDetail() {
        MessageSupplier messageSupplier = this.traceEntryComponent.getRootEntry().getMessageSupplier();
        Preconditions.checkNotNull(messageSupplier);
        return ((ReadableMessage)((Object)messageSupplier.get())).getDetail();
    }

    @Nullable
    public ReadableErrorMessage getErrorMessage() {
        if (this.errorMessage != null) {
            return (ReadableErrorMessage)((Object)this.errorMessage);
        }
        return this.traceEntryComponent.getRootEntry().getErrorMessage();
    }

    public TimerImpl getRootTimer() {
        this.readMemoryBarrier();
        return this.rootTimer;
    }

    @Nullable
    public TimerImpl getCurrentTimer() {
        return this.currentTimer;
    }

    @Nullable
    public ThreadInfoData getThreadInfo() {
        return this.threadInfoComponent == null ? null : this.threadInfoComponent.getThreadInfo();
    }

    @Nullable
    public List<GcInfo> getGcInfos() {
        return this.gcInfoComponent == null ? null : this.gcInfoComponent.getGcInfos();
    }

    public TraceEntryImpl getRootEntry() {
        return this.traceEntryComponent.getRootEntry();
    }

    public int getEntryCount() {
        return this.traceEntryComponent.getEntryCount();
    }

    public Iterable<QueryData> getQueries() {
        this.readMemoryBarrier();
        if (this.headQueryData == null) {
            return ImmutableList.of();
        }
        return new Iterable<QueryData>(){

            @Override
            public Iterator<QueryData> iterator() {
                return new Iterator<QueryData>(){
                    @Nullable
                    private QueryData next;
                    {
                        this.next = Transaction.this.headQueryData;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public QueryData next() {
                        QueryData curr = this.next;
                        if (curr == null) {
                            throw new NoSuchElementException();
                        }
                        this.next = curr.getNextQueryData();
                        return curr;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public Iterable<TraceEntryImpl> getEntries() {
        this.readMemoryBarrier();
        return this.traceEntryComponent;
    }

    public int getProfileSampleCount() {
        if (this.profile == null) {
            return 0;
        }
        return this.profile.getSampleCount();
    }

    @Nullable
    public Profile getProfile() {
        return this.profile;
    }

    public int getTraceStoreThresholdMillisOverride() {
        return this.traceStoreThresholdMillisOverride;
    }

    @Nullable
    public ScheduledRunnable getUserProfileRunnable() {
        return this.userProfileRunnable;
    }

    @Nullable
    public ScheduledRunnable getImmedateTraceStoreRunnable() {
        return this.immedateTraceStoreRunnable;
    }

    public boolean isPartiallyStored() {
        return this.partiallyStored;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public void setTransactionType(@Nullable String transactionType) {
        if (!this.explicitSetTransactionType && transactionType != null && !transactionType.isEmpty()) {
            this.transactionType = transactionType;
            this.explicitSetTransactionType = true;
        }
    }

    public void setTransactionName(@Nullable String transactionName) {
        if (!this.explicitSetTransactionName && transactionName != null && !transactionName.isEmpty()) {
            this.transactionName = transactionName;
            this.explicitSetTransactionName = true;
        }
    }

    public void setUser(String user) {
        if (this.user == null) {
            this.user = user;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCustomAttribute(String name, @Nullable String value) {
        if (this.customAttributes == null) {
            this.customAttributes = HashMultimap.create(16, 1);
        }
        String val = Strings.nullToEmpty(value);
        SetMultimap<String, String> setMultimap = this.customAttributes;
        synchronized (setMultimap) {
            Set<String> values = this.customAttributes.get(name);
            if ((long)values.size() < 10000L) {
                values.add(val);
            }
        }
    }

    public void setError(ErrorMessage errorMessage) {
        if (this.errorMessage == null) {
            this.errorMessage = errorMessage;
        }
    }

    public void setTraceStoreThresholdMillisOverride(int traceStoreThresholdMillisOverride) {
        this.traceStoreThresholdMillisOverride = this.traceStoreThresholdMillisOverride == -1 ? traceStoreThresholdMillisOverride : Math.min(this.traceStoreThresholdMillisOverride, traceStoreThresholdMillisOverride);
    }

    public void setUserProfileRunnable(ScheduledRunnable scheduledRunnable) {
        if (this.userProfileRunnable != null) {
            logger.warn("setUserProfileRunnable(): overwriting non-null userProfileRunnable");
        }
        this.userProfileRunnable = scheduledRunnable;
    }

    public void setImmediateTraceStoreRunnable(ScheduledRunnable scheduledRunnable) {
        if (this.immedateTraceStoreRunnable != null) {
            logger.warn("setImmediateTraceStoreRunnable(): overwriting non-null immedateTraceStoreRunnable");
        }
        this.immedateTraceStoreRunnable = scheduledRunnable;
    }

    public void setPartiallyStored() {
        this.partiallyStored = true;
    }

    public TraceEntryImpl pushEntry(long startTick, MessageSupplier messageSupplier, @Nullable String queryType, @Nullable String queryText, long queryExecutionCount, TimerImpl timer) {
        QueryData queryData = null;
        if (queryType != null && queryText != null) {
            queryData = this.getOrCreateQueryDataIfPossible(queryType, queryText);
        }
        return this.traceEntryComponent.pushEntry(startTick, messageSupplier, queryData, queryExecutionCount, timer);
    }

    @Nullable
    public QueryData getOrCreateQueryDataIfPossible(String queryType, String queryText) {
        if (this.headQueryData == null) {
            QueryData queryData = new QueryData(queryType, queryText, null);
            this.firstQueryTypeQueries = new HashMap<String, QueryData>(4);
            this.firstQueryTypeQueries.put(queryText, queryData);
            this.headQueryData = queryData;
            return this.headQueryData;
        }
        Map<String, QueryData> currentQueryTypeQueries = queryType.equals(this.headQueryData.getQueryType()) ? Preconditions.checkNotNull(this.firstQueryTypeQueries) : this.getOrCreateQueriesForQueryType(queryType);
        QueryData queryData = currentQueryTypeQueries.get(queryText);
        if (queryData == null && currentQueryTypeQueries.size() < this.maxAggregateQueriesPerQueryType * 10) {
            queryData = new QueryData(queryType, queryText, this.headQueryData);
            currentQueryTypeQueries.put(queryText, queryData);
            this.headQueryData = queryData;
        }
        return queryData;
    }

    public TraceEntryImpl addEntry(long startTick, long endTick, @Nullable MessageSupplier messageSupplier, @Nullable ErrorMessage errorMessage, boolean limitBypassed) {
        TraceEntryImpl entry = this.traceEntryComponent.addEntry(startTick, endTick, messageSupplier, errorMessage, limitBypassed);
        this.memoryBarrier = true;
        return entry;
    }

    public void addEntryLimitExceededMarkerIfNeeded() {
        this.traceEntryComponent.addEntryLimitExceededMarkerIfNeeded();
        this.memoryBarrier = true;
    }

    public void captureStackTrace(@Nullable ThreadInfo threadInfo, int limit, boolean mayHaveSyntheticTimerMethods) {
        if (threadInfo == null) {
            return;
        }
        if (this.traceEntryComponent.isCompleted()) {
            return;
        }
        if (this.profile == null) {
            Profile profile = new Profile(mayHaveSyntheticTimerMethods);
            profile.addStackTrace(threadInfo, limit);
            this.profile = profile;
        } else {
            this.profile.addStackTrace(threadInfo, limit);
        }
    }

    public void onCompleteCaptureThreadInfo() {
        if (this.threadInfoComponent != null) {
            this.threadInfoComponent.onComplete();
        }
    }

    public void onCompleteCaptureGcInfo() {
        if (this.gcInfoComponent != null) {
            this.gcInfoComponent.onComplete();
        }
    }

    public void onComplete(long captureTime) {
        this.captureTime = captureTime;
    }

    public long getCaptureTime() {
        return this.captureTime;
    }

    void popEntry(TraceEntryImpl entry, long endTick) {
        this.traceEntryComponent.popEntry(entry, endTick);
        this.memoryBarrier = true;
        if (this.isCompleted()) {
            if (this.immedateTraceStoreRunnable != null) {
                this.immedateTraceStoreRunnable.cancel();
            }
            if (this.userProfileRunnable != null) {
                this.userProfileRunnable.cancel();
            }
            this.completionCallback.completed(this);
        }
    }

    void setCurrentTimer(@Nullable TimerImpl currentTimer) {
        this.currentTimer = currentTimer;
    }

    private Map<String, QueryData> getOrCreateQueriesForQueryType(String queryType) {
        if (this.allQueryTypesMap == null) {
            this.allQueryTypesMap = new HashMap<String, Map<String, QueryData>>(2);
            HashMap<String, QueryData> currentQueryTypeQueries = new HashMap<String, QueryData>(4);
            this.allQueryTypesMap.put(queryType, currentQueryTypeQueries);
            return currentQueryTypeQueries;
        }
        Map<String, QueryData> currentQueryTypeQueries = this.allQueryTypesMap.get(queryType);
        if (currentQueryTypeQueries == null) {
            currentQueryTypeQueries = new HashMap<String, QueryData>(4);
            this.allQueryTypesMap.put(queryType, currentQueryTypeQueries);
        }
        return currentQueryTypeQueries;
    }

    private boolean readMemoryBarrier() {
        return this.memoryBarrier;
    }

    public static interface CompletionCallback {
        public void completed(Transaction var1);
    }
}

