/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.api.weaving.Pointcut;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.ImmutableSet;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import org.glowroot.shaded.objectweb.asm.Type;
import org.glowroot.shaded.objectweb.asm.commons.Method;
import org.glowroot.weaving.AdviceBase;
import org.glowroot.weaving.AdviceParameter;

@ParametersAreNonnullByDefault
@Immutable
public final class Advice
extends AdviceBase {
    private final Pointcut pointcut;
    private final Type adviceType;
    @Nullable
    private final Pattern pointcutClassNamePattern;
    @Nullable
    private final Pattern pointcutMethodNamePattern;
    @Nullable
    private final Type travelerType;
    @Nullable
    private final Method isEnabledAdvice;
    @Nullable
    private final Method onBeforeAdvice;
    @Nullable
    private final Method onReturnAdvice;
    @Nullable
    private final Method onThrowAdvice;
    @Nullable
    private final Method onAfterAdvice;
    private final ImmutableList<AdviceParameter> isEnabledParameters;
    private final ImmutableList<AdviceParameter> onBeforeParameters;
    private final ImmutableList<AdviceParameter> onReturnParameters;
    private final ImmutableList<AdviceParameter> onThrowParameters;
    private final ImmutableList<AdviceParameter> onAfterParameters;
    private final boolean reweavable;
    private final ImmutableSet<Type> classMetaTypes;
    private final ImmutableSet<Type> methodMetaTypes;

    private Advice(Pointcut pointcut, Type adviceType, @Nullable Pattern pointcutClassNamePattern, @Nullable Pattern pointcutMethodNamePattern, @Nullable Type travelerType, @Nullable Method isEnabledAdvice, @Nullable Method onBeforeAdvice, @Nullable Method onReturnAdvice, @Nullable Method onThrowAdvice, @Nullable Method onAfterAdvice, ImmutableList<AdviceParameter> isEnabledParameters, ImmutableList<AdviceParameter> onBeforeParameters, ImmutableList<AdviceParameter> onReturnParameters, ImmutableList<AdviceParameter> onThrowParameters, ImmutableList<AdviceParameter> onAfterParameters, boolean reweavable) {
        this.pointcut = pointcut;
        this.adviceType = adviceType;
        this.pointcutClassNamePattern = pointcutClassNamePattern;
        this.pointcutMethodNamePattern = pointcutMethodNamePattern;
        this.travelerType = travelerType;
        this.isEnabledAdvice = isEnabledAdvice;
        this.onBeforeAdvice = onBeforeAdvice;
        this.onReturnAdvice = onReturnAdvice;
        this.onThrowAdvice = onThrowAdvice;
        this.onAfterAdvice = onAfterAdvice;
        this.isEnabledParameters = isEnabledParameters;
        this.onBeforeParameters = onBeforeParameters;
        this.onReturnParameters = onReturnParameters;
        this.onThrowParameters = onThrowParameters;
        this.onAfterParameters = onAfterParameters;
        this.reweavable = reweavable;
        this.classMetaTypes = Preconditions.checkNotNull(super.classMetaTypes());
        this.methodMetaTypes = Preconditions.checkNotNull(super.methodMetaTypes());
    }

    @Override
    public Pointcut pointcut() {
        return this.pointcut;
    }

    @Override
    public Type adviceType() {
        return this.adviceType;
    }

    @Override
    public Pattern pointcutClassNamePattern() {
        return this.pointcutClassNamePattern;
    }

    @Override
    public Pattern pointcutMethodNamePattern() {
        return this.pointcutMethodNamePattern;
    }

    @Override
    public Type travelerType() {
        return this.travelerType;
    }

    @Override
    public Method isEnabledAdvice() {
        return this.isEnabledAdvice;
    }

    @Override
    public Method onBeforeAdvice() {
        return this.onBeforeAdvice;
    }

    @Override
    public Method onReturnAdvice() {
        return this.onReturnAdvice;
    }

    @Override
    public Method onThrowAdvice() {
        return this.onThrowAdvice;
    }

    @Override
    public Method onAfterAdvice() {
        return this.onAfterAdvice;
    }

    @Override
    public ImmutableList<AdviceParameter> isEnabledParameters() {
        return this.isEnabledParameters;
    }

    @Override
    public ImmutableList<AdviceParameter> onBeforeParameters() {
        return this.onBeforeParameters;
    }

    @Override
    public ImmutableList<AdviceParameter> onReturnParameters() {
        return this.onReturnParameters;
    }

    @Override
    public ImmutableList<AdviceParameter> onThrowParameters() {
        return this.onThrowParameters;
    }

    @Override
    public ImmutableList<AdviceParameter> onAfterParameters() {
        return this.onAfterParameters;
    }

    @Override
    public boolean reweavable() {
        return this.reweavable;
    }

    @Override
    public ImmutableSet<Type> classMetaTypes() {
        return this.classMetaTypes;
    }

    @Override
    public ImmutableSet<Type> methodMetaTypes() {
        return this.methodMetaTypes;
    }

    public final Advice withPointcut(Pointcut value) {
        if (this.pointcut == value) {
            return this;
        }
        Pointcut newValue = Preconditions.checkNotNull(value);
        return new Advice(newValue, this.adviceType, this.pointcutClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withAdviceType(Type value) {
        if (this.adviceType == value) {
            return this;
        }
        Type newValue = Preconditions.checkNotNull(value);
        return new Advice(this.pointcut, newValue, this.pointcutClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withPointcutClassNamePattern(@Nullable Pattern value) {
        if (this.pointcutClassNamePattern == value) {
            return this;
        }
        Pattern newValue = value;
        return new Advice(this.pointcut, this.adviceType, newValue, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withPointcutMethodNamePattern(@Nullable Pattern value) {
        if (this.pointcutMethodNamePattern == value) {
            return this;
        }
        Pattern newValue = value;
        return new Advice(this.pointcut, this.adviceType, this.pointcutClassNamePattern, newValue, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withTravelerType(@Nullable Type value) {
        if (this.travelerType == value) {
            return this;
        }
        Type newValue = value;
        return new Advice(this.pointcut, this.adviceType, this.pointcutClassNamePattern, this.pointcutMethodNamePattern, newValue, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withIsEnabledAdvice(@Nullable Method value) {
        if (this.isEnabledAdvice == value) {
            return this;
        }
        Method newValue = value;
        return new Advice(this.pointcut, this.adviceType, this.pointcutClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, newValue, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withOnBeforeAdvice(@Nullable Method value) {
        if (this.onBeforeAdvice == value) {
            return this;
        }
        Method newValue = value;
        return new Advice(this.pointcut, this.adviceType, this.pointcutClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, newValue, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withOnReturnAdvice(@Nullable Method value) {
        if (this.onReturnAdvice == value) {
            return this;
        }
        Method newValue = value;
        return new Advice(this.pointcut, this.adviceType, this.pointcutClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, newValue, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withOnThrowAdvice(@Nullable Method value) {
        if (this.onThrowAdvice == value) {
            return this;
        }
        Method newValue = value;
        return new Advice(this.pointcut, this.adviceType, this.pointcutClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, newValue, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withOnAfterAdvice(@Nullable Method value) {
        if (this.onAfterAdvice == value) {
            return this;
        }
        Method newValue = value;
        return new Advice(this.pointcut, this.adviceType, this.pointcutClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, newValue, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withIsEnabledParameters(AdviceParameter ... elements) {
        ImmutableList<AdviceParameter> newValue = ImmutableList.copyOf(elements);
        return new Advice(this.pointcut, this.adviceType, this.pointcutClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, newValue, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withIsEnabledParameters(Iterable<? extends AdviceParameter> elements) {
        if (this.isEnabledParameters == elements) {
            return this;
        }
        ImmutableList<AdviceParameter> newValue = ImmutableList.copyOf(elements);
        return new Advice(this.pointcut, this.adviceType, this.pointcutClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, newValue, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withOnBeforeParameters(AdviceParameter ... elements) {
        ImmutableList<AdviceParameter> newValue = ImmutableList.copyOf(elements);
        return new Advice(this.pointcut, this.adviceType, this.pointcutClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, newValue, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withOnBeforeParameters(Iterable<? extends AdviceParameter> elements) {
        if (this.onBeforeParameters == elements) {
            return this;
        }
        ImmutableList<AdviceParameter> newValue = ImmutableList.copyOf(elements);
        return new Advice(this.pointcut, this.adviceType, this.pointcutClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, newValue, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withOnReturnParameters(AdviceParameter ... elements) {
        ImmutableList<AdviceParameter> newValue = ImmutableList.copyOf(elements);
        return new Advice(this.pointcut, this.adviceType, this.pointcutClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, newValue, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withOnReturnParameters(Iterable<? extends AdviceParameter> elements) {
        if (this.onReturnParameters == elements) {
            return this;
        }
        ImmutableList<AdviceParameter> newValue = ImmutableList.copyOf(elements);
        return new Advice(this.pointcut, this.adviceType, this.pointcutClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, newValue, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withOnThrowParameters(AdviceParameter ... elements) {
        ImmutableList<AdviceParameter> newValue = ImmutableList.copyOf(elements);
        return new Advice(this.pointcut, this.adviceType, this.pointcutClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, newValue, this.onAfterParameters, this.reweavable);
    }

    public final Advice withOnThrowParameters(Iterable<? extends AdviceParameter> elements) {
        if (this.onThrowParameters == elements) {
            return this;
        }
        ImmutableList<AdviceParameter> newValue = ImmutableList.copyOf(elements);
        return new Advice(this.pointcut, this.adviceType, this.pointcutClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, newValue, this.onAfterParameters, this.reweavable);
    }

    public final Advice withOnAfterParameters(AdviceParameter ... elements) {
        ImmutableList<AdviceParameter> newValue = ImmutableList.copyOf(elements);
        return new Advice(this.pointcut, this.adviceType, this.pointcutClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, newValue, this.reweavable);
    }

    public final Advice withOnAfterParameters(Iterable<? extends AdviceParameter> elements) {
        if (this.onAfterParameters == elements) {
            return this;
        }
        ImmutableList<AdviceParameter> newValue = ImmutableList.copyOf(elements);
        return new Advice(this.pointcut, this.adviceType, this.pointcutClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, newValue, this.reweavable);
    }

    public final Advice withReweavable(boolean value) {
        if (this.reweavable == value) {
            return this;
        }
        boolean newValue = value;
        return new Advice(this.pointcut, this.adviceType, this.pointcutClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof Advice && this.equalTo((Advice)another);
    }

    private boolean equalTo(Advice another) {
        return this.pointcut.equals(another.pointcut) && this.adviceType.equals(another.adviceType) && Objects.equal(this.pointcutClassNamePattern, another.pointcutClassNamePattern) && Objects.equal(this.pointcutMethodNamePattern, another.pointcutMethodNamePattern) && Objects.equal(this.travelerType, another.travelerType) && Objects.equal(this.isEnabledAdvice, another.isEnabledAdvice) && Objects.equal(this.onBeforeAdvice, another.onBeforeAdvice) && Objects.equal(this.onReturnAdvice, another.onReturnAdvice) && Objects.equal(this.onThrowAdvice, another.onThrowAdvice) && Objects.equal(this.onAfterAdvice, another.onAfterAdvice) && this.isEnabledParameters.equals(another.isEnabledParameters) && this.onBeforeParameters.equals(another.onBeforeParameters) && this.onReturnParameters.equals(another.onReturnParameters) && this.onThrowParameters.equals(another.onThrowParameters) && this.onAfterParameters.equals(another.onAfterParameters) && this.reweavable == another.reweavable && this.classMetaTypes.equals(another.classMetaTypes) && this.methodMetaTypes.equals(another.methodMetaTypes);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.pointcut.hashCode();
        h = h * 17 + this.adviceType.hashCode();
        h = h * 17 + Objects.hashCode(this.pointcutClassNamePattern);
        h = h * 17 + Objects.hashCode(this.pointcutMethodNamePattern);
        h = h * 17 + Objects.hashCode(this.travelerType);
        h = h * 17 + Objects.hashCode(this.isEnabledAdvice);
        h = h * 17 + Objects.hashCode(this.onBeforeAdvice);
        h = h * 17 + Objects.hashCode(this.onReturnAdvice);
        h = h * 17 + Objects.hashCode(this.onThrowAdvice);
        h = h * 17 + Objects.hashCode(this.onAfterAdvice);
        h = h * 17 + this.isEnabledParameters.hashCode();
        h = h * 17 + this.onBeforeParameters.hashCode();
        h = h * 17 + this.onReturnParameters.hashCode();
        h = h * 17 + this.onThrowParameters.hashCode();
        h = h * 17 + this.onAfterParameters.hashCode();
        h = h * 17 + Booleans.hashCode(this.reweavable);
        h = h * 17 + this.classMetaTypes.hashCode();
        h = h * 17 + this.methodMetaTypes.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Advice").add("pointcut", this.pointcut).add("adviceType", this.adviceType).add("pointcutClassNamePattern", this.pointcutClassNamePattern).add("pointcutMethodNamePattern", this.pointcutMethodNamePattern).add("travelerType", this.travelerType).add("isEnabledAdvice", this.isEnabledAdvice).add("onBeforeAdvice", this.onBeforeAdvice).add("onReturnAdvice", this.onReturnAdvice).add("onThrowAdvice", this.onThrowAdvice).add("onAfterAdvice", this.onAfterAdvice).add("isEnabledParameters", this.isEnabledParameters).add("onBeforeParameters", this.onBeforeParameters).add("onReturnParameters", this.onReturnParameters).add("onThrowParameters", this.onThrowParameters).add("onAfterParameters", this.onAfterParameters).add("reweavable", this.reweavable).add("classMetaTypes", this.classMetaTypes).add("methodMetaTypes", this.methodMetaTypes).toString();
    }

    public static Advice copyOf(AdviceBase instance) {
        if (instance instanceof Advice) {
            return (Advice)instance;
        }
        return Advice.builder().all(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 7L;
        private static final long INITIALIZED_BIT_POINTCUT = 1L;
        private static final long INITIALIZED_BIT_ADVICE_TYPE = 2L;
        private static final long INITIALIZED_BIT_REWEAVABLE = 4L;
        private long initializedBitset;
        @Nullable
        private Pointcut pointcut;
        @Nullable
        private Type adviceType;
        @Nullable
        private Pattern pointcutClassNamePattern;
        @Nullable
        private Pattern pointcutMethodNamePattern;
        @Nullable
        private Type travelerType;
        @Nullable
        private Method isEnabledAdvice;
        @Nullable
        private Method onBeforeAdvice;
        @Nullable
        private Method onReturnAdvice;
        @Nullable
        private Method onThrowAdvice;
        @Nullable
        private Method onAfterAdvice;
        private ImmutableList.Builder<AdviceParameter> isEnabledParametersBuilder = ImmutableList.builder();
        private ImmutableList.Builder<AdviceParameter> onBeforeParametersBuilder = ImmutableList.builder();
        private ImmutableList.Builder<AdviceParameter> onReturnParametersBuilder = ImmutableList.builder();
        private ImmutableList.Builder<AdviceParameter> onThrowParametersBuilder = ImmutableList.builder();
        private ImmutableList.Builder<AdviceParameter> onAfterParametersBuilder = ImmutableList.builder();
        private boolean reweavable;

        private Builder() {
        }

        public final Builder all(AdviceBase instance) {
            Method onAfterAdviceValue;
            Method onThrowAdviceValue;
            Method onReturnAdviceValue;
            Method onBeforeAdviceValue;
            Method isEnabledAdviceValue;
            Type travelerTypeValue;
            Pattern pointcutMethodNamePatternValue;
            Preconditions.checkNotNull(instance);
            this.pointcut(instance.pointcut());
            this.adviceType(instance.adviceType());
            Pattern pointcutClassNamePatternValue = instance.pointcutClassNamePattern();
            if (pointcutClassNamePatternValue != null) {
                this.pointcutClassNamePattern(pointcutClassNamePatternValue);
            }
            if ((pointcutMethodNamePatternValue = instance.pointcutMethodNamePattern()) != null) {
                this.pointcutMethodNamePattern(pointcutMethodNamePatternValue);
            }
            if ((travelerTypeValue = instance.travelerType()) != null) {
                this.travelerType(travelerTypeValue);
            }
            if ((isEnabledAdviceValue = instance.isEnabledAdvice()) != null) {
                this.isEnabledAdvice(isEnabledAdviceValue);
            }
            if ((onBeforeAdviceValue = instance.onBeforeAdvice()) != null) {
                this.onBeforeAdvice(onBeforeAdviceValue);
            }
            if ((onReturnAdviceValue = instance.onReturnAdvice()) != null) {
                this.onReturnAdvice(onReturnAdviceValue);
            }
            if ((onThrowAdviceValue = instance.onThrowAdvice()) != null) {
                this.onThrowAdvice(onThrowAdviceValue);
            }
            if ((onAfterAdviceValue = instance.onAfterAdvice()) != null) {
                this.onAfterAdvice(onAfterAdviceValue);
            }
            this.addAllIsEnabledParameters(instance.isEnabledParameters());
            this.addAllOnBeforeParameters(instance.onBeforeParameters());
            this.addAllOnReturnParameters(instance.onReturnParameters());
            this.addAllOnThrowParameters(instance.onThrowParameters());
            this.addAllOnAfterParameters(instance.onAfterParameters());
            this.reweavable(instance.reweavable());
            return this;
        }

        public final Builder pointcut(Pointcut pointcut) {
            this.pointcut = Preconditions.checkNotNull(pointcut);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder adviceType(Type adviceType) {
            this.adviceType = Preconditions.checkNotNull(adviceType);
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder pointcutClassNamePattern(@Nullable Pattern pointcutClassNamePattern) {
            this.pointcutClassNamePattern = pointcutClassNamePattern;
            return this;
        }

        public final Builder pointcutMethodNamePattern(@Nullable Pattern pointcutMethodNamePattern) {
            this.pointcutMethodNamePattern = pointcutMethodNamePattern;
            return this;
        }

        public final Builder travelerType(@Nullable Type travelerType) {
            this.travelerType = travelerType;
            return this;
        }

        public final Builder isEnabledAdvice(@Nullable Method isEnabledAdvice) {
            this.isEnabledAdvice = isEnabledAdvice;
            return this;
        }

        public final Builder onBeforeAdvice(@Nullable Method onBeforeAdvice) {
            this.onBeforeAdvice = onBeforeAdvice;
            return this;
        }

        public final Builder onReturnAdvice(@Nullable Method onReturnAdvice) {
            this.onReturnAdvice = onReturnAdvice;
            return this;
        }

        public final Builder onThrowAdvice(@Nullable Method onThrowAdvice) {
            this.onThrowAdvice = onThrowAdvice;
            return this;
        }

        public final Builder onAfterAdvice(@Nullable Method onAfterAdvice) {
            this.onAfterAdvice = onAfterAdvice;
            return this;
        }

        public final Builder addIsEnabledParameters(AdviceParameter element) {
            this.isEnabledParametersBuilder.add((Object)element);
            return this;
        }

        public final Builder addIsEnabledParameters(AdviceParameter ... elements) {
            this.isEnabledParametersBuilder.add(elements);
            return this;
        }

        public final Builder isEnabledParameters(Iterable<? extends AdviceParameter> elements) {
            this.isEnabledParametersBuilder = ImmutableList.builder();
            return this.addAllIsEnabledParameters(elements);
        }

        public final Builder addAllIsEnabledParameters(Iterable<? extends AdviceParameter> elements) {
            this.isEnabledParametersBuilder.addAll(elements);
            return this;
        }

        public final Builder addOnBeforeParameters(AdviceParameter element) {
            this.onBeforeParametersBuilder.add((Object)element);
            return this;
        }

        public final Builder addOnBeforeParameters(AdviceParameter ... elements) {
            this.onBeforeParametersBuilder.add(elements);
            return this;
        }

        public final Builder onBeforeParameters(Iterable<? extends AdviceParameter> elements) {
            this.onBeforeParametersBuilder = ImmutableList.builder();
            return this.addAllOnBeforeParameters(elements);
        }

        public final Builder addAllOnBeforeParameters(Iterable<? extends AdviceParameter> elements) {
            this.onBeforeParametersBuilder.addAll(elements);
            return this;
        }

        public final Builder addOnReturnParameters(AdviceParameter element) {
            this.onReturnParametersBuilder.add((Object)element);
            return this;
        }

        public final Builder addOnReturnParameters(AdviceParameter ... elements) {
            this.onReturnParametersBuilder.add(elements);
            return this;
        }

        public final Builder onReturnParameters(Iterable<? extends AdviceParameter> elements) {
            this.onReturnParametersBuilder = ImmutableList.builder();
            return this.addAllOnReturnParameters(elements);
        }

        public final Builder addAllOnReturnParameters(Iterable<? extends AdviceParameter> elements) {
            this.onReturnParametersBuilder.addAll(elements);
            return this;
        }

        public final Builder addOnThrowParameters(AdviceParameter element) {
            this.onThrowParametersBuilder.add((Object)element);
            return this;
        }

        public final Builder addOnThrowParameters(AdviceParameter ... elements) {
            this.onThrowParametersBuilder.add(elements);
            return this;
        }

        public final Builder onThrowParameters(Iterable<? extends AdviceParameter> elements) {
            this.onThrowParametersBuilder = ImmutableList.builder();
            return this.addAllOnThrowParameters(elements);
        }

        public final Builder addAllOnThrowParameters(Iterable<? extends AdviceParameter> elements) {
            this.onThrowParametersBuilder.addAll(elements);
            return this;
        }

        public final Builder addOnAfterParameters(AdviceParameter element) {
            this.onAfterParametersBuilder.add((Object)element);
            return this;
        }

        public final Builder addOnAfterParameters(AdviceParameter ... elements) {
            this.onAfterParametersBuilder.add(elements);
            return this;
        }

        public final Builder onAfterParameters(Iterable<? extends AdviceParameter> elements) {
            this.onAfterParametersBuilder = ImmutableList.builder();
            return this.addAllOnAfterParameters(elements);
        }

        public final Builder addAllOnAfterParameters(Iterable<? extends AdviceParameter> elements) {
            this.onAfterParametersBuilder.addAll(elements);
            return this;
        }

        public final Builder reweavable(boolean reweavable) {
            this.reweavable = reweavable;
            this.initializedBitset |= 4L;
            return this;
        }

        public Advice build() {
            this.checkRequiredAttributes();
            return new Advice(this.pointcut, this.adviceType, this.pointcutClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, (ImmutableList)this.isEnabledParametersBuilder.build(), (ImmutableList)this.onBeforeParametersBuilder.build(), (ImmutableList)this.onReturnParametersBuilder.build(), (ImmutableList)this.onThrowParametersBuilder.build(), (ImmutableList)this.onAfterParametersBuilder.build(), this.reweavable);
        }

        private boolean pointcutIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean adviceTypeIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean reweavableIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 7L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.pointcutIsSet()) {
                attributes.add("pointcut");
            }
            if (!this.adviceTypeIsSet()) {
                attributes.add("adviceType");
            }
            if (!this.reweavableIsSet()) {
                attributes.add("reweavable");
            }
            return "Cannot build Advice, some of required attributes are not set " + attributes;
        }
    }
}

