/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.weaving.AnalyzedClassBase;
import org.glowroot.weaving.AnalyzedMethod;
import org.glowroot.weaving.MixinType;
import org.glowroot.weaving.ShimType;

@ParametersAreNonnullByDefault
@Immutable
final class AnalyzedClass
extends AnalyzedClassBase {
    private final int modifiers;
    private final String name;
    @Nullable
    private final String superName;
    private final ImmutableList<String> interfaceNames;
    private final ImmutableList<AnalyzedMethod> analyzedMethods;
    private final ImmutableList<ShimType> shimTypes;
    private final ImmutableList<MixinType> mixinTypes;

    private AnalyzedClass(int modifiers, String name, @Nullable String superName, ImmutableList<String> interfaceNames, ImmutableList<AnalyzedMethod> analyzedMethods, ImmutableList<ShimType> shimTypes, ImmutableList<MixinType> mixinTypes) {
        this.modifiers = modifiers;
        this.name = name;
        this.superName = superName;
        this.interfaceNames = interfaceNames;
        this.analyzedMethods = analyzedMethods;
        this.shimTypes = shimTypes;
        this.mixinTypes = mixinTypes;
    }

    @Override
    public int modifiers() {
        return this.modifiers;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String superName() {
        return this.superName;
    }

    @Override
    public ImmutableList<String> interfaceNames() {
        return this.interfaceNames;
    }

    @Override
    public ImmutableList<AnalyzedMethod> analyzedMethods() {
        return this.analyzedMethods;
    }

    @Override
    public ImmutableList<ShimType> shimTypes() {
        return this.shimTypes;
    }

    @Override
    public ImmutableList<MixinType> mixinTypes() {
        return this.mixinTypes;
    }

    public final AnalyzedClass withModifiers(int value) {
        if (this.modifiers == value) {
            return this;
        }
        int newValue = value;
        return new AnalyzedClass(newValue, this.name, this.superName, this.interfaceNames, this.analyzedMethods, this.shimTypes, this.mixinTypes);
    }

    public final AnalyzedClass withName(String value) {
        if (this.name == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new AnalyzedClass(this.modifiers, newValue, this.superName, this.interfaceNames, this.analyzedMethods, this.shimTypes, this.mixinTypes);
    }

    public final AnalyzedClass withSuperName(@Nullable String value) {
        if (this.superName == value) {
            return this;
        }
        String newValue = value;
        return new AnalyzedClass(this.modifiers, this.name, newValue, this.interfaceNames, this.analyzedMethods, this.shimTypes, this.mixinTypes);
    }

    public final AnalyzedClass withInterfaceNames(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new AnalyzedClass(this.modifiers, this.name, this.superName, newValue, this.analyzedMethods, this.shimTypes, this.mixinTypes);
    }

    public final AnalyzedClass withInterfaceNames(Iterable<String> elements) {
        if (this.interfaceNames == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new AnalyzedClass(this.modifiers, this.name, this.superName, newValue, this.analyzedMethods, this.shimTypes, this.mixinTypes);
    }

    public final AnalyzedClass withAnalyzedMethods(AnalyzedMethod ... elements) {
        ImmutableList<AnalyzedMethod> newValue = ImmutableList.copyOf(elements);
        return new AnalyzedClass(this.modifiers, this.name, this.superName, this.interfaceNames, newValue, this.shimTypes, this.mixinTypes);
    }

    public final AnalyzedClass withAnalyzedMethods(Iterable<? extends AnalyzedMethod> elements) {
        if (this.analyzedMethods == elements) {
            return this;
        }
        ImmutableList<AnalyzedMethod> newValue = ImmutableList.copyOf(elements);
        return new AnalyzedClass(this.modifiers, this.name, this.superName, this.interfaceNames, newValue, this.shimTypes, this.mixinTypes);
    }

    public final AnalyzedClass withShimTypes(ShimType ... elements) {
        ImmutableList<ShimType> newValue = ImmutableList.copyOf(elements);
        return new AnalyzedClass(this.modifiers, this.name, this.superName, this.interfaceNames, this.analyzedMethods, newValue, this.mixinTypes);
    }

    public final AnalyzedClass withShimTypes(Iterable<? extends ShimType> elements) {
        if (this.shimTypes == elements) {
            return this;
        }
        ImmutableList<ShimType> newValue = ImmutableList.copyOf(elements);
        return new AnalyzedClass(this.modifiers, this.name, this.superName, this.interfaceNames, this.analyzedMethods, newValue, this.mixinTypes);
    }

    public final AnalyzedClass withMixinTypes(MixinType ... elements) {
        ImmutableList<MixinType> newValue = ImmutableList.copyOf(elements);
        return new AnalyzedClass(this.modifiers, this.name, this.superName, this.interfaceNames, this.analyzedMethods, this.shimTypes, newValue);
    }

    public final AnalyzedClass withMixinTypes(Iterable<? extends MixinType> elements) {
        if (this.mixinTypes == elements) {
            return this;
        }
        ImmutableList<MixinType> newValue = ImmutableList.copyOf(elements);
        return new AnalyzedClass(this.modifiers, this.name, this.superName, this.interfaceNames, this.analyzedMethods, this.shimTypes, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof AnalyzedClass && this.equalTo((AnalyzedClass)another);
    }

    private boolean equalTo(AnalyzedClass another) {
        return this.modifiers == another.modifiers && this.name.equals(another.name) && Objects.equal(this.superName, another.superName) && this.interfaceNames.equals(another.interfaceNames) && this.analyzedMethods.equals(another.analyzedMethods) && this.shimTypes.equals(another.shimTypes) && this.mixinTypes.equals(another.mixinTypes);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.modifiers;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + Objects.hashCode(this.superName);
        h = h * 17 + this.interfaceNames.hashCode();
        h = h * 17 + this.analyzedMethods.hashCode();
        h = h * 17 + this.shimTypes.hashCode();
        h = h * 17 + this.mixinTypes.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("AnalyzedClass").add("modifiers", this.modifiers).add("name", this.name).add("superName", this.superName).add("interfaceNames", this.interfaceNames).add("analyzedMethods", this.analyzedMethods).add("shimTypes", this.shimTypes).add("mixinTypes", this.mixinTypes).toString();
    }

    static AnalyzedClass copyOf(AnalyzedClassBase instance) {
        if (instance instanceof AnalyzedClass) {
            return (AnalyzedClass)instance;
        }
        return AnalyzedClass.builder().all(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_MODIFIERS = 1L;
        private static final long INITIALIZED_BIT_NAME = 2L;
        private long initializedBitset;
        private int modifiers;
        @Nullable
        private String name;
        @Nullable
        private String superName;
        private ImmutableList.Builder<String> interfaceNamesBuilder = ImmutableList.builder();
        private ImmutableList.Builder<AnalyzedMethod> analyzedMethodsBuilder = ImmutableList.builder();
        private ImmutableList.Builder<ShimType> shimTypesBuilder = ImmutableList.builder();
        private ImmutableList.Builder<MixinType> mixinTypesBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder all(AnalyzedClassBase instance) {
            Preconditions.checkNotNull(instance);
            this.modifiers(instance.modifiers());
            this.name(instance.name());
            String superNameValue = instance.superName();
            if (superNameValue != null) {
                this.superName(superNameValue);
            }
            this.addAllInterfaceNames(instance.interfaceNames());
            this.addAllAnalyzedMethods(instance.analyzedMethods());
            this.addAllShimTypes(instance.shimTypes());
            this.addAllMixinTypes(instance.mixinTypes());
            return this;
        }

        public final Builder modifiers(int modifiers) {
            this.modifiers = modifiers;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder name(String name) {
            this.name = Preconditions.checkNotNull(name);
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder superName(@Nullable String superName) {
            this.superName = superName;
            return this;
        }

        public final Builder addInterfaceNames(String element) {
            this.interfaceNamesBuilder.add((Object)element);
            return this;
        }

        public final Builder addInterfaceNames(String ... elements) {
            this.interfaceNamesBuilder.add(elements);
            return this;
        }

        public final Builder interfaceNames(Iterable<String> elements) {
            this.interfaceNamesBuilder = ImmutableList.builder();
            return this.addAllInterfaceNames(elements);
        }

        public final Builder addAllInterfaceNames(Iterable<String> elements) {
            this.interfaceNamesBuilder.addAll((Iterable)elements);
            return this;
        }

        public final Builder addAnalyzedMethods(AnalyzedMethod element) {
            this.analyzedMethodsBuilder.add((Object)element);
            return this;
        }

        public final Builder addAnalyzedMethods(AnalyzedMethod ... elements) {
            this.analyzedMethodsBuilder.add(elements);
            return this;
        }

        public final Builder analyzedMethods(Iterable<? extends AnalyzedMethod> elements) {
            this.analyzedMethodsBuilder = ImmutableList.builder();
            return this.addAllAnalyzedMethods(elements);
        }

        public final Builder addAllAnalyzedMethods(Iterable<? extends AnalyzedMethod> elements) {
            this.analyzedMethodsBuilder.addAll(elements);
            return this;
        }

        public final Builder addShimTypes(ShimType element) {
            this.shimTypesBuilder.add((Object)element);
            return this;
        }

        public final Builder addShimTypes(ShimType ... elements) {
            this.shimTypesBuilder.add(elements);
            return this;
        }

        public final Builder shimTypes(Iterable<? extends ShimType> elements) {
            this.shimTypesBuilder = ImmutableList.builder();
            return this.addAllShimTypes(elements);
        }

        public final Builder addAllShimTypes(Iterable<? extends ShimType> elements) {
            this.shimTypesBuilder.addAll(elements);
            return this;
        }

        public final Builder addMixinTypes(MixinType element) {
            this.mixinTypesBuilder.add((Object)element);
            return this;
        }

        public final Builder addMixinTypes(MixinType ... elements) {
            this.mixinTypesBuilder.add(elements);
            return this;
        }

        public final Builder mixinTypes(Iterable<? extends MixinType> elements) {
            this.mixinTypesBuilder = ImmutableList.builder();
            return this.addAllMixinTypes(elements);
        }

        public final Builder addAllMixinTypes(Iterable<? extends MixinType> elements) {
            this.mixinTypesBuilder.addAll(elements);
            return this;
        }

        public AnalyzedClass build() {
            this.checkRequiredAttributes();
            return new AnalyzedClass(this.modifiers, this.name, this.superName, (ImmutableList)this.interfaceNamesBuilder.build(), (ImmutableList)this.analyzedMethodsBuilder.build(), (ImmutableList)this.shimTypesBuilder.build(), (ImmutableList)this.mixinTypesBuilder.build());
        }

        private boolean modifiersIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean nameIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.modifiersIsSet()) {
                attributes.add("modifiers");
            }
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            return "Cannot build AnalyzedClass, some of required attributes are not set " + attributes;
        }
    }
}

