/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.lang.reflect.Modifier;
import javax.annotation.Nullable;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.weaving.Advice;
import org.glowroot.weaving.AnalyzedMethod;
import org.glowroot.weaving.MixinType;
import org.glowroot.weaving.ShimType;
import org.immutables.value.Value;

@Value.Immutable
abstract class AnalyzedClassBase {
    AnalyzedClassBase() {
    }

    abstract int modifiers();

    abstract String name();

    @Nullable
    abstract String superName();

    abstract ImmutableList<String> interfaceNames();

    abstract ImmutableList<AnalyzedMethod> analyzedMethods();

    abstract ImmutableList<ShimType> shimTypes();

    abstract ImmutableList<MixinType> mixinTypes();

    boolean isInterface() {
        return Modifier.isInterface(this.modifiers());
    }

    boolean isAbstract() {
        return Modifier.isAbstract(this.modifiers());
    }

    boolean hasReweavableAdvice() {
        for (AnalyzedMethod analyzedMethod : this.analyzedMethods()) {
            for (Advice advice : analyzedMethod.advisors()) {
                if (!advice.reweavable()) continue;
                return true;
            }
        }
        return false;
    }
}

