/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.objectweb.asm.Label;
import org.glowroot.weaving.Advice;
import org.glowroot.weaving.WeavingMethodVisitor;

@ParametersAreNonnullByDefault
@Immutable
final class CatchHandler
extends WeavingMethodVisitor.CatchHandlerBase {
    private final Label catchStartLabel;
    private final ImmutableList<Advice> advisors;

    private CatchHandler(Label catchStartLabel, Iterable<? extends Advice> advisors) {
        this.catchStartLabel = Preconditions.checkNotNull(catchStartLabel);
        this.advisors = ImmutableList.copyOf(advisors);
    }

    private CatchHandler(CatchHandler original, Label catchStartLabel, ImmutableList<Advice> advisors) {
        this.catchStartLabel = catchStartLabel;
        this.advisors = advisors;
    }

    @Override
    public Label catchStartLabel() {
        return this.catchStartLabel;
    }

    public ImmutableList<Advice> advisors() {
        return this.advisors;
    }

    public final CatchHandler withCatchStartLabel(Label value) {
        if (this.catchStartLabel == value) {
            return this;
        }
        Label newValue = Preconditions.checkNotNull(value);
        return new CatchHandler(this, newValue, this.advisors);
    }

    public final CatchHandler withAdvisors(Advice ... elements) {
        ImmutableList<Advice> newValue = ImmutableList.copyOf(elements);
        return new CatchHandler(this, this.catchStartLabel, newValue);
    }

    public final CatchHandler withAdvisors(Iterable<? extends Advice> elements) {
        if (this.advisors == elements) {
            return this;
        }
        ImmutableList<Advice> newValue = ImmutableList.copyOf(elements);
        return new CatchHandler(this, this.catchStartLabel, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof CatchHandler && this.equalTo((CatchHandler)another);
    }

    private boolean equalTo(CatchHandler another) {
        return this.catchStartLabel.equals(another.catchStartLabel) && this.advisors.equals(another.advisors);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.catchStartLabel.hashCode();
        h = h * 17 + this.advisors.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("CatchHandler").add("catchStartLabel", this.catchStartLabel).add("advisors", this.advisors).toString();
    }

    public static CatchHandler of(Label catchStartLabel, List<Advice> advisors) {
        return CatchHandler.of(catchStartLabel, advisors);
    }

    public static CatchHandler of(Label catchStartLabel, Iterable<? extends Advice> advisors) {
        return new CatchHandler(catchStartLabel, advisors);
    }

    static CatchHandler copyOf(WeavingMethodVisitor.CatchHandlerBase instance) {
        if (instance instanceof CatchHandler) {
            return (CatchHandler)instance;
        }
        return CatchHandler.builder().all(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 1L;
        private static final long INITIALIZED_BIT_CATCH_START_LABEL = 1L;
        private long initializedBitset;
        @Nullable
        private Label catchStartLabel;
        private ImmutableList.Builder<Advice> advisorsBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder all(WeavingMethodVisitor.CatchHandlerBase instance) {
            Preconditions.checkNotNull(instance);
            this.catchStartLabel(instance.catchStartLabel());
            this.addAllAdvisors(instance.advisors());
            return this;
        }

        public final Builder catchStartLabel(Label catchStartLabel) {
            this.catchStartLabel = Preconditions.checkNotNull(catchStartLabel);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder addAdvisors(Advice element) {
            this.advisorsBuilder.add((Object)element);
            return this;
        }

        public final Builder addAdvisors(Advice ... elements) {
            this.advisorsBuilder.add(elements);
            return this;
        }

        public final Builder advisors(Iterable<? extends Advice> elements) {
            this.advisorsBuilder = ImmutableList.builder();
            return this.addAllAdvisors(elements);
        }

        public final Builder addAllAdvisors(Iterable<? extends Advice> elements) {
            this.advisorsBuilder.addAll(elements);
            return this;
        }

        public CatchHandler build() {
            this.checkRequiredAttributes();
            return new CatchHandler(null, this.catchStartLabel, (ImmutableList)this.advisorsBuilder.build());
        }

        private boolean catchStartLabelIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 1L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.catchStartLabelIsSet()) {
                attributes.add("catchStartLabel");
            }
            return "Cannot build CatchHandler, some of required attributes are not set " + attributes;
        }
    }
}

