/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.CodeSource;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.glowroot.api.weaving.Shim;
import org.glowroot.common.ClassNames;
import org.glowroot.shaded.google.common.base.CharMatcher;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.ImmutableSet;
import org.glowroot.shaded.google.common.collect.Iterables;
import org.glowroot.shaded.google.common.collect.Maps;
import org.glowroot.shaded.google.common.collect.Sets;
import org.glowroot.shaded.objectweb.asm.AnnotationVisitor;
import org.glowroot.shaded.objectweb.asm.ClassReader;
import org.glowroot.shaded.objectweb.asm.ClassVisitor;
import org.glowroot.shaded.objectweb.asm.ClassWriter;
import org.glowroot.shaded.objectweb.asm.FieldVisitor;
import org.glowroot.shaded.objectweb.asm.Label;
import org.glowroot.shaded.objectweb.asm.MethodVisitor;
import org.glowroot.shaded.objectweb.asm.Type;
import org.glowroot.shaded.objectweb.asm.commons.AdviceAdapter;
import org.glowroot.shaded.objectweb.asm.commons.GeneratorAdapter;
import org.glowroot.shaded.objectweb.asm.commons.RemappingMethodAdapter;
import org.glowroot.shaded.objectweb.asm.commons.SimpleRemapper;
import org.glowroot.shaded.objectweb.asm.tree.ClassNode;
import org.glowroot.shaded.objectweb.asm.tree.FieldNode;
import org.glowroot.shaded.objectweb.asm.tree.MethodNode;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.glowroot.weaving.Advice;
import org.glowroot.weaving.AnalyzedClass;
import org.glowroot.weaving.AnalyzedMethod;
import org.glowroot.weaving.AnalyzedMethodKey;
import org.glowroot.weaving.AnalyzedWorld;
import org.glowroot.weaving.AnalyzingClassVisitor;
import org.glowroot.weaving.BootstrapMetaHolders;
import org.glowroot.weaving.ClassLoaders;
import org.glowroot.weaving.GeneratedBytecodeUtil;
import org.glowroot.weaving.MethodMetaGroup;
import org.glowroot.weaving.MixinType;
import org.glowroot.weaving.ShimType;
import org.glowroot.weaving.WeavingMethodVisitor;
import org.immutables.value.Value;

class WeavingClassVisitor
extends ClassVisitor {
    private static final Logger logger = LoggerFactory.getLogger(WeavingClassVisitor.class);
    private static final CharMatcher timerNameCharMatcher = CharMatcher.JAVA_LETTER_OR_DIGIT.or(CharMatcher.is(' '));
    private static final Set<String> invalidTimerNameSet = Sets.newConcurrentHashSet();
    private static final AtomicLong metaHolderCounter = new AtomicLong();
    private final ClassVisitor cv;
    @Nullable
    private final ClassLoader loader;
    private final AnalyzingClassVisitor analyzingClassVisitor;
    private final AnalyzedWorld analyzedWorld;
    private final boolean timerWrapperMethods;
    @MonotonicNonNull
    private Type type;
    private boolean throwShortCircuitException;
    private boolean interfaceSoNothingToWeave;
    private int innerMethodCounter;
    private final Set<Type> classMetaTypes = Sets.newHashSet();
    private final Set<MethodMetaGroup> methodMetaGroups = Sets.newHashSet();
    @MonotonicNonNull
    private String metaHolderInternalName;
    private int methodMetaCounter;

    public WeavingClassVisitor(ClassVisitor cv, List<Advice> advisors, ImmutableList<ShimType> shimTypes, ImmutableList<MixinType> mixinTypes, @Nullable ClassLoader loader, AnalyzedWorld analyzedWorld, @Nullable CodeSource codeSource, boolean timerWrapperMethods) {
        super(327680, cv);
        this.cv = cv;
        this.loader = loader;
        this.analyzingClassVisitor = new AnalyzingClassVisitor(advisors, shimTypes, mixinTypes, loader, analyzedWorld, codeSource);
        this.analyzedWorld = analyzedWorld;
        this.timerWrapperMethods = timerWrapperMethods;
    }

    @Override
    public void visit(int version, int access, String internalName, @Nullable String signature, @Nullable String superInternalName, String[] interfaceInternalNamesNullable) {
        AnalyzedClass nonInterestingAnalyzedClass = this.analyzingClassVisitor.visitAndSometimesReturnNonInterestingAnalyzedClass(access, internalName, superInternalName, interfaceInternalNamesNullable);
        if (nonInterestingAnalyzedClass != null) {
            this.analyzedWorld.add(nonInterestingAnalyzedClass, this.loader);
            this.throwShortCircuitException = true;
            return;
        }
        this.interfaceSoNothingToWeave = Modifier.isInterface(access);
        if (this.interfaceSoNothingToWeave) {
            return;
        }
        this.type = Type.getObjectType(internalName);
        String[] interfacesIncludingMixins = WeavingClassVisitor.getInterfacesIncludingShimsAndMixins(interfaceInternalNamesNullable, this.analyzingClassVisitor.getMatchedShimTypes(), this.analyzingClassVisitor.getMatchedMixinTypes());
        this.cv.visit(version, access, internalName, signature, superInternalName, interfacesIncludingMixins);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (desc.equals("Lorg/glowroot/api/weaving/Pointcut;")) {
            throw PointcutClassFoundException.INSTANCE;
        }
        return this.cv.visitAnnotation(desc, visible);
    }

    @Override
    @Nullable
    public MethodVisitor visitMethod(int access, String name, String desc, @Nullable String signature, String[] exceptions) {
        if (this.throwShortCircuitException) {
            throw ShortCircuitException.INSTANCE;
        }
        List<Advice> matchingAdvisors = this.analyzingClassVisitor.visitMethodAndReturnAdvisors(access, name, desc, signature, exceptions);
        if (this.interfaceSoNothingToWeave) {
            return null;
        }
        Preconditions.checkNotNull(this.type);
        if (WeavingClassVisitor.isAbstractOrNativeOrSynthetic(access)) {
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
        if (this.isInitWithMixins(name)) {
            return this.visitInitWithMixins(access, name, desc, signature, exceptions, matchingAdvisors);
        }
        if (matchingAdvisors.isEmpty()) {
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
        return this.visitMethodWithAdvice(access, name, desc, signature, exceptions, matchingAdvisors);
    }

    @Override
    public void visitEnd() {
        if (this.throwShortCircuitException) {
            throw ShortCircuitException.INSTANCE;
        }
        this.analyzingClassVisitor.visitEnd();
        AnalyzedClass analyzedClass = this.analyzingClassVisitor.getAnalyzedClass();
        Preconditions.checkNotNull(analyzedClass);
        this.analyzedWorld.add(analyzedClass, this.loader);
        if (this.interfaceSoNothingToWeave) {
            return;
        }
        Preconditions.checkNotNull(this.type);
        for (ShimType shimType : this.analyzingClassVisitor.getMatchedShimTypes()) {
            this.addShim(shimType);
        }
        for (MixinType mixinType : this.analyzingClassVisitor.getMatchedMixinTypes()) {
            this.addMixin(mixinType);
        }
        this.handleInheritedMethodsThatNowFulfillAdvice(analyzedClass);
        this.handleMetaHolders();
        this.cv.visitEnd();
    }

    boolean isInterfaceSoNothingToWeave() {
        return this.interfaceSoNothingToWeave;
    }

    @RequiresNonNull(value={"type"})
    private void handleMetaHolders() {
        if (this.metaHolderInternalName != null) {
            if (this.loader == null) {
                this.initializeBoostrapMetaHolders();
            } else {
                try {
                    this.generateMetaHolder();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @RequiresNonNull(value={"type", "metaHolderInternalName"})
    private void initializeBoostrapMetaHolders() {
        for (Type classMetaType : this.classMetaTypes) {
            String classMetaInternalName = classMetaType.getInternalName();
            String classMetaFieldName = "glowroot$class$meta$" + classMetaInternalName.replace('/', '$');
            BootstrapMetaHolders.createClassMetaHolder(this.metaHolderInternalName, classMetaFieldName, classMetaType, this.type);
        }
        for (MethodMetaGroup methodMetaGroup : this.methodMetaGroups) {
            for (Type methodMetaType : methodMetaGroup.methodMetaTypes()) {
                String methodMetaInternalName = methodMetaType.getInternalName();
                String methodMetaFieldName = "glowroot$method$meta$" + methodMetaGroup.uniqueNum() + '$' + methodMetaInternalName.replace('/', '$');
                BootstrapMetaHolders.createMethodMetaHolder(this.metaHolderInternalName, methodMetaFieldName, methodMetaType, this.type, methodMetaGroup.returnType(), methodMetaGroup.parameterTypes());
            }
        }
    }

    @RequiresNonNull(value={"type", "metaHolderInternalName", "loader"})
    private void generateMetaHolder() throws Exception {
        ClassWriter cw = new ClassWriter(3);
        cw.visit(49, 33, this.metaHolderInternalName, null, "java/lang/Object", null);
        Type metaHolderType = Type.getObjectType(this.metaHolderInternalName);
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        mv.visitTryCatchBlock(l0, l1, l2, "java/lang/ClassNotFoundException");
        mv.visitLabel(l0);
        for (Type classMetaType : this.classMetaTypes) {
            String classMetaInternalName = classMetaType.getInternalName();
            String classMetaFieldName = "glowroot$class$meta$" + classMetaInternalName.replace('/', '$');
            FieldVisitor fv = cw.visitField(25, classMetaFieldName, "L" + classMetaInternalName + ";", null, null);
            fv.visitEnd();
            mv.visitTypeInsn(187, classMetaInternalName);
            mv.visitInsn(89);
            WeavingClassVisitor.loadType(mv, this.type, metaHolderType);
            mv.visitMethodInsn(183, classMetaInternalName, "<init>", "(Ljava/lang/Class;)V", false);
            mv.visitFieldInsn(179, this.metaHolderInternalName, classMetaFieldName, "L" + classMetaInternalName + ";");
        }
        for (MethodMetaGroup methodMetaGroup : this.methodMetaGroups) {
            for (Type methodMetaType : methodMetaGroup.methodMetaTypes()) {
                String methodMetaInternalName = methodMetaType.getInternalName();
                String methodMetaFieldName = "glowroot$method$meta$" + methodMetaGroup.uniqueNum() + '$' + methodMetaInternalName.replace('/', '$');
                FieldVisitor fv = cw.visitField(25, methodMetaFieldName, "L" + methodMetaInternalName + ";", null, null);
                fv.visitEnd();
                mv.visitTypeInsn(187, methodMetaInternalName);
                mv.visitInsn(89);
                WeavingClassVisitor.loadType(mv, this.type, metaHolderType);
                WeavingClassVisitor.loadType(mv, methodMetaGroup.returnType(), metaHolderType);
                mv.visitIntInsn(16, methodMetaGroup.parameterTypes().size());
                mv.visitTypeInsn(189, "java/lang/Class");
                for (int i = 0; i < methodMetaGroup.parameterTypes().size(); ++i) {
                    mv.visitInsn(89);
                    mv.visitIntInsn(16, i);
                    WeavingClassVisitor.loadType(mv, (Type)methodMetaGroup.parameterTypes().get(i), metaHolderType);
                    mv.visitInsn(83);
                }
                mv.visitMethodInsn(183, methodMetaInternalName, "<init>", "(Ljava/lang/Class;Ljava/lang/Class;[Ljava/lang/Class;)V", false);
                mv.visitFieldInsn(179, this.metaHolderInternalName, methodMetaFieldName, "L" + methodMetaInternalName + ";");
            }
        }
        mv.visitLabel(l1);
        Label l3 = new Label();
        mv.visitJumpInsn(167, l3);
        mv.visitLabel(l2);
        mv.visitFrame(4, 0, null, 1, new Object[]{"java/lang/ClassNotFoundException"});
        mv.visitVarInsn(58, 0);
        mv.visitTypeInsn(187, "java/lang/AssertionError");
        mv.visitInsn(89);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/AssertionError", "<init>", "(Ljava/lang/Object;)V", false);
        mv.visitInsn(191);
        mv.visitLabel(l3);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        byte[] bytes = cw.toByteArray();
        ClassLoaders.defineClass(ClassNames.fromInternalName(this.metaHolderInternalName), bytes, this.loader);
    }

    private static void loadType(MethodVisitor mv, Type type, Type ownerType) {
        switch (type.getSort()) {
            case 0: {
                mv.visitFieldInsn(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 1: {
                mv.visitFieldInsn(178, "java/lang/Boolean", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 2: {
                mv.visitFieldInsn(178, "java/lang/Character", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 3: {
                mv.visitFieldInsn(178, "java/lang/Byte", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 4: {
                mv.visitFieldInsn(178, "java/lang/Short", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 5: {
                mv.visitFieldInsn(178, "java/lang/Integer", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 6: {
                mv.visitFieldInsn(178, "java/lang/Float", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 7: {
                mv.visitFieldInsn(178, "java/lang/Long", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 8: {
                mv.visitFieldInsn(178, "java/lang/Double", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 9: {
                WeavingClassVisitor.loadArrayType(mv, type, ownerType);
                break;
            }
            default: {
                WeavingClassVisitor.loadObjectType(mv, type, ownerType);
            }
        }
    }

    private static void loadArrayType(MethodVisitor mv, Type type, Type ownerType) {
        WeavingClassVisitor.loadType(mv, type.getElementType(), ownerType);
        mv.visitIntInsn(16, type.getDimensions());
        mv.visitMethodInsn(184, Type.getInternalName(GeneratedBytecodeUtil.class), "getArrayClass", "(Ljava/lang/Class;I)Ljava/lang/Class;", false);
    }

    private static void loadObjectType(MethodVisitor mv, Type type, Type ownerType) {
        mv.visitLdcInsn(type.getClassName());
        mv.visitInsn(3);
        mv.visitLdcInsn(ownerType);
        mv.visitMethodInsn(182, "java/lang/Class", "getClassLoader", "()Ljava/lang/ClassLoader;", false);
        mv.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;", false);
    }

    private static String[] getInterfacesIncludingShimsAndMixins(String[] interfaces, ImmutableList<ShimType> matchedShimTypes, ImmutableList<MixinType> matchedMixinTypes) {
        if (matchedMixinTypes.isEmpty() && matchedShimTypes.isEmpty()) {
            return interfaces;
        }
        HashSet<String> interfacesIncludingShimsAndMixins = Sets.newHashSet();
        if (interfaces != null) {
            interfacesIncludingShimsAndMixins.addAll(Arrays.asList(interfaces));
        }
        for (ShimType matchedShimType : matchedShimTypes) {
            interfacesIncludingShimsAndMixins.add(matchedShimType.iface().getInternalName());
        }
        for (MixinType matchedMixinType : matchedMixinTypes) {
            for (Type mixinInterface : matchedMixinType.interfaces()) {
                interfacesIncludingShimsAndMixins.add(mixinInterface.getInternalName());
            }
        }
        return Iterables.toArray(interfacesIncludingShimsAndMixins, String.class);
    }

    private boolean isInitWithMixins(String name) {
        return name.equals("<init>") && !this.analyzingClassVisitor.getMatchedMixinTypes().isEmpty();
    }

    @RequiresNonNull(value={"type"})
    private MethodVisitor visitInitWithMixins(int access, String name, String desc, @Nullable String signature, String[] exceptions, List<Advice> matchingAdvisors) {
        Integer methodMetaUniqueNum = this.collectMetasAtMethod(matchingAdvisors, desc);
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        Preconditions.checkNotNull(mv);
        mv = new InitMixins(mv, access, name, desc, this.analyzingClassVisitor.getMatchedMixinTypes(), this.type);
        for (Advice advice : matchingAdvisors) {
            if (advice.pointcut().timerName().length() == 0) continue;
            logger.warn("cannot add timer to <clinit> or <init> methods at this time");
            break;
        }
        return new WeavingMethodVisitor(mv, access, name, desc, this.type, matchingAdvisors, this.metaHolderInternalName, methodMetaUniqueNum, this.loader == null, null);
    }

    @RequiresNonNull(value={"type"})
    private MethodVisitor visitMethodWithAdvice(int access, String name, String desc, @Nullable String signature, String[] exceptions, Iterable<Advice> matchingAdvisors) {
        Integer methodMetaUniqueNum = this.collectMetasAtMethod(matchingAdvisors, desc);
        if (this.timerWrapperMethods && !name.equals("<init>")) {
            return this.wrapWithSyntheticTimerMarkerMethods(access, name, desc, signature, exceptions, matchingAdvisors, methodMetaUniqueNum);
        }
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        Preconditions.checkNotNull(mv);
        return new WeavingMethodVisitor(mv, access, name, desc, this.type, matchingAdvisors, this.metaHolderInternalName, methodMetaUniqueNum, this.loader == null, null);
    }

    @Nullable
    private Integer collectMetasAtMethod(Iterable<Advice> matchingAdvisors, String desc) {
        HashSet<Type> methodMetaTypes = Sets.newHashSet();
        for (Advice matchingAdvice : matchingAdvisors) {
            this.classMetaTypes.addAll(matchingAdvice.classMetaTypes());
            methodMetaTypes.addAll(matchingAdvice.methodMetaTypes());
        }
        Integer methodMetaUniqueNum = null;
        if (!methodMetaTypes.isEmpty()) {
            methodMetaUniqueNum = ++this.methodMetaCounter;
            List<Type> parameterTypes = Arrays.asList(Type.getArgumentTypes(desc));
            Type returnType = Type.getReturnType(desc);
            this.methodMetaGroups.add(MethodMetaGroup.builder().returnType(returnType).parameterTypes(parameterTypes).uniqueNum(methodMetaUniqueNum).methodMetaTypes(methodMetaTypes).build());
        }
        if (!(this.classMetaTypes.isEmpty() && methodMetaTypes.isEmpty() || this.metaHolderInternalName != null)) {
            this.metaHolderInternalName = "org/glowroot/weaving/MetaHolder" + metaHolderCounter.incrementAndGet();
        }
        return methodMetaUniqueNum;
    }

    @RequiresNonNull(value={"type"})
    private WeavingMethodVisitor wrapWithSyntheticTimerMarkerMethods(int outerAccess, String outerName, String desc, @Nullable String signature, String[] exceptions, Iterable<Advice> matchingAdvisors, @Nullable Integer methodMetaUniqueNum) {
        int innerAccess = 18 + (outerAccess & 8);
        GeneratorAdapter outerMethodVisitor = null;
        String currMethodName = outerName;
        int currMethodAccess = outerAccess;
        for (Advice advice : matchingAdvisors) {
            String timerName = advice.pointcut().timerName();
            if (timerName.isEmpty()) continue;
            if (!timerNameCharMatcher.matchesAllOf(timerName)) {
                WeavingClassVisitor.logInvalidTimerNameWarningOnce(timerName);
                timerName = timerNameCharMatcher.negate().replaceFrom((CharSequence)timerName, '_');
            }
            String nextMethodName = outerName + "$glowroot$timer$" + timerName.replace(' ', '$') + '$' + this.innerMethodCounter++;
            int access = outerMethodVisitor == null ? outerAccess : innerAccess;
            MethodVisitor mv = this.cv.visitMethod(access, currMethodName, desc, signature, exceptions);
            Preconditions.checkNotNull(mv);
            GeneratorAdapter mg = new GeneratorAdapter(mv, access, nextMethodName, desc);
            if (!Modifier.isStatic(outerAccess)) {
                mg.loadThis();
                mg.loadArgs();
                mg.invokeVirtual(this.type, new org.glowroot.shaded.objectweb.asm.commons.Method(nextMethodName, desc));
            } else {
                mg.loadArgs();
                mg.invokeStatic(this.type, new org.glowroot.shaded.objectweb.asm.commons.Method(nextMethodName, desc));
            }
            mg.returnValue();
            mg.endMethod();
            currMethodName = nextMethodName;
            currMethodAccess = innerAccess;
            if (outerMethodVisitor != null) continue;
            outerMethodVisitor = mg;
        }
        MethodVisitor mv = this.cv.visitMethod(currMethodAccess, currMethodName, desc, signature, exceptions);
        Preconditions.checkNotNull(mv);
        return new WeavingMethodVisitor(mv, currMethodAccess, currMethodName, desc, this.type, matchingAdvisors, this.metaHolderInternalName, methodMetaUniqueNum, this.loader == null, outerMethodVisitor);
    }

    @RequiresNonNull(value={"type"})
    private void addShim(ShimType shimType) {
        for (Method reflectMethod : shimType.shimMethods()) {
            org.glowroot.shaded.objectweb.asm.commons.Method method = org.glowroot.shaded.objectweb.asm.commons.Method.getMethod(reflectMethod);
            Shim shim = reflectMethod.getAnnotation(Shim.class);
            Preconditions.checkNotNull(shim);
            org.glowroot.shaded.objectweb.asm.commons.Method targetMethod = org.glowroot.shaded.objectweb.asm.commons.Method.getMethod(shim.value());
            MethodVisitor mv = this.cv.visitMethod(1, method.getName(), method.getDescriptor(), null, null);
            Preconditions.checkNotNull(mv);
            mv.visitCode();
            int i = 0;
            mv.visitVarInsn(25, i++);
            for (Type argumentType : method.getArgumentTypes()) {
                mv.visitVarInsn(argumentType.getOpcode(21), i++);
            }
            mv.visitMethodInsn(182, this.type.getInternalName(), targetMethod.getName(), targetMethod.getDescriptor(), false);
            mv.visitInsn(method.getReturnType().getOpcode(172));
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    @RequiresNonNull(value={"type"})
    private void addMixin(MixinType mixinType) {
        ClassReader cr = new ClassReader(mixinType.implementationBytes());
        ClassNode cn = new ClassNode();
        cr.accept(cn, 8);
        List fieldNodes = cn.fields;
        for (FieldNode fieldNode : fieldNodes) {
            fieldNode.accept(this);
        }
        List methodNodes = cn.methods;
        for (MethodNode mn : methodNodes) {
            if (mn.name.equals("<init>")) continue;
            String[] exceptions = Iterables.toArray(mn.exceptions, String.class);
            MethodVisitor mv = this.cv.visitMethod(mn.access, mn.name, mn.desc, mn.signature, exceptions);
            Preconditions.checkNotNull(mv);
            mn.accept(new RemappingMethodAdapter(mn.access, mn.desc, mv, new SimpleRemapper(cn.name, this.type.getInternalName())));
        }
    }

    @RequiresNonNull(value={"type"})
    private void handleInheritedMethodsThatNowFulfillAdvice(AnalyzedClass analyzedClass) {
        if (analyzedClass.isInterface() || analyzedClass.isAbstract()) {
            return;
        }
        Map<AnalyzedMethodKey, Set<Advice>> matchingAdvisorSets = this.getInheritedInterfaceMethodsWithAdvice();
        for (AnalyzedMethod analyzedMethod : analyzedClass.analyzedMethods()) {
            matchingAdvisorSets.remove(AnalyzedMethodKey.wrap(analyzedMethod));
        }
        this.removeAdviceAlreadyWovenIntoSuperClass(matchingAdvisorSets);
        for (Map.Entry<AnalyzedMethodKey, Set<Advice>> entry : matchingAdvisorSets.entrySet()) {
            AnalyzedMethod inheritedMethod = entry.getKey().analyzedMethod();
            Set<Advice> advisors = entry.getValue();
            if (advisors.isEmpty()) continue;
            this.overrideAndWeaveInheritedMethod(analyzedClass, inheritedMethod, advisors);
        }
    }

    private Map<AnalyzedMethodKey, Set<Advice>> getInheritedInterfaceMethodsWithAdvice() {
        HashMap<AnalyzedMethodKey, Set<Advice>> matchingAdvisorSets = Maps.newHashMap();
        for (AnalyzedClass superAnalyzedClass : this.analyzingClassVisitor.getSuperAnalyzedClasses()) {
            if (!superAnalyzedClass.isInterface()) continue;
            for (AnalyzedMethod superAnalyzedMethod : superAnalyzedClass.analyzedMethods()) {
                AnalyzedMethodKey key = AnalyzedMethodKey.wrap(superAnalyzedMethod);
                HashSet<Advice> matchingAdvisorSet = (HashSet<Advice>)matchingAdvisorSets.get(key);
                if (matchingAdvisorSet == null) {
                    matchingAdvisorSet = Sets.newHashSet();
                    matchingAdvisorSets.put(key, matchingAdvisorSet);
                }
                matchingAdvisorSet.addAll(superAnalyzedMethod.advisors());
            }
        }
        return matchingAdvisorSets;
    }

    private void removeAdviceAlreadyWovenIntoSuperClass(Map<AnalyzedMethodKey, Set<Advice>> matchingAdvisorSets) {
        for (AnalyzedClass superAnalyzedClass : this.analyzingClassVisitor.getSuperAnalyzedClasses()) {
            if (superAnalyzedClass.isInterface()) continue;
            for (AnalyzedMethod superAnalyzedMethod : superAnalyzedClass.analyzedMethods()) {
                Set<Advice> matchingAdvisorSet = matchingAdvisorSets.get(AnalyzedMethodKey.wrap(superAnalyzedMethod));
                if (matchingAdvisorSet == null) continue;
                matchingAdvisorSet.removeAll(superAnalyzedMethod.advisors());
            }
        }
    }

    @RequiresNonNull(value={"type"})
    private void overrideAndWeaveInheritedMethod(AnalyzedClass analyzedClass, AnalyzedMethod inheritedMethod, Collection<Advice> matchingAdvisors) {
        String superName = analyzedClass.superName();
        Preconditions.checkNotNull(superName);
        String[] exceptions = new String[inheritedMethod.exceptions().size()];
        for (int i = 0; i < inheritedMethod.exceptions().size(); ++i) {
            exceptions[i] = ClassNames.toInternalName((String)inheritedMethod.exceptions().get(i));
        }
        MethodVisitor mv = this.visitMethodWithAdvice(1, inheritedMethod.name(), inheritedMethod.getDesc(), inheritedMethod.signature(), exceptions, matchingAdvisors);
        Preconditions.checkNotNull(mv);
        GeneratorAdapter mg = new GeneratorAdapter(mv, 1, inheritedMethod.name(), inheritedMethod.getDesc());
        mg.visitCode();
        mg.loadThis();
        mg.loadArgs();
        Type superType = Type.getObjectType(ClassNames.toInternalName(superName));
        org.glowroot.shaded.objectweb.asm.commons.Method method = new org.glowroot.shaded.objectweb.asm.commons.Method(inheritedMethod.name(), inheritedMethod.getDesc());
        mg.invokeConstructor(superType, method);
        mg.returnValue();
        mg.endMethod();
    }

    private static boolean isAbstractOrNativeOrSynthetic(int access) {
        return Modifier.isAbstract(access) || Modifier.isNative(access) || (access & 0x1000) != 0;
    }

    private static void logInvalidTimerNameWarningOnce(String timerName) {
        if (invalidTimerNameSet.add(timerName)) {
            logger.warn("timer name must contain only letters, digits and spaces: {}", (Object)timerName);
        }
    }

    @Value.Immutable
    static abstract class AnalyzedMethodKeyBase {
        AnalyzedMethodKeyBase() {
        }

        abstract String name();

        abstract ImmutableList<String> parameterTypes();

        abstract AnalyzedMethod analyzedMethod();

        static AnalyzedMethodKey wrap(AnalyzedMethod analyzedMethod) {
            return AnalyzedMethodKey.builder().name(analyzedMethod.name()).addAllParameterTypes(analyzedMethod.parameterTypes()).analyzedMethod(analyzedMethod).build();
        }
    }

    @Value.Immutable
    static abstract class MethodMetaGroupBase {
        MethodMetaGroupBase() {
        }

        abstract Type returnType();

        abstract ImmutableList<Type> parameterTypes();

        abstract int uniqueNum();

        abstract ImmutableSet<Type> methodMetaTypes();
    }

    private static class InitMixins
    extends AdviceAdapter {
        private final ImmutableList<MixinType> matchedMixinTypes;
        private final Type type;
        private boolean cascadingConstructor;

        InitMixins(MethodVisitor mv, int access, String name, String desc, ImmutableList<MixinType> matchedMixinTypes, Type type) {
            super(327680, mv, access, name, desc);
            this.matchedMixinTypes = matchedMixinTypes;
            this.type = type;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (name.equals("<init>") && owner.equals(this.type.getInternalName())) {
                this.cascadingConstructor = true;
            }
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }

        @Override
        protected void onMethodExit(int opcode) {
            if (this.cascadingConstructor) {
                return;
            }
            for (MixinType mixinType : this.matchedMixinTypes) {
                String initMethodName = mixinType.initMethodName();
                if (initMethodName == null) continue;
                this.loadThis();
                this.invokeVirtual(this.type, new org.glowroot.shaded.objectweb.asm.commons.Method(initMethodName, "()V"));
            }
        }
    }

    static class PointcutClassFoundException
    extends RuntimeException {
        private static final PointcutClassFoundException INSTANCE = new PointcutClassFoundException();

        private PointcutClassFoundException() {
        }
    }

    static class ShortCircuitException
    extends RuntimeException {
        static final ShortCircuitException INSTANCE = new ShortCircuitException();

        private ShortCircuitException() {
        }
    }
}

