package org.glowroot.config;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.primitives.Booleans;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link AdvancedConfigBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code AdvancedConfig.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AdvancedConfigBase"})
@Immutable
public final class AdvancedConfig extends AdvancedConfigBase {
  private final boolean timerWrapperMethods;
  private final boolean weavingTimer;
  private final int immediatePartialStoreThresholdSeconds;
  private final int maxAggregateTransactionsPerTransactionType;
  private final int maxAggregateQueriesPerQueryType;
  private final int maxTraceEntriesPerTransaction;
  private final int maxStackTraceSamplesPerTransaction;
  private final boolean captureThreadInfo;
  private final boolean captureGcInfo;
  private final int mbeanGaugeNotFoundDelaySeconds;
  private final int internalQueryTimeoutSeconds;
  private final String version;

  private AdvancedConfig(AdvancedConfig.Builder builder) {
    this.timerWrapperMethods = builder.timerWrapperMethodsIsSet()
        ? builder.timerWrapperMethods
        : super.timerWrapperMethods();
    this.weavingTimer = builder.weavingTimerIsSet()
        ? builder.weavingTimer
        : super.weavingTimer();
    this.immediatePartialStoreThresholdSeconds = builder.immediatePartialStoreThresholdSecondsIsSet()
        ? builder.immediatePartialStoreThresholdSeconds
        : super.immediatePartialStoreThresholdSeconds();
    this.maxAggregateTransactionsPerTransactionType = builder.maxAggregateTransactionsPerTransactionTypeIsSet()
        ? builder.maxAggregateTransactionsPerTransactionType
        : super.maxAggregateTransactionsPerTransactionType();
    this.maxAggregateQueriesPerQueryType = builder.maxAggregateQueriesPerQueryTypeIsSet()
        ? builder.maxAggregateQueriesPerQueryType
        : super.maxAggregateQueriesPerQueryType();
    this.maxTraceEntriesPerTransaction = builder.maxTraceEntriesPerTransactionIsSet()
        ? builder.maxTraceEntriesPerTransaction
        : super.maxTraceEntriesPerTransaction();
    this.maxStackTraceSamplesPerTransaction = builder.maxStackTraceSamplesPerTransactionIsSet()
        ? builder.maxStackTraceSamplesPerTransaction
        : super.maxStackTraceSamplesPerTransaction();
    this.captureThreadInfo = builder.captureThreadInfoIsSet()
        ? builder.captureThreadInfo
        : super.captureThreadInfo();
    this.captureGcInfo = builder.captureGcInfoIsSet()
        ? builder.captureGcInfo
        : super.captureGcInfo();
    this.mbeanGaugeNotFoundDelaySeconds = builder.mbeanGaugeNotFoundDelaySecondsIsSet()
        ? builder.mbeanGaugeNotFoundDelaySeconds
        : super.mbeanGaugeNotFoundDelaySeconds();
    this.internalQueryTimeoutSeconds = builder.internalQueryTimeoutSecondsIsSet()
        ? builder.internalQueryTimeoutSeconds
        : super.internalQueryTimeoutSeconds();
    this.version = Preconditions.checkNotNull(super.version());
  }

  private AdvancedConfig(
      boolean timerWrapperMethods,
      boolean weavingTimer,
      int immediatePartialStoreThresholdSeconds,
      int maxAggregateTransactionsPerTransactionType,
      int maxAggregateQueriesPerQueryType,
      int maxTraceEntriesPerTransaction,
      int maxStackTraceSamplesPerTransaction,
      boolean captureThreadInfo,
      boolean captureGcInfo,
      int mbeanGaugeNotFoundDelaySeconds,
      int internalQueryTimeoutSeconds) {
    this.timerWrapperMethods = timerWrapperMethods;
    this.weavingTimer = weavingTimer;
    this.immediatePartialStoreThresholdSeconds = immediatePartialStoreThresholdSeconds;
    this.maxAggregateTransactionsPerTransactionType = maxAggregateTransactionsPerTransactionType;
    this.maxAggregateQueriesPerQueryType = maxAggregateQueriesPerQueryType;
    this.maxTraceEntriesPerTransaction = maxTraceEntriesPerTransaction;
    this.maxStackTraceSamplesPerTransaction = maxStackTraceSamplesPerTransaction;
    this.captureThreadInfo = captureThreadInfo;
    this.captureGcInfo = captureGcInfo;
    this.mbeanGaugeNotFoundDelaySeconds = mbeanGaugeNotFoundDelaySeconds;
    this.internalQueryTimeoutSeconds = internalQueryTimeoutSeconds;
    this.version = Preconditions.checkNotNull(super.version());
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code timerWrapperMethods} attribute
   */
  @JsonProperty("timerWrapperMethods")
  @Override
  public boolean timerWrapperMethods() {
    return timerWrapperMethods;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code weavingTimer} attribute
   */
  @JsonProperty("weavingTimer")
  @Override
  public boolean weavingTimer() {
    return weavingTimer;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code immediatePartialStoreThresholdSeconds} attribute
   */
  @JsonProperty("immediatePartialStoreThresholdSeconds")
  @Override
  public int immediatePartialStoreThresholdSeconds() {
    return immediatePartialStoreThresholdSeconds;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code maxAggregateTransactionsPerTransactionType} attribute
   */
  @JsonProperty("maxAggregateTransactionsPerTransactionType")
  @Override
  public int maxAggregateTransactionsPerTransactionType() {
    return maxAggregateTransactionsPerTransactionType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code maxAggregateQueriesPerQueryType} attribute
   */
  @JsonProperty("maxAggregateQueriesPerQueryType")
  @Override
  public int maxAggregateQueriesPerQueryType() {
    return maxAggregateQueriesPerQueryType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code maxTraceEntriesPerTransaction} attribute
   */
  @JsonProperty("maxTraceEntriesPerTransaction")
  @Override
  public int maxTraceEntriesPerTransaction() {
    return maxTraceEntriesPerTransaction;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code maxStackTraceSamplesPerTransaction} attribute
   */
  @JsonProperty("maxStackTraceSamplesPerTransaction")
  @Override
  public int maxStackTraceSamplesPerTransaction() {
    return maxStackTraceSamplesPerTransaction;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code captureThreadInfo} attribute
   */
  @JsonProperty("captureThreadInfo")
  @Override
  public boolean captureThreadInfo() {
    return captureThreadInfo;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code captureGcInfo} attribute
   */
  @JsonProperty("captureGcInfo")
  @Override
  public boolean captureGcInfo() {
    return captureGcInfo;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code mbeanGaugeNotFoundDelaySeconds} attribute
   */
  @JsonProperty("mbeanGaugeNotFoundDelaySeconds")
  @Override
  public int mbeanGaugeNotFoundDelaySeconds() {
    return mbeanGaugeNotFoundDelaySeconds;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code internalQueryTimeoutSeconds} attribute
   */
  @JsonProperty("internalQueryTimeoutSeconds")
  @Override
  public int internalQueryTimeoutSeconds() {
    return internalQueryTimeoutSeconds;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code version} attribute
   */
  @JsonIgnore
  @JsonProperty("version")
  @Override
  public String version() {
    return version;
  }
  
  /**
   * Copy current immutable object by setting value for {@link AdvancedConfigBase#timerWrapperMethods() timerWrapperMethods}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for timerWrapperMethods
   * @return modified copy of the {@code this} object
   */
  public final AdvancedConfig withTimerWrapperMethods(boolean value) {
    if (this.timerWrapperMethods == value) {
      return this;
    }
    boolean newValue = value;
    return new AdvancedConfig(
        newValue,
        this.weavingTimer,
        this.immediatePartialStoreThresholdSeconds,
        this.maxAggregateTransactionsPerTransactionType,
        this.maxAggregateQueriesPerQueryType,
        this.maxTraceEntriesPerTransaction,
        this.maxStackTraceSamplesPerTransaction,
        this.captureThreadInfo,
        this.captureGcInfo,
        this.mbeanGaugeNotFoundDelaySeconds,
        this.internalQueryTimeoutSeconds);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AdvancedConfigBase#weavingTimer() weavingTimer}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for weavingTimer
   * @return modified copy of the {@code this} object
   */
  public final AdvancedConfig withWeavingTimer(boolean value) {
    if (this.weavingTimer == value) {
      return this;
    }
    boolean newValue = value;
    return new AdvancedConfig(
        this.timerWrapperMethods,
        newValue,
        this.immediatePartialStoreThresholdSeconds,
        this.maxAggregateTransactionsPerTransactionType,
        this.maxAggregateQueriesPerQueryType,
        this.maxTraceEntriesPerTransaction,
        this.maxStackTraceSamplesPerTransaction,
        this.captureThreadInfo,
        this.captureGcInfo,
        this.mbeanGaugeNotFoundDelaySeconds,
        this.internalQueryTimeoutSeconds);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AdvancedConfigBase#immediatePartialStoreThresholdSeconds() immediatePartialStoreThresholdSeconds}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for immediatePartialStoreThresholdSeconds
   * @return modified copy of the {@code this} object
   */
  public final AdvancedConfig withImmediatePartialStoreThresholdSeconds(int value) {
    if (this.immediatePartialStoreThresholdSeconds == value) {
      return this;
    }
    int newValue = value;
    return new AdvancedConfig(
        this.timerWrapperMethods,
        this.weavingTimer,
        newValue,
        this.maxAggregateTransactionsPerTransactionType,
        this.maxAggregateQueriesPerQueryType,
        this.maxTraceEntriesPerTransaction,
        this.maxStackTraceSamplesPerTransaction,
        this.captureThreadInfo,
        this.captureGcInfo,
        this.mbeanGaugeNotFoundDelaySeconds,
        this.internalQueryTimeoutSeconds);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AdvancedConfigBase#maxAggregateTransactionsPerTransactionType() maxAggregateTransactionsPerTransactionType}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for maxAggregateTransactionsPerTransactionType
   * @return modified copy of the {@code this} object
   */
  public final AdvancedConfig withMaxAggregateTransactionsPerTransactionType(int value) {
    if (this.maxAggregateTransactionsPerTransactionType == value) {
      return this;
    }
    int newValue = value;
    return new AdvancedConfig(
        this.timerWrapperMethods,
        this.weavingTimer,
        this.immediatePartialStoreThresholdSeconds,
        newValue,
        this.maxAggregateQueriesPerQueryType,
        this.maxTraceEntriesPerTransaction,
        this.maxStackTraceSamplesPerTransaction,
        this.captureThreadInfo,
        this.captureGcInfo,
        this.mbeanGaugeNotFoundDelaySeconds,
        this.internalQueryTimeoutSeconds);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AdvancedConfigBase#maxAggregateQueriesPerQueryType() maxAggregateQueriesPerQueryType}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for maxAggregateQueriesPerQueryType
   * @return modified copy of the {@code this} object
   */
  public final AdvancedConfig withMaxAggregateQueriesPerQueryType(int value) {
    if (this.maxAggregateQueriesPerQueryType == value) {
      return this;
    }
    int newValue = value;
    return new AdvancedConfig(
        this.timerWrapperMethods,
        this.weavingTimer,
        this.immediatePartialStoreThresholdSeconds,
        this.maxAggregateTransactionsPerTransactionType,
        newValue,
        this.maxTraceEntriesPerTransaction,
        this.maxStackTraceSamplesPerTransaction,
        this.captureThreadInfo,
        this.captureGcInfo,
        this.mbeanGaugeNotFoundDelaySeconds,
        this.internalQueryTimeoutSeconds);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AdvancedConfigBase#maxTraceEntriesPerTransaction() maxTraceEntriesPerTransaction}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for maxTraceEntriesPerTransaction
   * @return modified copy of the {@code this} object
   */
  public final AdvancedConfig withMaxTraceEntriesPerTransaction(int value) {
    if (this.maxTraceEntriesPerTransaction == value) {
      return this;
    }
    int newValue = value;
    return new AdvancedConfig(
        this.timerWrapperMethods,
        this.weavingTimer,
        this.immediatePartialStoreThresholdSeconds,
        this.maxAggregateTransactionsPerTransactionType,
        this.maxAggregateQueriesPerQueryType,
        newValue,
        this.maxStackTraceSamplesPerTransaction,
        this.captureThreadInfo,
        this.captureGcInfo,
        this.mbeanGaugeNotFoundDelaySeconds,
        this.internalQueryTimeoutSeconds);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AdvancedConfigBase#maxStackTraceSamplesPerTransaction() maxStackTraceSamplesPerTransaction}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for maxStackTraceSamplesPerTransaction
   * @return modified copy of the {@code this} object
   */
  public final AdvancedConfig withMaxStackTraceSamplesPerTransaction(int value) {
    if (this.maxStackTraceSamplesPerTransaction == value) {
      return this;
    }
    int newValue = value;
    return new AdvancedConfig(
        this.timerWrapperMethods,
        this.weavingTimer,
        this.immediatePartialStoreThresholdSeconds,
        this.maxAggregateTransactionsPerTransactionType,
        this.maxAggregateQueriesPerQueryType,
        this.maxTraceEntriesPerTransaction,
        newValue,
        this.captureThreadInfo,
        this.captureGcInfo,
        this.mbeanGaugeNotFoundDelaySeconds,
        this.internalQueryTimeoutSeconds);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AdvancedConfigBase#captureThreadInfo() captureThreadInfo}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for captureThreadInfo
   * @return modified copy of the {@code this} object
   */
  public final AdvancedConfig withCaptureThreadInfo(boolean value) {
    if (this.captureThreadInfo == value) {
      return this;
    }
    boolean newValue = value;
    return new AdvancedConfig(
        this.timerWrapperMethods,
        this.weavingTimer,
        this.immediatePartialStoreThresholdSeconds,
        this.maxAggregateTransactionsPerTransactionType,
        this.maxAggregateQueriesPerQueryType,
        this.maxTraceEntriesPerTransaction,
        this.maxStackTraceSamplesPerTransaction,
        newValue,
        this.captureGcInfo,
        this.mbeanGaugeNotFoundDelaySeconds,
        this.internalQueryTimeoutSeconds);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AdvancedConfigBase#captureGcInfo() captureGcInfo}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for captureGcInfo
   * @return modified copy of the {@code this} object
   */
  public final AdvancedConfig withCaptureGcInfo(boolean value) {
    if (this.captureGcInfo == value) {
      return this;
    }
    boolean newValue = value;
    return new AdvancedConfig(
        this.timerWrapperMethods,
        this.weavingTimer,
        this.immediatePartialStoreThresholdSeconds,
        this.maxAggregateTransactionsPerTransactionType,
        this.maxAggregateQueriesPerQueryType,
        this.maxTraceEntriesPerTransaction,
        this.maxStackTraceSamplesPerTransaction,
        this.captureThreadInfo,
        newValue,
        this.mbeanGaugeNotFoundDelaySeconds,
        this.internalQueryTimeoutSeconds);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AdvancedConfigBase#mbeanGaugeNotFoundDelaySeconds() mbeanGaugeNotFoundDelaySeconds}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for mbeanGaugeNotFoundDelaySeconds
   * @return modified copy of the {@code this} object
   */
  public final AdvancedConfig withMbeanGaugeNotFoundDelaySeconds(int value) {
    if (this.mbeanGaugeNotFoundDelaySeconds == value) {
      return this;
    }
    int newValue = value;
    return new AdvancedConfig(
        this.timerWrapperMethods,
        this.weavingTimer,
        this.immediatePartialStoreThresholdSeconds,
        this.maxAggregateTransactionsPerTransactionType,
        this.maxAggregateQueriesPerQueryType,
        this.maxTraceEntriesPerTransaction,
        this.maxStackTraceSamplesPerTransaction,
        this.captureThreadInfo,
        this.captureGcInfo,
        newValue,
        this.internalQueryTimeoutSeconds);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AdvancedConfigBase#internalQueryTimeoutSeconds() internalQueryTimeoutSeconds}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for internalQueryTimeoutSeconds
   * @return modified copy of the {@code this} object
   */
  public final AdvancedConfig withInternalQueryTimeoutSeconds(int value) {
    if (this.internalQueryTimeoutSeconds == value) {
      return this;
    }
    int newValue = value;
    return new AdvancedConfig(
        this.timerWrapperMethods,
        this.weavingTimer,
        this.immediatePartialStoreThresholdSeconds,
        this.maxAggregateTransactionsPerTransactionType,
        this.maxAggregateQueriesPerQueryType,
        this.maxTraceEntriesPerTransaction,
        this.maxStackTraceSamplesPerTransaction,
        this.captureThreadInfo,
        this.captureGcInfo,
        this.mbeanGaugeNotFoundDelaySeconds,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code AdvancedConfig} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof AdvancedConfig && equalTo((AdvancedConfig) another));
  }
  
  private boolean equalTo(AdvancedConfig another) {
    return timerWrapperMethods == another.timerWrapperMethods
        && weavingTimer == another.weavingTimer
        && immediatePartialStoreThresholdSeconds == another.immediatePartialStoreThresholdSeconds
        && maxAggregateTransactionsPerTransactionType == another.maxAggregateTransactionsPerTransactionType
        && maxAggregateQueriesPerQueryType == another.maxAggregateQueriesPerQueryType
        && maxTraceEntriesPerTransaction == another.maxTraceEntriesPerTransaction
        && maxStackTraceSamplesPerTransaction == another.maxStackTraceSamplesPerTransaction
        && captureThreadInfo == another.captureThreadInfo
        && captureGcInfo == another.captureGcInfo
        && mbeanGaugeNotFoundDelaySeconds == another.mbeanGaugeNotFoundDelaySeconds
        && internalQueryTimeoutSeconds == another.internalQueryTimeoutSeconds
        && version.equals(another.version);
  }
  
  /**
   * Computes hash code from attributes: {@code timerWrapperMethods}, {@code weavingTimer}, {@code immediatePartialStoreThresholdSeconds}, {@code maxAggregateTransactionsPerTransactionType}, {@code maxAggregateQueriesPerQueryType}, {@code maxTraceEntriesPerTransaction}, {@code maxStackTraceSamplesPerTransaction}, {@code captureThreadInfo}, {@code captureGcInfo}, {@code mbeanGaugeNotFoundDelaySeconds}, {@code internalQueryTimeoutSeconds}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Booleans.hashCode(timerWrapperMethods);
    h = h * 17 + Booleans.hashCode(weavingTimer);
    h = h * 17 + immediatePartialStoreThresholdSeconds;
    h = h * 17 + maxAggregateTransactionsPerTransactionType;
    h = h * 17 + maxAggregateQueriesPerQueryType;
    h = h * 17 + maxTraceEntriesPerTransaction;
    h = h * 17 + maxStackTraceSamplesPerTransaction;
    h = h * 17 + Booleans.hashCode(captureThreadInfo);
    h = h * 17 + Booleans.hashCode(captureGcInfo);
    h = h * 17 + mbeanGaugeNotFoundDelaySeconds;
    h = h * 17 + internalQueryTimeoutSeconds;
    h = h * 17 + version.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code AdvancedConfig{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AdvancedConfig")
        .add("timerWrapperMethods", timerWrapperMethods)
        .add("weavingTimer", weavingTimer)
        .add("immediatePartialStoreThresholdSeconds", immediatePartialStoreThresholdSeconds)
        .add("maxAggregateTransactionsPerTransactionType", maxAggregateTransactionsPerTransactionType)
        .add("maxAggregateQueriesPerQueryType", maxAggregateQueriesPerQueryType)
        .add("maxTraceEntriesPerTransaction", maxTraceEntriesPerTransaction)
        .add("maxStackTraceSamplesPerTransaction", maxStackTraceSamplesPerTransaction)
        .add("captureThreadInfo", captureThreadInfo)
        .add("captureGcInfo", captureGcInfo)
        .add("mbeanGaugeNotFoundDelaySeconds", mbeanGaugeNotFoundDelaySeconds)
        .add("internalQueryTimeoutSeconds", internalQueryTimeoutSeconds)
        .add("version", version)
        .toString();
  }
  
  @JsonCreator
  public static AdvancedConfig fromAllAttributes(
      @JsonProperty("timerWrapperMethods") @Nullable Boolean timerWrapperMethods,
      @JsonProperty("weavingTimer") @Nullable Boolean weavingTimer,
      @JsonProperty("immediatePartialStoreThresholdSeconds") @Nullable Integer immediatePartialStoreThresholdSeconds,
      @JsonProperty("maxAggregateTransactionsPerTransactionType") @Nullable Integer maxAggregateTransactionsPerTransactionType,
      @JsonProperty("maxAggregateQueriesPerQueryType") @Nullable Integer maxAggregateQueriesPerQueryType,
      @JsonProperty("maxTraceEntriesPerTransaction") @Nullable Integer maxTraceEntriesPerTransaction,
      @JsonProperty("maxStackTraceSamplesPerTransaction") @Nullable Integer maxStackTraceSamplesPerTransaction,
      @JsonProperty("captureThreadInfo") @Nullable Boolean captureThreadInfo,
      @JsonProperty("captureGcInfo") @Nullable Boolean captureGcInfo,
      @JsonProperty("mbeanGaugeNotFoundDelaySeconds") @Nullable Integer mbeanGaugeNotFoundDelaySeconds,
      @JsonProperty("internalQueryTimeoutSeconds") @Nullable Integer internalQueryTimeoutSeconds) {
    AdvancedConfig.Builder builder = AdvancedConfig.builder();
    if (timerWrapperMethods != null) {
      builder.timerWrapperMethods(timerWrapperMethods);
    }
    if (weavingTimer != null) {
      builder.weavingTimer(weavingTimer);
    }
    if (immediatePartialStoreThresholdSeconds != null) {
      builder.immediatePartialStoreThresholdSeconds(immediatePartialStoreThresholdSeconds);
    }
    if (maxAggregateTransactionsPerTransactionType != null) {
      builder.maxAggregateTransactionsPerTransactionType(maxAggregateTransactionsPerTransactionType);
    }
    if (maxAggregateQueriesPerQueryType != null) {
      builder.maxAggregateQueriesPerQueryType(maxAggregateQueriesPerQueryType);
    }
    if (maxTraceEntriesPerTransaction != null) {
      builder.maxTraceEntriesPerTransaction(maxTraceEntriesPerTransaction);
    }
    if (maxStackTraceSamplesPerTransaction != null) {
      builder.maxStackTraceSamplesPerTransaction(maxStackTraceSamplesPerTransaction);
    }
    if (captureThreadInfo != null) {
      builder.captureThreadInfo(captureThreadInfo);
    }
    if (captureGcInfo != null) {
      builder.captureGcInfo(captureGcInfo);
    }
    if (mbeanGaugeNotFoundDelaySeconds != null) {
      builder.mbeanGaugeNotFoundDelaySeconds(mbeanGaugeNotFoundDelaySeconds);
    }
    if (internalQueryTimeoutSeconds != null) {
      builder.internalQueryTimeoutSeconds(internalQueryTimeoutSeconds);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link AdvancedConfigBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable AdvancedConfig instance
   */
  public static AdvancedConfig copyOf(AdvancedConfigBase instance) {
    if (instance instanceof AdvancedConfig) {
      return (AdvancedConfig) instance;
    }
    return AdvancedConfig.builder()
        .timerWrapperMethods(instance.timerWrapperMethods())
        .weavingTimer(instance.weavingTimer())
        .immediatePartialStoreThresholdSeconds(instance.immediatePartialStoreThresholdSeconds())
        .maxAggregateTransactionsPerTransactionType(instance.maxAggregateTransactionsPerTransactionType())
        .maxAggregateQueriesPerQueryType(instance.maxAggregateQueriesPerQueryType())
        .maxTraceEntriesPerTransaction(instance.maxTraceEntriesPerTransaction())
        .maxStackTraceSamplesPerTransaction(instance.maxStackTraceSamplesPerTransaction())
        .captureThreadInfo(instance.captureThreadInfo())
        .captureGcInfo(instance.captureGcInfo())
        .mbeanGaugeNotFoundDelaySeconds(instance.mbeanGaugeNotFoundDelaySeconds())
        .internalQueryTimeoutSeconds(instance.internalQueryTimeoutSeconds())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.config.AdvancedConfig}.
   * @return new AdvancedConfig builder
   */
  public static AdvancedConfig.Builder builder() {
    return new AdvancedConfig.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.config.AdvancedConfig}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long NONDEFAULT_BIT_TIMER_WRAPPER_METHODS = 0x1L;
    private static final long NONDEFAULT_BIT_WEAVING_TIMER = 0x2L;
    private static final long NONDEFAULT_BIT_IMMEDIATE_PARTIAL_STORE_THRESHOLD_SECONDS = 0x4L;
    private static final long NONDEFAULT_BIT_MAX_AGGREGATE_TRANSACTIONS_PER_TRANSACTION_TYPE = 0x8L;
    private static final long NONDEFAULT_BIT_MAX_AGGREGATE_QUERIES_PER_QUERY_TYPE = 0x10L;
    private static final long NONDEFAULT_BIT_MAX_TRACE_ENTRIES_PER_TRANSACTION = 0x20L;
    private static final long NONDEFAULT_BIT_MAX_STACK_TRACE_SAMPLES_PER_TRANSACTION = 0x40L;
    private static final long NONDEFAULT_BIT_CAPTURE_THREAD_INFO = 0x80L;
    private static final long NONDEFAULT_BIT_CAPTURE_GC_INFO = 0x100L;
    private static final long NONDEFAULT_BIT_MBEAN_GAUGE_NOT_FOUND_DELAY_SECONDS = 0x200L;
    private static final long NONDEFAULT_BIT_INTERNAL_QUERY_TIMEOUT_SECONDS = 0x400L;
    private long nondefaultBitset;
  
    private boolean timerWrapperMethods;
    private boolean weavingTimer;
    private int immediatePartialStoreThresholdSeconds;
    private int maxAggregateTransactionsPerTransactionType;
    private int maxAggregateQueriesPerQueryType;
    private int maxTraceEntriesPerTransaction;
    private int maxStackTraceSamplesPerTransaction;
    private boolean captureThreadInfo;
    private boolean captureGcInfo;
    private int mbeanGaugeNotFoundDelaySeconds;
    private int internalQueryTimeoutSeconds;
    private Builder() {}
  
    /**
     * Initializes value for {@link AdvancedConfigBase#timerWrapperMethods() timerWrapperMethods}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link AdvancedConfigBase#timerWrapperMethods() timerWrapperMethods}.</em>
     * @param timerWrapperMethods value for timerWrapperMethods
     * @return {@code this} builder for chained invocation
     */
    public final Builder timerWrapperMethods(boolean timerWrapperMethods) {
      checkNotIsSet(timerWrapperMethodsIsSet(), "timerWrapperMethods");
      this.timerWrapperMethods = timerWrapperMethods;
      nondefaultBitset |= NONDEFAULT_BIT_TIMER_WRAPPER_METHODS;
      return this;
    }
  
    /**
     * Initializes value for {@link AdvancedConfigBase#weavingTimer() weavingTimer}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link AdvancedConfigBase#weavingTimer() weavingTimer}.</em>
     * @param weavingTimer value for weavingTimer
     * @return {@code this} builder for chained invocation
     */
    public final Builder weavingTimer(boolean weavingTimer) {
      checkNotIsSet(weavingTimerIsSet(), "weavingTimer");
      this.weavingTimer = weavingTimer;
      nondefaultBitset |= NONDEFAULT_BIT_WEAVING_TIMER;
      return this;
    }
  
    /**
     * Initializes value for {@link AdvancedConfigBase#immediatePartialStoreThresholdSeconds() immediatePartialStoreThresholdSeconds}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link AdvancedConfigBase#immediatePartialStoreThresholdSeconds() immediatePartialStoreThresholdSeconds}.</em>
     * @param immediatePartialStoreThresholdSeconds value for immediatePartialStoreThresholdSeconds
     * @return {@code this} builder for chained invocation
     */
    public final Builder immediatePartialStoreThresholdSeconds(int immediatePartialStoreThresholdSeconds) {
      checkNotIsSet(immediatePartialStoreThresholdSecondsIsSet(), "immediatePartialStoreThresholdSeconds");
      this.immediatePartialStoreThresholdSeconds = immediatePartialStoreThresholdSeconds;
      nondefaultBitset |= NONDEFAULT_BIT_IMMEDIATE_PARTIAL_STORE_THRESHOLD_SECONDS;
      return this;
    }
  
    /**
     * Initializes value for {@link AdvancedConfigBase#maxAggregateTransactionsPerTransactionType() maxAggregateTransactionsPerTransactionType}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link AdvancedConfigBase#maxAggregateTransactionsPerTransactionType() maxAggregateTransactionsPerTransactionType}.</em>
     * @param maxAggregateTransactionsPerTransactionType value for maxAggregateTransactionsPerTransactionType
     * @return {@code this} builder for chained invocation
     */
    public final Builder maxAggregateTransactionsPerTransactionType(int maxAggregateTransactionsPerTransactionType) {
      checkNotIsSet(maxAggregateTransactionsPerTransactionTypeIsSet(), "maxAggregateTransactionsPerTransactionType");
      this.maxAggregateTransactionsPerTransactionType = maxAggregateTransactionsPerTransactionType;
      nondefaultBitset |= NONDEFAULT_BIT_MAX_AGGREGATE_TRANSACTIONS_PER_TRANSACTION_TYPE;
      return this;
    }
  
    /**
     * Initializes value for {@link AdvancedConfigBase#maxAggregateQueriesPerQueryType() maxAggregateQueriesPerQueryType}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link AdvancedConfigBase#maxAggregateQueriesPerQueryType() maxAggregateQueriesPerQueryType}.</em>
     * @param maxAggregateQueriesPerQueryType value for maxAggregateQueriesPerQueryType
     * @return {@code this} builder for chained invocation
     */
    public final Builder maxAggregateQueriesPerQueryType(int maxAggregateQueriesPerQueryType) {
      checkNotIsSet(maxAggregateQueriesPerQueryTypeIsSet(), "maxAggregateQueriesPerQueryType");
      this.maxAggregateQueriesPerQueryType = maxAggregateQueriesPerQueryType;
      nondefaultBitset |= NONDEFAULT_BIT_MAX_AGGREGATE_QUERIES_PER_QUERY_TYPE;
      return this;
    }
  
    /**
     * Initializes value for {@link AdvancedConfigBase#maxTraceEntriesPerTransaction() maxTraceEntriesPerTransaction}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link AdvancedConfigBase#maxTraceEntriesPerTransaction() maxTraceEntriesPerTransaction}.</em>
     * @param maxTraceEntriesPerTransaction value for maxTraceEntriesPerTransaction
     * @return {@code this} builder for chained invocation
     */
    public final Builder maxTraceEntriesPerTransaction(int maxTraceEntriesPerTransaction) {
      checkNotIsSet(maxTraceEntriesPerTransactionIsSet(), "maxTraceEntriesPerTransaction");
      this.maxTraceEntriesPerTransaction = maxTraceEntriesPerTransaction;
      nondefaultBitset |= NONDEFAULT_BIT_MAX_TRACE_ENTRIES_PER_TRANSACTION;
      return this;
    }
  
    /**
     * Initializes value for {@link AdvancedConfigBase#maxStackTraceSamplesPerTransaction() maxStackTraceSamplesPerTransaction}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link AdvancedConfigBase#maxStackTraceSamplesPerTransaction() maxStackTraceSamplesPerTransaction}.</em>
     * @param maxStackTraceSamplesPerTransaction value for maxStackTraceSamplesPerTransaction
     * @return {@code this} builder for chained invocation
     */
    public final Builder maxStackTraceSamplesPerTransaction(int maxStackTraceSamplesPerTransaction) {
      checkNotIsSet(maxStackTraceSamplesPerTransactionIsSet(), "maxStackTraceSamplesPerTransaction");
      this.maxStackTraceSamplesPerTransaction = maxStackTraceSamplesPerTransaction;
      nondefaultBitset |= NONDEFAULT_BIT_MAX_STACK_TRACE_SAMPLES_PER_TRANSACTION;
      return this;
    }
  
    /**
     * Initializes value for {@link AdvancedConfigBase#captureThreadInfo() captureThreadInfo}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link AdvancedConfigBase#captureThreadInfo() captureThreadInfo}.</em>
     * @param captureThreadInfo value for captureThreadInfo
     * @return {@code this} builder for chained invocation
     */
    public final Builder captureThreadInfo(boolean captureThreadInfo) {
      checkNotIsSet(captureThreadInfoIsSet(), "captureThreadInfo");
      this.captureThreadInfo = captureThreadInfo;
      nondefaultBitset |= NONDEFAULT_BIT_CAPTURE_THREAD_INFO;
      return this;
    }
  
    /**
     * Initializes value for {@link AdvancedConfigBase#captureGcInfo() captureGcInfo}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link AdvancedConfigBase#captureGcInfo() captureGcInfo}.</em>
     * @param captureGcInfo value for captureGcInfo
     * @return {@code this} builder for chained invocation
     */
    public final Builder captureGcInfo(boolean captureGcInfo) {
      checkNotIsSet(captureGcInfoIsSet(), "captureGcInfo");
      this.captureGcInfo = captureGcInfo;
      nondefaultBitset |= NONDEFAULT_BIT_CAPTURE_GC_INFO;
      return this;
    }
  
    /**
     * Initializes value for {@link AdvancedConfigBase#mbeanGaugeNotFoundDelaySeconds() mbeanGaugeNotFoundDelaySeconds}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link AdvancedConfigBase#mbeanGaugeNotFoundDelaySeconds() mbeanGaugeNotFoundDelaySeconds}.</em>
     * @param mbeanGaugeNotFoundDelaySeconds value for mbeanGaugeNotFoundDelaySeconds
     * @return {@code this} builder for chained invocation
     */
    public final Builder mbeanGaugeNotFoundDelaySeconds(int mbeanGaugeNotFoundDelaySeconds) {
      checkNotIsSet(mbeanGaugeNotFoundDelaySecondsIsSet(), "mbeanGaugeNotFoundDelaySeconds");
      this.mbeanGaugeNotFoundDelaySeconds = mbeanGaugeNotFoundDelaySeconds;
      nondefaultBitset |= NONDEFAULT_BIT_MBEAN_GAUGE_NOT_FOUND_DELAY_SECONDS;
      return this;
    }
  
    /**
     * Initializes value for {@link AdvancedConfigBase#internalQueryTimeoutSeconds() internalQueryTimeoutSeconds}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link AdvancedConfigBase#internalQueryTimeoutSeconds() internalQueryTimeoutSeconds}.</em>
     * @param internalQueryTimeoutSeconds value for internalQueryTimeoutSeconds
     * @return {@code this} builder for chained invocation
     */
    public final Builder internalQueryTimeoutSeconds(int internalQueryTimeoutSeconds) {
      checkNotIsSet(internalQueryTimeoutSecondsIsSet(), "internalQueryTimeoutSeconds");
      this.internalQueryTimeoutSeconds = internalQueryTimeoutSeconds;
      nondefaultBitset |= NONDEFAULT_BIT_INTERNAL_QUERY_TIMEOUT_SECONDS;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.config.AdvancedConfig}.
     * @return immutable instance of AdvancedConfig
     */
    public AdvancedConfig build() {
      return new AdvancedConfig(this);
    }
  
    private boolean timerWrapperMethodsIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TIMER_WRAPPER_METHODS) != 0;
    }
  
    private boolean weavingTimerIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_WEAVING_TIMER) != 0;
    }
  
    private boolean immediatePartialStoreThresholdSecondsIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_IMMEDIATE_PARTIAL_STORE_THRESHOLD_SECONDS) != 0;
    }
  
    private boolean maxAggregateTransactionsPerTransactionTypeIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_MAX_AGGREGATE_TRANSACTIONS_PER_TRANSACTION_TYPE) != 0;
    }
  
    private boolean maxAggregateQueriesPerQueryTypeIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_MAX_AGGREGATE_QUERIES_PER_QUERY_TYPE) != 0;
    }
  
    private boolean maxTraceEntriesPerTransactionIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_MAX_TRACE_ENTRIES_PER_TRANSACTION) != 0;
    }
  
    private boolean maxStackTraceSamplesPerTransactionIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_MAX_STACK_TRACE_SAMPLES_PER_TRANSACTION) != 0;
    }
  
    private boolean captureThreadInfoIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_CAPTURE_THREAD_INFO) != 0;
    }
  
    private boolean captureGcInfoIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_CAPTURE_GC_INFO) != 0;
    }
  
    private boolean mbeanGaugeNotFoundDelaySecondsIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_MBEAN_GAUGE_NOT_FOUND_DELAY_SECONDS) != 0;
    }
  
    private boolean internalQueryTimeoutSecondsIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_INTERNAL_QUERY_TIMEOUT_SECONDS) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of AdvancedConfig is strict, attribute is already set: ".concat(name));
      }
    }
  }
}
