package org.glowroot.config;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.ImmutableMap;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.api.weaving.MethodModifier;

/**
 * Immutable implementation of {@link InstrumentationConfigBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code InstrumentationConfig.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "InstrumentationConfigBase"})
@Immutable
public final class InstrumentationConfig extends InstrumentationConfigBase {
  private final String className;
  private final String methodName;
  private final ImmutableList<String> methodParameterTypes;
  private final String methodReturnType;
  private final ImmutableList<MethodModifier> methodModifiers;
  private final CaptureKind captureKind;
  private final String timerName;
  private final String traceEntryTemplate;
  private final @Nullable Long traceEntryStackThresholdMillis;
  private final boolean traceEntryCaptureSelfNested;
  private final String transactionType;
  private final String transactionNameTemplate;
  private final String transactionUserTemplate;
  private final ImmutableMap<String, String> transactionCustomAttributeTemplates;
  private final @Nullable Long traceStoreThresholdMillis;
  private final String enabledProperty;
  private final String traceEntryEnabledProperty;
  private final String version;
  private final boolean isTimerOrGreater;
  private final boolean isTraceEntryOrGreater;
  private final boolean isTransaction;
  private final ImmutableList<String> validationErrors;

  private InstrumentationConfig(InstrumentationConfig.Builder builder) {
    this.className = builder.className;
    this.methodName = builder.methodName;
    this.methodParameterTypes = builder.methodParameterTypesBuilder.build();
    this.methodModifiers = builder.methodModifiersBuilder.build();
    this.captureKind = builder.captureKind;
    this.traceEntryStackThresholdMillis = builder.traceEntryStackThresholdMillis;
    this.transactionCustomAttributeTemplates = builder.transactionCustomAttributeTemplatesBuilder.build();
    this.traceStoreThresholdMillis = builder.traceStoreThresholdMillis;
    this.methodReturnType = builder.methodReturnType != null
        ? builder.methodReturnType
        : Preconditions.checkNotNull(super.methodReturnType());
    this.timerName = builder.timerName != null
        ? builder.timerName
        : Preconditions.checkNotNull(super.timerName());
    this.traceEntryTemplate = builder.traceEntryTemplate != null
        ? builder.traceEntryTemplate
        : Preconditions.checkNotNull(super.traceEntryTemplate());
    this.traceEntryCaptureSelfNested = builder.traceEntryCaptureSelfNestedIsSet()
        ? builder.traceEntryCaptureSelfNested
        : super.traceEntryCaptureSelfNested();
    this.transactionType = builder.transactionType != null
        ? builder.transactionType
        : Preconditions.checkNotNull(super.transactionType());
    this.transactionNameTemplate = builder.transactionNameTemplate != null
        ? builder.transactionNameTemplate
        : Preconditions.checkNotNull(super.transactionNameTemplate());
    this.transactionUserTemplate = builder.transactionUserTemplate != null
        ? builder.transactionUserTemplate
        : Preconditions.checkNotNull(super.transactionUserTemplate());
    this.enabledProperty = builder.enabledProperty != null
        ? builder.enabledProperty
        : Preconditions.checkNotNull(super.enabledProperty());
    this.traceEntryEnabledProperty = builder.traceEntryEnabledProperty != null
        ? builder.traceEntryEnabledProperty
        : Preconditions.checkNotNull(super.traceEntryEnabledProperty());
    this.version = Preconditions.checkNotNull(super.version());
    this.isTimerOrGreater = super.isTimerOrGreater();
    this.isTraceEntryOrGreater = super.isTraceEntryOrGreater();
    this.isTransaction = super.isTransaction();
    this.validationErrors = Preconditions.checkNotNull(super.validationErrors());
  }

  private InstrumentationConfig(
      String className,
      String methodName,
      ImmutableList<String> methodParameterTypes,
      String methodReturnType,
      ImmutableList<MethodModifier> methodModifiers,
      CaptureKind captureKind,
      String timerName,
      String traceEntryTemplate,
      @Nullable Long traceEntryStackThresholdMillis,
      boolean traceEntryCaptureSelfNested,
      String transactionType,
      String transactionNameTemplate,
      String transactionUserTemplate,
      ImmutableMap<String, String> transactionCustomAttributeTemplates,
      @Nullable Long traceStoreThresholdMillis,
      String enabledProperty,
      String traceEntryEnabledProperty) {
    this.className = className;
    this.methodName = methodName;
    this.methodParameterTypes = methodParameterTypes;
    this.methodReturnType = methodReturnType;
    this.methodModifiers = methodModifiers;
    this.captureKind = captureKind;
    this.timerName = timerName;
    this.traceEntryTemplate = traceEntryTemplate;
    this.traceEntryStackThresholdMillis = traceEntryStackThresholdMillis;
    this.traceEntryCaptureSelfNested = traceEntryCaptureSelfNested;
    this.transactionType = transactionType;
    this.transactionNameTemplate = transactionNameTemplate;
    this.transactionUserTemplate = transactionUserTemplate;
    this.transactionCustomAttributeTemplates = transactionCustomAttributeTemplates;
    this.traceStoreThresholdMillis = traceStoreThresholdMillis;
    this.enabledProperty = enabledProperty;
    this.traceEntryEnabledProperty = traceEntryEnabledProperty;
    this.version = Preconditions.checkNotNull(super.version());
    this.isTimerOrGreater = super.isTimerOrGreater();
    this.isTraceEntryOrGreater = super.isTraceEntryOrGreater();
    this.isTransaction = super.isTransaction();
    this.validationErrors = Preconditions.checkNotNull(super.validationErrors());
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code className} attribute
   */
  @JsonProperty("className")
  @Override
  public String className() {
    return className;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code methodName} attribute
   */
  @JsonProperty("methodName")
  @Override
  public String methodName() {
    return methodName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code methodParameterTypes} attribute
   */
  @JsonProperty("methodParameterTypes")
  @Override
  public ImmutableList<String> methodParameterTypes() {
    return methodParameterTypes;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code methodReturnType} attribute
   */
  @JsonProperty("methodReturnType")
  @Override
  public String methodReturnType() {
    return methodReturnType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code methodModifiers} attribute
   */
  @JsonProperty("methodModifiers")
  @Override
  public ImmutableList<MethodModifier> methodModifiers() {
    return methodModifiers;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code captureKind} attribute
   */
  @JsonProperty("captureKind")
  @Override
  public CaptureKind captureKind() {
    return captureKind;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code timerName} attribute
   */
  @JsonProperty("timerName")
  @Override
  public String timerName() {
    return timerName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code traceEntryTemplate} attribute
   */
  @JsonProperty("traceEntryTemplate")
  @Override
  public String traceEntryTemplate() {
    return traceEntryTemplate;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code traceEntryStackThresholdMillis} attribute
   */
  @JsonProperty("traceEntryStackThresholdMillis")
  @Override
  public Long traceEntryStackThresholdMillis() {
    return traceEntryStackThresholdMillis;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code traceEntryCaptureSelfNested} attribute
   */
  @JsonProperty("traceEntryCaptureSelfNested")
  @Override
  public boolean traceEntryCaptureSelfNested() {
    return traceEntryCaptureSelfNested;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionType} attribute
   */
  @JsonProperty("transactionType")
  @Override
  public String transactionType() {
    return transactionType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionNameTemplate} attribute
   */
  @JsonProperty("transactionNameTemplate")
  @Override
  public String transactionNameTemplate() {
    return transactionNameTemplate;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionUserTemplate} attribute
   */
  @JsonProperty("transactionUserTemplate")
  @Override
  public String transactionUserTemplate() {
    return transactionUserTemplate;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionCustomAttributeTemplates} attribute
   */
  @JsonProperty("transactionCustomAttributeTemplates")
  @Override
  public ImmutableMap<String, String> transactionCustomAttributeTemplates() {
    return transactionCustomAttributeTemplates;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code traceStoreThresholdMillis} attribute
   */
  @JsonProperty("traceStoreThresholdMillis")
  @Override
  public Long traceStoreThresholdMillis() {
    return traceStoreThresholdMillis;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code enabledProperty} attribute
   */
  @JsonProperty("enabledProperty")
  @Override
  public String enabledProperty() {
    return enabledProperty;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code traceEntryEnabledProperty} attribute
   */
  @JsonProperty("traceEntryEnabledProperty")
  @Override
  public String traceEntryEnabledProperty() {
    return traceEntryEnabledProperty;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code version} attribute
   */
  @JsonIgnore
  @JsonProperty("version")
  @Override
  public String version() {
    return version;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code isTimerOrGreater} attribute
   */
  @JsonIgnore
  @JsonProperty("isTimerOrGreater")
  @Override
  public boolean isTimerOrGreater() {
    return isTimerOrGreater;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code isTraceEntryOrGreater} attribute
   */
  @JsonIgnore
  @JsonProperty("isTraceEntryOrGreater")
  @Override
  public boolean isTraceEntryOrGreater() {
    return isTraceEntryOrGreater;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code isTransaction} attribute
   */
  @JsonIgnore
  @JsonProperty("isTransaction")
  @Override
  public boolean isTransaction() {
    return isTransaction;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code validationErrors} attribute
   */
  @JsonIgnore
  @JsonProperty("validationErrors")
  @Override
  public ImmutableList<String> validationErrors() {
    return validationErrors;
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationConfigBase#className() className}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for className
   * @return modified copy of the {@code this} object
   */
  public final InstrumentationConfig withClassName(String value) {
    if (this.className == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new InstrumentationConfig(
        newValue,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty);
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationConfigBase#methodName() methodName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for methodName
   * @return modified copy of the {@code this} object
   */
  public final InstrumentationConfig withMethodName(String value) {
    if (this.methodName == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new InstrumentationConfig(
        this.className,
        newValue,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link InstrumentationConfigBase#methodParameterTypes() methodParameterTypes}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfig withMethodParameterTypes(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new InstrumentationConfig(
        this.className,
        this.methodName,
        newValue,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link InstrumentationConfigBase#methodParameterTypes() methodParameterTypes}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of methodParameterTypes elements to set
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfig withMethodParameterTypes(Iterable<String> elements) {
    if (this.methodParameterTypes == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new InstrumentationConfig(
        this.className,
        this.methodName,
        newValue,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty);
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationConfigBase#methodReturnType() methodReturnType}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for methodReturnType
   * @return modified copy of the {@code this} object
   */
  public final InstrumentationConfig withMethodReturnType(String value) {
    if (this.methodReturnType == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new InstrumentationConfig(
        this.className,
        this.methodName,
        this.methodParameterTypes,
        newValue,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link InstrumentationConfigBase#methodModifiers() methodModifiers}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfig withMethodModifiers(MethodModifier... elements) {
    ImmutableList<MethodModifier> newValue = ImmutableList.copyOf(elements);
    return new InstrumentationConfig(
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        newValue,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link InstrumentationConfigBase#methodModifiers() methodModifiers}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of methodModifiers elements to set
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfig withMethodModifiers(Iterable<? extends MethodModifier> elements) {
    if (this.methodModifiers == elements) {
      return this;
    }
    ImmutableList<MethodModifier> newValue = ImmutableList.copyOf(elements);
    return new InstrumentationConfig(
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        newValue,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty);
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationConfigBase#captureKind() captureKind}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for captureKind
   * @return modified copy of the {@code this} object
   */
  public final InstrumentationConfig withCaptureKind(CaptureKind value) {
    if (this.captureKind == value) {
      return this;
    }
    CaptureKind newValue = Preconditions.checkNotNull(value);
    return new InstrumentationConfig(
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        newValue,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty);
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationConfigBase#timerName() timerName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for timerName
   * @return modified copy of the {@code this} object
   */
  public final InstrumentationConfig withTimerName(String value) {
    if (this.timerName == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new InstrumentationConfig(
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        newValue,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty);
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationConfigBase#traceEntryTemplate() traceEntryTemplate}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for traceEntryTemplate
   * @return modified copy of the {@code this} object
   */
  public final InstrumentationConfig withTraceEntryTemplate(String value) {
    if (this.traceEntryTemplate == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new InstrumentationConfig(
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        newValue,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty);
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationConfigBase#traceEntryStackThresholdMillis() traceEntryStackThresholdMillis}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for traceEntryStackThresholdMillis, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final InstrumentationConfig withTraceEntryStackThresholdMillis(@Nullable Long value) {
    if (this.traceEntryStackThresholdMillis == value) {
      return this;
    }
    @Nullable Long newValue = value;
    return new InstrumentationConfig(
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        newValue,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty);
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationConfigBase#traceEntryCaptureSelfNested() traceEntryCaptureSelfNested}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for traceEntryCaptureSelfNested
   * @return modified copy of the {@code this} object
   */
  public final InstrumentationConfig withTraceEntryCaptureSelfNested(boolean value) {
    if (this.traceEntryCaptureSelfNested == value) {
      return this;
    }
    boolean newValue = value;
    return new InstrumentationConfig(
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        newValue,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty);
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationConfigBase#transactionType() transactionType}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transactionType
   * @return modified copy of the {@code this} object
   */
  public final InstrumentationConfig withTransactionType(String value) {
    if (this.transactionType == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new InstrumentationConfig(
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        newValue,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty);
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationConfigBase#transactionNameTemplate() transactionNameTemplate}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transactionNameTemplate
   * @return modified copy of the {@code this} object
   */
  public final InstrumentationConfig withTransactionNameTemplate(String value) {
    if (this.transactionNameTemplate == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new InstrumentationConfig(
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        newValue,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty);
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationConfigBase#transactionUserTemplate() transactionUserTemplate}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transactionUserTemplate
   * @return modified copy of the {@code this} object
   */
  public final InstrumentationConfig withTransactionUserTemplate(String value) {
    if (this.transactionUserTemplate == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new InstrumentationConfig(
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        newValue,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty);
  }
  
  /**
   * Copy current immutable object by replacing {@link InstrumentationConfigBase#transactionCustomAttributeTemplates() transactionCustomAttributeTemplates} map with specified map.
   * Nulls are not permitted as keys or values.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries to be added to transactionCustomAttributeTemplates map
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfig withTransactionCustomAttributeTemplates(Map<String, ? extends String> entries) {
    if (this.transactionCustomAttributeTemplates == entries) {
      return this;
    }
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new InstrumentationConfig(
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        newValue,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty);
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationConfigBase#traceStoreThresholdMillis() traceStoreThresholdMillis}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for traceStoreThresholdMillis, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final InstrumentationConfig withTraceStoreThresholdMillis(@Nullable Long value) {
    if (this.traceStoreThresholdMillis == value) {
      return this;
    }
    @Nullable Long newValue = value;
    return new InstrumentationConfig(
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        newValue,
        this.enabledProperty,
        this.traceEntryEnabledProperty);
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationConfigBase#enabledProperty() enabledProperty}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for enabledProperty
   * @return modified copy of the {@code this} object
   */
  public final InstrumentationConfig withEnabledProperty(String value) {
    if (this.enabledProperty == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new InstrumentationConfig(
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        newValue,
        this.traceEntryEnabledProperty);
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationConfigBase#traceEntryEnabledProperty() traceEntryEnabledProperty}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for traceEntryEnabledProperty
   * @return modified copy of the {@code this} object
   */
  public final InstrumentationConfig withTraceEntryEnabledProperty(String value) {
    if (this.traceEntryEnabledProperty == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new InstrumentationConfig(
        this.className,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.traceStoreThresholdMillis,
        this.enabledProperty,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code InstrumentationConfig} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof InstrumentationConfig && equalTo((InstrumentationConfig) another));
  }
  
  private boolean equalTo(InstrumentationConfig another) {
    return className.equals(another.className)
        && methodName.equals(another.methodName)
        && methodParameterTypes.equals(another.methodParameterTypes)
        && methodReturnType.equals(another.methodReturnType)
        && methodModifiers.equals(another.methodModifiers)
        && captureKind.equals(another.captureKind)
        && timerName.equals(another.timerName)
        && traceEntryTemplate.equals(another.traceEntryTemplate)
        && Objects.equal(traceEntryStackThresholdMillis, another.traceEntryStackThresholdMillis)
        && traceEntryCaptureSelfNested == another.traceEntryCaptureSelfNested
        && transactionType.equals(another.transactionType)
        && transactionNameTemplate.equals(another.transactionNameTemplate)
        && transactionUserTemplate.equals(another.transactionUserTemplate)
        && transactionCustomAttributeTemplates.equals(another.transactionCustomAttributeTemplates)
        && Objects.equal(traceStoreThresholdMillis, another.traceStoreThresholdMillis)
        && enabledProperty.equals(another.enabledProperty)
        && traceEntryEnabledProperty.equals(another.traceEntryEnabledProperty)
        && version.equals(another.version)
        && isTimerOrGreater == another.isTimerOrGreater
        && isTraceEntryOrGreater == another.isTraceEntryOrGreater
        && isTransaction == another.isTransaction
        && validationErrors.equals(another.validationErrors);
  }
  
  /**
   * Computes hash code from attributes: {@code className}, {@code methodName}, {@code methodParameterTypes}, {@code methodReturnType}, {@code methodModifiers}, {@code captureKind}, {@code timerName}, {@code traceEntryTemplate}, {@code traceEntryStackThresholdMillis}, {@code traceEntryCaptureSelfNested}, {@code transactionType}, {@code transactionNameTemplate}, {@code transactionUserTemplate}, {@code transactionCustomAttributeTemplates}, {@code traceStoreThresholdMillis}, {@code enabledProperty}, {@code traceEntryEnabledProperty}, {@code version}, {@code isTimerOrGreater}, {@code isTraceEntryOrGreater}, {@code isTransaction}, {@code validationErrors}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + className.hashCode();
    h = h * 17 + methodName.hashCode();
    h = h * 17 + methodParameterTypes.hashCode();
    h = h * 17 + methodReturnType.hashCode();
    h = h * 17 + methodModifiers.hashCode();
    h = h * 17 + captureKind.hashCode();
    h = h * 17 + timerName.hashCode();
    h = h * 17 + traceEntryTemplate.hashCode();
    h = h * 17 + Objects.hashCode(traceEntryStackThresholdMillis);
    h = h * 17 + Booleans.hashCode(traceEntryCaptureSelfNested);
    h = h * 17 + transactionType.hashCode();
    h = h * 17 + transactionNameTemplate.hashCode();
    h = h * 17 + transactionUserTemplate.hashCode();
    h = h * 17 + transactionCustomAttributeTemplates.hashCode();
    h = h * 17 + Objects.hashCode(traceStoreThresholdMillis);
    h = h * 17 + enabledProperty.hashCode();
    h = h * 17 + traceEntryEnabledProperty.hashCode();
    h = h * 17 + version.hashCode();
    h = h * 17 + Booleans.hashCode(isTimerOrGreater);
    h = h * 17 + Booleans.hashCode(isTraceEntryOrGreater);
    h = h * 17 + Booleans.hashCode(isTransaction);
    h = h * 17 + validationErrors.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code InstrumentationConfig{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("InstrumentationConfig")
        .add("className", className)
        .add("methodName", methodName)
        .add("methodParameterTypes", methodParameterTypes)
        .add("methodReturnType", methodReturnType)
        .add("methodModifiers", methodModifiers)
        .add("captureKind", captureKind)
        .add("timerName", timerName)
        .add("traceEntryTemplate", traceEntryTemplate)
        .add("traceEntryStackThresholdMillis", traceEntryStackThresholdMillis)
        .add("traceEntryCaptureSelfNested", traceEntryCaptureSelfNested)
        .add("transactionType", transactionType)
        .add("transactionNameTemplate", transactionNameTemplate)
        .add("transactionUserTemplate", transactionUserTemplate)
        .add("transactionCustomAttributeTemplates", transactionCustomAttributeTemplates)
        .add("traceStoreThresholdMillis", traceStoreThresholdMillis)
        .add("enabledProperty", enabledProperty)
        .add("traceEntryEnabledProperty", traceEntryEnabledProperty)
        .add("version", version)
        .add("isTimerOrGreater", isTimerOrGreater)
        .add("isTraceEntryOrGreater", isTraceEntryOrGreater)
        .add("isTransaction", isTransaction)
        .add("validationErrors", validationErrors)
        .toString();
  }
  
  @JsonCreator
  public static InstrumentationConfig fromAllAttributes(
      @JsonProperty("className") @Nullable String className,
      @JsonProperty("methodName") @Nullable String methodName,
      @JsonProperty("methodParameterTypes") @Nullable ImmutableList<String> methodParameterTypes,
      @JsonProperty("methodReturnType") @Nullable String methodReturnType,
      @JsonProperty("methodModifiers") @Nullable ImmutableList<MethodModifier> methodModifiers,
      @JsonProperty("captureKind") @Nullable CaptureKind captureKind,
      @JsonProperty("timerName") @Nullable String timerName,
      @JsonProperty("traceEntryTemplate") @Nullable String traceEntryTemplate,
      @JsonProperty("traceEntryStackThresholdMillis") @Nullable Long traceEntryStackThresholdMillis,
      @JsonProperty("traceEntryCaptureSelfNested") @Nullable Boolean traceEntryCaptureSelfNested,
      @JsonProperty("transactionType") @Nullable String transactionType,
      @JsonProperty("transactionNameTemplate") @Nullable String transactionNameTemplate,
      @JsonProperty("transactionUserTemplate") @Nullable String transactionUserTemplate,
      @JsonProperty("transactionCustomAttributeTemplates") @Nullable Map<String, String> transactionCustomAttributeTemplates,
      @JsonProperty("traceStoreThresholdMillis") @Nullable Long traceStoreThresholdMillis,
      @JsonProperty("enabledProperty") @Nullable String enabledProperty,
      @JsonProperty("traceEntryEnabledProperty") @Nullable String traceEntryEnabledProperty) {
    InstrumentationConfig.Builder builder = InstrumentationConfig.builder();
    if (className != null) {
      builder.className(className);
    }
    if (methodName != null) {
      builder.methodName(methodName);
    }
    if (methodParameterTypes != null) {
      builder.addAllMethodParameterTypes(methodParameterTypes);
    }
    if (methodReturnType != null) {
      builder.methodReturnType(methodReturnType);
    }
    if (methodModifiers != null) {
      builder.addAllMethodModifiers(methodModifiers);
    }
    if (captureKind != null) {
      builder.captureKind(captureKind);
    }
    if (timerName != null) {
      builder.timerName(timerName);
    }
    if (traceEntryTemplate != null) {
      builder.traceEntryTemplate(traceEntryTemplate);
    }
    if (traceEntryStackThresholdMillis != null) {
      builder.traceEntryStackThresholdMillis(traceEntryStackThresholdMillis);
    }
    if (traceEntryCaptureSelfNested != null) {
      builder.traceEntryCaptureSelfNested(traceEntryCaptureSelfNested);
    }
    if (transactionType != null) {
      builder.transactionType(transactionType);
    }
    if (transactionNameTemplate != null) {
      builder.transactionNameTemplate(transactionNameTemplate);
    }
    if (transactionUserTemplate != null) {
      builder.transactionUserTemplate(transactionUserTemplate);
    }
    if (transactionCustomAttributeTemplates != null) {
      builder.putAllTransactionCustomAttributeTemplates(transactionCustomAttributeTemplates);
    }
    if (traceStoreThresholdMillis != null) {
      builder.traceStoreThresholdMillis(traceStoreThresholdMillis);
    }
    if (enabledProperty != null) {
      builder.enabledProperty(enabledProperty);
    }
    if (traceEntryEnabledProperty != null) {
      builder.traceEntryEnabledProperty(traceEntryEnabledProperty);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link InstrumentationConfigBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable InstrumentationConfig instance
   */
  public static InstrumentationConfig copyOf(InstrumentationConfigBase instance) {
    if (instance instanceof InstrumentationConfig) {
      return (InstrumentationConfig) instance;
    }
    return InstrumentationConfig.builder()
        .className(instance.className())
        .methodName(instance.methodName())
        .addAllMethodParameterTypes(instance.methodParameterTypes())
        .methodReturnType(instance.methodReturnType())
        .addAllMethodModifiers(instance.methodModifiers())
        .captureKind(instance.captureKind())
        .timerName(instance.timerName())
        .traceEntryTemplate(instance.traceEntryTemplate())
        .traceEntryStackThresholdMillis(instance.traceEntryStackThresholdMillis())
        .traceEntryCaptureSelfNested(instance.traceEntryCaptureSelfNested())
        .transactionType(instance.transactionType())
        .transactionNameTemplate(instance.transactionNameTemplate())
        .transactionUserTemplate(instance.transactionUserTemplate())
        .putAllTransactionCustomAttributeTemplates(instance.transactionCustomAttributeTemplates())
        .traceStoreThresholdMillis(instance.traceStoreThresholdMillis())
        .enabledProperty(instance.enabledProperty())
        .traceEntryEnabledProperty(instance.traceEntryEnabledProperty())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.config.InstrumentationConfig}.
   * @return new InstrumentationConfig builder
   */
  public static InstrumentationConfig.Builder builder() {
    return new InstrumentationConfig.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.config.InstrumentationConfig}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x7;
    private static final long INITIALIZED_BIT_CLASS_NAME = 0x1L;
    private static final long INITIALIZED_BIT_METHOD_NAME = 0x2L;
    private static final long INITIALIZED_BIT_CAPTURE_KIND = 0x4L;
    private static final long NONDEFAULT_BIT_METHOD_RETURN_TYPE = 0x1L;
    private static final long NONDEFAULT_BIT_TIMER_NAME = 0x2L;
    private static final long NONDEFAULT_BIT_TRACE_ENTRY_TEMPLATE = 0x4L;
    private static final long NONDEFAULT_BIT_TRACE_ENTRY_STACK_THRESHOLD_MILLIS = 0x8L;
    private static final long NONDEFAULT_BIT_TRACE_ENTRY_CAPTURE_SELF_NESTED = 0x10L;
    private static final long NONDEFAULT_BIT_TRANSACTION_TYPE = 0x20L;
    private static final long NONDEFAULT_BIT_TRANSACTION_NAME_TEMPLATE = 0x40L;
    private static final long NONDEFAULT_BIT_TRANSACTION_USER_TEMPLATE = 0x80L;
    private static final long NONDEFAULT_BIT_TRACE_STORE_THRESHOLD_MILLIS = 0x100L;
    private static final long NONDEFAULT_BIT_ENABLED_PROPERTY = 0x200L;
    private static final long NONDEFAULT_BIT_TRACE_ENTRY_ENABLED_PROPERTY = 0x400L;
    private long initializedBitset;
    private long nondefaultBitset;
  
    private @Nullable String className;
    private @Nullable String methodName;
    private ImmutableList.Builder<String> methodParameterTypesBuilder = ImmutableList.builder();
    private @Nullable String methodReturnType;
    private ImmutableList.Builder<MethodModifier> methodModifiersBuilder = ImmutableList.builder();
    private @Nullable CaptureKind captureKind;
    private @Nullable String timerName;
    private @Nullable String traceEntryTemplate;
    private @Nullable Long traceEntryStackThresholdMillis;
    private boolean traceEntryCaptureSelfNested;
    private @Nullable String transactionType;
    private @Nullable String transactionNameTemplate;
    private @Nullable String transactionUserTemplate;
    private ImmutableMap.Builder<String, String> transactionCustomAttributeTemplatesBuilder = ImmutableMap.builder();
    private @Nullable Long traceStoreThresholdMillis;
    private @Nullable String enabledProperty;
    private @Nullable String traceEntryEnabledProperty;
    private Builder() {}
  
    /**
     * Initializes value for {@link InstrumentationConfigBase#className() className}.
     * @param className value for className
     * @return {@code this} builder for chained invocation
     */
    public final Builder className(String className) {
      checkNotIsSet(classNameIsSet(), "className");
      this.className = Preconditions.checkNotNull(className);
      initializedBitset |= INITIALIZED_BIT_CLASS_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationConfigBase#methodName() methodName}.
     * @param methodName value for methodName
     * @return {@code this} builder for chained invocation
     */
    public final Builder methodName(String methodName) {
      checkNotIsSet(methodNameIsSet(), "methodName");
      this.methodName = Preconditions.checkNotNull(methodName);
      initializedBitset |= INITIALIZED_BIT_METHOD_NAME;
      return this;
    }
  
    /**
     * Adds one element to {@link InstrumentationConfigBase#methodParameterTypes() methodParameterTypes} list.
     * @param element methodParameterTypes element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addMethodParameterTypes(String element) {
      methodParameterTypesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link InstrumentationConfigBase#methodParameterTypes() methodParameterTypes} list.
     * @param elements array of methodParameterTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addMethodParameterTypes(String... elements) {
      methodParameterTypesBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link InstrumentationConfigBase#methodParameterTypes() methodParameterTypes} list.
     * @param elements iterable of methodParameterTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllMethodParameterTypes(Iterable<String> elements) {
      methodParameterTypesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationConfigBase#methodReturnType() methodReturnType}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link InstrumentationConfigBase#methodReturnType() methodReturnType}.</em>
     * @param methodReturnType value for methodReturnType
     * @return {@code this} builder for chained invocation
     */
    public final Builder methodReturnType(String methodReturnType) {
      checkNotIsSet(methodReturnTypeIsSet(), "methodReturnType");
      this.methodReturnType = Preconditions.checkNotNull(methodReturnType);
      nondefaultBitset |= NONDEFAULT_BIT_METHOD_RETURN_TYPE;
      return this;
    }
  
    /**
     * Adds one element to {@link InstrumentationConfigBase#methodModifiers() methodModifiers} list.
     * @param element methodModifiers element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addMethodModifiers(MethodModifier element) {
      methodModifiersBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link InstrumentationConfigBase#methodModifiers() methodModifiers} list.
     * @param elements array of methodModifiers elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addMethodModifiers(MethodModifier... elements) {
      methodModifiersBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link InstrumentationConfigBase#methodModifiers() methodModifiers} list.
     * @param elements iterable of methodModifiers elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllMethodModifiers(Iterable<? extends MethodModifier> elements) {
      methodModifiersBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationConfigBase#captureKind() captureKind}.
     * @param captureKind value for captureKind
     * @return {@code this} builder for chained invocation
     */
    public final Builder captureKind(CaptureKind captureKind) {
      checkNotIsSet(captureKindIsSet(), "captureKind");
      this.captureKind = Preconditions.checkNotNull(captureKind);
      initializedBitset |= INITIALIZED_BIT_CAPTURE_KIND;
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationConfigBase#timerName() timerName}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link InstrumentationConfigBase#timerName() timerName}.</em>
     * @param timerName value for timerName
     * @return {@code this} builder for chained invocation
     */
    public final Builder timerName(String timerName) {
      checkNotIsSet(timerNameIsSet(), "timerName");
      this.timerName = Preconditions.checkNotNull(timerName);
      nondefaultBitset |= NONDEFAULT_BIT_TIMER_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationConfigBase#traceEntryTemplate() traceEntryTemplate}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link InstrumentationConfigBase#traceEntryTemplate() traceEntryTemplate}.</em>
     * @param traceEntryTemplate value for traceEntryTemplate
     * @return {@code this} builder for chained invocation
     */
    public final Builder traceEntryTemplate(String traceEntryTemplate) {
      checkNotIsSet(traceEntryTemplateIsSet(), "traceEntryTemplate");
      this.traceEntryTemplate = Preconditions.checkNotNull(traceEntryTemplate);
      nondefaultBitset |= NONDEFAULT_BIT_TRACE_ENTRY_TEMPLATE;
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationConfigBase#traceEntryStackThresholdMillis() traceEntryStackThresholdMillis}.
     * @param traceEntryStackThresholdMillis value for traceEntryStackThresholdMillis, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder traceEntryStackThresholdMillis(@Nullable Long traceEntryStackThresholdMillis) {
      checkNotIsSet(traceEntryStackThresholdMillisIsSet(), "traceEntryStackThresholdMillis");
      this.traceEntryStackThresholdMillis = traceEntryStackThresholdMillis;
      nondefaultBitset |= NONDEFAULT_BIT_TRACE_ENTRY_STACK_THRESHOLD_MILLIS;
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationConfigBase#traceEntryCaptureSelfNested() traceEntryCaptureSelfNested}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link InstrumentationConfigBase#traceEntryCaptureSelfNested() traceEntryCaptureSelfNested}.</em>
     * @param traceEntryCaptureSelfNested value for traceEntryCaptureSelfNested
     * @return {@code this} builder for chained invocation
     */
    public final Builder traceEntryCaptureSelfNested(boolean traceEntryCaptureSelfNested) {
      checkNotIsSet(traceEntryCaptureSelfNestedIsSet(), "traceEntryCaptureSelfNested");
      this.traceEntryCaptureSelfNested = traceEntryCaptureSelfNested;
      nondefaultBitset |= NONDEFAULT_BIT_TRACE_ENTRY_CAPTURE_SELF_NESTED;
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationConfigBase#transactionType() transactionType}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link InstrumentationConfigBase#transactionType() transactionType}.</em>
     * @param transactionType value for transactionType
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionType(String transactionType) {
      checkNotIsSet(transactionTypeIsSet(), "transactionType");
      this.transactionType = Preconditions.checkNotNull(transactionType);
      nondefaultBitset |= NONDEFAULT_BIT_TRANSACTION_TYPE;
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationConfigBase#transactionNameTemplate() transactionNameTemplate}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link InstrumentationConfigBase#transactionNameTemplate() transactionNameTemplate}.</em>
     * @param transactionNameTemplate value for transactionNameTemplate
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionNameTemplate(String transactionNameTemplate) {
      checkNotIsSet(transactionNameTemplateIsSet(), "transactionNameTemplate");
      this.transactionNameTemplate = Preconditions.checkNotNull(transactionNameTemplate);
      nondefaultBitset |= NONDEFAULT_BIT_TRANSACTION_NAME_TEMPLATE;
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationConfigBase#transactionUserTemplate() transactionUserTemplate}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link InstrumentationConfigBase#transactionUserTemplate() transactionUserTemplate}.</em>
     * @param transactionUserTemplate value for transactionUserTemplate
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionUserTemplate(String transactionUserTemplate) {
      checkNotIsSet(transactionUserTemplateIsSet(), "transactionUserTemplate");
      this.transactionUserTemplate = Preconditions.checkNotNull(transactionUserTemplate);
      nondefaultBitset |= NONDEFAULT_BIT_TRANSACTION_USER_TEMPLATE;
      return this;
    }
  
    /**
     * Put one entry to {@link InstrumentationConfigBase#transactionCustomAttributeTemplates() transactionCustomAttributeTemplates} map.
     * @param key the key in transactionCustomAttributeTemplates map
     * @param value the associated value in transactionCustomAttributeTemplates map
     * @return {@code this} builder for chained invocation
     */
    public final Builder putTransactionCustomAttributeTemplates(String key, String value) {
      transactionCustomAttributeTemplatesBuilder.put(key, value);
      return this;
    }
  
    /**
     * Put one entry to {@link InstrumentationConfigBase#transactionCustomAttributeTemplates() transactionCustomAttributeTemplates} map. Nulls are not permitted
     * @param entry the key and value entry
     * @return {@code this} builder for chained invocation
     */
    public final Builder putTransactionCustomAttributeTemplates(Map.Entry<String, ? extends String> entry) {
      transactionCustomAttributeTemplatesBuilder.put(entry);
      return this;
    }
  
    /**
     * Put all mappings from specified map as entries to {@link InstrumentationConfigBase#transactionCustomAttributeTemplates() transactionCustomAttributeTemplates} map. Nulls are not permitted
     * @param entries to be added to transactionCustomAttributeTemplates map
     * @return {@code this} builder for chained invocation
     */
    public final Builder putAllTransactionCustomAttributeTemplates(Map<String, ? extends String> entries) {
      transactionCustomAttributeTemplatesBuilder.putAll(entries);
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationConfigBase#traceStoreThresholdMillis() traceStoreThresholdMillis}.
     * @param traceStoreThresholdMillis value for traceStoreThresholdMillis, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder traceStoreThresholdMillis(@Nullable Long traceStoreThresholdMillis) {
      checkNotIsSet(traceStoreThresholdMillisIsSet(), "traceStoreThresholdMillis");
      this.traceStoreThresholdMillis = traceStoreThresholdMillis;
      nondefaultBitset |= NONDEFAULT_BIT_TRACE_STORE_THRESHOLD_MILLIS;
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationConfigBase#enabledProperty() enabledProperty}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link InstrumentationConfigBase#enabledProperty() enabledProperty}.</em>
     * @param enabledProperty value for enabledProperty
     * @return {@code this} builder for chained invocation
     */
    public final Builder enabledProperty(String enabledProperty) {
      checkNotIsSet(enabledPropertyIsSet(), "enabledProperty");
      this.enabledProperty = Preconditions.checkNotNull(enabledProperty);
      nondefaultBitset |= NONDEFAULT_BIT_ENABLED_PROPERTY;
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationConfigBase#traceEntryEnabledProperty() traceEntryEnabledProperty}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link InstrumentationConfigBase#traceEntryEnabledProperty() traceEntryEnabledProperty}.</em>
     * @param traceEntryEnabledProperty value for traceEntryEnabledProperty
     * @return {@code this} builder for chained invocation
     */
    public final Builder traceEntryEnabledProperty(String traceEntryEnabledProperty) {
      checkNotIsSet(traceEntryEnabledPropertyIsSet(), "traceEntryEnabledProperty");
      this.traceEntryEnabledProperty = Preconditions.checkNotNull(traceEntryEnabledProperty);
      nondefaultBitset |= NONDEFAULT_BIT_TRACE_ENTRY_ENABLED_PROPERTY;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.config.InstrumentationConfig}.
     * @return immutable instance of InstrumentationConfig
     */
    public InstrumentationConfig build() {
      checkRequiredAttributes();
      return new InstrumentationConfig(this);
    }
  
    private boolean methodReturnTypeIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_METHOD_RETURN_TYPE) != 0;
    }
  
    private boolean timerNameIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TIMER_NAME) != 0;
    }
  
    private boolean traceEntryTemplateIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TRACE_ENTRY_TEMPLATE) != 0;
    }
  
    private boolean traceEntryStackThresholdMillisIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TRACE_ENTRY_STACK_THRESHOLD_MILLIS) != 0;
    }
  
    private boolean traceEntryCaptureSelfNestedIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TRACE_ENTRY_CAPTURE_SELF_NESTED) != 0;
    }
  
    private boolean transactionTypeIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TRANSACTION_TYPE) != 0;
    }
  
    private boolean transactionNameTemplateIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TRANSACTION_NAME_TEMPLATE) != 0;
    }
  
    private boolean transactionUserTemplateIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TRANSACTION_USER_TEMPLATE) != 0;
    }
  
    private boolean traceStoreThresholdMillisIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TRACE_STORE_THRESHOLD_MILLIS) != 0;
    }
  
    private boolean enabledPropertyIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_ENABLED_PROPERTY) != 0;
    }
  
    private boolean traceEntryEnabledPropertyIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TRACE_ENTRY_ENABLED_PROPERTY) != 0;
    }
  
    private boolean classNameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CLASS_NAME) != 0;
    }
  
    private boolean methodNameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_METHOD_NAME) != 0;
    }
  
    private boolean captureKindIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CAPTURE_KIND) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of InstrumentationConfig is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!classNameIsSet()) {
        attributes.add("className");
      }
      if (!methodNameIsSet()) {
        attributes.add("methodName");
      }
      if (!captureKindIsSet()) {
        attributes.add("captureKind");
      }
      return "Cannot build InstrumentationConfig, some of required attributes are not set " + attributes;
    }
  }
}
