package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ConfigJsonService.AdvancedConfigDtoBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code AdvancedConfigDto.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConfigJsonService.AdvancedConfigDtoBase"})
@Immutable
final class AdvancedConfigDto extends ConfigJsonService.AdvancedConfigDtoBase {
  private final boolean timerWrapperMethods;
  private final boolean weavingTimer;
  private final int immediatePartialStoreThresholdSeconds;
  private final int maxAggregateTransactionsPerTransactionType;
  private final int maxAggregateQueriesPerQueryType;
  private final int maxTraceEntriesPerTransaction;
  private final int maxStackTraceSamplesPerTransaction;
  private final boolean captureThreadInfo;
  private final boolean captureGcInfo;
  private final int mbeanGaugeNotFoundDelaySeconds;
  private final int internalQueryTimeoutSeconds;
  private final String version;

  private AdvancedConfigDto(
      boolean timerWrapperMethods,
      boolean weavingTimer,
      int immediatePartialStoreThresholdSeconds,
      int maxAggregateTransactionsPerTransactionType,
      int maxAggregateQueriesPerQueryType,
      int maxTraceEntriesPerTransaction,
      int maxStackTraceSamplesPerTransaction,
      boolean captureThreadInfo,
      boolean captureGcInfo,
      int mbeanGaugeNotFoundDelaySeconds,
      int internalQueryTimeoutSeconds,
      String version) {
    this.timerWrapperMethods = timerWrapperMethods;
    this.weavingTimer = weavingTimer;
    this.immediatePartialStoreThresholdSeconds = immediatePartialStoreThresholdSeconds;
    this.maxAggregateTransactionsPerTransactionType = maxAggregateTransactionsPerTransactionType;
    this.maxAggregateQueriesPerQueryType = maxAggregateQueriesPerQueryType;
    this.maxTraceEntriesPerTransaction = maxTraceEntriesPerTransaction;
    this.maxStackTraceSamplesPerTransaction = maxStackTraceSamplesPerTransaction;
    this.captureThreadInfo = captureThreadInfo;
    this.captureGcInfo = captureGcInfo;
    this.mbeanGaugeNotFoundDelaySeconds = mbeanGaugeNotFoundDelaySeconds;
    this.internalQueryTimeoutSeconds = internalQueryTimeoutSeconds;
    this.version = version;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code timerWrapperMethods} attribute
   */
  @JsonProperty("timerWrapperMethods")
  @Override
  public boolean timerWrapperMethods() {
    return timerWrapperMethods;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code weavingTimer} attribute
   */
  @JsonProperty("weavingTimer")
  @Override
  public boolean weavingTimer() {
    return weavingTimer;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code immediatePartialStoreThresholdSeconds} attribute
   */
  @JsonProperty("immediatePartialStoreThresholdSeconds")
  @Override
  public int immediatePartialStoreThresholdSeconds() {
    return immediatePartialStoreThresholdSeconds;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code maxAggregateTransactionsPerTransactionType} attribute
   */
  @JsonProperty("maxAggregateTransactionsPerTransactionType")
  @Override
  public int maxAggregateTransactionsPerTransactionType() {
    return maxAggregateTransactionsPerTransactionType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code maxAggregateQueriesPerQueryType} attribute
   */
  @JsonProperty("maxAggregateQueriesPerQueryType")
  @Override
  public int maxAggregateQueriesPerQueryType() {
    return maxAggregateQueriesPerQueryType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code maxTraceEntriesPerTransaction} attribute
   */
  @JsonProperty("maxTraceEntriesPerTransaction")
  @Override
  public int maxTraceEntriesPerTransaction() {
    return maxTraceEntriesPerTransaction;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code maxStackTraceSamplesPerTransaction} attribute
   */
  @JsonProperty("maxStackTraceSamplesPerTransaction")
  @Override
  public int maxStackTraceSamplesPerTransaction() {
    return maxStackTraceSamplesPerTransaction;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code captureThreadInfo} attribute
   */
  @JsonProperty("captureThreadInfo")
  @Override
  public boolean captureThreadInfo() {
    return captureThreadInfo;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code captureGcInfo} attribute
   */
  @JsonProperty("captureGcInfo")
  @Override
  public boolean captureGcInfo() {
    return captureGcInfo;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code mbeanGaugeNotFoundDelaySeconds} attribute
   */
  @JsonProperty("mbeanGaugeNotFoundDelaySeconds")
  @Override
  public int mbeanGaugeNotFoundDelaySeconds() {
    return mbeanGaugeNotFoundDelaySeconds;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code internalQueryTimeoutSeconds} attribute
   */
  @JsonProperty("internalQueryTimeoutSeconds")
  @Override
  public int internalQueryTimeoutSeconds() {
    return internalQueryTimeoutSeconds;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public String version() {
    return version;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.AdvancedConfigDtoBase#timerWrapperMethods() timerWrapperMethods}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for timerWrapperMethods
   * @return modified copy of the {@code this} object
   */
  public final AdvancedConfigDto withTimerWrapperMethods(boolean value) {
    if (this.timerWrapperMethods == value) {
      return this;
    }
    boolean newValue = value;
    return new AdvancedConfigDto(
        newValue,
        this.weavingTimer,
        this.immediatePartialStoreThresholdSeconds,
        this.maxAggregateTransactionsPerTransactionType,
        this.maxAggregateQueriesPerQueryType,
        this.maxTraceEntriesPerTransaction,
        this.maxStackTraceSamplesPerTransaction,
        this.captureThreadInfo,
        this.captureGcInfo,
        this.mbeanGaugeNotFoundDelaySeconds,
        this.internalQueryTimeoutSeconds,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.AdvancedConfigDtoBase#weavingTimer() weavingTimer}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for weavingTimer
   * @return modified copy of the {@code this} object
   */
  public final AdvancedConfigDto withWeavingTimer(boolean value) {
    if (this.weavingTimer == value) {
      return this;
    }
    boolean newValue = value;
    return new AdvancedConfigDto(
        this.timerWrapperMethods,
        newValue,
        this.immediatePartialStoreThresholdSeconds,
        this.maxAggregateTransactionsPerTransactionType,
        this.maxAggregateQueriesPerQueryType,
        this.maxTraceEntriesPerTransaction,
        this.maxStackTraceSamplesPerTransaction,
        this.captureThreadInfo,
        this.captureGcInfo,
        this.mbeanGaugeNotFoundDelaySeconds,
        this.internalQueryTimeoutSeconds,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.AdvancedConfigDtoBase#immediatePartialStoreThresholdSeconds() immediatePartialStoreThresholdSeconds}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for immediatePartialStoreThresholdSeconds
   * @return modified copy of the {@code this} object
   */
  public final AdvancedConfigDto withImmediatePartialStoreThresholdSeconds(int value) {
    if (this.immediatePartialStoreThresholdSeconds == value) {
      return this;
    }
    int newValue = value;
    return new AdvancedConfigDto(
        this.timerWrapperMethods,
        this.weavingTimer,
        newValue,
        this.maxAggregateTransactionsPerTransactionType,
        this.maxAggregateQueriesPerQueryType,
        this.maxTraceEntriesPerTransaction,
        this.maxStackTraceSamplesPerTransaction,
        this.captureThreadInfo,
        this.captureGcInfo,
        this.mbeanGaugeNotFoundDelaySeconds,
        this.internalQueryTimeoutSeconds,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.AdvancedConfigDtoBase#maxAggregateTransactionsPerTransactionType() maxAggregateTransactionsPerTransactionType}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for maxAggregateTransactionsPerTransactionType
   * @return modified copy of the {@code this} object
   */
  public final AdvancedConfigDto withMaxAggregateTransactionsPerTransactionType(int value) {
    if (this.maxAggregateTransactionsPerTransactionType == value) {
      return this;
    }
    int newValue = value;
    return new AdvancedConfigDto(
        this.timerWrapperMethods,
        this.weavingTimer,
        this.immediatePartialStoreThresholdSeconds,
        newValue,
        this.maxAggregateQueriesPerQueryType,
        this.maxTraceEntriesPerTransaction,
        this.maxStackTraceSamplesPerTransaction,
        this.captureThreadInfo,
        this.captureGcInfo,
        this.mbeanGaugeNotFoundDelaySeconds,
        this.internalQueryTimeoutSeconds,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.AdvancedConfigDtoBase#maxAggregateQueriesPerQueryType() maxAggregateQueriesPerQueryType}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for maxAggregateQueriesPerQueryType
   * @return modified copy of the {@code this} object
   */
  public final AdvancedConfigDto withMaxAggregateQueriesPerQueryType(int value) {
    if (this.maxAggregateQueriesPerQueryType == value) {
      return this;
    }
    int newValue = value;
    return new AdvancedConfigDto(
        this.timerWrapperMethods,
        this.weavingTimer,
        this.immediatePartialStoreThresholdSeconds,
        this.maxAggregateTransactionsPerTransactionType,
        newValue,
        this.maxTraceEntriesPerTransaction,
        this.maxStackTraceSamplesPerTransaction,
        this.captureThreadInfo,
        this.captureGcInfo,
        this.mbeanGaugeNotFoundDelaySeconds,
        this.internalQueryTimeoutSeconds,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.AdvancedConfigDtoBase#maxTraceEntriesPerTransaction() maxTraceEntriesPerTransaction}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for maxTraceEntriesPerTransaction
   * @return modified copy of the {@code this} object
   */
  public final AdvancedConfigDto withMaxTraceEntriesPerTransaction(int value) {
    if (this.maxTraceEntriesPerTransaction == value) {
      return this;
    }
    int newValue = value;
    return new AdvancedConfigDto(
        this.timerWrapperMethods,
        this.weavingTimer,
        this.immediatePartialStoreThresholdSeconds,
        this.maxAggregateTransactionsPerTransactionType,
        this.maxAggregateQueriesPerQueryType,
        newValue,
        this.maxStackTraceSamplesPerTransaction,
        this.captureThreadInfo,
        this.captureGcInfo,
        this.mbeanGaugeNotFoundDelaySeconds,
        this.internalQueryTimeoutSeconds,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.AdvancedConfigDtoBase#maxStackTraceSamplesPerTransaction() maxStackTraceSamplesPerTransaction}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for maxStackTraceSamplesPerTransaction
   * @return modified copy of the {@code this} object
   */
  public final AdvancedConfigDto withMaxStackTraceSamplesPerTransaction(int value) {
    if (this.maxStackTraceSamplesPerTransaction == value) {
      return this;
    }
    int newValue = value;
    return new AdvancedConfigDto(
        this.timerWrapperMethods,
        this.weavingTimer,
        this.immediatePartialStoreThresholdSeconds,
        this.maxAggregateTransactionsPerTransactionType,
        this.maxAggregateQueriesPerQueryType,
        this.maxTraceEntriesPerTransaction,
        newValue,
        this.captureThreadInfo,
        this.captureGcInfo,
        this.mbeanGaugeNotFoundDelaySeconds,
        this.internalQueryTimeoutSeconds,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.AdvancedConfigDtoBase#captureThreadInfo() captureThreadInfo}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for captureThreadInfo
   * @return modified copy of the {@code this} object
   */
  public final AdvancedConfigDto withCaptureThreadInfo(boolean value) {
    if (this.captureThreadInfo == value) {
      return this;
    }
    boolean newValue = value;
    return new AdvancedConfigDto(
        this.timerWrapperMethods,
        this.weavingTimer,
        this.immediatePartialStoreThresholdSeconds,
        this.maxAggregateTransactionsPerTransactionType,
        this.maxAggregateQueriesPerQueryType,
        this.maxTraceEntriesPerTransaction,
        this.maxStackTraceSamplesPerTransaction,
        newValue,
        this.captureGcInfo,
        this.mbeanGaugeNotFoundDelaySeconds,
        this.internalQueryTimeoutSeconds,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.AdvancedConfigDtoBase#captureGcInfo() captureGcInfo}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for captureGcInfo
   * @return modified copy of the {@code this} object
   */
  public final AdvancedConfigDto withCaptureGcInfo(boolean value) {
    if (this.captureGcInfo == value) {
      return this;
    }
    boolean newValue = value;
    return new AdvancedConfigDto(
        this.timerWrapperMethods,
        this.weavingTimer,
        this.immediatePartialStoreThresholdSeconds,
        this.maxAggregateTransactionsPerTransactionType,
        this.maxAggregateQueriesPerQueryType,
        this.maxTraceEntriesPerTransaction,
        this.maxStackTraceSamplesPerTransaction,
        this.captureThreadInfo,
        newValue,
        this.mbeanGaugeNotFoundDelaySeconds,
        this.internalQueryTimeoutSeconds,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.AdvancedConfigDtoBase#mbeanGaugeNotFoundDelaySeconds() mbeanGaugeNotFoundDelaySeconds}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for mbeanGaugeNotFoundDelaySeconds
   * @return modified copy of the {@code this} object
   */
  public final AdvancedConfigDto withMbeanGaugeNotFoundDelaySeconds(int value) {
    if (this.mbeanGaugeNotFoundDelaySeconds == value) {
      return this;
    }
    int newValue = value;
    return new AdvancedConfigDto(
        this.timerWrapperMethods,
        this.weavingTimer,
        this.immediatePartialStoreThresholdSeconds,
        this.maxAggregateTransactionsPerTransactionType,
        this.maxAggregateQueriesPerQueryType,
        this.maxTraceEntriesPerTransaction,
        this.maxStackTraceSamplesPerTransaction,
        this.captureThreadInfo,
        this.captureGcInfo,
        newValue,
        this.internalQueryTimeoutSeconds,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.AdvancedConfigDtoBase#internalQueryTimeoutSeconds() internalQueryTimeoutSeconds}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for internalQueryTimeoutSeconds
   * @return modified copy of the {@code this} object
   */
  public final AdvancedConfigDto withInternalQueryTimeoutSeconds(int value) {
    if (this.internalQueryTimeoutSeconds == value) {
      return this;
    }
    int newValue = value;
    return new AdvancedConfigDto(
        this.timerWrapperMethods,
        this.weavingTimer,
        this.immediatePartialStoreThresholdSeconds,
        this.maxAggregateTransactionsPerTransactionType,
        this.maxAggregateQueriesPerQueryType,
        this.maxTraceEntriesPerTransaction,
        this.maxStackTraceSamplesPerTransaction,
        this.captureThreadInfo,
        this.captureGcInfo,
        this.mbeanGaugeNotFoundDelaySeconds,
        newValue,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.AdvancedConfigDtoBase#version() version}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for version
   * @return modified copy of the {@code this} object
   */
  public final AdvancedConfigDto withVersion(String value) {
    if (this.version == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new AdvancedConfigDto(
        this.timerWrapperMethods,
        this.weavingTimer,
        this.immediatePartialStoreThresholdSeconds,
        this.maxAggregateTransactionsPerTransactionType,
        this.maxAggregateQueriesPerQueryType,
        this.maxTraceEntriesPerTransaction,
        this.maxStackTraceSamplesPerTransaction,
        this.captureThreadInfo,
        this.captureGcInfo,
        this.mbeanGaugeNotFoundDelaySeconds,
        this.internalQueryTimeoutSeconds,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code AdvancedConfigDto} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof AdvancedConfigDto && equalTo((AdvancedConfigDto) another));
  }
  
  private boolean equalTo(AdvancedConfigDto another) {
    return timerWrapperMethods == another.timerWrapperMethods
        && weavingTimer == another.weavingTimer
        && immediatePartialStoreThresholdSeconds == another.immediatePartialStoreThresholdSeconds
        && maxAggregateTransactionsPerTransactionType == another.maxAggregateTransactionsPerTransactionType
        && maxAggregateQueriesPerQueryType == another.maxAggregateQueriesPerQueryType
        && maxTraceEntriesPerTransaction == another.maxTraceEntriesPerTransaction
        && maxStackTraceSamplesPerTransaction == another.maxStackTraceSamplesPerTransaction
        && captureThreadInfo == another.captureThreadInfo
        && captureGcInfo == another.captureGcInfo
        && mbeanGaugeNotFoundDelaySeconds == another.mbeanGaugeNotFoundDelaySeconds
        && internalQueryTimeoutSeconds == another.internalQueryTimeoutSeconds
        && version.equals(another.version);
  }
  
  /**
   * Computes hash code from attributes: {@code timerWrapperMethods}, {@code weavingTimer}, {@code immediatePartialStoreThresholdSeconds}, {@code maxAggregateTransactionsPerTransactionType}, {@code maxAggregateQueriesPerQueryType}, {@code maxTraceEntriesPerTransaction}, {@code maxStackTraceSamplesPerTransaction}, {@code captureThreadInfo}, {@code captureGcInfo}, {@code mbeanGaugeNotFoundDelaySeconds}, {@code internalQueryTimeoutSeconds}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Booleans.hashCode(timerWrapperMethods);
    h = h * 17 + Booleans.hashCode(weavingTimer);
    h = h * 17 + immediatePartialStoreThresholdSeconds;
    h = h * 17 + maxAggregateTransactionsPerTransactionType;
    h = h * 17 + maxAggregateQueriesPerQueryType;
    h = h * 17 + maxTraceEntriesPerTransaction;
    h = h * 17 + maxStackTraceSamplesPerTransaction;
    h = h * 17 + Booleans.hashCode(captureThreadInfo);
    h = h * 17 + Booleans.hashCode(captureGcInfo);
    h = h * 17 + mbeanGaugeNotFoundDelaySeconds;
    h = h * 17 + internalQueryTimeoutSeconds;
    h = h * 17 + version.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code AdvancedConfigDto{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AdvancedConfigDto")
        .add("timerWrapperMethods", timerWrapperMethods)
        .add("weavingTimer", weavingTimer)
        .add("immediatePartialStoreThresholdSeconds", immediatePartialStoreThresholdSeconds)
        .add("maxAggregateTransactionsPerTransactionType", maxAggregateTransactionsPerTransactionType)
        .add("maxAggregateQueriesPerQueryType", maxAggregateQueriesPerQueryType)
        .add("maxTraceEntriesPerTransaction", maxTraceEntriesPerTransaction)
        .add("maxStackTraceSamplesPerTransaction", maxStackTraceSamplesPerTransaction)
        .add("captureThreadInfo", captureThreadInfo)
        .add("captureGcInfo", captureGcInfo)
        .add("mbeanGaugeNotFoundDelaySeconds", mbeanGaugeNotFoundDelaySeconds)
        .add("internalQueryTimeoutSeconds", internalQueryTimeoutSeconds)
        .add("version", version)
        .toString();
  }
  
  @JsonCreator
  public static AdvancedConfigDto fromAllAttributes(
      @JsonProperty("timerWrapperMethods") @Nullable Boolean timerWrapperMethods,
      @JsonProperty("weavingTimer") @Nullable Boolean weavingTimer,
      @JsonProperty("immediatePartialStoreThresholdSeconds") @Nullable Integer immediatePartialStoreThresholdSeconds,
      @JsonProperty("maxAggregateTransactionsPerTransactionType") @Nullable Integer maxAggregateTransactionsPerTransactionType,
      @JsonProperty("maxAggregateQueriesPerQueryType") @Nullable Integer maxAggregateQueriesPerQueryType,
      @JsonProperty("maxTraceEntriesPerTransaction") @Nullable Integer maxTraceEntriesPerTransaction,
      @JsonProperty("maxStackTraceSamplesPerTransaction") @Nullable Integer maxStackTraceSamplesPerTransaction,
      @JsonProperty("captureThreadInfo") @Nullable Boolean captureThreadInfo,
      @JsonProperty("captureGcInfo") @Nullable Boolean captureGcInfo,
      @JsonProperty("mbeanGaugeNotFoundDelaySeconds") @Nullable Integer mbeanGaugeNotFoundDelaySeconds,
      @JsonProperty("internalQueryTimeoutSeconds") @Nullable Integer internalQueryTimeoutSeconds,
      @JsonProperty("version") @Nullable String version) {
    AdvancedConfigDto.Builder builder = AdvancedConfigDto.builder();
    if (timerWrapperMethods != null) {
      builder.timerWrapperMethods(timerWrapperMethods);
    }
    if (weavingTimer != null) {
      builder.weavingTimer(weavingTimer);
    }
    if (immediatePartialStoreThresholdSeconds != null) {
      builder.immediatePartialStoreThresholdSeconds(immediatePartialStoreThresholdSeconds);
    }
    if (maxAggregateTransactionsPerTransactionType != null) {
      builder.maxAggregateTransactionsPerTransactionType(maxAggregateTransactionsPerTransactionType);
    }
    if (maxAggregateQueriesPerQueryType != null) {
      builder.maxAggregateQueriesPerQueryType(maxAggregateQueriesPerQueryType);
    }
    if (maxTraceEntriesPerTransaction != null) {
      builder.maxTraceEntriesPerTransaction(maxTraceEntriesPerTransaction);
    }
    if (maxStackTraceSamplesPerTransaction != null) {
      builder.maxStackTraceSamplesPerTransaction(maxStackTraceSamplesPerTransaction);
    }
    if (captureThreadInfo != null) {
      builder.captureThreadInfo(captureThreadInfo);
    }
    if (captureGcInfo != null) {
      builder.captureGcInfo(captureGcInfo);
    }
    if (mbeanGaugeNotFoundDelaySeconds != null) {
      builder.mbeanGaugeNotFoundDelaySeconds(mbeanGaugeNotFoundDelaySeconds);
    }
    if (internalQueryTimeoutSeconds != null) {
      builder.internalQueryTimeoutSeconds(internalQueryTimeoutSeconds);
    }
    if (version != null) {
      builder.version(version);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link ConfigJsonService.AdvancedConfigDtoBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable AdvancedConfigDto instance
   */
  static AdvancedConfigDto copyOf(ConfigJsonService.AdvancedConfigDtoBase instance) {
    if (instance instanceof AdvancedConfigDto) {
      return (AdvancedConfigDto) instance;
    }
    return AdvancedConfigDto.builder()
        .timerWrapperMethods(instance.timerWrapperMethods())
        .weavingTimer(instance.weavingTimer())
        .immediatePartialStoreThresholdSeconds(instance.immediatePartialStoreThresholdSeconds())
        .maxAggregateTransactionsPerTransactionType(instance.maxAggregateTransactionsPerTransactionType())
        .maxAggregateQueriesPerQueryType(instance.maxAggregateQueriesPerQueryType())
        .maxTraceEntriesPerTransaction(instance.maxTraceEntriesPerTransaction())
        .maxStackTraceSamplesPerTransaction(instance.maxStackTraceSamplesPerTransaction())
        .captureThreadInfo(instance.captureThreadInfo())
        .captureGcInfo(instance.captureGcInfo())
        .mbeanGaugeNotFoundDelaySeconds(instance.mbeanGaugeNotFoundDelaySeconds())
        .internalQueryTimeoutSeconds(instance.internalQueryTimeoutSeconds())
        .version(instance.version())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.AdvancedConfigDto}.
   * @return new AdvancedConfigDto builder
   */
  static AdvancedConfigDto.Builder builder() {
    return new AdvancedConfigDto.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.AdvancedConfigDto}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0xfff;
    private static final long INITIALIZED_BIT_TIMER_WRAPPER_METHODS = 0x1L;
    private static final long INITIALIZED_BIT_WEAVING_TIMER = 0x2L;
    private static final long INITIALIZED_BIT_IMMEDIATE_PARTIAL_STORE_THRESHOLD_SECONDS = 0x4L;
    private static final long INITIALIZED_BIT_MAX_AGGREGATE_TRANSACTIONS_PER_TRANSACTION_TYPE = 0x8L;
    private static final long INITIALIZED_BIT_MAX_AGGREGATE_QUERIES_PER_QUERY_TYPE = 0x10L;
    private static final long INITIALIZED_BIT_MAX_TRACE_ENTRIES_PER_TRANSACTION = 0x20L;
    private static final long INITIALIZED_BIT_MAX_STACK_TRACE_SAMPLES_PER_TRANSACTION = 0x40L;
    private static final long INITIALIZED_BIT_CAPTURE_THREAD_INFO = 0x80L;
    private static final long INITIALIZED_BIT_CAPTURE_GC_INFO = 0x100L;
    private static final long INITIALIZED_BIT_MBEAN_GAUGE_NOT_FOUND_DELAY_SECONDS = 0x200L;
    private static final long INITIALIZED_BIT_INTERNAL_QUERY_TIMEOUT_SECONDS = 0x400L;
    private static final long INITIALIZED_BIT_VERSION = 0x800L;
    private long initializedBitset;
  
    private boolean timerWrapperMethods;
    private boolean weavingTimer;
    private int immediatePartialStoreThresholdSeconds;
    private int maxAggregateTransactionsPerTransactionType;
    private int maxAggregateQueriesPerQueryType;
    private int maxTraceEntriesPerTransaction;
    private int maxStackTraceSamplesPerTransaction;
    private boolean captureThreadInfo;
    private boolean captureGcInfo;
    private int mbeanGaugeNotFoundDelaySeconds;
    private int internalQueryTimeoutSeconds;
    private @Nullable String version;
    private Builder() {}
  
    /**
     * Initializes value for {@link ConfigJsonService.AdvancedConfigDtoBase#timerWrapperMethods() timerWrapperMethods}.
     * @param timerWrapperMethods value for timerWrapperMethods
     * @return {@code this} builder for chained invocation
     */
    public final Builder timerWrapperMethods(boolean timerWrapperMethods) {
      checkNotIsSet(timerWrapperMethodsIsSet(), "timerWrapperMethods");
      this.timerWrapperMethods = timerWrapperMethods;
      initializedBitset |= INITIALIZED_BIT_TIMER_WRAPPER_METHODS;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.AdvancedConfigDtoBase#weavingTimer() weavingTimer}.
     * @param weavingTimer value for weavingTimer
     * @return {@code this} builder for chained invocation
     */
    public final Builder weavingTimer(boolean weavingTimer) {
      checkNotIsSet(weavingTimerIsSet(), "weavingTimer");
      this.weavingTimer = weavingTimer;
      initializedBitset |= INITIALIZED_BIT_WEAVING_TIMER;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.AdvancedConfigDtoBase#immediatePartialStoreThresholdSeconds() immediatePartialStoreThresholdSeconds}.
     * @param immediatePartialStoreThresholdSeconds value for immediatePartialStoreThresholdSeconds
     * @return {@code this} builder for chained invocation
     */
    public final Builder immediatePartialStoreThresholdSeconds(int immediatePartialStoreThresholdSeconds) {
      checkNotIsSet(immediatePartialStoreThresholdSecondsIsSet(), "immediatePartialStoreThresholdSeconds");
      this.immediatePartialStoreThresholdSeconds = immediatePartialStoreThresholdSeconds;
      initializedBitset |= INITIALIZED_BIT_IMMEDIATE_PARTIAL_STORE_THRESHOLD_SECONDS;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.AdvancedConfigDtoBase#maxAggregateTransactionsPerTransactionType() maxAggregateTransactionsPerTransactionType}.
     * @param maxAggregateTransactionsPerTransactionType value for maxAggregateTransactionsPerTransactionType
     * @return {@code this} builder for chained invocation
     */
    public final Builder maxAggregateTransactionsPerTransactionType(int maxAggregateTransactionsPerTransactionType) {
      checkNotIsSet(maxAggregateTransactionsPerTransactionTypeIsSet(), "maxAggregateTransactionsPerTransactionType");
      this.maxAggregateTransactionsPerTransactionType = maxAggregateTransactionsPerTransactionType;
      initializedBitset |= INITIALIZED_BIT_MAX_AGGREGATE_TRANSACTIONS_PER_TRANSACTION_TYPE;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.AdvancedConfigDtoBase#maxAggregateQueriesPerQueryType() maxAggregateQueriesPerQueryType}.
     * @param maxAggregateQueriesPerQueryType value for maxAggregateQueriesPerQueryType
     * @return {@code this} builder for chained invocation
     */
    public final Builder maxAggregateQueriesPerQueryType(int maxAggregateQueriesPerQueryType) {
      checkNotIsSet(maxAggregateQueriesPerQueryTypeIsSet(), "maxAggregateQueriesPerQueryType");
      this.maxAggregateQueriesPerQueryType = maxAggregateQueriesPerQueryType;
      initializedBitset |= INITIALIZED_BIT_MAX_AGGREGATE_QUERIES_PER_QUERY_TYPE;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.AdvancedConfigDtoBase#maxTraceEntriesPerTransaction() maxTraceEntriesPerTransaction}.
     * @param maxTraceEntriesPerTransaction value for maxTraceEntriesPerTransaction
     * @return {@code this} builder for chained invocation
     */
    public final Builder maxTraceEntriesPerTransaction(int maxTraceEntriesPerTransaction) {
      checkNotIsSet(maxTraceEntriesPerTransactionIsSet(), "maxTraceEntriesPerTransaction");
      this.maxTraceEntriesPerTransaction = maxTraceEntriesPerTransaction;
      initializedBitset |= INITIALIZED_BIT_MAX_TRACE_ENTRIES_PER_TRANSACTION;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.AdvancedConfigDtoBase#maxStackTraceSamplesPerTransaction() maxStackTraceSamplesPerTransaction}.
     * @param maxStackTraceSamplesPerTransaction value for maxStackTraceSamplesPerTransaction
     * @return {@code this} builder for chained invocation
     */
    public final Builder maxStackTraceSamplesPerTransaction(int maxStackTraceSamplesPerTransaction) {
      checkNotIsSet(maxStackTraceSamplesPerTransactionIsSet(), "maxStackTraceSamplesPerTransaction");
      this.maxStackTraceSamplesPerTransaction = maxStackTraceSamplesPerTransaction;
      initializedBitset |= INITIALIZED_BIT_MAX_STACK_TRACE_SAMPLES_PER_TRANSACTION;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.AdvancedConfigDtoBase#captureThreadInfo() captureThreadInfo}.
     * @param captureThreadInfo value for captureThreadInfo
     * @return {@code this} builder for chained invocation
     */
    public final Builder captureThreadInfo(boolean captureThreadInfo) {
      checkNotIsSet(captureThreadInfoIsSet(), "captureThreadInfo");
      this.captureThreadInfo = captureThreadInfo;
      initializedBitset |= INITIALIZED_BIT_CAPTURE_THREAD_INFO;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.AdvancedConfigDtoBase#captureGcInfo() captureGcInfo}.
     * @param captureGcInfo value for captureGcInfo
     * @return {@code this} builder for chained invocation
     */
    public final Builder captureGcInfo(boolean captureGcInfo) {
      checkNotIsSet(captureGcInfoIsSet(), "captureGcInfo");
      this.captureGcInfo = captureGcInfo;
      initializedBitset |= INITIALIZED_BIT_CAPTURE_GC_INFO;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.AdvancedConfigDtoBase#mbeanGaugeNotFoundDelaySeconds() mbeanGaugeNotFoundDelaySeconds}.
     * @param mbeanGaugeNotFoundDelaySeconds value for mbeanGaugeNotFoundDelaySeconds
     * @return {@code this} builder for chained invocation
     */
    public final Builder mbeanGaugeNotFoundDelaySeconds(int mbeanGaugeNotFoundDelaySeconds) {
      checkNotIsSet(mbeanGaugeNotFoundDelaySecondsIsSet(), "mbeanGaugeNotFoundDelaySeconds");
      this.mbeanGaugeNotFoundDelaySeconds = mbeanGaugeNotFoundDelaySeconds;
      initializedBitset |= INITIALIZED_BIT_MBEAN_GAUGE_NOT_FOUND_DELAY_SECONDS;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.AdvancedConfigDtoBase#internalQueryTimeoutSeconds() internalQueryTimeoutSeconds}.
     * @param internalQueryTimeoutSeconds value for internalQueryTimeoutSeconds
     * @return {@code this} builder for chained invocation
     */
    public final Builder internalQueryTimeoutSeconds(int internalQueryTimeoutSeconds) {
      checkNotIsSet(internalQueryTimeoutSecondsIsSet(), "internalQueryTimeoutSeconds");
      this.internalQueryTimeoutSeconds = internalQueryTimeoutSeconds;
      initializedBitset |= INITIALIZED_BIT_INTERNAL_QUERY_TIMEOUT_SECONDS;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.AdvancedConfigDtoBase#version() version}.
     * @param version value for version
     * @return {@code this} builder for chained invocation
     */
    public final Builder version(String version) {
      checkNotIsSet(versionIsSet(), "version");
      this.version = Preconditions.checkNotNull(version);
      initializedBitset |= INITIALIZED_BIT_VERSION;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.AdvancedConfigDto}.
     * @return immutable instance of AdvancedConfigDto
     */
    public org.glowroot.local.ui.AdvancedConfigDto build() {
      checkRequiredAttributes();
      return new AdvancedConfigDto(
        timerWrapperMethods,
        weavingTimer,
        immediatePartialStoreThresholdSeconds,
        maxAggregateTransactionsPerTransactionType,
        maxAggregateQueriesPerQueryType,
        maxTraceEntriesPerTransaction,
        maxStackTraceSamplesPerTransaction,
        captureThreadInfo,
        captureGcInfo,
        mbeanGaugeNotFoundDelaySeconds,
        internalQueryTimeoutSeconds,
        version);
    }
  
    private boolean timerWrapperMethodsIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TIMER_WRAPPER_METHODS) != 0;
    }
  
    private boolean weavingTimerIsSet() {
      return (initializedBitset & INITIALIZED_BIT_WEAVING_TIMER) != 0;
    }
  
    private boolean immediatePartialStoreThresholdSecondsIsSet() {
      return (initializedBitset & INITIALIZED_BIT_IMMEDIATE_PARTIAL_STORE_THRESHOLD_SECONDS) != 0;
    }
  
    private boolean maxAggregateTransactionsPerTransactionTypeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_MAX_AGGREGATE_TRANSACTIONS_PER_TRANSACTION_TYPE) != 0;
    }
  
    private boolean maxAggregateQueriesPerQueryTypeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_MAX_AGGREGATE_QUERIES_PER_QUERY_TYPE) != 0;
    }
  
    private boolean maxTraceEntriesPerTransactionIsSet() {
      return (initializedBitset & INITIALIZED_BIT_MAX_TRACE_ENTRIES_PER_TRANSACTION) != 0;
    }
  
    private boolean maxStackTraceSamplesPerTransactionIsSet() {
      return (initializedBitset & INITIALIZED_BIT_MAX_STACK_TRACE_SAMPLES_PER_TRANSACTION) != 0;
    }
  
    private boolean captureThreadInfoIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CAPTURE_THREAD_INFO) != 0;
    }
  
    private boolean captureGcInfoIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CAPTURE_GC_INFO) != 0;
    }
  
    private boolean mbeanGaugeNotFoundDelaySecondsIsSet() {
      return (initializedBitset & INITIALIZED_BIT_MBEAN_GAUGE_NOT_FOUND_DELAY_SECONDS) != 0;
    }
  
    private boolean internalQueryTimeoutSecondsIsSet() {
      return (initializedBitset & INITIALIZED_BIT_INTERNAL_QUERY_TIMEOUT_SECONDS) != 0;
    }
  
    private boolean versionIsSet() {
      return (initializedBitset & INITIALIZED_BIT_VERSION) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of AdvancedConfigDto is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!timerWrapperMethodsIsSet()) {
        attributes.add("timerWrapperMethods");
      }
      if (!weavingTimerIsSet()) {
        attributes.add("weavingTimer");
      }
      if (!immediatePartialStoreThresholdSecondsIsSet()) {
        attributes.add("immediatePartialStoreThresholdSeconds");
      }
      if (!maxAggregateTransactionsPerTransactionTypeIsSet()) {
        attributes.add("maxAggregateTransactionsPerTransactionType");
      }
      if (!maxAggregateQueriesPerQueryTypeIsSet()) {
        attributes.add("maxAggregateQueriesPerQueryType");
      }
      if (!maxTraceEntriesPerTransactionIsSet()) {
        attributes.add("maxTraceEntriesPerTransaction");
      }
      if (!maxStackTraceSamplesPerTransactionIsSet()) {
        attributes.add("maxStackTraceSamplesPerTransaction");
      }
      if (!captureThreadInfoIsSet()) {
        attributes.add("captureThreadInfo");
      }
      if (!captureGcInfoIsSet()) {
        attributes.add("captureGcInfo");
      }
      if (!mbeanGaugeNotFoundDelaySecondsIsSet()) {
        attributes.add("mbeanGaugeNotFoundDelaySeconds");
      }
      if (!internalQueryTimeoutSecondsIsSet()) {
        attributes.add("internalQueryTimeoutSeconds");
      }
      if (!versionIsSet()) {
        attributes.add("version");
      }
      return "Cannot build AdvancedConfigDto, some of required attributes are not set " + attributes;
    }
  }
}
