package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ConfigJsonService.AdvancedConfigResponseBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code AdvancedConfigResponse.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConfigJsonService.AdvancedConfigResponseBase"})
@Immutable
final class AdvancedConfigResponse
    extends ConfigJsonService.AdvancedConfigResponseBase {
  private final AdvancedConfigDto config;
  private final boolean timerWrapperMethodsActive;

  private AdvancedConfigResponse(AdvancedConfigDto config, boolean timerWrapperMethodsActive) {
    this.config = config;
    this.timerWrapperMethodsActive = timerWrapperMethodsActive;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code config} attribute
   */
  @JsonProperty("config")
  @Override
  public AdvancedConfigDto config() {
    return config;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code timerWrapperMethodsActive} attribute
   */
  @JsonProperty("timerWrapperMethodsActive")
  @Override
  public boolean timerWrapperMethodsActive() {
    return timerWrapperMethodsActive;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.AdvancedConfigResponseBase#config() config}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for config
   * @return modified copy of the {@code this} object
   */
  public final AdvancedConfigResponse withConfig(AdvancedConfigDto value) {
    if (this.config == value) {
      return this;
    }
    AdvancedConfigDto newValue = Preconditions.checkNotNull(value);
    return new AdvancedConfigResponse(newValue, this.timerWrapperMethodsActive);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.AdvancedConfigResponseBase#timerWrapperMethodsActive() timerWrapperMethodsActive}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for timerWrapperMethodsActive
   * @return modified copy of the {@code this} object
   */
  public final AdvancedConfigResponse withTimerWrapperMethodsActive(boolean value) {
    if (this.timerWrapperMethodsActive == value) {
      return this;
    }
    boolean newValue = value;
    return new AdvancedConfigResponse(this.config, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code AdvancedConfigResponse} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof AdvancedConfigResponse && equalTo((AdvancedConfigResponse) another));
  }
  
  private boolean equalTo(AdvancedConfigResponse another) {
    return config.equals(another.config)
        && timerWrapperMethodsActive == another.timerWrapperMethodsActive;
  }
  
  /**
   * Computes hash code from attributes: {@code config}, {@code timerWrapperMethodsActive}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + config.hashCode();
    h = h * 17 + Booleans.hashCode(timerWrapperMethodsActive);
    return h;
  }
  
  /**
   * Prints immutable value {@code AdvancedConfigResponse{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AdvancedConfigResponse")
        .add("config", config)
        .add("timerWrapperMethodsActive", timerWrapperMethodsActive)
        .toString();
  }
  
  @JsonCreator
  public static AdvancedConfigResponse fromAllAttributes(
      @JsonProperty("config") @Nullable AdvancedConfigDto config,
      @JsonProperty("timerWrapperMethodsActive") @Nullable Boolean timerWrapperMethodsActive) {
    AdvancedConfigResponse.Builder builder = AdvancedConfigResponse.builder();
    if (config != null) {
      builder.config(config);
    }
    if (timerWrapperMethodsActive != null) {
      builder.timerWrapperMethodsActive(timerWrapperMethodsActive);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link ConfigJsonService.AdvancedConfigResponseBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable AdvancedConfigResponse instance
   */
  static AdvancedConfigResponse copyOf(ConfigJsonService.AdvancedConfigResponseBase instance) {
    if (instance instanceof AdvancedConfigResponse) {
      return (AdvancedConfigResponse) instance;
    }
    return AdvancedConfigResponse.builder()
        .config(instance.config())
        .timerWrapperMethodsActive(instance.timerWrapperMethodsActive())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.AdvancedConfigResponse}.
   * @return new AdvancedConfigResponse builder
   */
  static AdvancedConfigResponse.Builder builder() {
    return new AdvancedConfigResponse.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.AdvancedConfigResponse}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_CONFIG = 0x1L;
    private static final long INITIALIZED_BIT_TIMER_WRAPPER_METHODS_ACTIVE = 0x2L;
    private long initializedBitset;
  
    private @Nullable AdvancedConfigDto config;
    private boolean timerWrapperMethodsActive;
    private Builder() {}
  
    /**
     * Initializes value for {@link ConfigJsonService.AdvancedConfigResponseBase#config() config}.
     * @param config value for config
     * @return {@code this} builder for chained invocation
     */
    public final Builder config(AdvancedConfigDto config) {
      checkNotIsSet(configIsSet(), "config");
      this.config = Preconditions.checkNotNull(config);
      initializedBitset |= INITIALIZED_BIT_CONFIG;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.AdvancedConfigResponseBase#timerWrapperMethodsActive() timerWrapperMethodsActive}.
     * @param timerWrapperMethodsActive value for timerWrapperMethodsActive
     * @return {@code this} builder for chained invocation
     */
    public final Builder timerWrapperMethodsActive(boolean timerWrapperMethodsActive) {
      checkNotIsSet(timerWrapperMethodsActiveIsSet(), "timerWrapperMethodsActive");
      this.timerWrapperMethodsActive = timerWrapperMethodsActive;
      initializedBitset |= INITIALIZED_BIT_TIMER_WRAPPER_METHODS_ACTIVE;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.AdvancedConfigResponse}.
     * @return immutable instance of AdvancedConfigResponse
     */
    public org.glowroot.local.ui.AdvancedConfigResponse build() {
      checkRequiredAttributes();
      return new AdvancedConfigResponse(config, timerWrapperMethodsActive);
    }
  
    private boolean configIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CONFIG) != 0;
    }
  
    private boolean timerWrapperMethodsActiveIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TIMER_WRAPPER_METHODS_ACTIVE) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of AdvancedConfigResponse is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!configIsSet()) {
        attributes.add("config");
      }
      if (!timerWrapperMethodsActiveIsSet()) {
        attributes.add("timerWrapperMethodsActive");
      }
      return "Cannot build AdvancedConfigResponse, some of required attributes are not set " + attributes;
    }
  }
}
