package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link InstrumentationJsonService.ClassNamesRequestBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ClassNamesRequest.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "InstrumentationJsonService.ClassNamesRequestBase"})
@Immutable
final class ClassNamesRequest
    extends InstrumentationJsonService.ClassNamesRequestBase {
  private final String partialClassName;
  private final int limit;

  private ClassNamesRequest(String partialClassName, int limit) {
    this.partialClassName = partialClassName;
    this.limit = limit;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code partialClassName} attribute
   */
  @JsonProperty("partialClassName")
  @Override
  public String partialClassName() {
    return partialClassName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code limit} attribute
   */
  @JsonProperty("limit")
  @Override
  public int limit() {
    return limit;
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationJsonService.ClassNamesRequestBase#partialClassName() partialClassName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for partialClassName
   * @return modified copy of the {@code this} object
   */
  public final ClassNamesRequest withPartialClassName(String value) {
    if (this.partialClassName == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ClassNamesRequest(newValue, this.limit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationJsonService.ClassNamesRequestBase#limit() limit}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for limit
   * @return modified copy of the {@code this} object
   */
  public final ClassNamesRequest withLimit(int value) {
    if (this.limit == value) {
      return this;
    }
    int newValue = value;
    return new ClassNamesRequest(this.partialClassName, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ClassNamesRequest} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof ClassNamesRequest && equalTo((ClassNamesRequest) another));
  }
  
  private boolean equalTo(ClassNamesRequest another) {
    return partialClassName.equals(another.partialClassName)
        && limit == another.limit;
  }
  
  /**
   * Computes hash code from attributes: {@code partialClassName}, {@code limit}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + partialClassName.hashCode();
    h = h * 17 + limit;
    return h;
  }
  
  /**
   * Prints immutable value {@code ClassNamesRequest{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ClassNamesRequest")
        .add("partialClassName", partialClassName)
        .add("limit", limit)
        .toString();
  }
  
  @JsonCreator
  public static ClassNamesRequest fromAllAttributes(
      @JsonProperty("partialClassName") @Nullable String partialClassName,
      @JsonProperty("limit") @Nullable Integer limit) {
    ClassNamesRequest.Builder builder = ClassNamesRequest.builder();
    if (partialClassName != null) {
      builder.partialClassName(partialClassName);
    }
    if (limit != null) {
      builder.limit(limit);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link InstrumentationJsonService.ClassNamesRequestBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable ClassNamesRequest instance
   */
  static ClassNamesRequest copyOf(InstrumentationJsonService.ClassNamesRequestBase instance) {
    if (instance instanceof ClassNamesRequest) {
      return (ClassNamesRequest) instance;
    }
    return ClassNamesRequest.builder()
        .partialClassName(instance.partialClassName())
        .limit(instance.limit())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.ClassNamesRequest}.
   * @return new ClassNamesRequest builder
   */
  static ClassNamesRequest.Builder builder() {
    return new ClassNamesRequest.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.ClassNamesRequest}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_PARTIAL_CLASS_NAME = 0x1L;
    private static final long INITIALIZED_BIT_LIMIT = 0x2L;
    private long initializedBitset;
  
    private @Nullable String partialClassName;
    private int limit;
    private Builder() {}
  
    /**
     * Initializes value for {@link InstrumentationJsonService.ClassNamesRequestBase#partialClassName() partialClassName}.
     * @param partialClassName value for partialClassName
     * @return {@code this} builder for chained invocation
     */
    public final Builder partialClassName(String partialClassName) {
      checkNotIsSet(partialClassNameIsSet(), "partialClassName");
      this.partialClassName = Preconditions.checkNotNull(partialClassName);
      initializedBitset |= INITIALIZED_BIT_PARTIAL_CLASS_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationJsonService.ClassNamesRequestBase#limit() limit}.
     * @param limit value for limit
     * @return {@code this} builder for chained invocation
     */
    public final Builder limit(int limit) {
      checkNotIsSet(limitIsSet(), "limit");
      this.limit = limit;
      initializedBitset |= INITIALIZED_BIT_LIMIT;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.ClassNamesRequest}.
     * @return immutable instance of ClassNamesRequest
     */
    public org.glowroot.local.ui.ClassNamesRequest build() {
      checkRequiredAttributes();
      return new ClassNamesRequest(partialClassName, limit);
    }
  
    private boolean partialClassNameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_PARTIAL_CLASS_NAME) != 0;
    }
  
    private boolean limitIsSet() {
      return (initializedBitset & INITIALIZED_BIT_LIMIT) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of ClassNamesRequest is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!partialClassNameIsSet()) {
        attributes.add("partialClassName");
      }
      if (!limitIsSet()) {
        attributes.add("limit");
      }
      return "Cannot build ClassNamesRequest, some of required attributes are not set " + attributes;
    }
  }
}
