package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link GaugeJsonService.GaugeConfigWithWarningMessagesBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code GaugeConfigWithWarningMessages.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "GaugeJsonService.GaugeConfigWithWarningMessagesBase"})
@Immutable
final class GaugeConfigWithWarningMessages
    extends GaugeJsonService.GaugeConfigWithWarningMessagesBase {
  private final GaugeConfigDto config;
  private final ImmutableList<String> warningMessages;

  private GaugeConfigWithWarningMessages(GaugeConfigDto config, ImmutableList<String> warningMessages) {
    this.config = config;
    this.warningMessages = warningMessages;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code config} attribute
   */
  @JsonProperty("config")
  @Override
  public GaugeConfigDto config() {
    return config;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code warningMessages} attribute
   */
  @JsonProperty("warningMessages")
  @Override
  public ImmutableList<String> warningMessages() {
    return warningMessages;
  }
  
  /**
   * Copy current immutable object by setting value for {@link GaugeJsonService.GaugeConfigWithWarningMessagesBase#config() config}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for config
   * @return modified copy of the {@code this} object
   */
  public final GaugeConfigWithWarningMessages withConfig(GaugeConfigDto value) {
    if (this.config == value) {
      return this;
    }
    GaugeConfigDto newValue = Preconditions.checkNotNull(value);
    return new GaugeConfigWithWarningMessages(newValue, this.warningMessages);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link GaugeJsonService.GaugeConfigWithWarningMessagesBase#warningMessages() warningMessages}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final GaugeConfigWithWarningMessages withWarningMessages(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new GaugeConfigWithWarningMessages(this.config, newValue);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link GaugeJsonService.GaugeConfigWithWarningMessagesBase#warningMessages() warningMessages}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of warningMessages elements to set
   * @return modified copy of {@code this} object
   */
  public final GaugeConfigWithWarningMessages withWarningMessages(Iterable<String> elements) {
    if (this.warningMessages == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new GaugeConfigWithWarningMessages(this.config, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code GaugeConfigWithWarningMessages} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof GaugeConfigWithWarningMessages && equalTo((GaugeConfigWithWarningMessages) another));
  }
  
  private boolean equalTo(GaugeConfigWithWarningMessages another) {
    return config.equals(another.config)
        && warningMessages.equals(another.warningMessages);
  }
  
  /**
   * Computes hash code from attributes: {@code config}, {@code warningMessages}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + config.hashCode();
    h = h * 17 + warningMessages.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code GaugeConfigWithWarningMessages{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GaugeConfigWithWarningMessages")
        .add("config", config)
        .add("warningMessages", warningMessages)
        .toString();
  }
  
  @JsonCreator
  public static GaugeConfigWithWarningMessages fromAllAttributes(
      @JsonProperty("config") @Nullable GaugeConfigDto config,
      @JsonProperty("warningMessages") @Nullable ImmutableList<String> warningMessages) {
    GaugeConfigWithWarningMessages.Builder builder = GaugeConfigWithWarningMessages.builder();
    if (config != null) {
      builder.config(config);
    }
    if (warningMessages != null) {
      builder.addAllWarningMessages(warningMessages);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link GaugeJsonService.GaugeConfigWithWarningMessagesBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable GaugeConfigWithWarningMessages instance
   */
  static GaugeConfigWithWarningMessages copyOf(GaugeJsonService.GaugeConfigWithWarningMessagesBase instance) {
    if (instance instanceof GaugeConfigWithWarningMessages) {
      return (GaugeConfigWithWarningMessages) instance;
    }
    return GaugeConfigWithWarningMessages.builder()
        .config(instance.config())
        .addAllWarningMessages(instance.warningMessages())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.GaugeConfigWithWarningMessages}.
   * @return new GaugeConfigWithWarningMessages builder
   */
  static GaugeConfigWithWarningMessages.Builder builder() {
    return new GaugeConfigWithWarningMessages.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.GaugeConfigWithWarningMessages}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x1;
    private static final long INITIALIZED_BIT_CONFIG = 0x1L;
    private long initializedBitset;
  
    private @Nullable GaugeConfigDto config;
    private ImmutableList.Builder<String> warningMessagesBuilder = ImmutableList.builder();
    private Builder() {}
  
    /**
     * Initializes value for {@link GaugeJsonService.GaugeConfigWithWarningMessagesBase#config() config}.
     * @param config value for config
     * @return {@code this} builder for chained invocation
     */
    public final Builder config(GaugeConfigDto config) {
      checkNotIsSet(configIsSet(), "config");
      this.config = Preconditions.checkNotNull(config);
      initializedBitset |= INITIALIZED_BIT_CONFIG;
      return this;
    }
  
    /**
     * Adds one element to {@link GaugeJsonService.GaugeConfigWithWarningMessagesBase#warningMessages() warningMessages} list.
     * @param element warningMessages element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addWarningMessages(String element) {
      warningMessagesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link GaugeJsonService.GaugeConfigWithWarningMessagesBase#warningMessages() warningMessages} list.
     * @param elements array of warningMessages elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addWarningMessages(String... elements) {
      warningMessagesBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link GaugeJsonService.GaugeConfigWithWarningMessagesBase#warningMessages() warningMessages} list.
     * @param elements iterable of warningMessages elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllWarningMessages(Iterable<String> elements) {
      warningMessagesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.GaugeConfigWithWarningMessages}.
     * @return immutable instance of GaugeConfigWithWarningMessages
     */
    public org.glowroot.local.ui.GaugeConfigWithWarningMessages build() {
      checkRequiredAttributes();
      return new GaugeConfigWithWarningMessages(config, warningMessagesBuilder.build());
    }
  
    private boolean configIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CONFIG) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of GaugeConfigWithWarningMessages is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!configIsSet()) {
        attributes.add("config");
      }
      return "Cannot build GaugeConfigWithWarningMessages, some of required attributes are not set " + attributes;
    }
  }
}
