package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link AggregateMerging.PercentileMergedAggregateBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code PercentileMergedAggregate.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AggregateMerging.PercentileMergedAggregateBase"})
@Immutable
public final class PercentileMergedAggregate
    extends AggregateMerging.PercentileMergedAggregateBase {
  private final long totalMicros;
  private final long transactionCount;
  private final ImmutableList<PercentileValue> percentileValues;

  private PercentileMergedAggregate(
      long totalMicros,
      long transactionCount,
      ImmutableList<PercentileValue> percentileValues) {
    this.totalMicros = totalMicros;
    this.transactionCount = transactionCount;
    this.percentileValues = percentileValues;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code totalMicros} attribute
   */
  @JsonProperty("totalMicros")
  @Override
  public long totalMicros() {
    return totalMicros;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionCount} attribute
   */
  @JsonProperty("transactionCount")
  @Override
  public long transactionCount() {
    return transactionCount;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code percentileValues} attribute
   */
  @JsonProperty("percentileValues")
  @Override
  public ImmutableList<PercentileValue> percentileValues() {
    return percentileValues;
  }
  
  /**
   * Copy current immutable object by setting value for {@link AggregateMerging.PercentileMergedAggregateBase#totalMicros() totalMicros}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for totalMicros
   * @return modified copy of the {@code this} object
   */
  public final PercentileMergedAggregate withTotalMicros(long value) {
    if (this.totalMicros == value) {
      return this;
    }
    long newValue = value;
    return new PercentileMergedAggregate(newValue, this.transactionCount, this.percentileValues);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AggregateMerging.PercentileMergedAggregateBase#transactionCount() transactionCount}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transactionCount
   * @return modified copy of the {@code this} object
   */
  public final PercentileMergedAggregate withTransactionCount(long value) {
    if (this.transactionCount == value) {
      return this;
    }
    long newValue = value;
    return new PercentileMergedAggregate(this.totalMicros, newValue, this.percentileValues);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link AggregateMerging.PercentileMergedAggregateBase#percentileValues() percentileValues}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final PercentileMergedAggregate withPercentileValues(PercentileValue... elements) {
    ImmutableList<PercentileValue> newValue = ImmutableList.copyOf(elements);
    return new PercentileMergedAggregate(this.totalMicros, this.transactionCount, newValue);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link AggregateMerging.PercentileMergedAggregateBase#percentileValues() percentileValues}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of percentileValues elements to set
   * @return modified copy of {@code this} object
   */
  public final PercentileMergedAggregate withPercentileValues(Iterable<? extends PercentileValue> elements) {
    if (this.percentileValues == elements) {
      return this;
    }
    ImmutableList<PercentileValue> newValue = ImmutableList.copyOf(elements);
    return new PercentileMergedAggregate(this.totalMicros, this.transactionCount, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code PercentileMergedAggregate} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof PercentileMergedAggregate && equalTo((PercentileMergedAggregate) another));
  }
  
  private boolean equalTo(PercentileMergedAggregate another) {
    return totalMicros == another.totalMicros
        && transactionCount == another.transactionCount
        && percentileValues.equals(another.percentileValues);
  }
  
  /**
   * Computes hash code from attributes: {@code totalMicros}, {@code transactionCount}, {@code percentileValues}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Longs.hashCode(totalMicros);
    h = h * 17 + Longs.hashCode(transactionCount);
    h = h * 17 + percentileValues.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code PercentileMergedAggregate{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PercentileMergedAggregate")
        .add("totalMicros", totalMicros)
        .add("transactionCount", transactionCount)
        .add("percentileValues", percentileValues)
        .toString();
  }
  
  @JsonCreator
  public static PercentileMergedAggregate fromAllAttributes(
      @JsonProperty("totalMicros") @Nullable Long totalMicros,
      @JsonProperty("transactionCount") @Nullable Long transactionCount,
      @JsonProperty("percentileValues") @Nullable ImmutableList<PercentileValue> percentileValues) {
    PercentileMergedAggregate.Builder builder = PercentileMergedAggregate.builder();
    if (totalMicros != null) {
      builder.totalMicros(totalMicros);
    }
    if (transactionCount != null) {
      builder.transactionCount(transactionCount);
    }
    if (percentileValues != null) {
      builder.addAllPercentileValues(percentileValues);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link AggregateMerging.PercentileMergedAggregateBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable PercentileMergedAggregate instance
   */
  public static PercentileMergedAggregate copyOf(AggregateMerging.PercentileMergedAggregateBase instance) {
    if (instance instanceof PercentileMergedAggregate) {
      return (PercentileMergedAggregate) instance;
    }
    return PercentileMergedAggregate.builder()
        .totalMicros(instance.totalMicros())
        .transactionCount(instance.transactionCount())
        .addAllPercentileValues(instance.percentileValues())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.PercentileMergedAggregate}.
   * @return new PercentileMergedAggregate builder
   */
  public static PercentileMergedAggregate.Builder builder() {
    return new PercentileMergedAggregate.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.PercentileMergedAggregate}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_TOTAL_MICROS = 0x1L;
    private static final long INITIALIZED_BIT_TRANSACTION_COUNT = 0x2L;
    private long initializedBitset;
  
    private long totalMicros;
    private long transactionCount;
    private ImmutableList.Builder<PercentileValue> percentileValuesBuilder = ImmutableList.builder();
    private Builder() {}
  
    /**
     * Initializes value for {@link AggregateMerging.PercentileMergedAggregateBase#totalMicros() totalMicros}.
     * @param totalMicros value for totalMicros
     * @return {@code this} builder for chained invocation
     */
    public final Builder totalMicros(long totalMicros) {
      checkNotIsSet(totalMicrosIsSet(), "totalMicros");
      this.totalMicros = totalMicros;
      initializedBitset |= INITIALIZED_BIT_TOTAL_MICROS;
      return this;
    }
  
    /**
     * Initializes value for {@link AggregateMerging.PercentileMergedAggregateBase#transactionCount() transactionCount}.
     * @param transactionCount value for transactionCount
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionCount(long transactionCount) {
      checkNotIsSet(transactionCountIsSet(), "transactionCount");
      this.transactionCount = transactionCount;
      initializedBitset |= INITIALIZED_BIT_TRANSACTION_COUNT;
      return this;
    }
  
    /**
     * Adds one element to {@link AggregateMerging.PercentileMergedAggregateBase#percentileValues() percentileValues} list.
     * @param element percentileValues element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addPercentileValues(PercentileValue element) {
      percentileValuesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link AggregateMerging.PercentileMergedAggregateBase#percentileValues() percentileValues} list.
     * @param elements array of percentileValues elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addPercentileValues(PercentileValue... elements) {
      percentileValuesBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link AggregateMerging.PercentileMergedAggregateBase#percentileValues() percentileValues} list.
     * @param elements iterable of percentileValues elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllPercentileValues(Iterable<? extends PercentileValue> elements) {
      percentileValuesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.PercentileMergedAggregate}.
     * @return immutable instance of PercentileMergedAggregate
     */
    public PercentileMergedAggregate build() {
      checkRequiredAttributes();
      return new PercentileMergedAggregate(totalMicros, transactionCount, percentileValuesBuilder.build());
    }
  
    private boolean totalMicrosIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TOTAL_MICROS) != 0;
    }
  
    private boolean transactionCountIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TRANSACTION_COUNT) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of PercentileMergedAggregate is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!totalMicrosIsSet()) {
        attributes.add("totalMicros");
      }
      if (!transactionCountIsSet()) {
        attributes.add("transactionCount");
      }
      return "Cannot build PercentileMergedAggregate, some of required attributes are not set " + attributes;
    }
  }
}
