package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link AggregateMerging.PercentileValueBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code PercentileValue.builder()}.
 * Use static factory method to create immutable instances:
 * {@code PercentileValue.of()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AggregateMerging.PercentileValueBase"})
@Immutable
public final class PercentileValue extends AggregateMerging.PercentileValueBase {
  private final String dataSeriesName;
  private final long value;

  private PercentileValue(String dataSeriesName, long value) {
    this.dataSeriesName = dataSeriesName;
    this.value = value;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code dataSeriesName} attribute
   */
  @JsonProperty("dataSeriesName")
  @Override
  public String dataSeriesName() {
    return dataSeriesName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code value} attribute
   */
  @JsonProperty("value")
  @Override
  public long value() {
    return value;
  }
  
  /**
   * Copy current immutable object by setting value for {@link AggregateMerging.PercentileValueBase#dataSeriesName() dataSeriesName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for dataSeriesName
   * @return modified copy of the {@code this} object
   */
  public final PercentileValue withDataSeriesName(String value) {
    if (this.dataSeriesName == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new PercentileValue(newValue, this.value);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AggregateMerging.PercentileValueBase#value() value}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for value
   * @return modified copy of the {@code this} object
   */
  public final PercentileValue withValue(long value) {
    if (this.value == value) {
      return this;
    }
    long newValue = value;
    return new PercentileValue(this.dataSeriesName, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code PercentileValue} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof PercentileValue && equalTo((PercentileValue) another));
  }
  
  private boolean equalTo(PercentileValue another) {
    return dataSeriesName.equals(another.dataSeriesName)
        && value == another.value;
  }
  
  /**
   * Computes hash code from attributes: {@code dataSeriesName}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + dataSeriesName.hashCode();
    h = h * 17 + Longs.hashCode(value);
    return h;
  }
  
  /**
   * Prints immutable value {@code PercentileValue{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PercentileValue")
        .add("dataSeriesName", dataSeriesName)
        .add("value", value)
        .toString();
  }
  
  @JsonCreator
  public static PercentileValue fromAllAttributes(
      @JsonProperty("dataSeriesName") @Nullable String dataSeriesName,
      @JsonProperty("value") @Nullable Long value) {
    PercentileValue.Builder builder = PercentileValue.builder();
    if (dataSeriesName != null) {
      builder.dataSeriesName(dataSeriesName);
    }
    if (value != null) {
      builder.value(value);
    }
    return builder.build();
  }

  /**
   * Construct new immutable {@code PercentileValue} instance.
   * @param dataSeriesName value for {@code dataSeriesName}
   * @param value value for {@code value}
   * @return immutable PercentileValue instance
   */
  public static org.glowroot.local.ui.PercentileValue of(String dataSeriesName, long value) {
    return new PercentileValue(dataSeriesName, value);
  }
  
  /**
   * Creates immutable copy of {@link AggregateMerging.PercentileValueBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable PercentileValue instance
   */
  public static PercentileValue copyOf(AggregateMerging.PercentileValueBase instance) {
    if (instance instanceof PercentileValue) {
      return (PercentileValue) instance;
    }
    return PercentileValue.builder()
        .dataSeriesName(instance.dataSeriesName())
        .value(instance.value())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.PercentileValue}.
   * @return new PercentileValue builder
   */
  public static PercentileValue.Builder builder() {
    return new PercentileValue.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.PercentileValue}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_DATA_SERIES_NAME = 0x1L;
    private static final long INITIALIZED_BIT_VALUE = 0x2L;
    private long initializedBitset;
  
    private @Nullable String dataSeriesName;
    private long value;
    private Builder() {}
  
    /**
     * Initializes value for {@link AggregateMerging.PercentileValueBase#dataSeriesName() dataSeriesName}.
     * @param dataSeriesName value for dataSeriesName
     * @return {@code this} builder for chained invocation
     */
    public final Builder dataSeriesName(String dataSeriesName) {
      checkNotIsSet(dataSeriesNameIsSet(), "dataSeriesName");
      this.dataSeriesName = Preconditions.checkNotNull(dataSeriesName);
      initializedBitset |= INITIALIZED_BIT_DATA_SERIES_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link AggregateMerging.PercentileValueBase#value() value}.
     * @param value value for value
     * @return {@code this} builder for chained invocation
     */
    public final Builder value(long value) {
      checkNotIsSet(valueIsSet(), "value");
      this.value = value;
      initializedBitset |= INITIALIZED_BIT_VALUE;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.PercentileValue}.
     * @return immutable instance of PercentileValue
     */
    public PercentileValue build() {
      checkRequiredAttributes();
      return new PercentileValue(dataSeriesName, value);
    }
  
    private boolean dataSeriesNameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_DATA_SERIES_NAME) != 0;
    }
  
    private boolean valueIsSet() {
      return (initializedBitset & INITIALIZED_BIT_VALUE) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of PercentileValue is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!dataSeriesNameIsSet()) {
        attributes.add("dataSeriesName");
      }
      if (!valueIsSet()) {
        attributes.add("value");
      }
      return "Cannot build PercentileValue, some of required attributes are not set " + attributes;
    }
  }
}
