package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link JvmJsonService.RequestWithDirectoryBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code RequestWithDirectory.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "JvmJsonService.RequestWithDirectoryBase"})
@Immutable
final class RequestWithDirectory extends JvmJsonService.RequestWithDirectoryBase {
  private final String directory;

  private RequestWithDirectory(String directory) {
    this.directory = directory;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code directory} attribute
   */
  @JsonProperty("directory")
  @Override
  public String directory() {
    return directory;
  }
  
  /**
   * Copy current immutable object by setting value for {@link JvmJsonService.RequestWithDirectoryBase#directory() directory}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for directory
   * @return modified copy of the {@code this} object
   */
  public final RequestWithDirectory withDirectory(String value) {
    if (this.directory == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new RequestWithDirectory(newValue);
  }
  
  /**
   * This instance is equal to instances of {@code RequestWithDirectory} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof RequestWithDirectory && equalTo((RequestWithDirectory) another));
  }
  
  private boolean equalTo(RequestWithDirectory another) {
    return directory.equals(another.directory);
  }
  
  /**
   * Computes hash code from attributes: {@code directory}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + directory.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code RequestWithDirectory{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RequestWithDirectory")
        .add("directory", directory)
        .toString();
  }
  
  @JsonCreator
  public static RequestWithDirectory fromAllAttributes(
      @JsonProperty("directory") @Nullable String directory) {
    RequestWithDirectory.Builder builder = RequestWithDirectory.builder();
    if (directory != null) {
      builder.directory(directory);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link JvmJsonService.RequestWithDirectoryBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable RequestWithDirectory instance
   */
  static RequestWithDirectory copyOf(JvmJsonService.RequestWithDirectoryBase instance) {
    if (instance instanceof RequestWithDirectory) {
      return (RequestWithDirectory) instance;
    }
    return RequestWithDirectory.builder()
        .directory(instance.directory())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.RequestWithDirectory}.
   * @return new RequestWithDirectory builder
   */
  static RequestWithDirectory.Builder builder() {
    return new RequestWithDirectory.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.RequestWithDirectory}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x1;
    private static final long INITIALIZED_BIT_DIRECTORY = 0x1L;
    private long initializedBitset;
  
    private @Nullable String directory;
    private Builder() {}
  
    /**
     * Initializes value for {@link JvmJsonService.RequestWithDirectoryBase#directory() directory}.
     * @param directory value for directory
     * @return {@code this} builder for chained invocation
     */
    public final Builder directory(String directory) {
      checkNotIsSet(directoryIsSet(), "directory");
      this.directory = Preconditions.checkNotNull(directory);
      initializedBitset |= INITIALIZED_BIT_DIRECTORY;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.RequestWithDirectory}.
     * @return immutable instance of RequestWithDirectory
     */
    public org.glowroot.local.ui.RequestWithDirectory build() {
      checkRequiredAttributes();
      return new RequestWithDirectory(directory);
    }
  
    private boolean directoryIsSet() {
      return (initializedBitset & INITIALIZED_BIT_DIRECTORY) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of RequestWithDirectory is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!directoryIsSet()) {
        attributes.add("directory");
      }
      return "Cannot build RequestWithDirectory, some of required attributes are not set " + attributes;
    }
  }
}
