package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ConfigJsonService.SmtpConfigResponseBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code SmtpConfigResponse.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConfigJsonService.SmtpConfigResponseBase"})
@Immutable
final class SmtpConfigResponse extends ConfigJsonService.SmtpConfigResponseBase {
  private final SmtpConfigDto config;
  private final String localServerName;

  private SmtpConfigResponse(SmtpConfigDto config, String localServerName) {
    this.config = config;
    this.localServerName = localServerName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code config} attribute
   */
  @JsonProperty("config")
  @Override
  public SmtpConfigDto config() {
    return config;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code localServerName} attribute
   */
  @JsonProperty("localServerName")
  @Override
  public String localServerName() {
    return localServerName;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.SmtpConfigResponseBase#config() config}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for config
   * @return modified copy of the {@code this} object
   */
  public final SmtpConfigResponse withConfig(SmtpConfigDto value) {
    if (this.config == value) {
      return this;
    }
    SmtpConfigDto newValue = Preconditions.checkNotNull(value);
    return new SmtpConfigResponse(newValue, this.localServerName);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.SmtpConfigResponseBase#localServerName() localServerName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for localServerName
   * @return modified copy of the {@code this} object
   */
  public final SmtpConfigResponse withLocalServerName(String value) {
    if (this.localServerName == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new SmtpConfigResponse(this.config, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code SmtpConfigResponse} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof SmtpConfigResponse && equalTo((SmtpConfigResponse) another));
  }
  
  private boolean equalTo(SmtpConfigResponse another) {
    return config.equals(another.config)
        && localServerName.equals(another.localServerName);
  }
  
  /**
   * Computes hash code from attributes: {@code config}, {@code localServerName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + config.hashCode();
    h = h * 17 + localServerName.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code SmtpConfigResponse{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SmtpConfigResponse")
        .add("config", config)
        .add("localServerName", localServerName)
        .toString();
  }
  
  @JsonCreator
  public static SmtpConfigResponse fromAllAttributes(
      @JsonProperty("config") @Nullable SmtpConfigDto config,
      @JsonProperty("localServerName") @Nullable String localServerName) {
    SmtpConfigResponse.Builder builder = SmtpConfigResponse.builder();
    if (config != null) {
      builder.config(config);
    }
    if (localServerName != null) {
      builder.localServerName(localServerName);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link ConfigJsonService.SmtpConfigResponseBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable SmtpConfigResponse instance
   */
  static SmtpConfigResponse copyOf(ConfigJsonService.SmtpConfigResponseBase instance) {
    if (instance instanceof SmtpConfigResponse) {
      return (SmtpConfigResponse) instance;
    }
    return SmtpConfigResponse.builder()
        .config(instance.config())
        .localServerName(instance.localServerName())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.SmtpConfigResponse}.
   * @return new SmtpConfigResponse builder
   */
  static SmtpConfigResponse.Builder builder() {
    return new SmtpConfigResponse.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.SmtpConfigResponse}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_CONFIG = 0x1L;
    private static final long INITIALIZED_BIT_LOCAL_SERVER_NAME = 0x2L;
    private long initializedBitset;
  
    private @Nullable SmtpConfigDto config;
    private @Nullable String localServerName;
    private Builder() {}
  
    /**
     * Initializes value for {@link ConfigJsonService.SmtpConfigResponseBase#config() config}.
     * @param config value for config
     * @return {@code this} builder for chained invocation
     */
    public final Builder config(SmtpConfigDto config) {
      checkNotIsSet(configIsSet(), "config");
      this.config = Preconditions.checkNotNull(config);
      initializedBitset |= INITIALIZED_BIT_CONFIG;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.SmtpConfigResponseBase#localServerName() localServerName}.
     * @param localServerName value for localServerName
     * @return {@code this} builder for chained invocation
     */
    public final Builder localServerName(String localServerName) {
      checkNotIsSet(localServerNameIsSet(), "localServerName");
      this.localServerName = Preconditions.checkNotNull(localServerName);
      initializedBitset |= INITIALIZED_BIT_LOCAL_SERVER_NAME;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.SmtpConfigResponse}.
     * @return immutable instance of SmtpConfigResponse
     */
    public org.glowroot.local.ui.SmtpConfigResponse build() {
      checkRequiredAttributes();
      return new SmtpConfigResponse(config, localServerName);
    }
  
    private boolean configIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CONFIG) != 0;
    }
  
    private boolean localServerNameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_LOCAL_SERVER_NAME) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of SmtpConfigResponse is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!configIsSet()) {
        attributes.add("config");
      }
      if (!localServerNameIsSet()) {
        attributes.add("localServerName");
      }
      return "Cannot build SmtpConfigResponse, some of required attributes are not set " + attributes;
    }
  }
}
