package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link JvmJsonService.ThreadDumpItemBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ThreadDumpItem.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "JvmJsonService.ThreadDumpItemBase"})
@Immutable
final class ThreadDumpItem extends JvmJsonService.ThreadDumpItemBase {
  private final String objectName;

  private ThreadDumpItem(String objectName) {
    this.objectName = objectName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code objectName} attribute
   */
  @JsonProperty("objectName")
  @Override
  public String objectName() {
    return objectName;
  }
  
  /**
   * Copy current immutable object by setting value for {@link JvmJsonService.ThreadDumpItemBase#objectName() objectName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for objectName
   * @return modified copy of the {@code this} object
   */
  public final ThreadDumpItem withObjectName(String value) {
    if (this.objectName == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ThreadDumpItem(newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ThreadDumpItem} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof ThreadDumpItem && equalTo((ThreadDumpItem) another));
  }
  
  private boolean equalTo(ThreadDumpItem another) {
    return objectName.equals(another.objectName);
  }
  
  /**
   * Computes hash code from attributes: {@code objectName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + objectName.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code ThreadDumpItem{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ThreadDumpItem")
        .add("objectName", objectName)
        .toString();
  }
  
  @JsonCreator
  public static ThreadDumpItem fromAllAttributes(
      @JsonProperty("objectName") @Nullable String objectName) {
    ThreadDumpItem.Builder builder = ThreadDumpItem.builder();
    if (objectName != null) {
      builder.objectName(objectName);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link JvmJsonService.ThreadDumpItemBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable ThreadDumpItem instance
   */
  static ThreadDumpItem copyOf(JvmJsonService.ThreadDumpItemBase instance) {
    if (instance instanceof ThreadDumpItem) {
      return (ThreadDumpItem) instance;
    }
    return ThreadDumpItem.builder()
        .objectName(instance.objectName())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.ThreadDumpItem}.
   * @return new ThreadDumpItem builder
   */
  static ThreadDumpItem.Builder builder() {
    return new ThreadDumpItem.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.ThreadDumpItem}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x1;
    private static final long INITIALIZED_BIT_OBJECT_NAME = 0x1L;
    private long initializedBitset;
  
    private @Nullable String objectName;
    private Builder() {}
  
    /**
     * Initializes value for {@link JvmJsonService.ThreadDumpItemBase#objectName() objectName}.
     * @param objectName value for objectName
     * @return {@code this} builder for chained invocation
     */
    public final Builder objectName(String objectName) {
      checkNotIsSet(objectNameIsSet(), "objectName");
      this.objectName = Preconditions.checkNotNull(objectName);
      initializedBitset |= INITIALIZED_BIT_OBJECT_NAME;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.ThreadDumpItem}.
     * @return immutable instance of ThreadDumpItem
     */
    public org.glowroot.local.ui.ThreadDumpItem build() {
      checkRequiredAttributes();
      return new ThreadDumpItem(objectName);
    }
  
    private boolean objectNameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_OBJECT_NAME) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of ThreadDumpItem is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!objectNameIsSet()) {
        attributes.add("objectName");
      }
      return "Cannot build ThreadDumpItem, some of required attributes are not set " + attributes;
    }
  }
}
