package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Doubles;
import org.glowroot.shaded.google.common.primitives.Longs;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link TransactionJsonService.TransactionProfileRequestBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code TransactionProfileRequest.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "TransactionJsonService.TransactionProfileRequestBase"})
@Immutable
final class TransactionProfileRequest
    extends TransactionJsonService.TransactionProfileRequestBase {
  private final long from;
  private final long to;
  private final String transactionType;
  private final @Nullable String transactionName;
  private final @Nullable String filter;
  private final double truncateLeafPercentage;

  private TransactionProfileRequest(
      long from,
      long to,
      String transactionType,
      @Nullable String transactionName,
      @Nullable String filter,
      double truncateLeafPercentage) {
    this.from = from;
    this.to = to;
    this.transactionType = transactionType;
    this.transactionName = transactionName;
    this.filter = filter;
    this.truncateLeafPercentage = truncateLeafPercentage;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code from} attribute
   */
  @JsonProperty("from")
  @Override
  public long from() {
    return from;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code to} attribute
   */
  @JsonProperty("to")
  @Override
  public long to() {
    return to;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionType} attribute
   */
  @JsonProperty("transactionType")
  @Override
  public String transactionType() {
    return transactionType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionName} attribute
   */
  @JsonProperty("transactionName")
  @Override
  public String transactionName() {
    return transactionName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code filter} attribute
   */
  @JsonProperty("filter")
  @Override
  public String filter() {
    return filter;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code truncateLeafPercentage} attribute
   */
  @JsonProperty("truncateLeafPercentage")
  @Override
  public double truncateLeafPercentage() {
    return truncateLeafPercentage;
  }
  
  /**
   * Copy current immutable object by setting value for {@link TransactionJsonService.TransactionProfileRequestBase#from() from}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for from
   * @return modified copy of the {@code this} object
   */
  public final TransactionProfileRequest withFrom(long value) {
    if (this.from == value) {
      return this;
    }
    long newValue = value;
    return new TransactionProfileRequest(
        newValue,
        this.to,
        this.transactionType,
        this.transactionName,
        this.filter,
        this.truncateLeafPercentage);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TransactionJsonService.TransactionProfileRequestBase#to() to}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for to
   * @return modified copy of the {@code this} object
   */
  public final TransactionProfileRequest withTo(long value) {
    if (this.to == value) {
      return this;
    }
    long newValue = value;
    return new TransactionProfileRequest(
        this.from,
        newValue,
        this.transactionType,
        this.transactionName,
        this.filter,
        this.truncateLeafPercentage);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TransactionJsonService.TransactionProfileRequestBase#transactionType() transactionType}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transactionType
   * @return modified copy of the {@code this} object
   */
  public final TransactionProfileRequest withTransactionType(String value) {
    if (this.transactionType == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new TransactionProfileRequest(this.from, this.to, newValue, this.transactionName, this.filter, this.truncateLeafPercentage);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TransactionJsonService.TransactionProfileRequestBase#transactionName() transactionName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transactionName, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final TransactionProfileRequest withTransactionName(@Nullable String value) {
    if (this.transactionName == value) {
      return this;
    }
    @Nullable String newValue = value;
    return new TransactionProfileRequest(this.from, this.to, this.transactionType, newValue, this.filter, this.truncateLeafPercentage);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TransactionJsonService.TransactionProfileRequestBase#filter() filter}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for filter, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final TransactionProfileRequest withFilter(@Nullable String value) {
    if (this.filter == value) {
      return this;
    }
    @Nullable String newValue = value;
    return new TransactionProfileRequest(
        this.from,
        this.to,
        this.transactionType,
        this.transactionName,
        newValue,
        this.truncateLeafPercentage);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TransactionJsonService.TransactionProfileRequestBase#truncateLeafPercentage() truncateLeafPercentage}.
   * @param value new value for truncateLeafPercentage
   * @return modified copy of the {@code this} object
   */
  public final TransactionProfileRequest withTruncateLeafPercentage(double value) {
    double newValue = value;
    return new TransactionProfileRequest(this.from, this.to, this.transactionType, this.transactionName, this.filter, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code TransactionProfileRequest} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof TransactionProfileRequest && equalTo((TransactionProfileRequest) another));
  }
  
  private boolean equalTo(TransactionProfileRequest another) {
    return from == another.from
        && to == another.to
        && transactionType.equals(another.transactionType)
        && Objects.equal(transactionName, another.transactionName)
        && Objects.equal(filter, another.filter)
        && Double.doubleToLongBits(truncateLeafPercentage) == Double.doubleToLongBits(another.truncateLeafPercentage);
  }
  
  /**
   * Computes hash code from attributes: {@code from}, {@code to}, {@code transactionType}, {@code transactionName}, {@code filter}, {@code truncateLeafPercentage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Longs.hashCode(from);
    h = h * 17 + Longs.hashCode(to);
    h = h * 17 + transactionType.hashCode();
    h = h * 17 + Objects.hashCode(transactionName);
    h = h * 17 + Objects.hashCode(filter);
    h = h * 17 + Doubles.hashCode(truncateLeafPercentage);
    return h;
  }
  
  /**
   * Prints immutable value {@code TransactionProfileRequest{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TransactionProfileRequest")
        .add("from", from)
        .add("to", to)
        .add("transactionType", transactionType)
        .add("transactionName", transactionName)
        .add("filter", filter)
        .add("truncateLeafPercentage", truncateLeafPercentage)
        .toString();
  }
  
  @JsonCreator
  public static TransactionProfileRequest fromAllAttributes(
      @JsonProperty("from") @Nullable Long from,
      @JsonProperty("to") @Nullable Long to,
      @JsonProperty("transactionType") @Nullable String transactionType,
      @JsonProperty("transactionName") @Nullable String transactionName,
      @JsonProperty("filter") @Nullable String filter,
      @JsonProperty("truncateLeafPercentage") @Nullable java.lang.Double truncateLeafPercentage) {
    TransactionProfileRequest.Builder builder = TransactionProfileRequest.builder();
    if (from != null) {
      builder.from(from);
    }
    if (to != null) {
      builder.to(to);
    }
    if (transactionType != null) {
      builder.transactionType(transactionType);
    }
    if (transactionName != null) {
      builder.transactionName(transactionName);
    }
    if (filter != null) {
      builder.filter(filter);
    }
    if (truncateLeafPercentage != null) {
      builder.truncateLeafPercentage(truncateLeafPercentage);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link TransactionJsonService.TransactionProfileRequestBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable TransactionProfileRequest instance
   */
  static TransactionProfileRequest copyOf(TransactionJsonService.TransactionProfileRequestBase instance) {
    if (instance instanceof TransactionProfileRequest) {
      return (TransactionProfileRequest) instance;
    }
    return TransactionProfileRequest.builder()
        .from(instance.from())
        .to(instance.to())
        .transactionType(instance.transactionType())
        .transactionName(instance.transactionName())
        .filter(instance.filter())
        .truncateLeafPercentage(instance.truncateLeafPercentage())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.TransactionProfileRequest}.
   * @return new TransactionProfileRequest builder
   */
  static TransactionProfileRequest.Builder builder() {
    return new TransactionProfileRequest.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.TransactionProfileRequest}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0xf;
    private static final long INITIALIZED_BIT_FROM = 0x1L;
    private static final long INITIALIZED_BIT_TO = 0x2L;
    private static final long INITIALIZED_BIT_TRANSACTION_TYPE = 0x4L;
    private static final long INITIALIZED_BIT_TRUNCATE_LEAF_PERCENTAGE = 0x8L;
    private static final long NONDEFAULT_BIT_TRANSACTION_NAME = 0x1L;
    private static final long NONDEFAULT_BIT_FILTER = 0x2L;
    private long initializedBitset;
    private long nondefaultBitset;
  
    private long from;
    private long to;
    private @Nullable String transactionType;
    private @Nullable String transactionName;
    private @Nullable String filter;
    private double truncateLeafPercentage;
    private Builder() {}
  
    /**
     * Initializes value for {@link TransactionJsonService.TransactionProfileRequestBase#from() from}.
     * @param from value for from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(long from) {
      checkNotIsSet(fromIsSet(), "from");
      this.from = from;
      initializedBitset |= INITIALIZED_BIT_FROM;
      return this;
    }
  
    /**
     * Initializes value for {@link TransactionJsonService.TransactionProfileRequestBase#to() to}.
     * @param to value for to
     * @return {@code this} builder for chained invocation
     */
    public final Builder to(long to) {
      checkNotIsSet(toIsSet(), "to");
      this.to = to;
      initializedBitset |= INITIALIZED_BIT_TO;
      return this;
    }
  
    /**
     * Initializes value for {@link TransactionJsonService.TransactionProfileRequestBase#transactionType() transactionType}.
     * @param transactionType value for transactionType
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionType(String transactionType) {
      checkNotIsSet(transactionTypeIsSet(), "transactionType");
      this.transactionType = Preconditions.checkNotNull(transactionType);
      initializedBitset |= INITIALIZED_BIT_TRANSACTION_TYPE;
      return this;
    }
  
    /**
     * Initializes value for {@link TransactionJsonService.TransactionProfileRequestBase#transactionName() transactionName}.
     * @param transactionName value for transactionName, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionName(@Nullable String transactionName) {
      checkNotIsSet(transactionNameIsSet(), "transactionName");
      this.transactionName = transactionName;
      nondefaultBitset |= NONDEFAULT_BIT_TRANSACTION_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link TransactionJsonService.TransactionProfileRequestBase#filter() filter}.
     * @param filter value for filter, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder filter(@Nullable String filter) {
      checkNotIsSet(filterIsSet(), "filter");
      this.filter = filter;
      nondefaultBitset |= NONDEFAULT_BIT_FILTER;
      return this;
    }
  
    /**
     * Initializes value for {@link TransactionJsonService.TransactionProfileRequestBase#truncateLeafPercentage() truncateLeafPercentage}.
     * @param truncateLeafPercentage value for truncateLeafPercentage
     * @return {@code this} builder for chained invocation
     */
    public final Builder truncateLeafPercentage(double truncateLeafPercentage) {
      checkNotIsSet(truncateLeafPercentageIsSet(), "truncateLeafPercentage");
      this.truncateLeafPercentage = truncateLeafPercentage;
      initializedBitset |= INITIALIZED_BIT_TRUNCATE_LEAF_PERCENTAGE;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.TransactionProfileRequest}.
     * @return immutable instance of TransactionProfileRequest
     */
    public org.glowroot.local.ui.TransactionProfileRequest build() {
      checkRequiredAttributes();
      return new TransactionProfileRequest(from, to, transactionType, transactionName, filter, truncateLeafPercentage);
    }
  
    private boolean transactionNameIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TRANSACTION_NAME) != 0;
    }
  
    private boolean filterIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_FILTER) != 0;
    }
  
    private boolean fromIsSet() {
      return (initializedBitset & INITIALIZED_BIT_FROM) != 0;
    }
  
    private boolean toIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TO) != 0;
    }
  
    private boolean transactionTypeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TRANSACTION_TYPE) != 0;
    }
  
    private boolean truncateLeafPercentageIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TRUNCATE_LEAF_PERCENTAGE) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of TransactionProfileRequest is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!fromIsSet()) {
        attributes.add("from");
      }
      if (!toIsSet()) {
        attributes.add("to");
      }
      if (!transactionTypeIsSet()) {
        attributes.add("transactionType");
      }
      if (!truncateLeafPercentageIsSet()) {
        attributes.add("truncateLeafPercentage");
      }
      return "Cannot build TransactionProfileRequest, some of required attributes are not set " + attributes;
    }
  }
}
