package org.glowroot.transaction.model;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link Profile.StackTraceElementPlusBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code StackTraceElementPlus.builder()}.
 * Use static factory method to create immutable instances:
 * {@code StackTraceElementPlus.of()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "Profile.StackTraceElementPlusBase"})
@Immutable
public final class StackTraceElementPlus
    extends Profile.StackTraceElementPlusBase {
  private final StackTraceElement stackTraceElement;
  private final ImmutableList<String> timerNames;

  private StackTraceElementPlus(StackTraceElement stackTraceElement, Iterable<String> timerNames) {
    this.stackTraceElement = Preconditions.checkNotNull(stackTraceElement);
    this.timerNames = ImmutableList.copyOf(timerNames);
  }

  private StackTraceElementPlus(
      StackTraceElementPlus original,
      StackTraceElement stackTraceElement,
      ImmutableList<String> timerNames) {
    this.stackTraceElement = stackTraceElement;
    this.timerNames = timerNames;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code stackTraceElement} attribute
   */
  @JsonProperty("stackTraceElement")
  @Override
  public StackTraceElement stackTraceElement() {
    return stackTraceElement;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code timerNames} attribute
   */
  @JsonProperty("timerNames")
  @Override
  public ImmutableList<String> timerNames() {
    return timerNames;
  }
  
  /**
   * Copy current immutable object by setting value for {@link Profile.StackTraceElementPlusBase#stackTraceElement() stackTraceElement}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for stackTraceElement
   * @return modified copy of the {@code this} object
   */
  public final StackTraceElementPlus withStackTraceElement(StackTraceElement value) {
    if (this.stackTraceElement == value) {
      return this;
    }
    StackTraceElement newValue = Preconditions.checkNotNull(value);
    return new StackTraceElementPlus(this, newValue, this.timerNames);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link Profile.StackTraceElementPlusBase#timerNames() timerNames}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final StackTraceElementPlus withTimerNames(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new StackTraceElementPlus(this, this.stackTraceElement, newValue);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link Profile.StackTraceElementPlusBase#timerNames() timerNames}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of timerNames elements to set
   * @return modified copy of {@code this} object
   */
  public final StackTraceElementPlus withTimerNames(Iterable<String> elements) {
    if (this.timerNames == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new StackTraceElementPlus(this, this.stackTraceElement, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code StackTraceElementPlus} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof StackTraceElementPlus && equalTo((StackTraceElementPlus) another));
  }
  
  private boolean equalTo(StackTraceElementPlus another) {
    return stackTraceElement.equals(another.stackTraceElement)
        && timerNames.equals(another.timerNames);
  }
  
  /**
   * Computes hash code from attributes: {@code stackTraceElement}, {@code timerNames}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + stackTraceElement.hashCode();
    h = h * 17 + timerNames.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code StackTraceElementPlus{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("StackTraceElementPlus")
        .add("stackTraceElement", stackTraceElement)
        .add("timerNames", timerNames)
        .toString();
  }
  
  @JsonCreator
  public static StackTraceElementPlus fromAllAttributes(
      @JsonProperty("stackTraceElement") @Nullable StackTraceElement stackTraceElement,
      @JsonProperty("timerNames") @Nullable ImmutableList<String> timerNames) {
    StackTraceElementPlus.Builder builder = StackTraceElementPlus.builder();
    if (stackTraceElement != null) {
      builder.stackTraceElement(stackTraceElement);
    }
    if (timerNames != null) {
      builder.addAllTimerNames(timerNames);
    }
    return builder.build();
  }

  /**
   * Construct new immutable {@code StackTraceElementPlus} instance.
   * @param stackTraceElement value for {@code stackTraceElement}
   * @param timerNames value for {@code timerNames}
   * @return immutable StackTraceElementPlus instance
   */
  public static org.glowroot.transaction.model.StackTraceElementPlus of(StackTraceElement stackTraceElement, ImmutableList<String> timerNames) {
    return of(stackTraceElement, (Iterable<String>) timerNames);
  }

  /**
   * Construct new immutable {@code StackTraceElementPlus} instance.
   * @param stackTraceElement value for {@code stackTraceElement}
   * @param timerNames value for {@code timerNames}
   * @return immutable StackTraceElementPlus instance
   */
  public static org.glowroot.transaction.model.StackTraceElementPlus of(StackTraceElement stackTraceElement, Iterable<String> timerNames) {
    return new StackTraceElementPlus(stackTraceElement, timerNames);
  }
  
  /**
   * Creates immutable copy of {@link Profile.StackTraceElementPlusBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable StackTraceElementPlus instance
   */
  public static StackTraceElementPlus copyOf(Profile.StackTraceElementPlusBase instance) {
    if (instance instanceof StackTraceElementPlus) {
      return (StackTraceElementPlus) instance;
    }
    return StackTraceElementPlus.builder()
        .stackTraceElement(instance.stackTraceElement())
        .addAllTimerNames(instance.timerNames())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.transaction.model.StackTraceElementPlus}.
   * @return new StackTraceElementPlus builder
   */
  public static StackTraceElementPlus.Builder builder() {
    return new StackTraceElementPlus.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.transaction.model.StackTraceElementPlus}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x1;
    private static final long INITIALIZED_BIT_STACK_TRACE_ELEMENT = 0x1L;
    private long initializedBitset;
  
    private @Nullable StackTraceElement stackTraceElement;
    private ImmutableList.Builder<String> timerNamesBuilder = ImmutableList.builder();
    private Builder() {}
  
    /**
     * Initializes value for {@link Profile.StackTraceElementPlusBase#stackTraceElement() stackTraceElement}.
     * @param stackTraceElement value for stackTraceElement
     * @return {@code this} builder for chained invocation
     */
    public final Builder stackTraceElement(StackTraceElement stackTraceElement) {
      checkNotIsSet(stackTraceElementIsSet(), "stackTraceElement");
      this.stackTraceElement = Preconditions.checkNotNull(stackTraceElement);
      initializedBitset |= INITIALIZED_BIT_STACK_TRACE_ELEMENT;
      return this;
    }
  
    /**
     * Adds one element to {@link Profile.StackTraceElementPlusBase#timerNames() timerNames} list.
     * @param element timerNames element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addTimerNames(String element) {
      timerNamesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link Profile.StackTraceElementPlusBase#timerNames() timerNames} list.
     * @param elements array of timerNames elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addTimerNames(String... elements) {
      timerNamesBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link Profile.StackTraceElementPlusBase#timerNames() timerNames} list.
     * @param elements iterable of timerNames elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllTimerNames(Iterable<String> elements) {
      timerNamesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.transaction.model.StackTraceElementPlus}.
     * @return immutable instance of StackTraceElementPlus
     */
    public StackTraceElementPlus build() {
      checkRequiredAttributes();
      return new StackTraceElementPlus(null, stackTraceElement, timerNamesBuilder.build());
    }
  
    private boolean stackTraceElementIsSet() {
      return (initializedBitset & INITIALIZED_BIT_STACK_TRACE_ELEMENT) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of StackTraceElementPlus is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!stackTraceElementIsSet()) {
        attributes.add("stackTraceElement");
      }
      return "Cannot build StackTraceElementPlus, some of required attributes are not set " + attributes;
    }
  }
}
