package org.glowroot.transaction.model;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ThreadInfoComponent.ThreadInfoDataBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ThreadInfoData.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ThreadInfoComponent.ThreadInfoDataBase"})
@Immutable
public final class ThreadInfoData
    extends ThreadInfoComponent.ThreadInfoDataBase {
  private final @Nullable Long threadCpuTime;
  private final @Nullable Long threadBlockedTime;
  private final @Nullable Long threadWaitedTime;
  private final @Nullable Long threadAllocatedBytes;

  private ThreadInfoData(
      @Nullable Long threadCpuTime,
      @Nullable Long threadBlockedTime,
      @Nullable Long threadWaitedTime,
      @Nullable Long threadAllocatedBytes) {
    this.threadCpuTime = threadCpuTime;
    this.threadBlockedTime = threadBlockedTime;
    this.threadWaitedTime = threadWaitedTime;
    this.threadAllocatedBytes = threadAllocatedBytes;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code threadCpuTime} attribute
   */
  @JsonProperty("threadCpuTime")
  @Override
  public Long threadCpuTime() {
    return threadCpuTime;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code threadBlockedTime} attribute
   */
  @JsonProperty("threadBlockedTime")
  @Override
  public Long threadBlockedTime() {
    return threadBlockedTime;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code threadWaitedTime} attribute
   */
  @JsonProperty("threadWaitedTime")
  @Override
  public Long threadWaitedTime() {
    return threadWaitedTime;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code threadAllocatedBytes} attribute
   */
  @JsonProperty("threadAllocatedBytes")
  @Override
  public Long threadAllocatedBytes() {
    return threadAllocatedBytes;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ThreadInfoComponent.ThreadInfoDataBase#threadCpuTime() threadCpuTime}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for threadCpuTime, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final ThreadInfoData withThreadCpuTime(@Nullable Long value) {
    if (this.threadCpuTime == value) {
      return this;
    }
    @Nullable Long newValue = value;
    return new ThreadInfoData(newValue, this.threadBlockedTime, this.threadWaitedTime, this.threadAllocatedBytes);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ThreadInfoComponent.ThreadInfoDataBase#threadBlockedTime() threadBlockedTime}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for threadBlockedTime, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final ThreadInfoData withThreadBlockedTime(@Nullable Long value) {
    if (this.threadBlockedTime == value) {
      return this;
    }
    @Nullable Long newValue = value;
    return new ThreadInfoData(this.threadCpuTime, newValue, this.threadWaitedTime, this.threadAllocatedBytes);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ThreadInfoComponent.ThreadInfoDataBase#threadWaitedTime() threadWaitedTime}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for threadWaitedTime, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final ThreadInfoData withThreadWaitedTime(@Nullable Long value) {
    if (this.threadWaitedTime == value) {
      return this;
    }
    @Nullable Long newValue = value;
    return new ThreadInfoData(this.threadCpuTime, this.threadBlockedTime, newValue, this.threadAllocatedBytes);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ThreadInfoComponent.ThreadInfoDataBase#threadAllocatedBytes() threadAllocatedBytes}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for threadAllocatedBytes, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final ThreadInfoData withThreadAllocatedBytes(@Nullable Long value) {
    if (this.threadAllocatedBytes == value) {
      return this;
    }
    @Nullable Long newValue = value;
    return new ThreadInfoData(this.threadCpuTime, this.threadBlockedTime, this.threadWaitedTime, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ThreadInfoData} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof ThreadInfoData && equalTo((ThreadInfoData) another));
  }
  
  private boolean equalTo(ThreadInfoData another) {
    return Objects.equal(threadCpuTime, another.threadCpuTime)
        && Objects.equal(threadBlockedTime, another.threadBlockedTime)
        && Objects.equal(threadWaitedTime, another.threadWaitedTime)
        && Objects.equal(threadAllocatedBytes, another.threadAllocatedBytes);
  }
  
  /**
   * Computes hash code from attributes: {@code threadCpuTime}, {@code threadBlockedTime}, {@code threadWaitedTime}, {@code threadAllocatedBytes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(threadCpuTime);
    h = h * 17 + Objects.hashCode(threadBlockedTime);
    h = h * 17 + Objects.hashCode(threadWaitedTime);
    h = h * 17 + Objects.hashCode(threadAllocatedBytes);
    return h;
  }
  
  /**
   * Prints immutable value {@code ThreadInfoData{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ThreadInfoData")
        .add("threadCpuTime", threadCpuTime)
        .add("threadBlockedTime", threadBlockedTime)
        .add("threadWaitedTime", threadWaitedTime)
        .add("threadAllocatedBytes", threadAllocatedBytes)
        .toString();
  }
  
  @JsonCreator
  public static ThreadInfoData fromAllAttributes(
      @JsonProperty("threadCpuTime") @Nullable Long threadCpuTime,
      @JsonProperty("threadBlockedTime") @Nullable Long threadBlockedTime,
      @JsonProperty("threadWaitedTime") @Nullable Long threadWaitedTime,
      @JsonProperty("threadAllocatedBytes") @Nullable Long threadAllocatedBytes) {
    ThreadInfoData.Builder builder = ThreadInfoData.builder();
    if (threadCpuTime != null) {
      builder.threadCpuTime(threadCpuTime);
    }
    if (threadBlockedTime != null) {
      builder.threadBlockedTime(threadBlockedTime);
    }
    if (threadWaitedTime != null) {
      builder.threadWaitedTime(threadWaitedTime);
    }
    if (threadAllocatedBytes != null) {
      builder.threadAllocatedBytes(threadAllocatedBytes);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link ThreadInfoComponent.ThreadInfoDataBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable ThreadInfoData instance
   */
  public static ThreadInfoData copyOf(ThreadInfoComponent.ThreadInfoDataBase instance) {
    if (instance instanceof ThreadInfoData) {
      return (ThreadInfoData) instance;
    }
    return ThreadInfoData.builder()
        .threadCpuTime(instance.threadCpuTime())
        .threadBlockedTime(instance.threadBlockedTime())
        .threadWaitedTime(instance.threadWaitedTime())
        .threadAllocatedBytes(instance.threadAllocatedBytes())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.transaction.model.ThreadInfoData}.
   * @return new ThreadInfoData builder
   */
  public static ThreadInfoData.Builder builder() {
    return new ThreadInfoData.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.transaction.model.ThreadInfoData}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long NONDEFAULT_BIT_THREAD_CPU_TIME = 0x1L;
    private static final long NONDEFAULT_BIT_THREAD_BLOCKED_TIME = 0x2L;
    private static final long NONDEFAULT_BIT_THREAD_WAITED_TIME = 0x4L;
    private static final long NONDEFAULT_BIT_THREAD_ALLOCATED_BYTES = 0x8L;
    private long nondefaultBitset;
  
    private @Nullable Long threadCpuTime;
    private @Nullable Long threadBlockedTime;
    private @Nullable Long threadWaitedTime;
    private @Nullable Long threadAllocatedBytes;
    private Builder() {}
  
    /**
     * Initializes value for {@link ThreadInfoComponent.ThreadInfoDataBase#threadCpuTime() threadCpuTime}.
     * @param threadCpuTime value for threadCpuTime, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder threadCpuTime(@Nullable Long threadCpuTime) {
      checkNotIsSet(threadCpuTimeIsSet(), "threadCpuTime");
      this.threadCpuTime = threadCpuTime;
      nondefaultBitset |= NONDEFAULT_BIT_THREAD_CPU_TIME;
      return this;
    }
  
    /**
     * Initializes value for {@link ThreadInfoComponent.ThreadInfoDataBase#threadBlockedTime() threadBlockedTime}.
     * @param threadBlockedTime value for threadBlockedTime, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder threadBlockedTime(@Nullable Long threadBlockedTime) {
      checkNotIsSet(threadBlockedTimeIsSet(), "threadBlockedTime");
      this.threadBlockedTime = threadBlockedTime;
      nondefaultBitset |= NONDEFAULT_BIT_THREAD_BLOCKED_TIME;
      return this;
    }
  
    /**
     * Initializes value for {@link ThreadInfoComponent.ThreadInfoDataBase#threadWaitedTime() threadWaitedTime}.
     * @param threadWaitedTime value for threadWaitedTime, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder threadWaitedTime(@Nullable Long threadWaitedTime) {
      checkNotIsSet(threadWaitedTimeIsSet(), "threadWaitedTime");
      this.threadWaitedTime = threadWaitedTime;
      nondefaultBitset |= NONDEFAULT_BIT_THREAD_WAITED_TIME;
      return this;
    }
  
    /**
     * Initializes value for {@link ThreadInfoComponent.ThreadInfoDataBase#threadAllocatedBytes() threadAllocatedBytes}.
     * @param threadAllocatedBytes value for threadAllocatedBytes, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder threadAllocatedBytes(@Nullable Long threadAllocatedBytes) {
      checkNotIsSet(threadAllocatedBytesIsSet(), "threadAllocatedBytes");
      this.threadAllocatedBytes = threadAllocatedBytes;
      nondefaultBitset |= NONDEFAULT_BIT_THREAD_ALLOCATED_BYTES;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.transaction.model.ThreadInfoData}.
     * @return immutable instance of ThreadInfoData
     */
    public ThreadInfoData build() {
      return new ThreadInfoData(threadCpuTime, threadBlockedTime, threadWaitedTime, threadAllocatedBytes);
    }
  
    private boolean threadCpuTimeIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_THREAD_CPU_TIME) != 0;
    }
  
    private boolean threadBlockedTimeIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_THREAD_BLOCKED_TIME) != 0;
    }
  
    private boolean threadWaitedTimeIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_THREAD_WAITED_TIME) != 0;
    }
  
    private boolean threadAllocatedBytesIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_THREAD_ALLOCATED_BYTES) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of ThreadInfoData is strict, attribute is already set: ".concat(name));
      }
    }
  }
}
