package org.glowroot.weaving;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.ImmutableSet;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.api.weaving.Pointcut;
import org.glowroot.shaded.objectweb.asm.Type;
import org.glowroot.shaded.objectweb.asm.commons.Method;

/**
 * Immutable implementation of {@link AdviceBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code Advice.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AdviceBase"})
@Immutable
public final class Advice extends AdviceBase {
  private final Pointcut pointcut;
  private final Type adviceType;
  private final @Nullable Pattern pointcutClassNamePattern;
  private final @Nullable Pattern pointcutMethodNamePattern;
  private final @Nullable Type travelerType;
  private final @Nullable Method isEnabledAdvice;
  private final @Nullable Method onBeforeAdvice;
  private final @Nullable Method onReturnAdvice;
  private final @Nullable Method onThrowAdvice;
  private final @Nullable Method onAfterAdvice;
  private final ImmutableList<AdviceParameter> isEnabledParameters;
  private final ImmutableList<AdviceParameter> onBeforeParameters;
  private final ImmutableList<AdviceParameter> onReturnParameters;
  private final ImmutableList<AdviceParameter> onThrowParameters;
  private final ImmutableList<AdviceParameter> onAfterParameters;
  private final boolean reweavable;
  private final ImmutableSet<Type> classMetaTypes;
  private final ImmutableSet<Type> methodMetaTypes;

  private Advice(
      Pointcut pointcut,
      Type adviceType,
      @Nullable Pattern pointcutClassNamePattern,
      @Nullable Pattern pointcutMethodNamePattern,
      @Nullable Type travelerType,
      @Nullable Method isEnabledAdvice,
      @Nullable Method onBeforeAdvice,
      @Nullable Method onReturnAdvice,
      @Nullable Method onThrowAdvice,
      @Nullable Method onAfterAdvice,
      ImmutableList<AdviceParameter> isEnabledParameters,
      ImmutableList<AdviceParameter> onBeforeParameters,
      ImmutableList<AdviceParameter> onReturnParameters,
      ImmutableList<AdviceParameter> onThrowParameters,
      ImmutableList<AdviceParameter> onAfterParameters,
      boolean reweavable) {
    this.pointcut = pointcut;
    this.adviceType = adviceType;
    this.pointcutClassNamePattern = pointcutClassNamePattern;
    this.pointcutMethodNamePattern = pointcutMethodNamePattern;
    this.travelerType = travelerType;
    this.isEnabledAdvice = isEnabledAdvice;
    this.onBeforeAdvice = onBeforeAdvice;
    this.onReturnAdvice = onReturnAdvice;
    this.onThrowAdvice = onThrowAdvice;
    this.onAfterAdvice = onAfterAdvice;
    this.isEnabledParameters = isEnabledParameters;
    this.onBeforeParameters = onBeforeParameters;
    this.onReturnParameters = onReturnParameters;
    this.onThrowParameters = onThrowParameters;
    this.onAfterParameters = onAfterParameters;
    this.reweavable = reweavable;
    this.classMetaTypes = Preconditions.checkNotNull(super.classMetaTypes());
    this.methodMetaTypes = Preconditions.checkNotNull(super.methodMetaTypes());
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code pointcut} attribute
   */
  @JsonProperty("pointcut")
  @Override
  public Pointcut pointcut() {
    return pointcut;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code adviceType} attribute
   */
  @JsonProperty("adviceType")
  @Override
  public Type adviceType() {
    return adviceType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code pointcutClassNamePattern} attribute
   */
  @JsonProperty("pointcutClassNamePattern")
  @Override
  public Pattern pointcutClassNamePattern() {
    return pointcutClassNamePattern;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code pointcutMethodNamePattern} attribute
   */
  @JsonProperty("pointcutMethodNamePattern")
  @Override
  public Pattern pointcutMethodNamePattern() {
    return pointcutMethodNamePattern;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code travelerType} attribute
   */
  @JsonProperty("travelerType")
  @Override
  public Type travelerType() {
    return travelerType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code isEnabledAdvice} attribute
   */
  @JsonProperty("isEnabledAdvice")
  @Override
  public Method isEnabledAdvice() {
    return isEnabledAdvice;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code onBeforeAdvice} attribute
   */
  @JsonProperty("onBeforeAdvice")
  @Override
  public Method onBeforeAdvice() {
    return onBeforeAdvice;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code onReturnAdvice} attribute
   */
  @JsonProperty("onReturnAdvice")
  @Override
  public Method onReturnAdvice() {
    return onReturnAdvice;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code onThrowAdvice} attribute
   */
  @JsonProperty("onThrowAdvice")
  @Override
  public Method onThrowAdvice() {
    return onThrowAdvice;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code onAfterAdvice} attribute
   */
  @JsonProperty("onAfterAdvice")
  @Override
  public Method onAfterAdvice() {
    return onAfterAdvice;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code isEnabledParameters} attribute
   */
  @JsonProperty("isEnabledParameters")
  @Override
  public ImmutableList<AdviceParameter> isEnabledParameters() {
    return isEnabledParameters;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code onBeforeParameters} attribute
   */
  @JsonProperty("onBeforeParameters")
  @Override
  public ImmutableList<AdviceParameter> onBeforeParameters() {
    return onBeforeParameters;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code onReturnParameters} attribute
   */
  @JsonProperty("onReturnParameters")
  @Override
  public ImmutableList<AdviceParameter> onReturnParameters() {
    return onReturnParameters;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code onThrowParameters} attribute
   */
  @JsonProperty("onThrowParameters")
  @Override
  public ImmutableList<AdviceParameter> onThrowParameters() {
    return onThrowParameters;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code onAfterParameters} attribute
   */
  @JsonProperty("onAfterParameters")
  @Override
  public ImmutableList<AdviceParameter> onAfterParameters() {
    return onAfterParameters;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code reweavable} attribute
   */
  @JsonProperty("reweavable")
  @Override
  public boolean reweavable() {
    return reweavable;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code classMetaTypes} attribute
   */
  @JsonProperty("classMetaTypes")
  @Override
  public ImmutableSet<Type> classMetaTypes() {
    return classMetaTypes;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code methodMetaTypes} attribute
   */
  @JsonProperty("methodMetaTypes")
  @Override
  public ImmutableSet<Type> methodMetaTypes() {
    return methodMetaTypes;
  }
  
  /**
   * Copy current immutable object by setting value for {@link AdviceBase#pointcut() pointcut}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for pointcut
   * @return modified copy of the {@code this} object
   */
  public final Advice withPointcut(Pointcut value) {
    if (this.pointcut == value) {
      return this;
    }
    Pointcut newValue = Preconditions.checkNotNull(value);
    return new Advice(
        newValue,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutMethodNamePattern,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.reweavable);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AdviceBase#adviceType() adviceType}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for adviceType
   * @return modified copy of the {@code this} object
   */
  public final Advice withAdviceType(Type value) {
    if (this.adviceType == value) {
      return this;
    }
    Type newValue = Preconditions.checkNotNull(value);
    return new Advice(
        this.pointcut,
        newValue,
        this.pointcutClassNamePattern,
        this.pointcutMethodNamePattern,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.reweavable);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AdviceBase#pointcutClassNamePattern() pointcutClassNamePattern}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for pointcutClassNamePattern, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final Advice withPointcutClassNamePattern(@Nullable Pattern value) {
    if (this.pointcutClassNamePattern == value) {
      return this;
    }
    @Nullable Pattern newValue = value;
    return new Advice(
        this.pointcut,
        this.adviceType,
        newValue,
        this.pointcutMethodNamePattern,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.reweavable);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AdviceBase#pointcutMethodNamePattern() pointcutMethodNamePattern}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for pointcutMethodNamePattern, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final Advice withPointcutMethodNamePattern(@Nullable Pattern value) {
    if (this.pointcutMethodNamePattern == value) {
      return this;
    }
    @Nullable Pattern newValue = value;
    return new Advice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        newValue,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.reweavable);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AdviceBase#travelerType() travelerType}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for travelerType, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final Advice withTravelerType(@Nullable Type value) {
    if (this.travelerType == value) {
      return this;
    }
    @Nullable Type newValue = value;
    return new Advice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutMethodNamePattern,
        newValue,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.reweavable);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AdviceBase#isEnabledAdvice() isEnabledAdvice}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for isEnabledAdvice, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final Advice withIsEnabledAdvice(@Nullable Method value) {
    if (this.isEnabledAdvice == value) {
      return this;
    }
    @Nullable Method newValue = value;
    return new Advice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutMethodNamePattern,
        this.travelerType,
        newValue,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.reweavable);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AdviceBase#onBeforeAdvice() onBeforeAdvice}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for onBeforeAdvice, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final Advice withOnBeforeAdvice(@Nullable Method value) {
    if (this.onBeforeAdvice == value) {
      return this;
    }
    @Nullable Method newValue = value;
    return new Advice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutMethodNamePattern,
        this.travelerType,
        this.isEnabledAdvice,
        newValue,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.reweavable);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AdviceBase#onReturnAdvice() onReturnAdvice}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for onReturnAdvice, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final Advice withOnReturnAdvice(@Nullable Method value) {
    if (this.onReturnAdvice == value) {
      return this;
    }
    @Nullable Method newValue = value;
    return new Advice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutMethodNamePattern,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        newValue,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.reweavable);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AdviceBase#onThrowAdvice() onThrowAdvice}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for onThrowAdvice, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final Advice withOnThrowAdvice(@Nullable Method value) {
    if (this.onThrowAdvice == value) {
      return this;
    }
    @Nullable Method newValue = value;
    return new Advice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutMethodNamePattern,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        newValue,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.reweavable);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AdviceBase#onAfterAdvice() onAfterAdvice}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for onAfterAdvice, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final Advice withOnAfterAdvice(@Nullable Method value) {
    if (this.onAfterAdvice == value) {
      return this;
    }
    @Nullable Method newValue = value;
    return new Advice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutMethodNamePattern,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        newValue,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.reweavable);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link AdviceBase#isEnabledParameters() isEnabledParameters}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final Advice withIsEnabledParameters(AdviceParameter... elements) {
    ImmutableList<AdviceParameter> newValue = ImmutableList.copyOf(elements);
    return new Advice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutMethodNamePattern,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        newValue,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.reweavable);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link AdviceBase#isEnabledParameters() isEnabledParameters}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of isEnabledParameters elements to set
   * @return modified copy of {@code this} object
   */
  public final Advice withIsEnabledParameters(Iterable<? extends AdviceParameter> elements) {
    if (this.isEnabledParameters == elements) {
      return this;
    }
    ImmutableList<AdviceParameter> newValue = ImmutableList.copyOf(elements);
    return new Advice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutMethodNamePattern,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        newValue,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.reweavable);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link AdviceBase#onBeforeParameters() onBeforeParameters}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final Advice withOnBeforeParameters(AdviceParameter... elements) {
    ImmutableList<AdviceParameter> newValue = ImmutableList.copyOf(elements);
    return new Advice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutMethodNamePattern,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        newValue,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.reweavable);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link AdviceBase#onBeforeParameters() onBeforeParameters}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of onBeforeParameters elements to set
   * @return modified copy of {@code this} object
   */
  public final Advice withOnBeforeParameters(Iterable<? extends AdviceParameter> elements) {
    if (this.onBeforeParameters == elements) {
      return this;
    }
    ImmutableList<AdviceParameter> newValue = ImmutableList.copyOf(elements);
    return new Advice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutMethodNamePattern,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        newValue,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.reweavable);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link AdviceBase#onReturnParameters() onReturnParameters}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final Advice withOnReturnParameters(AdviceParameter... elements) {
    ImmutableList<AdviceParameter> newValue = ImmutableList.copyOf(elements);
    return new Advice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutMethodNamePattern,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        newValue,
        this.onThrowParameters,
        this.onAfterParameters,
        this.reweavable);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link AdviceBase#onReturnParameters() onReturnParameters}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of onReturnParameters elements to set
   * @return modified copy of {@code this} object
   */
  public final Advice withOnReturnParameters(Iterable<? extends AdviceParameter> elements) {
    if (this.onReturnParameters == elements) {
      return this;
    }
    ImmutableList<AdviceParameter> newValue = ImmutableList.copyOf(elements);
    return new Advice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutMethodNamePattern,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        newValue,
        this.onThrowParameters,
        this.onAfterParameters,
        this.reweavable);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link AdviceBase#onThrowParameters() onThrowParameters}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final Advice withOnThrowParameters(AdviceParameter... elements) {
    ImmutableList<AdviceParameter> newValue = ImmutableList.copyOf(elements);
    return new Advice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutMethodNamePattern,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        newValue,
        this.onAfterParameters,
        this.reweavable);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link AdviceBase#onThrowParameters() onThrowParameters}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of onThrowParameters elements to set
   * @return modified copy of {@code this} object
   */
  public final Advice withOnThrowParameters(Iterable<? extends AdviceParameter> elements) {
    if (this.onThrowParameters == elements) {
      return this;
    }
    ImmutableList<AdviceParameter> newValue = ImmutableList.copyOf(elements);
    return new Advice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutMethodNamePattern,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        newValue,
        this.onAfterParameters,
        this.reweavable);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link AdviceBase#onAfterParameters() onAfterParameters}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final Advice withOnAfterParameters(AdviceParameter... elements) {
    ImmutableList<AdviceParameter> newValue = ImmutableList.copyOf(elements);
    return new Advice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutMethodNamePattern,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        newValue,
        this.reweavable);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link AdviceBase#onAfterParameters() onAfterParameters}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of onAfterParameters elements to set
   * @return modified copy of {@code this} object
   */
  public final Advice withOnAfterParameters(Iterable<? extends AdviceParameter> elements) {
    if (this.onAfterParameters == elements) {
      return this;
    }
    ImmutableList<AdviceParameter> newValue = ImmutableList.copyOf(elements);
    return new Advice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutMethodNamePattern,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        newValue,
        this.reweavable);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AdviceBase#reweavable() reweavable}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for reweavable
   * @return modified copy of the {@code this} object
   */
  public final Advice withReweavable(boolean value) {
    if (this.reweavable == value) {
      return this;
    }
    boolean newValue = value;
    return new Advice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutMethodNamePattern,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code Advice} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof Advice && equalTo((Advice) another));
  }
  
  private boolean equalTo(Advice another) {
    return pointcut.equals(another.pointcut)
        && adviceType.equals(another.adviceType)
        && Objects.equal(pointcutClassNamePattern, another.pointcutClassNamePattern)
        && Objects.equal(pointcutMethodNamePattern, another.pointcutMethodNamePattern)
        && Objects.equal(travelerType, another.travelerType)
        && Objects.equal(isEnabledAdvice, another.isEnabledAdvice)
        && Objects.equal(onBeforeAdvice, another.onBeforeAdvice)
        && Objects.equal(onReturnAdvice, another.onReturnAdvice)
        && Objects.equal(onThrowAdvice, another.onThrowAdvice)
        && Objects.equal(onAfterAdvice, another.onAfterAdvice)
        && isEnabledParameters.equals(another.isEnabledParameters)
        && onBeforeParameters.equals(another.onBeforeParameters)
        && onReturnParameters.equals(another.onReturnParameters)
        && onThrowParameters.equals(another.onThrowParameters)
        && onAfterParameters.equals(another.onAfterParameters)
        && reweavable == another.reweavable
        && classMetaTypes.equals(another.classMetaTypes)
        && methodMetaTypes.equals(another.methodMetaTypes);
  }
  
  /**
   * Computes hash code from attributes: {@code pointcut}, {@code adviceType}, {@code pointcutClassNamePattern}, {@code pointcutMethodNamePattern}, {@code travelerType}, {@code isEnabledAdvice}, {@code onBeforeAdvice}, {@code onReturnAdvice}, {@code onThrowAdvice}, {@code onAfterAdvice}, {@code isEnabledParameters}, {@code onBeforeParameters}, {@code onReturnParameters}, {@code onThrowParameters}, {@code onAfterParameters}, {@code reweavable}, {@code classMetaTypes}, {@code methodMetaTypes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + pointcut.hashCode();
    h = h * 17 + adviceType.hashCode();
    h = h * 17 + Objects.hashCode(pointcutClassNamePattern);
    h = h * 17 + Objects.hashCode(pointcutMethodNamePattern);
    h = h * 17 + Objects.hashCode(travelerType);
    h = h * 17 + Objects.hashCode(isEnabledAdvice);
    h = h * 17 + Objects.hashCode(onBeforeAdvice);
    h = h * 17 + Objects.hashCode(onReturnAdvice);
    h = h * 17 + Objects.hashCode(onThrowAdvice);
    h = h * 17 + Objects.hashCode(onAfterAdvice);
    h = h * 17 + isEnabledParameters.hashCode();
    h = h * 17 + onBeforeParameters.hashCode();
    h = h * 17 + onReturnParameters.hashCode();
    h = h * 17 + onThrowParameters.hashCode();
    h = h * 17 + onAfterParameters.hashCode();
    h = h * 17 + Booleans.hashCode(reweavable);
    h = h * 17 + classMetaTypes.hashCode();
    h = h * 17 + methodMetaTypes.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code Advice{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Advice")
        .add("pointcut", pointcut)
        .add("adviceType", adviceType)
        .add("pointcutClassNamePattern", pointcutClassNamePattern)
        .add("pointcutMethodNamePattern", pointcutMethodNamePattern)
        .add("travelerType", travelerType)
        .add("isEnabledAdvice", isEnabledAdvice)
        .add("onBeforeAdvice", onBeforeAdvice)
        .add("onReturnAdvice", onReturnAdvice)
        .add("onThrowAdvice", onThrowAdvice)
        .add("onAfterAdvice", onAfterAdvice)
        .add("isEnabledParameters", isEnabledParameters)
        .add("onBeforeParameters", onBeforeParameters)
        .add("onReturnParameters", onReturnParameters)
        .add("onThrowParameters", onThrowParameters)
        .add("onAfterParameters", onAfterParameters)
        .add("reweavable", reweavable)
        .add("classMetaTypes", classMetaTypes)
        .add("methodMetaTypes", methodMetaTypes)
        .toString();
  }
  
  @JsonCreator
  public static Advice fromAllAttributes(
      @JsonProperty("pointcut") @Nullable Pointcut pointcut,
      @JsonProperty("adviceType") @Nullable Type adviceType,
      @JsonProperty("pointcutClassNamePattern") @Nullable Pattern pointcutClassNamePattern,
      @JsonProperty("pointcutMethodNamePattern") @Nullable Pattern pointcutMethodNamePattern,
      @JsonProperty("travelerType") @Nullable Type travelerType,
      @JsonProperty("isEnabledAdvice") @Nullable Method isEnabledAdvice,
      @JsonProperty("onBeforeAdvice") @Nullable Method onBeforeAdvice,
      @JsonProperty("onReturnAdvice") @Nullable Method onReturnAdvice,
      @JsonProperty("onThrowAdvice") @Nullable Method onThrowAdvice,
      @JsonProperty("onAfterAdvice") @Nullable Method onAfterAdvice,
      @JsonProperty("isEnabledParameters") @Nullable ImmutableList<AdviceParameter> isEnabledParameters,
      @JsonProperty("onBeforeParameters") @Nullable ImmutableList<AdviceParameter> onBeforeParameters,
      @JsonProperty("onReturnParameters") @Nullable ImmutableList<AdviceParameter> onReturnParameters,
      @JsonProperty("onThrowParameters") @Nullable ImmutableList<AdviceParameter> onThrowParameters,
      @JsonProperty("onAfterParameters") @Nullable ImmutableList<AdviceParameter> onAfterParameters,
      @JsonProperty("reweavable") @Nullable Boolean reweavable) {
    Advice.Builder builder = Advice.builder();
    if (pointcut != null) {
      builder.pointcut(pointcut);
    }
    if (adviceType != null) {
      builder.adviceType(adviceType);
    }
    if (pointcutClassNamePattern != null) {
      builder.pointcutClassNamePattern(pointcutClassNamePattern);
    }
    if (pointcutMethodNamePattern != null) {
      builder.pointcutMethodNamePattern(pointcutMethodNamePattern);
    }
    if (travelerType != null) {
      builder.travelerType(travelerType);
    }
    if (isEnabledAdvice != null) {
      builder.isEnabledAdvice(isEnabledAdvice);
    }
    if (onBeforeAdvice != null) {
      builder.onBeforeAdvice(onBeforeAdvice);
    }
    if (onReturnAdvice != null) {
      builder.onReturnAdvice(onReturnAdvice);
    }
    if (onThrowAdvice != null) {
      builder.onThrowAdvice(onThrowAdvice);
    }
    if (onAfterAdvice != null) {
      builder.onAfterAdvice(onAfterAdvice);
    }
    if (isEnabledParameters != null) {
      builder.addAllIsEnabledParameters(isEnabledParameters);
    }
    if (onBeforeParameters != null) {
      builder.addAllOnBeforeParameters(onBeforeParameters);
    }
    if (onReturnParameters != null) {
      builder.addAllOnReturnParameters(onReturnParameters);
    }
    if (onThrowParameters != null) {
      builder.addAllOnThrowParameters(onThrowParameters);
    }
    if (onAfterParameters != null) {
      builder.addAllOnAfterParameters(onAfterParameters);
    }
    if (reweavable != null) {
      builder.reweavable(reweavable);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link AdviceBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable Advice instance
   */
  public static Advice copyOf(AdviceBase instance) {
    if (instance instanceof Advice) {
      return (Advice) instance;
    }
    return Advice.builder()
        .pointcut(instance.pointcut())
        .adviceType(instance.adviceType())
        .pointcutClassNamePattern(instance.pointcutClassNamePattern())
        .pointcutMethodNamePattern(instance.pointcutMethodNamePattern())
        .travelerType(instance.travelerType())
        .isEnabledAdvice(instance.isEnabledAdvice())
        .onBeforeAdvice(instance.onBeforeAdvice())
        .onReturnAdvice(instance.onReturnAdvice())
        .onThrowAdvice(instance.onThrowAdvice())
        .onAfterAdvice(instance.onAfterAdvice())
        .addAllIsEnabledParameters(instance.isEnabledParameters())
        .addAllOnBeforeParameters(instance.onBeforeParameters())
        .addAllOnReturnParameters(instance.onReturnParameters())
        .addAllOnThrowParameters(instance.onThrowParameters())
        .addAllOnAfterParameters(instance.onAfterParameters())
        .reweavable(instance.reweavable())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.weaving.Advice}.
   * @return new Advice builder
   */
  public static Advice.Builder builder() {
    return new Advice.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.weaving.Advice}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x7;
    private static final long INITIALIZED_BIT_POINTCUT = 0x1L;
    private static final long INITIALIZED_BIT_ADVICE_TYPE = 0x2L;
    private static final long INITIALIZED_BIT_REWEAVABLE = 0x4L;
    private static final long NONDEFAULT_BIT_POINTCUT_CLASS_NAME_PATTERN = 0x1L;
    private static final long NONDEFAULT_BIT_POINTCUT_METHOD_NAME_PATTERN = 0x2L;
    private static final long NONDEFAULT_BIT_TRAVELER_TYPE = 0x4L;
    private static final long NONDEFAULT_BIT_IS_ENABLED_ADVICE = 0x8L;
    private static final long NONDEFAULT_BIT_ON_BEFORE_ADVICE = 0x10L;
    private static final long NONDEFAULT_BIT_ON_RETURN_ADVICE = 0x20L;
    private static final long NONDEFAULT_BIT_ON_THROW_ADVICE = 0x40L;
    private static final long NONDEFAULT_BIT_ON_AFTER_ADVICE = 0x80L;
    private long initializedBitset;
    private long nondefaultBitset;
  
    private @Nullable Pointcut pointcut;
    private @Nullable Type adviceType;
    private @Nullable Pattern pointcutClassNamePattern;
    private @Nullable Pattern pointcutMethodNamePattern;
    private @Nullable Type travelerType;
    private @Nullable Method isEnabledAdvice;
    private @Nullable Method onBeforeAdvice;
    private @Nullable Method onReturnAdvice;
    private @Nullable Method onThrowAdvice;
    private @Nullable Method onAfterAdvice;
    private ImmutableList.Builder<AdviceParameter> isEnabledParametersBuilder = ImmutableList.builder();
    private ImmutableList.Builder<AdviceParameter> onBeforeParametersBuilder = ImmutableList.builder();
    private ImmutableList.Builder<AdviceParameter> onReturnParametersBuilder = ImmutableList.builder();
    private ImmutableList.Builder<AdviceParameter> onThrowParametersBuilder = ImmutableList.builder();
    private ImmutableList.Builder<AdviceParameter> onAfterParametersBuilder = ImmutableList.builder();
    private boolean reweavable;
    private Builder() {}
  
    /**
     * Initializes value for {@link AdviceBase#pointcut() pointcut}.
     * @param pointcut value for pointcut
     * @return {@code this} builder for chained invocation
     */
    public final Builder pointcut(Pointcut pointcut) {
      checkNotIsSet(pointcutIsSet(), "pointcut");
      this.pointcut = Preconditions.checkNotNull(pointcut);
      initializedBitset |= INITIALIZED_BIT_POINTCUT;
      return this;
    }
  
    /**
     * Initializes value for {@link AdviceBase#adviceType() adviceType}.
     * @param adviceType value for adviceType
     * @return {@code this} builder for chained invocation
     */
    public final Builder adviceType(Type adviceType) {
      checkNotIsSet(adviceTypeIsSet(), "adviceType");
      this.adviceType = Preconditions.checkNotNull(adviceType);
      initializedBitset |= INITIALIZED_BIT_ADVICE_TYPE;
      return this;
    }
  
    /**
     * Initializes value for {@link AdviceBase#pointcutClassNamePattern() pointcutClassNamePattern}.
     * @param pointcutClassNamePattern value for pointcutClassNamePattern, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder pointcutClassNamePattern(@Nullable Pattern pointcutClassNamePattern) {
      checkNotIsSet(pointcutClassNamePatternIsSet(), "pointcutClassNamePattern");
      this.pointcutClassNamePattern = pointcutClassNamePattern;
      nondefaultBitset |= NONDEFAULT_BIT_POINTCUT_CLASS_NAME_PATTERN;
      return this;
    }
  
    /**
     * Initializes value for {@link AdviceBase#pointcutMethodNamePattern() pointcutMethodNamePattern}.
     * @param pointcutMethodNamePattern value for pointcutMethodNamePattern, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder pointcutMethodNamePattern(@Nullable Pattern pointcutMethodNamePattern) {
      checkNotIsSet(pointcutMethodNamePatternIsSet(), "pointcutMethodNamePattern");
      this.pointcutMethodNamePattern = pointcutMethodNamePattern;
      nondefaultBitset |= NONDEFAULT_BIT_POINTCUT_METHOD_NAME_PATTERN;
      return this;
    }
  
    /**
     * Initializes value for {@link AdviceBase#travelerType() travelerType}.
     * @param travelerType value for travelerType, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder travelerType(@Nullable Type travelerType) {
      checkNotIsSet(travelerTypeIsSet(), "travelerType");
      this.travelerType = travelerType;
      nondefaultBitset |= NONDEFAULT_BIT_TRAVELER_TYPE;
      return this;
    }
  
    /**
     * Initializes value for {@link AdviceBase#isEnabledAdvice() isEnabledAdvice}.
     * @param isEnabledAdvice value for isEnabledAdvice, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder isEnabledAdvice(@Nullable Method isEnabledAdvice) {
      checkNotIsSet(isEnabledAdviceIsSet(), "isEnabledAdvice");
      this.isEnabledAdvice = isEnabledAdvice;
      nondefaultBitset |= NONDEFAULT_BIT_IS_ENABLED_ADVICE;
      return this;
    }
  
    /**
     * Initializes value for {@link AdviceBase#onBeforeAdvice() onBeforeAdvice}.
     * @param onBeforeAdvice value for onBeforeAdvice, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder onBeforeAdvice(@Nullable Method onBeforeAdvice) {
      checkNotIsSet(onBeforeAdviceIsSet(), "onBeforeAdvice");
      this.onBeforeAdvice = onBeforeAdvice;
      nondefaultBitset |= NONDEFAULT_BIT_ON_BEFORE_ADVICE;
      return this;
    }
  
    /**
     * Initializes value for {@link AdviceBase#onReturnAdvice() onReturnAdvice}.
     * @param onReturnAdvice value for onReturnAdvice, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder onReturnAdvice(@Nullable Method onReturnAdvice) {
      checkNotIsSet(onReturnAdviceIsSet(), "onReturnAdvice");
      this.onReturnAdvice = onReturnAdvice;
      nondefaultBitset |= NONDEFAULT_BIT_ON_RETURN_ADVICE;
      return this;
    }
  
    /**
     * Initializes value for {@link AdviceBase#onThrowAdvice() onThrowAdvice}.
     * @param onThrowAdvice value for onThrowAdvice, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder onThrowAdvice(@Nullable Method onThrowAdvice) {
      checkNotIsSet(onThrowAdviceIsSet(), "onThrowAdvice");
      this.onThrowAdvice = onThrowAdvice;
      nondefaultBitset |= NONDEFAULT_BIT_ON_THROW_ADVICE;
      return this;
    }
  
    /**
     * Initializes value for {@link AdviceBase#onAfterAdvice() onAfterAdvice}.
     * @param onAfterAdvice value for onAfterAdvice, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder onAfterAdvice(@Nullable Method onAfterAdvice) {
      checkNotIsSet(onAfterAdviceIsSet(), "onAfterAdvice");
      this.onAfterAdvice = onAfterAdvice;
      nondefaultBitset |= NONDEFAULT_BIT_ON_AFTER_ADVICE;
      return this;
    }
  
    /**
     * Adds one element to {@link AdviceBase#isEnabledParameters() isEnabledParameters} list.
     * @param element isEnabledParameters element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addIsEnabledParameters(AdviceParameter element) {
      isEnabledParametersBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link AdviceBase#isEnabledParameters() isEnabledParameters} list.
     * @param elements array of isEnabledParameters elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addIsEnabledParameters(AdviceParameter... elements) {
      isEnabledParametersBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link AdviceBase#isEnabledParameters() isEnabledParameters} list.
     * @param elements iterable of isEnabledParameters elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllIsEnabledParameters(Iterable<? extends AdviceParameter> elements) {
      isEnabledParametersBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Adds one element to {@link AdviceBase#onBeforeParameters() onBeforeParameters} list.
     * @param element onBeforeParameters element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addOnBeforeParameters(AdviceParameter element) {
      onBeforeParametersBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link AdviceBase#onBeforeParameters() onBeforeParameters} list.
     * @param elements array of onBeforeParameters elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addOnBeforeParameters(AdviceParameter... elements) {
      onBeforeParametersBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link AdviceBase#onBeforeParameters() onBeforeParameters} list.
     * @param elements iterable of onBeforeParameters elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllOnBeforeParameters(Iterable<? extends AdviceParameter> elements) {
      onBeforeParametersBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Adds one element to {@link AdviceBase#onReturnParameters() onReturnParameters} list.
     * @param element onReturnParameters element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addOnReturnParameters(AdviceParameter element) {
      onReturnParametersBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link AdviceBase#onReturnParameters() onReturnParameters} list.
     * @param elements array of onReturnParameters elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addOnReturnParameters(AdviceParameter... elements) {
      onReturnParametersBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link AdviceBase#onReturnParameters() onReturnParameters} list.
     * @param elements iterable of onReturnParameters elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllOnReturnParameters(Iterable<? extends AdviceParameter> elements) {
      onReturnParametersBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Adds one element to {@link AdviceBase#onThrowParameters() onThrowParameters} list.
     * @param element onThrowParameters element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addOnThrowParameters(AdviceParameter element) {
      onThrowParametersBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link AdviceBase#onThrowParameters() onThrowParameters} list.
     * @param elements array of onThrowParameters elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addOnThrowParameters(AdviceParameter... elements) {
      onThrowParametersBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link AdviceBase#onThrowParameters() onThrowParameters} list.
     * @param elements iterable of onThrowParameters elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllOnThrowParameters(Iterable<? extends AdviceParameter> elements) {
      onThrowParametersBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Adds one element to {@link AdviceBase#onAfterParameters() onAfterParameters} list.
     * @param element onAfterParameters element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addOnAfterParameters(AdviceParameter element) {
      onAfterParametersBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link AdviceBase#onAfterParameters() onAfterParameters} list.
     * @param elements array of onAfterParameters elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addOnAfterParameters(AdviceParameter... elements) {
      onAfterParametersBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link AdviceBase#onAfterParameters() onAfterParameters} list.
     * @param elements iterable of onAfterParameters elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllOnAfterParameters(Iterable<? extends AdviceParameter> elements) {
      onAfterParametersBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes value for {@link AdviceBase#reweavable() reweavable}.
     * @param reweavable value for reweavable
     * @return {@code this} builder for chained invocation
     */
    public final Builder reweavable(boolean reweavable) {
      checkNotIsSet(reweavableIsSet(), "reweavable");
      this.reweavable = reweavable;
      initializedBitset |= INITIALIZED_BIT_REWEAVABLE;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.weaving.Advice}.
     * @return immutable instance of Advice
     */
    public Advice build() {
      checkRequiredAttributes();
      return new Advice(
        pointcut,
        adviceType,
        pointcutClassNamePattern,
        pointcutMethodNamePattern,
        travelerType,
        isEnabledAdvice,
        onBeforeAdvice,
        onReturnAdvice,
        onThrowAdvice,
        onAfterAdvice,
        isEnabledParametersBuilder.build(),
        onBeforeParametersBuilder.build(),
        onReturnParametersBuilder.build(),
        onThrowParametersBuilder.build(),
        onAfterParametersBuilder.build(),
        reweavable);
    }
  
    private boolean pointcutClassNamePatternIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_POINTCUT_CLASS_NAME_PATTERN) != 0;
    }
  
    private boolean pointcutMethodNamePatternIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_POINTCUT_METHOD_NAME_PATTERN) != 0;
    }
  
    private boolean travelerTypeIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TRAVELER_TYPE) != 0;
    }
  
    private boolean isEnabledAdviceIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_IS_ENABLED_ADVICE) != 0;
    }
  
    private boolean onBeforeAdviceIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_ON_BEFORE_ADVICE) != 0;
    }
  
    private boolean onReturnAdviceIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_ON_RETURN_ADVICE) != 0;
    }
  
    private boolean onThrowAdviceIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_ON_THROW_ADVICE) != 0;
    }
  
    private boolean onAfterAdviceIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_ON_AFTER_ADVICE) != 0;
    }
  
    private boolean pointcutIsSet() {
      return (initializedBitset & INITIALIZED_BIT_POINTCUT) != 0;
    }
  
    private boolean adviceTypeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ADVICE_TYPE) != 0;
    }
  
    private boolean reweavableIsSet() {
      return (initializedBitset & INITIALIZED_BIT_REWEAVABLE) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of Advice is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!pointcutIsSet()) {
        attributes.add("pointcut");
      }
      if (!adviceTypeIsSet()) {
        attributes.add("adviceType");
      }
      if (!reweavableIsSet()) {
        attributes.add("reweavable");
      }
      return "Cannot build Advice, some of required attributes are not set " + attributes;
    }
  }
}
