package org.glowroot.weaving;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link AdviceMatcherBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code AdviceMatcher.builder()}.
 * Use static factory method to create immutable instances:
 * {@code AdviceMatcher.of()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AdviceMatcherBase"})
@Immutable
final class AdviceMatcher extends AdviceMatcherBase {
  private final Advice advice;

  private AdviceMatcher(Advice advice) {
    this.advice = advice;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code advice} attribute
   */
  @JsonProperty("advice")
  @Override
  public Advice advice() {
    return advice;
  }
  
  /**
   * Copy current immutable object by setting value for {@link AdviceMatcherBase#advice() advice}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for advice
   * @return modified copy of the {@code this} object
   */
  public final AdviceMatcher withAdvice(Advice value) {
    if (this.advice == value) {
      return this;
    }
    Advice newValue = Preconditions.checkNotNull(value);
    return new AdviceMatcher(newValue);
  }
  
  /**
   * This instance is equal to instances of {@code AdviceMatcher} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof AdviceMatcher && equalTo((AdviceMatcher) another));
  }
  
  private boolean equalTo(AdviceMatcher another) {
    return advice.equals(another.advice);
  }
  
  /**
   * Computes hash code from attributes: {@code advice}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + advice.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code AdviceMatcher{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AdviceMatcher")
        .add("advice", advice)
        .toString();
  }
  
  @JsonCreator
  public static AdviceMatcher fromAllAttributes(
      @JsonProperty("advice") @Nullable Advice advice) {
    AdviceMatcher.Builder builder = AdviceMatcher.builder();
    if (advice != null) {
      builder.advice(advice);
    }
    return builder.build();
  }

  /**
   * Construct new immutable {@code AdviceMatcher} instance.
   * @param advice value for {@code advice}
   * @return immutable AdviceMatcher instance
   */
  public static org.glowroot.weaving.AdviceMatcher of(Advice advice) {
    return new AdviceMatcher(advice);
  }
  
  /**
   * Creates immutable copy of {@link AdviceMatcherBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable AdviceMatcher instance
   */
  static AdviceMatcher copyOf(AdviceMatcherBase instance) {
    if (instance instanceof AdviceMatcher) {
      return (AdviceMatcher) instance;
    }
    return AdviceMatcher.builder()
        .advice(instance.advice())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.weaving.AdviceMatcher}.
   * @return new AdviceMatcher builder
   */
  static AdviceMatcher.Builder builder() {
    return new AdviceMatcher.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.weaving.AdviceMatcher}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x1;
    private static final long INITIALIZED_BIT_ADVICE = 0x1L;
    private long initializedBitset;
  
    private @Nullable Advice advice;
    private Builder() {}
  
    /**
     * Initializes value for {@link AdviceMatcherBase#advice() advice}.
     * @param advice value for advice
     * @return {@code this} builder for chained invocation
     */
    public final Builder advice(Advice advice) {
      checkNotIsSet(adviceIsSet(), "advice");
      this.advice = Preconditions.checkNotNull(advice);
      initializedBitset |= INITIALIZED_BIT_ADVICE;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.weaving.AdviceMatcher}.
     * @return immutable instance of AdviceMatcher
     */
    public org.glowroot.weaving.AdviceMatcher build() {
      checkRequiredAttributes();
      return new AdviceMatcher(advice);
    }
  
    private boolean adviceIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ADVICE) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of AdviceMatcher is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!adviceIsSet()) {
        attributes.add("advice");
      }
      return "Cannot build AdviceMatcher, some of required attributes are not set " + attributes;
    }
  }
}
