package org.glowroot.weaving;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.ImmutableSet;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.shaded.objectweb.asm.Type;

/**
 * Immutable implementation of {@link WeavingClassVisitor.MethodMetaGroupBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code MethodMetaGroup.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "WeavingClassVisitor.MethodMetaGroupBase"})
@Immutable
final class MethodMetaGroup extends WeavingClassVisitor.MethodMetaGroupBase {
  private final Type returnType;
  private final ImmutableList<Type> parameterTypes;
  private final int uniqueNum;
  private final ImmutableSet<Type> methodMetaTypes;

  private MethodMetaGroup(
      Type returnType,
      ImmutableList<Type> parameterTypes,
      int uniqueNum,
      ImmutableSet<Type> methodMetaTypes) {
    this.returnType = returnType;
    this.parameterTypes = parameterTypes;
    this.uniqueNum = uniqueNum;
    this.methodMetaTypes = methodMetaTypes;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code returnType} attribute
   */
  @JsonProperty("returnType")
  @Override
  public Type returnType() {
    return returnType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code parameterTypes} attribute
   */
  @JsonProperty("parameterTypes")
  @Override
  public ImmutableList<Type> parameterTypes() {
    return parameterTypes;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code uniqueNum} attribute
   */
  @JsonProperty("uniqueNum")
  @Override
  public int uniqueNum() {
    return uniqueNum;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code methodMetaTypes} attribute
   */
  @JsonProperty("methodMetaTypes")
  @Override
  public ImmutableSet<Type> methodMetaTypes() {
    return methodMetaTypes;
  }
  
  /**
   * Copy current immutable object by setting value for {@link WeavingClassVisitor.MethodMetaGroupBase#returnType() returnType}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for returnType
   * @return modified copy of the {@code this} object
   */
  public final MethodMetaGroup withReturnType(Type value) {
    if (this.returnType == value) {
      return this;
    }
    Type newValue = Preconditions.checkNotNull(value);
    return new MethodMetaGroup(newValue, this.parameterTypes, this.uniqueNum, this.methodMetaTypes);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link WeavingClassVisitor.MethodMetaGroupBase#parameterTypes() parameterTypes}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final MethodMetaGroup withParameterTypes(Type... elements) {
    ImmutableList<Type> newValue = ImmutableList.copyOf(elements);
    return new MethodMetaGroup(this.returnType, newValue, this.uniqueNum, this.methodMetaTypes);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link WeavingClassVisitor.MethodMetaGroupBase#parameterTypes() parameterTypes}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of parameterTypes elements to set
   * @return modified copy of {@code this} object
   */
  public final MethodMetaGroup withParameterTypes(Iterable<? extends Type> elements) {
    if (this.parameterTypes == elements) {
      return this;
    }
    ImmutableList<Type> newValue = ImmutableList.copyOf(elements);
    return new MethodMetaGroup(this.returnType, newValue, this.uniqueNum, this.methodMetaTypes);
  }
  
  /**
   * Copy current immutable object by setting value for {@link WeavingClassVisitor.MethodMetaGroupBase#uniqueNum() uniqueNum}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for uniqueNum
   * @return modified copy of the {@code this} object
   */
  public final MethodMetaGroup withUniqueNum(int value) {
    if (this.uniqueNum == value) {
      return this;
    }
    int newValue = value;
    return new MethodMetaGroup(this.returnType, this.parameterTypes, newValue, this.methodMetaTypes);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link WeavingClassVisitor.MethodMetaGroupBase#methodMetaTypes() methodMetaTypes}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final MethodMetaGroup withMethodMetaTypes(Type... elements) {
    ImmutableSet<Type> newValue = ImmutableSet.copyOf(elements);
    return new MethodMetaGroup(this.returnType, this.parameterTypes, this.uniqueNum, newValue);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link WeavingClassVisitor.MethodMetaGroupBase#methodMetaTypes() methodMetaTypes}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of methodMetaTypes elements to set
   * @return modified copy of {@code this} object
   */
  public final MethodMetaGroup withMethodMetaTypes(Iterable<? extends Type> elements) {
    if (this.methodMetaTypes == elements) {
      return this;
    }
    ImmutableSet<Type> newValue = ImmutableSet.copyOf(elements);
    return new MethodMetaGroup(this.returnType, this.parameterTypes, this.uniqueNum, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code MethodMetaGroup} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof MethodMetaGroup && equalTo((MethodMetaGroup) another));
  }
  
  private boolean equalTo(MethodMetaGroup another) {
    return returnType.equals(another.returnType)
        && parameterTypes.equals(another.parameterTypes)
        && uniqueNum == another.uniqueNum
        && methodMetaTypes.equals(another.methodMetaTypes);
  }
  
  /**
   * Computes hash code from attributes: {@code returnType}, {@code parameterTypes}, {@code uniqueNum}, {@code methodMetaTypes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + returnType.hashCode();
    h = h * 17 + parameterTypes.hashCode();
    h = h * 17 + uniqueNum;
    h = h * 17 + methodMetaTypes.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code MethodMetaGroup{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MethodMetaGroup")
        .add("returnType", returnType)
        .add("parameterTypes", parameterTypes)
        .add("uniqueNum", uniqueNum)
        .add("methodMetaTypes", methodMetaTypes)
        .toString();
  }
  
  @JsonCreator
  public static MethodMetaGroup fromAllAttributes(
      @JsonProperty("returnType") @Nullable Type returnType,
      @JsonProperty("parameterTypes") @Nullable ImmutableList<Type> parameterTypes,
      @JsonProperty("uniqueNum") @Nullable Integer uniqueNum,
      @JsonProperty("methodMetaTypes") @Nullable ImmutableSet<Type> methodMetaTypes) {
    MethodMetaGroup.Builder builder = MethodMetaGroup.builder();
    if (returnType != null) {
      builder.returnType(returnType);
    }
    if (parameterTypes != null) {
      builder.addAllParameterTypes(parameterTypes);
    }
    if (uniqueNum != null) {
      builder.uniqueNum(uniqueNum);
    }
    if (methodMetaTypes != null) {
      builder.addAllMethodMetaTypes(methodMetaTypes);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link WeavingClassVisitor.MethodMetaGroupBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable MethodMetaGroup instance
   */
  static MethodMetaGroup copyOf(WeavingClassVisitor.MethodMetaGroupBase instance) {
    if (instance instanceof MethodMetaGroup) {
      return (MethodMetaGroup) instance;
    }
    return MethodMetaGroup.builder()
        .returnType(instance.returnType())
        .addAllParameterTypes(instance.parameterTypes())
        .uniqueNum(instance.uniqueNum())
        .addAllMethodMetaTypes(instance.methodMetaTypes())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.weaving.MethodMetaGroup}.
   * @return new MethodMetaGroup builder
   */
  static MethodMetaGroup.Builder builder() {
    return new MethodMetaGroup.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.weaving.MethodMetaGroup}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_RETURN_TYPE = 0x1L;
    private static final long INITIALIZED_BIT_UNIQUE_NUM = 0x2L;
    private long initializedBitset;
  
    private @Nullable Type returnType;
    private ImmutableList.Builder<Type> parameterTypesBuilder = ImmutableList.builder();
    private int uniqueNum;
    private ImmutableSet.Builder<Type> methodMetaTypesBuilder = ImmutableSet.builder();
    private Builder() {}
  
    /**
     * Initializes value for {@link WeavingClassVisitor.MethodMetaGroupBase#returnType() returnType}.
     * @param returnType value for returnType
     * @return {@code this} builder for chained invocation
     */
    public final Builder returnType(Type returnType) {
      checkNotIsSet(returnTypeIsSet(), "returnType");
      this.returnType = Preconditions.checkNotNull(returnType);
      initializedBitset |= INITIALIZED_BIT_RETURN_TYPE;
      return this;
    }
  
    /**
     * Adds one element to {@link WeavingClassVisitor.MethodMetaGroupBase#parameterTypes() parameterTypes} list.
     * @param element parameterTypes element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addParameterTypes(Type element) {
      parameterTypesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link WeavingClassVisitor.MethodMetaGroupBase#parameterTypes() parameterTypes} list.
     * @param elements array of parameterTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addParameterTypes(Type... elements) {
      parameterTypesBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link WeavingClassVisitor.MethodMetaGroupBase#parameterTypes() parameterTypes} list.
     * @param elements iterable of parameterTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllParameterTypes(Iterable<? extends Type> elements) {
      parameterTypesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes value for {@link WeavingClassVisitor.MethodMetaGroupBase#uniqueNum() uniqueNum}.
     * @param uniqueNum value for uniqueNum
     * @return {@code this} builder for chained invocation
     */
    public final Builder uniqueNum(int uniqueNum) {
      checkNotIsSet(uniqueNumIsSet(), "uniqueNum");
      this.uniqueNum = uniqueNum;
      initializedBitset |= INITIALIZED_BIT_UNIQUE_NUM;
      return this;
    }
  
    /**
     * Adds one element to {@link WeavingClassVisitor.MethodMetaGroupBase#methodMetaTypes() methodMetaTypes} set.
     * @param element methodMetaTypes element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addMethodMetaTypes(Type element) {
      methodMetaTypesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link WeavingClassVisitor.MethodMetaGroupBase#methodMetaTypes() methodMetaTypes} set.
     * @param elements array of methodMetaTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addMethodMetaTypes(Type... elements) {
      methodMetaTypesBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link WeavingClassVisitor.MethodMetaGroupBase#methodMetaTypes() methodMetaTypes} set.
     * @param elements iterable of methodMetaTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllMethodMetaTypes(Iterable<? extends Type> elements) {
      methodMetaTypesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.weaving.MethodMetaGroup}.
     * @return immutable instance of MethodMetaGroup
     */
    public org.glowroot.weaving.MethodMetaGroup build() {
      checkRequiredAttributes();
      return new MethodMetaGroup(returnType, parameterTypesBuilder.build(), uniqueNum, methodMetaTypesBuilder.build());
    }
  
    private boolean returnTypeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_RETURN_TYPE) != 0;
    }
  
    private boolean uniqueNumIsSet() {
      return (initializedBitset & INITIALIZED_BIT_UNIQUE_NUM) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of MethodMetaGroup is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!returnTypeIsSet()) {
        attributes.add("returnType");
      }
      if (!uniqueNumIsSet()) {
        attributes.add("uniqueNum");
      }
      return "Cannot build MethodMetaGroup, some of required attributes are not set " + attributes;
    }
  }
}
