/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.collector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.glowroot.collector.Aggregate;
import org.glowroot.collector.AggregateBuilder;
import org.glowroot.collector.AggregateRepository;
import org.glowroot.collector.ErrorPoint;
import org.glowroot.collector.ErrorSummary;
import org.glowroot.collector.ProfileAggregate;
import org.glowroot.collector.QueryAggregate;
import org.glowroot.collector.TransactionSummary;
import org.glowroot.common.ScratchBuffer;
import org.glowroot.config.ConfigService;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.Maps;
import org.glowroot.shaded.google.common.io.CharSource;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.glowroot.transaction.model.Profile;
import org.glowroot.transaction.model.Transaction;

public class AggregateIntervalCollector {
    private static final Logger logger = LoggerFactory.getLogger(AggregateIntervalCollector.class);
    private static final AtomicBoolean maxAggregateTransactionsWarnLogged = new AtomicBoolean();
    private final long endTime;
    private final Map<String, IntervalTypeCollector> typeCollectors = Maps.newConcurrentMap();
    private final int maxAggregateTransactionsPerTransactionType;
    private final int maxAggregateQueriesPerQueryType;

    AggregateIntervalCollector(long currentTime, long fixedAggregateIntervalMillis, ConfigService configService) {
        this.endTime = (long)Math.ceil((double)currentTime / (double)fixedAggregateIntervalMillis) * fixedAggregateIntervalMillis;
        this.maxAggregateTransactionsPerTransactionType = configService.getAdvancedConfig().maxAggregateTransactionsPerTransactionType();
        this.maxAggregateQueriesPerQueryType = configService.getAdvancedConfig().maxAggregateQueriesPerQueryType();
    }

    public long getEndTime() {
        return this.endTime;
    }

    void add(Transaction transaction) {
        IntervalTypeCollector typeBuilder = this.getTypeBuilder(transaction.getTransactionType());
        typeBuilder.add(transaction);
    }

    void flush(AggregateRepository aggregateRepository) throws Exception {
        ArrayList<Aggregate> overallAggregates = Lists.newArrayList();
        ArrayList<Aggregate> transactionAggregates = Lists.newArrayList();
        ScratchBuffer scratchBuffer = new ScratchBuffer();
        for (Map.Entry<String, IntervalTypeCollector> e : this.typeCollectors.entrySet()) {
            IntervalTypeCollector intervalTypeCollector = e.getValue();
            overallAggregates.add(this.build(intervalTypeCollector.overallBuilder, scratchBuffer));
            for (Map.Entry f : intervalTypeCollector.transactionBuilders.entrySet()) {
                transactionAggregates.add(this.build((AggregateBuilder)f.getValue(), scratchBuffer));
            }
        }
        aggregateRepository.store(overallAggregates, transactionAggregates, this.endTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public TransactionSummary getLiveOverallSummary(String transactionType) {
        AggregateBuilder aggregateBuilder;
        IntervalTypeCollector intervalTypeCollector = this.typeCollectors.get(transactionType);
        if (intervalTypeCollector == null) {
            return null;
        }
        AggregateBuilder aggregateBuilder2 = aggregateBuilder = intervalTypeCollector.overallBuilder;
        synchronized (aggregateBuilder2) {
            return aggregateBuilder.getLiveTransactionSummary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TransactionSummary> getLiveTransactionSummaries(String transactionType) {
        IntervalTypeCollector intervalTypeCollector = this.typeCollectors.get(transactionType);
        if (intervalTypeCollector == null) {
            return ImmutableList.of();
        }
        ArrayList<TransactionSummary> transactionSummaries = Lists.newArrayList();
        for (Map.Entry entry : intervalTypeCollector.transactionBuilders.entrySet()) {
            AggregateBuilder aggregateBuilder;
            AggregateBuilder aggregateBuilder2 = aggregateBuilder = (AggregateBuilder)entry.getValue();
            synchronized (aggregateBuilder2) {
                transactionSummaries.add(aggregateBuilder.getLiveTransactionSummary());
            }
        }
        return transactionSummaries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ErrorSummary getLiveOverallErrorSummary(String transactionType) {
        AggregateBuilder aggregateBuilder;
        IntervalTypeCollector intervalTypeCollector = this.typeCollectors.get(transactionType);
        if (intervalTypeCollector == null) {
            return null;
        }
        AggregateBuilder aggregateBuilder2 = aggregateBuilder = intervalTypeCollector.overallBuilder;
        synchronized (aggregateBuilder2) {
            return aggregateBuilder.getLiveErrorSummary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ErrorSummary> getLiveTransactionErrorSummaries(String transactionType) {
        IntervalTypeCollector intervalTypeCollector = this.typeCollectors.get(transactionType);
        if (intervalTypeCollector == null) {
            return ImmutableList.of();
        }
        ArrayList<ErrorSummary> errorSummaries = Lists.newArrayList();
        for (Map.Entry entry : intervalTypeCollector.transactionBuilders.entrySet()) {
            AggregateBuilder aggregateBuilder;
            AggregateBuilder aggregateBuilder2 = aggregateBuilder = (AggregateBuilder)entry.getValue();
            synchronized (aggregateBuilder2) {
                errorSummaries.add(aggregateBuilder.getLiveErrorSummary());
            }
        }
        return errorSummaries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Aggregate getLiveAggregate(String transactionType, @Nullable String transactionName, long liveCaptureTime) throws IOException {
        AggregateBuilder aggregateBuilder = this.getAggregateBuilder(transactionType, transactionName);
        if (aggregateBuilder == null) {
            return null;
        }
        AggregateBuilder aggregateBuilder2 = aggregateBuilder;
        synchronized (aggregateBuilder2) {
            long capturedAt = Math.min(liveCaptureTime, this.endTime);
            return aggregateBuilder.build(capturedAt, new ScratchBuffer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ErrorPoint getLiveErrorPoint(String transactionType, @Nullable String transactionName, long liveCaptureTime) throws IOException {
        AggregateBuilder aggregateBuilder = this.getAggregateBuilder(transactionType, transactionName);
        if (aggregateBuilder == null) {
            return null;
        }
        AggregateBuilder aggregateBuilder2 = aggregateBuilder;
        synchronized (aggregateBuilder2) {
            long capturedAt = Math.min(liveCaptureTime, this.endTime);
            return aggregateBuilder.buildErrorPoint(capturedAt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public QueryAggregate getLiveQueryAggregate(String transactionType, @Nullable String transactionName) throws IOException {
        String queriesJson;
        AggregateBuilder aggregateBuilder = this.getAggregateBuilder(transactionType, transactionName);
        if (aggregateBuilder == null) {
            return null;
        }
        AggregateBuilder aggregateBuilder2 = aggregateBuilder;
        synchronized (aggregateBuilder2) {
            queriesJson = aggregateBuilder.getQueriesJson();
        }
        if (queriesJson == null) {
            return null;
        }
        return QueryAggregate.of(this.endTime, CharSource.wrap(queriesJson));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ProfileAggregate getLiveProfileAggregate(String transactionType, @Nullable String transactionName) throws IOException {
        String profileJson;
        AggregateBuilder aggregateBuilder = this.getAggregateBuilder(transactionType, transactionName);
        if (aggregateBuilder == null) {
            return null;
        }
        AggregateBuilder aggregateBuilder2 = aggregateBuilder;
        synchronized (aggregateBuilder2) {
            profileJson = aggregateBuilder.getProfileJson();
        }
        if (profileJson == null) {
            return null;
        }
        return ProfileAggregate.of(this.endTime, CharSource.wrap(profileJson));
    }

    void clear() {
        this.typeCollectors.clear();
    }

    private IntervalTypeCollector getTypeBuilder(String transactionType) {
        IntervalTypeCollector typeBuilder = this.typeCollectors.get(transactionType);
        if (typeBuilder == null) {
            typeBuilder = new IntervalTypeCollector(transactionType);
            this.typeCollectors.put(transactionType, typeBuilder);
        }
        return typeBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Aggregate build(AggregateBuilder aggregateBuilder, ScratchBuffer scratchBuffer) throws IOException {
        AggregateBuilder aggregateBuilder2 = aggregateBuilder;
        synchronized (aggregateBuilder2) {
            return aggregateBuilder.build(this.endTime, scratchBuffer);
        }
    }

    @Nullable
    private AggregateBuilder getAggregateBuilder(String transactionType, @Nullable String transactionName) {
        IntervalTypeCollector intervalTypeCollector = this.typeCollectors.get(transactionType);
        if (intervalTypeCollector == null) {
            return null;
        }
        if (transactionName == null) {
            return intervalTypeCollector.overallBuilder;
        }
        return (AggregateBuilder)intervalTypeCollector.transactionBuilders.get(transactionName);
    }

    private class IntervalTypeCollector {
        private final String transactionType;
        private final AggregateBuilder overallBuilder;
        private final Map<String, AggregateBuilder> transactionBuilders = Maps.newConcurrentMap();

        private IntervalTypeCollector(String transactionType) {
            this.transactionType = transactionType;
            this.overallBuilder = new AggregateBuilder(transactionType, null, AggregateIntervalCollector.this.maxAggregateQueriesPerQueryType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(Transaction transaction) {
            Profile profile = transaction.getProfile();
            AggregateBuilder aggregateBuilder = this.overallBuilder;
            synchronized (aggregateBuilder) {
                this.overallBuilder.add(transaction);
                this.overallBuilder.addToTimers(transaction.getRootTimer());
                this.overallBuilder.addToQueries(transaction.getQueries());
                if (profile != null) {
                    this.overallBuilder.addToProfile(profile);
                }
            }
            AggregateBuilder transactionBuilder = this.transactionBuilders.get(transaction.getTransactionName());
            if (transactionBuilder == null && this.transactionBuilders.size() < AggregateIntervalCollector.this.maxAggregateTransactionsPerTransactionType) {
                transactionBuilder = new AggregateBuilder(this.transactionType, transaction.getTransactionName(), AggregateIntervalCollector.this.maxAggregateQueriesPerQueryType);
                this.transactionBuilders.put(transaction.getTransactionName(), transactionBuilder);
            }
            if (transactionBuilder == null) {
                if (!maxAggregateTransactionsWarnLogged.getAndSet(true)) {
                    logger.warn("the max transaction names per transaction type was exceeded during the current interval. consider increasing the limit under Configuration > Advanced, or reducing the number of transaction names by configuring instrumentation points under Configuration > Instrumentation that override the transaction name.");
                }
                return;
            }
            AggregateBuilder aggregateBuilder2 = transactionBuilder;
            synchronized (aggregateBuilder2) {
                transactionBuilder.add(transaction);
                transactionBuilder.addToTimers(transaction.getRootTimer());
                transactionBuilder.addToQueries(transaction.getQueries());
                if (profile != null) {
                    this.overallBuilder.addToProfile(profile);
                    transactionBuilder.addToProfile(profile);
                }
            }
        }
    }
}

