/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.collector;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.glowroot.collector.GaugePoint;
import org.glowroot.collector.GaugePointRepository;
import org.glowroot.collector.PatternObjectNameQueryExp;
import org.glowroot.common.Clock;
import org.glowroot.common.Reflections;
import org.glowroot.common.ScheduledRunnable;
import org.glowroot.config.ConfigService;
import org.glowroot.config.GaugeConfig;
import org.glowroot.config.MBeanAttribute;
import org.glowroot.jvm.LazyPlatformMBeanServer;
import org.glowroot.shaded.google.common.annotations.VisibleForTesting;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.Sets;
import org.glowroot.shaded.google.common.util.concurrent.ThreadFactoryBuilder;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

class GaugeCollector
extends ScheduledRunnable {
    private final Logger logger;
    private final ConfigService configService;
    private final GaugePointRepository gaugePointRepository;
    private final LazyPlatformMBeanServer lazyPlatformMBeanServer;
    private final ScheduledExecutorService scheduledExecutor;
    private final Clock clock;
    private final long startTimeMillis;
    private final Set<String> pendingLoggedMBeanGauges = Sets.newConcurrentHashSet();
    private final Set<String> loggedMBeanGauges = Sets.newConcurrentHashSet();
    private final ScheduledExecutorService dedicatedScheduledExecutor;

    GaugeCollector(ConfigService configService, GaugePointRepository gaugePointRepository, LazyPlatformMBeanServer lazyPlatformMBeanServer, ScheduledExecutorService scheduledExecutor, Clock clock, @Nullable Logger logger) {
        this.configService = configService;
        this.gaugePointRepository = gaugePointRepository;
        this.lazyPlatformMBeanServer = lazyPlatformMBeanServer;
        this.scheduledExecutor = scheduledExecutor;
        this.clock = clock;
        this.startTimeMillis = clock.currentTimeMillis();
        this.logger = logger == null ? LoggerFactory.getLogger(GaugeCollector.class) : logger;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Glowroot-Gauge-Collector-%d").build();
        this.dedicatedScheduledExecutor = Executors.newScheduledThreadPool(1, threadFactory);
        lazyPlatformMBeanServer.possiblyDelayedCall(new LazyPlatformMBeanServer.MBeanServerCallback(){

            @Override
            public void call(MBeanServer mbeanServer) {
                try {
                    Class<?> sunManagementFactoryHelperClass = Class.forName("sun.management.ManagementFactoryHelper");
                    Method registerInternalMBeansMethod = Reflections.getDeclaredMethod(sunManagementFactoryHelperClass, "registerInternalMBeans", MBeanServer.class);
                    registerInternalMBeansMethod.invoke(null, mbeanServer);
                }
                catch (Exception e) {
                    Preconditions.checkNotNull(GaugeCollector.this.logger).debug(e.getMessage(), e);
                }
            }
        });
    }

    @Override
    protected void runInternal() throws Exception {
        final ArrayList<GaugePoint> gaugePoints = Lists.newArrayList();
        for (GaugeConfig gaugeConfig : this.configService.getGaugeConfigs()) {
            gaugePoints.addAll(this.collectGaugePoints(gaugeConfig));
        }
        try {
            this.scheduledExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        GaugeCollector.this.gaugePointRepository.store(gaugePoints);
                    }
                    catch (Throwable t) {
                        GaugeCollector.this.logger.error(t.getMessage(), t);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            if (this.scheduledExecutor.isShutdown()) {
                this.logger.debug(e.getMessage(), e);
                return;
            }
            throw e;
        }
    }

    void scheduleAtFixedRate(long initialDelay, long period, TimeUnit unit) {
        this.scheduleAtFixedRate(this.dedicatedScheduledExecutor, initialDelay, period, unit);
    }

    void close() {
        this.dedicatedScheduledExecutor.shutdownNow();
    }

    @VisibleForTesting
    List<GaugePoint> collectGaugePoints(GaugeConfig gaugeConfig) throws InterruptedException {
        String mbeanObjectName = gaugeConfig.mbeanObjectName();
        if (!mbeanObjectName.contains("*")) {
            ObjectName objectName;
            try {
                objectName = ObjectName.getInstance(mbeanObjectName);
            }
            catch (MalformedObjectNameException e) {
                this.logger.debug(e.getMessage(), e);
                this.logFirstTimeMBeanException(mbeanObjectName, e.toString());
                return ImmutableList.of();
            }
            return this.collectGaugePoints(objectName, gaugeConfig.mbeanAttributes(), mbeanObjectName);
        }
        Set<ObjectName> objectNames = this.lazyPlatformMBeanServer.queryNames(null, new PatternObjectNameQueryExp(mbeanObjectName));
        if (objectNames.isEmpty()) {
            this.logFirstTimeMBeanNotMatchedOrFound(mbeanObjectName);
            return ImmutableList.of();
        }
        ArrayList<GaugePoint> gaugePoints = Lists.newArrayList();
        for (ObjectName objectName : objectNames) {
            gaugePoints.addAll(this.collectGaugePoints(objectName, gaugeConfig.mbeanAttributes(), objectName.getDomain() + ":" + objectName.getKeyPropertyListString()));
        }
        return gaugePoints;
    }

    private List<GaugePoint> collectGaugePoints(ObjectName objectName, List<MBeanAttribute> mbeanAttributes, String mbeanObjectName) {
        long captureTime = this.clock.currentTimeMillis();
        ArrayList<GaugePoint> gaugePoints = Lists.newArrayList();
        for (MBeanAttribute mbeanAttribute : mbeanAttributes) {
            Object attributeValue;
            String mbeanAttributeName = mbeanAttribute.name();
            try {
                if (mbeanAttributeName.contains("/")) {
                    String[] path = mbeanAttributeName.split("\\/");
                    attributeValue = this.lazyPlatformMBeanServer.getAttribute(objectName, path[0]);
                    CompositeData compositeData = (CompositeData)attributeValue;
                    attributeValue = compositeData.get(path[1]);
                } else {
                    attributeValue = this.lazyPlatformMBeanServer.getAttribute(objectName, mbeanAttributeName);
                }
            }
            catch (InstanceNotFoundException e) {
                this.logger.debug(e.getMessage(), e);
                this.logFirstTimeMBeanNotMatchedOrFound(mbeanObjectName);
                break;
            }
            catch (AttributeNotFoundException e) {
                this.logger.debug(e.getMessage(), e);
                this.logFirstTimeMBeanAttributeNotFound(mbeanObjectName, mbeanAttributeName);
                continue;
            }
            catch (Exception e) {
                this.logger.debug(e.getMessage(), e);
                this.logFirstTimeMBeanAttributeError(mbeanObjectName, mbeanAttributeName, e.toString());
                continue;
            }
            Double value = null;
            if (attributeValue instanceof Number) {
                value = ((Number)attributeValue).doubleValue();
            } else if (attributeValue instanceof String) {
                try {
                    value = Double.parseDouble((String)attributeValue);
                }
                catch (NumberFormatException e) {
                    this.logFirstTimeMBeanAttributeError(mbeanObjectName, mbeanAttributeName, "MBean attribute value is not a valid number: \"" + attributeValue + "\"");
                }
            } else {
                this.logFirstTimeMBeanAttributeError(mbeanObjectName, mbeanAttributeName, "MBean attribute value is not a number or string");
            }
            if (value == null) continue;
            gaugePoints.add(GaugePoint.builder().gaugeName(mbeanObjectName + ',' + mbeanAttributeName).everIncreasing(mbeanAttribute.everIncreasing()).captureTime(captureTime).value(value).build());
        }
        return gaugePoints;
    }

    private void logFirstTimeMBeanNotMatchedOrFound(String mbeanObjectName) {
        int delaySeconds = this.configService.getAdvancedConfig().mbeanGaugeNotFoundDelaySeconds();
        if (this.clock.currentTimeMillis() - this.startTimeMillis < (long)delaySeconds * 1000L) {
            this.pendingLoggedMBeanGauges.add(mbeanObjectName);
        } else if (this.loggedMBeanGauges.add(mbeanObjectName)) {
            String matchedOrFound;
            String string = matchedOrFound = mbeanObjectName.contains("*") ? "matched" : "found";
            if (this.pendingLoggedMBeanGauges.remove(mbeanObjectName)) {
                this.logger.warn("mbean not {}: {} (waited {} seconds after jvm startup before logging this warning to allow time for mbean registration - this wait time can be changed under Configuration > Advanced)", matchedOrFound, mbeanObjectName, delaySeconds);
            } else {
                this.logger.warn("mbean not {}: {}", (Object)matchedOrFound, (Object)mbeanObjectName);
            }
        }
    }

    private void logFirstTimeMBeanAttributeNotFound(String mbeanObjectName, String mbeanAttributeName) {
        if (this.loggedMBeanGauges.add(mbeanObjectName + "/" + mbeanAttributeName)) {
            this.logger.warn("mbean attribute {} not found: {}", (Object)mbeanAttributeName, (Object)mbeanObjectName);
        }
    }

    private void logFirstTimeMBeanException(String mbeanObjectName, @Nullable String message) {
        if (this.loggedMBeanGauges.add(mbeanObjectName)) {
            this.logger.warn("error accessing mbean {}: {}", (Object)mbeanObjectName, (Object)message);
        }
    }

    private void logFirstTimeMBeanAttributeError(String mbeanObjectName, String mbeanAttributeName, @Nullable String message) {
        if (this.loggedMBeanGauges.add(mbeanObjectName + "/" + mbeanAttributeName)) {
            this.logger.warn("error accessing mbean attribute {} {}: {}", mbeanObjectName, mbeanAttributeName, message);
        }
    }
}

