/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.common;

import java.io.File;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.glowroot.shaded.google.common.base.Charsets;
import org.glowroot.shaded.google.common.io.BaseEncoding;
import org.glowroot.shaded.google.common.io.Files;

public class Encryption {
    private static final SecureRandom secureRandom = new SecureRandom();
    private static final BaseEncoding encoder = BaseEncoding.base64().omitPadding();

    private Encryption() {
    }

    public static SecretKey generateNewKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(128);
        return keyGen.generateKey();
    }

    public static SecretKey loadKey(File secretFile) throws Exception {
        byte[] bytes = Files.toByteArray(secretFile);
        return new SecretKeySpec(bytes, "AES");
    }

    public static String encrypt(String text, SecretKey secretKey) throws GeneralSecurityException {
        byte[] iv = new byte[16];
        secureRandom.nextBytes(iv);
        Cipher aesCipherForEncryption = Cipher.getInstance("AES/CBC/PKCS5Padding");
        aesCipherForEncryption.init(1, (Key)secretKey, new IvParameterSpec(iv));
        byte[] encryptedBytes = aesCipherForEncryption.doFinal(text.getBytes(Charsets.UTF_8));
        return encoder.encode(encryptedBytes) + ':' + encoder.encode(iv);
    }

    public static String decrypt(String encrypted, SecretKey secretKey) throws GeneralSecurityException {
        String[] parts = encrypted.split(":");
        byte[] encryptedText = encoder.decode(parts[0]);
        byte[] iv = encoder.decode(parts[1]);
        Cipher aesCipherForDecryption = Cipher.getInstance("AES/CBC/PKCS5Padding");
        aesCipherForDecryption.init(2, (Key)secretKey, new IvParameterSpec(iv));
        byte[] decryptedBytes = aesCipherForDecryption.doFinal(encryptedText);
        return new String(decryptedBytes, Charsets.UTF_8);
    }
}

