/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.common;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.common.SpyingLogbackFilter;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;

@ParametersAreNonnullByDefault
@Immutable
final class ExpectedMessage
extends SpyingLogbackFilter.ExpectedMessageBase {
    private final String loggerName;
    private final String partialMessage;

    private ExpectedMessage(String loggerName, String partialMessage) {
        this.loggerName = loggerName;
        this.partialMessage = partialMessage;
    }

    @Override
    @JsonProperty(value="loggerName")
    public String loggerName() {
        return this.loggerName;
    }

    @Override
    @JsonProperty(value="partialMessage")
    public String partialMessage() {
        return this.partialMessage;
    }

    public final ExpectedMessage withLoggerName(String value) {
        if (this.loggerName == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ExpectedMessage(newValue, this.partialMessage);
    }

    public final ExpectedMessage withPartialMessage(String value) {
        if (this.partialMessage == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ExpectedMessage(this.loggerName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof ExpectedMessage && this.equalTo((ExpectedMessage)another);
    }

    private boolean equalTo(ExpectedMessage another) {
        return this.loggerName.equals(another.loggerName) && this.partialMessage.equals(another.partialMessage);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.loggerName.hashCode();
        h = h * 17 + this.partialMessage.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ExpectedMessage").add("loggerName", this.loggerName).add("partialMessage", this.partialMessage).toString();
    }

    @JsonCreator
    public static ExpectedMessage fromAllAttributes(@JsonProperty(value="loggerName") @Nullable String loggerName, @JsonProperty(value="partialMessage") @Nullable String partialMessage) {
        Builder builder = ExpectedMessage.builder();
        if (loggerName != null) {
            builder.loggerName(loggerName);
        }
        if (partialMessage != null) {
            builder.partialMessage(partialMessage);
        }
        return builder.build();
    }

    public static ExpectedMessage of(String loggerName, String partialMessage) {
        return new ExpectedMessage(loggerName, partialMessage);
    }

    static ExpectedMessage copyOf(SpyingLogbackFilter.ExpectedMessageBase instance) {
        if (instance instanceof ExpectedMessage) {
            return (ExpectedMessage)instance;
        }
        return ExpectedMessage.builder().loggerName(instance.loggerName()).partialMessage(instance.partialMessage()).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_LOGGER_NAME = 1L;
        private static final long INITIALIZED_BIT_PARTIAL_MESSAGE = 2L;
        private long initializedBitset;
        @Nullable
        private String loggerName;
        @Nullable
        private String partialMessage;

        private Builder() {
        }

        public final Builder loggerName(String loggerName) {
            this.checkNotIsSet(this.loggerNameIsSet(), "loggerName");
            this.loggerName = Preconditions.checkNotNull(loggerName);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder partialMessage(String partialMessage) {
            this.checkNotIsSet(this.partialMessageIsSet(), "partialMessage");
            this.partialMessage = Preconditions.checkNotNull(partialMessage);
            this.initializedBitset |= 2L;
            return this;
        }

        public ExpectedMessage build() {
            this.checkRequiredAttributes();
            return new ExpectedMessage(this.loggerName, this.partialMessage);
        }

        private boolean loggerNameIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean partialMessageIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of ExpectedMessage is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.loggerNameIsSet()) {
                attributes.add("loggerName");
            }
            if (!this.partialMessageIsSet()) {
                attributes.add("partialMessage");
            }
            return "Cannot build ExpectedMessage, some of required attributes are not set " + attributes;
        }
    }
}

