/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.config;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.AdvancedConfig;
import org.glowroot.config.AlertConfig;
import org.glowroot.config.ConfigBase;
import org.glowroot.config.GaugeConfig;
import org.glowroot.config.GeneralConfig;
import org.glowroot.config.InstrumentationConfig;
import org.glowroot.config.PluginConfig;
import org.glowroot.config.SmtpConfig;
import org.glowroot.config.StorageConfig;
import org.glowroot.config.UserInterfaceConfig;
import org.glowroot.config.UserRecordingConfig;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;

@ParametersAreNonnullByDefault
@Immutable
final class Config
extends ConfigBase {
    private final GeneralConfig generalConfig;
    private final UserInterfaceConfig userInterfaceConfig;
    private final StorageConfig storageConfig;
    private final SmtpConfig smtpConfig;
    private final UserRecordingConfig userRecordingConfig;
    private final AdvancedConfig advancedConfig;
    private final ImmutableList<PluginConfig> pluginConfigs;
    private final ImmutableList<InstrumentationConfig> instrumentationConfigs;
    private final ImmutableList<GaugeConfig> gaugeConfigs;
    private final ImmutableList<AlertConfig> alertConfigs;

    private Config(Builder builder) {
        this.pluginConfigs = builder.pluginConfigsBuilder.build();
        this.instrumentationConfigs = builder.instrumentationConfigsBuilder.build();
        this.gaugeConfigs = builder.gaugeConfigsBuilder.build();
        this.alertConfigs = builder.alertConfigsBuilder.build();
        this.generalConfig = builder.generalConfig != null ? builder.generalConfig : Preconditions.checkNotNull(super.generalConfig());
        this.userInterfaceConfig = builder.userInterfaceConfig != null ? builder.userInterfaceConfig : Preconditions.checkNotNull(super.userInterfaceConfig());
        this.storageConfig = builder.storageConfig != null ? builder.storageConfig : Preconditions.checkNotNull(super.storageConfig());
        this.smtpConfig = builder.smtpConfig != null ? builder.smtpConfig : Preconditions.checkNotNull(super.smtpConfig());
        this.userRecordingConfig = builder.userRecordingConfig != null ? builder.userRecordingConfig : Preconditions.checkNotNull(super.userRecordingConfig());
        this.advancedConfig = builder.advancedConfig != null ? builder.advancedConfig : Preconditions.checkNotNull(super.advancedConfig());
    }

    private Config(GeneralConfig generalConfig, UserInterfaceConfig userInterfaceConfig, StorageConfig storageConfig, SmtpConfig smtpConfig, UserRecordingConfig userRecordingConfig, AdvancedConfig advancedConfig, ImmutableList<PluginConfig> pluginConfigs, ImmutableList<InstrumentationConfig> instrumentationConfigs, ImmutableList<GaugeConfig> gaugeConfigs, ImmutableList<AlertConfig> alertConfigs) {
        this.generalConfig = generalConfig;
        this.userInterfaceConfig = userInterfaceConfig;
        this.storageConfig = storageConfig;
        this.smtpConfig = smtpConfig;
        this.userRecordingConfig = userRecordingConfig;
        this.advancedConfig = advancedConfig;
        this.pluginConfigs = pluginConfigs;
        this.instrumentationConfigs = instrumentationConfigs;
        this.gaugeConfigs = gaugeConfigs;
        this.alertConfigs = alertConfigs;
    }

    @Override
    @JsonProperty(value="general")
    public GeneralConfig generalConfig() {
        return this.generalConfig;
    }

    @Override
    @JsonProperty(value="ui")
    public UserInterfaceConfig userInterfaceConfig() {
        return this.userInterfaceConfig;
    }

    @Override
    @JsonProperty(value="storage")
    public StorageConfig storageConfig() {
        return this.storageConfig;
    }

    @Override
    @JsonProperty(value="smtp")
    public SmtpConfig smtpConfig() {
        return this.smtpConfig;
    }

    @Override
    @JsonProperty(value="userRecording")
    public UserRecordingConfig userRecordingConfig() {
        return this.userRecordingConfig;
    }

    @Override
    @JsonProperty(value="advanced")
    public AdvancedConfig advancedConfig() {
        return this.advancedConfig;
    }

    @Override
    @JsonProperty(value="plugins")
    public ImmutableList<PluginConfig> pluginConfigs() {
        return this.pluginConfigs;
    }

    @Override
    @JsonProperty(value="instrumentation")
    public ImmutableList<InstrumentationConfig> instrumentationConfigs() {
        return this.instrumentationConfigs;
    }

    @Override
    @JsonProperty(value="gauges")
    public ImmutableList<GaugeConfig> gaugeConfigs() {
        return this.gaugeConfigs;
    }

    @Override
    @JsonProperty(value="alerts")
    public ImmutableList<AlertConfig> alertConfigs() {
        return this.alertConfigs;
    }

    public final Config withGeneralConfig(GeneralConfig value) {
        if (this.generalConfig == value) {
            return this;
        }
        GeneralConfig newValue = Preconditions.checkNotNull(value);
        return new Config(newValue, this.userInterfaceConfig, this.storageConfig, this.smtpConfig, this.userRecordingConfig, this.advancedConfig, this.pluginConfigs, this.instrumentationConfigs, this.gaugeConfigs, this.alertConfigs);
    }

    public final Config withUserInterfaceConfig(UserInterfaceConfig value) {
        if (this.userInterfaceConfig == value) {
            return this;
        }
        UserInterfaceConfig newValue = Preconditions.checkNotNull(value);
        return new Config(this.generalConfig, newValue, this.storageConfig, this.smtpConfig, this.userRecordingConfig, this.advancedConfig, this.pluginConfigs, this.instrumentationConfigs, this.gaugeConfigs, this.alertConfigs);
    }

    public final Config withStorageConfig(StorageConfig value) {
        if (this.storageConfig == value) {
            return this;
        }
        StorageConfig newValue = Preconditions.checkNotNull(value);
        return new Config(this.generalConfig, this.userInterfaceConfig, newValue, this.smtpConfig, this.userRecordingConfig, this.advancedConfig, this.pluginConfigs, this.instrumentationConfigs, this.gaugeConfigs, this.alertConfigs);
    }

    public final Config withSmtpConfig(SmtpConfig value) {
        if (this.smtpConfig == value) {
            return this;
        }
        SmtpConfig newValue = Preconditions.checkNotNull(value);
        return new Config(this.generalConfig, this.userInterfaceConfig, this.storageConfig, newValue, this.userRecordingConfig, this.advancedConfig, this.pluginConfigs, this.instrumentationConfigs, this.gaugeConfigs, this.alertConfigs);
    }

    public final Config withUserRecordingConfig(UserRecordingConfig value) {
        if (this.userRecordingConfig == value) {
            return this;
        }
        UserRecordingConfig newValue = Preconditions.checkNotNull(value);
        return new Config(this.generalConfig, this.userInterfaceConfig, this.storageConfig, this.smtpConfig, newValue, this.advancedConfig, this.pluginConfigs, this.instrumentationConfigs, this.gaugeConfigs, this.alertConfigs);
    }

    public final Config withAdvancedConfig(AdvancedConfig value) {
        if (this.advancedConfig == value) {
            return this;
        }
        AdvancedConfig newValue = Preconditions.checkNotNull(value);
        return new Config(this.generalConfig, this.userInterfaceConfig, this.storageConfig, this.smtpConfig, this.userRecordingConfig, newValue, this.pluginConfigs, this.instrumentationConfigs, this.gaugeConfigs, this.alertConfigs);
    }

    public final Config withPluginConfigs(PluginConfig ... elements) {
        ImmutableList<PluginConfig> newValue = ImmutableList.copyOf(elements);
        return new Config(this.generalConfig, this.userInterfaceConfig, this.storageConfig, this.smtpConfig, this.userRecordingConfig, this.advancedConfig, newValue, this.instrumentationConfigs, this.gaugeConfigs, this.alertConfigs);
    }

    public final Config withPluginConfigs(Iterable<? extends PluginConfig> elements) {
        if (this.pluginConfigs == elements) {
            return this;
        }
        ImmutableList<PluginConfig> newValue = ImmutableList.copyOf(elements);
        return new Config(this.generalConfig, this.userInterfaceConfig, this.storageConfig, this.smtpConfig, this.userRecordingConfig, this.advancedConfig, newValue, this.instrumentationConfigs, this.gaugeConfigs, this.alertConfigs);
    }

    public final Config withInstrumentationConfigs(InstrumentationConfig ... elements) {
        ImmutableList<InstrumentationConfig> newValue = ImmutableList.copyOf(elements);
        return new Config(this.generalConfig, this.userInterfaceConfig, this.storageConfig, this.smtpConfig, this.userRecordingConfig, this.advancedConfig, this.pluginConfigs, newValue, this.gaugeConfigs, this.alertConfigs);
    }

    public final Config withInstrumentationConfigs(Iterable<? extends InstrumentationConfig> elements) {
        if (this.instrumentationConfigs == elements) {
            return this;
        }
        ImmutableList<InstrumentationConfig> newValue = ImmutableList.copyOf(elements);
        return new Config(this.generalConfig, this.userInterfaceConfig, this.storageConfig, this.smtpConfig, this.userRecordingConfig, this.advancedConfig, this.pluginConfigs, newValue, this.gaugeConfigs, this.alertConfigs);
    }

    public final Config withGaugeConfigs(GaugeConfig ... elements) {
        ImmutableList<GaugeConfig> newValue = ImmutableList.copyOf(elements);
        return new Config(this.generalConfig, this.userInterfaceConfig, this.storageConfig, this.smtpConfig, this.userRecordingConfig, this.advancedConfig, this.pluginConfigs, this.instrumentationConfigs, newValue, this.alertConfigs);
    }

    public final Config withGaugeConfigs(Iterable<? extends GaugeConfig> elements) {
        if (this.gaugeConfigs == elements) {
            return this;
        }
        ImmutableList<GaugeConfig> newValue = ImmutableList.copyOf(elements);
        return new Config(this.generalConfig, this.userInterfaceConfig, this.storageConfig, this.smtpConfig, this.userRecordingConfig, this.advancedConfig, this.pluginConfigs, this.instrumentationConfigs, newValue, this.alertConfigs);
    }

    public final Config withAlertConfigs(AlertConfig ... elements) {
        ImmutableList<AlertConfig> newValue = ImmutableList.copyOf(elements);
        return new Config(this.generalConfig, this.userInterfaceConfig, this.storageConfig, this.smtpConfig, this.userRecordingConfig, this.advancedConfig, this.pluginConfigs, this.instrumentationConfigs, this.gaugeConfigs, newValue);
    }

    public final Config withAlertConfigs(Iterable<? extends AlertConfig> elements) {
        if (this.alertConfigs == elements) {
            return this;
        }
        ImmutableList<AlertConfig> newValue = ImmutableList.copyOf(elements);
        return new Config(this.generalConfig, this.userInterfaceConfig, this.storageConfig, this.smtpConfig, this.userRecordingConfig, this.advancedConfig, this.pluginConfigs, this.instrumentationConfigs, this.gaugeConfigs, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof Config && this.equalTo((Config)another);
    }

    private boolean equalTo(Config another) {
        return this.generalConfig.equals(another.generalConfig) && this.userInterfaceConfig.equals(another.userInterfaceConfig) && this.storageConfig.equals(another.storageConfig) && this.smtpConfig.equals(another.smtpConfig) && this.userRecordingConfig.equals(another.userRecordingConfig) && this.advancedConfig.equals(another.advancedConfig) && this.pluginConfigs.equals(another.pluginConfigs) && this.instrumentationConfigs.equals(another.instrumentationConfigs) && this.gaugeConfigs.equals(another.gaugeConfigs) && this.alertConfigs.equals(another.alertConfigs);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.generalConfig.hashCode();
        h = h * 17 + this.userInterfaceConfig.hashCode();
        h = h * 17 + this.storageConfig.hashCode();
        h = h * 17 + this.smtpConfig.hashCode();
        h = h * 17 + this.userRecordingConfig.hashCode();
        h = h * 17 + this.advancedConfig.hashCode();
        h = h * 17 + this.pluginConfigs.hashCode();
        h = h * 17 + this.instrumentationConfigs.hashCode();
        h = h * 17 + this.gaugeConfigs.hashCode();
        h = h * 17 + this.alertConfigs.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Config").add("generalConfig", this.generalConfig).add("userInterfaceConfig", this.userInterfaceConfig).add("storageConfig", this.storageConfig).add("smtpConfig", this.smtpConfig).add("userRecordingConfig", this.userRecordingConfig).add("advancedConfig", this.advancedConfig).add("pluginConfigs", this.pluginConfigs).add("instrumentationConfigs", this.instrumentationConfigs).add("gaugeConfigs", this.gaugeConfigs).add("alertConfigs", this.alertConfigs).toString();
    }

    @JsonCreator
    public static Config fromAllAttributes(@JsonProperty(value="general") @Nullable GeneralConfig generalConfig, @JsonProperty(value="ui") @Nullable UserInterfaceConfig userInterfaceConfig, @JsonProperty(value="storage") @Nullable StorageConfig storageConfig, @JsonProperty(value="smtp") @Nullable SmtpConfig smtpConfig, @JsonProperty(value="userRecording") @Nullable UserRecordingConfig userRecordingConfig, @JsonProperty(value="advanced") @Nullable AdvancedConfig advancedConfig, @JsonProperty(value="plugins") @Nullable ImmutableList<PluginConfig> pluginConfigs, @JsonProperty(value="instrumentation") @Nullable ImmutableList<InstrumentationConfig> instrumentationConfigs, @JsonProperty(value="gauges") @Nullable ImmutableList<GaugeConfig> gaugeConfigs, @JsonProperty(value="alerts") @Nullable ImmutableList<AlertConfig> alertConfigs) {
        Builder builder = Config.builder();
        if (generalConfig != null) {
            builder.generalConfig(generalConfig);
        }
        if (userInterfaceConfig != null) {
            builder.userInterfaceConfig(userInterfaceConfig);
        }
        if (storageConfig != null) {
            builder.storageConfig(storageConfig);
        }
        if (smtpConfig != null) {
            builder.smtpConfig(smtpConfig);
        }
        if (userRecordingConfig != null) {
            builder.userRecordingConfig(userRecordingConfig);
        }
        if (advancedConfig != null) {
            builder.advancedConfig(advancedConfig);
        }
        if (pluginConfigs != null) {
            builder.addAllPluginConfigs(pluginConfigs);
        }
        if (instrumentationConfigs != null) {
            builder.addAllInstrumentationConfigs(instrumentationConfigs);
        }
        if (gaugeConfigs != null) {
            builder.addAllGaugeConfigs(gaugeConfigs);
        }
        if (alertConfigs != null) {
            builder.addAllAlertConfigs(alertConfigs);
        }
        return builder.build();
    }

    static Config copyOf(ConfigBase instance) {
        if (instance instanceof Config) {
            return (Config)instance;
        }
        return Config.builder().generalConfig(instance.generalConfig()).userInterfaceConfig(instance.userInterfaceConfig()).storageConfig(instance.storageConfig()).smtpConfig(instance.smtpConfig()).userRecordingConfig(instance.userRecordingConfig()).advancedConfig(instance.advancedConfig()).addAllPluginConfigs(instance.pluginConfigs()).addAllInstrumentationConfigs(instance.instrumentationConfigs()).addAllGaugeConfigs(instance.gaugeConfigs()).addAllAlertConfigs(instance.alertConfigs()).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long NONDEFAULT_BIT_GENERAL_CONFIG = 1L;
        private static final long NONDEFAULT_BIT_USER_INTERFACE_CONFIG = 2L;
        private static final long NONDEFAULT_BIT_STORAGE_CONFIG = 4L;
        private static final long NONDEFAULT_BIT_SMTP_CONFIG = 8L;
        private static final long NONDEFAULT_BIT_USER_RECORDING_CONFIG = 16L;
        private static final long NONDEFAULT_BIT_ADVANCED_CONFIG = 32L;
        private long nondefaultBitset;
        @Nullable
        private GeneralConfig generalConfig;
        @Nullable
        private UserInterfaceConfig userInterfaceConfig;
        @Nullable
        private StorageConfig storageConfig;
        @Nullable
        private SmtpConfig smtpConfig;
        @Nullable
        private UserRecordingConfig userRecordingConfig;
        @Nullable
        private AdvancedConfig advancedConfig;
        private ImmutableList.Builder<PluginConfig> pluginConfigsBuilder = ImmutableList.builder();
        private ImmutableList.Builder<InstrumentationConfig> instrumentationConfigsBuilder = ImmutableList.builder();
        private ImmutableList.Builder<GaugeConfig> gaugeConfigsBuilder = ImmutableList.builder();
        private ImmutableList.Builder<AlertConfig> alertConfigsBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder generalConfig(GeneralConfig generalConfig) {
            this.checkNotIsSet(this.generalConfigIsSet(), "generalConfig");
            this.generalConfig = Preconditions.checkNotNull(generalConfig);
            this.nondefaultBitset |= 1L;
            return this;
        }

        public final Builder userInterfaceConfig(UserInterfaceConfig userInterfaceConfig) {
            this.checkNotIsSet(this.userInterfaceConfigIsSet(), "userInterfaceConfig");
            this.userInterfaceConfig = Preconditions.checkNotNull(userInterfaceConfig);
            this.nondefaultBitset |= 2L;
            return this;
        }

        public final Builder storageConfig(StorageConfig storageConfig) {
            this.checkNotIsSet(this.storageConfigIsSet(), "storageConfig");
            this.storageConfig = Preconditions.checkNotNull(storageConfig);
            this.nondefaultBitset |= 4L;
            return this;
        }

        public final Builder smtpConfig(SmtpConfig smtpConfig) {
            this.checkNotIsSet(this.smtpConfigIsSet(), "smtpConfig");
            this.smtpConfig = Preconditions.checkNotNull(smtpConfig);
            this.nondefaultBitset |= 8L;
            return this;
        }

        public final Builder userRecordingConfig(UserRecordingConfig userRecordingConfig) {
            this.checkNotIsSet(this.userRecordingConfigIsSet(), "userRecordingConfig");
            this.userRecordingConfig = Preconditions.checkNotNull(userRecordingConfig);
            this.nondefaultBitset |= 0x10L;
            return this;
        }

        public final Builder advancedConfig(AdvancedConfig advancedConfig) {
            this.checkNotIsSet(this.advancedConfigIsSet(), "advancedConfig");
            this.advancedConfig = Preconditions.checkNotNull(advancedConfig);
            this.nondefaultBitset |= 0x20L;
            return this;
        }

        public final Builder addPluginConfigs(PluginConfig element) {
            this.pluginConfigsBuilder.add((Object)element);
            return this;
        }

        public final Builder addPluginConfigs(PluginConfig ... elements) {
            this.pluginConfigsBuilder.add(elements);
            return this;
        }

        public final Builder addAllPluginConfigs(Iterable<? extends PluginConfig> elements) {
            this.pluginConfigsBuilder.addAll(elements);
            return this;
        }

        public final Builder addInstrumentationConfigs(InstrumentationConfig element) {
            this.instrumentationConfigsBuilder.add((Object)element);
            return this;
        }

        public final Builder addInstrumentationConfigs(InstrumentationConfig ... elements) {
            this.instrumentationConfigsBuilder.add(elements);
            return this;
        }

        public final Builder addAllInstrumentationConfigs(Iterable<? extends InstrumentationConfig> elements) {
            this.instrumentationConfigsBuilder.addAll(elements);
            return this;
        }

        public final Builder addGaugeConfigs(GaugeConfig element) {
            this.gaugeConfigsBuilder.add((Object)element);
            return this;
        }

        public final Builder addGaugeConfigs(GaugeConfig ... elements) {
            this.gaugeConfigsBuilder.add(elements);
            return this;
        }

        public final Builder addAllGaugeConfigs(Iterable<? extends GaugeConfig> elements) {
            this.gaugeConfigsBuilder.addAll(elements);
            return this;
        }

        public final Builder addAlertConfigs(AlertConfig element) {
            this.alertConfigsBuilder.add((Object)element);
            return this;
        }

        public final Builder addAlertConfigs(AlertConfig ... elements) {
            this.alertConfigsBuilder.add(elements);
            return this;
        }

        public final Builder addAllAlertConfigs(Iterable<? extends AlertConfig> elements) {
            this.alertConfigsBuilder.addAll(elements);
            return this;
        }

        public Config build() {
            return new Config(this);
        }

        private boolean generalConfigIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean userInterfaceConfigIsSet() {
            return (this.nondefaultBitset & 2L) != 0L;
        }

        private boolean storageConfigIsSet() {
            return (this.nondefaultBitset & 4L) != 0L;
        }

        private boolean smtpConfigIsSet() {
            return (this.nondefaultBitset & 8L) != 0L;
        }

        private boolean userRecordingConfigIsSet() {
            return (this.nondefaultBitset & 0x10L) != 0L;
        }

        private boolean advancedConfigIsSet() {
            return (this.nondefaultBitset & 0x20L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of Config is strict, attribute is already set: ".concat(name));
            }
        }
    }
}

