/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.config;

import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import org.glowroot.api.weaving.MethodModifier;
import org.glowroot.config.CaptureKind;
import org.glowroot.config.InstrumentationConfig;
import org.glowroot.config.Versions;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.Ordering;
import org.glowroot.shaded.google.common.primitives.Ints;
import org.immutables.value.Value;

@Value.Immutable
public abstract class InstrumentationConfigBase {
    public static final Ordering<InstrumentationConfig> ordering = new InstrumentationConfigOrdering();

    public abstract String className();

    public abstract String methodName();

    public abstract ImmutableList<String> methodParameterTypes();

    public String methodReturnType() {
        return "";
    }

    public abstract ImmutableList<MethodModifier> methodModifiers();

    public abstract CaptureKind captureKind();

    public String timerName() {
        return "";
    }

    public String traceEntryTemplate() {
        return "";
    }

    @Nullable
    public abstract Long traceEntryStackThresholdMillis();

    public boolean traceEntryCaptureSelfNested() {
        return false;
    }

    public String transactionType() {
        return "";
    }

    public String transactionNameTemplate() {
        return "";
    }

    public String transactionUserTemplate() {
        return "";
    }

    public abstract Map<String, String> transactionCustomAttributeTemplates();

    @Nullable
    public abstract Long traceStoreThresholdMillis();

    public String enabledProperty() {
        return "";
    }

    public String traceEntryEnabledProperty() {
        return "";
    }

    @JsonIgnore
    public String version() {
        return Versions.getVersion(this);
    }

    @JsonIgnore
    public boolean isTimerOrGreater() {
        return this.captureKind() == CaptureKind.TIMER || this.captureKind() == CaptureKind.TRACE_ENTRY || this.captureKind() == CaptureKind.TRANSACTION;
    }

    @JsonIgnore
    public boolean isTraceEntryOrGreater() {
        return this.captureKind() == CaptureKind.TRACE_ENTRY || this.captureKind() == CaptureKind.TRANSACTION;
    }

    @JsonIgnore
    public boolean isTransaction() {
        return this.captureKind() == CaptureKind.TRANSACTION;
    }

    @JsonIgnore
    public ImmutableList<String> validationErrors() {
        ArrayList<String> errors = Lists.newArrayList();
        if (this.className().isEmpty()) {
            errors.add("className is empty");
        }
        if (this.methodName().isEmpty()) {
            errors.add("methodName is empty");
        }
        if (this.isTimerOrGreater() && this.timerName().isEmpty()) {
            errors.add("timerName is empty");
        }
        if (this.captureKind() == CaptureKind.TRACE_ENTRY && this.traceEntryTemplate().isEmpty()) {
            errors.add("traceEntryTemplate is empty");
        }
        if (this.isTransaction() && this.transactionType().isEmpty()) {
            errors.add("transactionType is empty");
        }
        if (this.isTransaction() && this.transactionNameTemplate().isEmpty()) {
            errors.add("transactionNameTemplate is empty");
        }
        if (!this.timerName().matches("[a-zA-Z0-9 ]*")) {
            errors.add("timerName contains invalid characters: " + this.timerName());
        }
        return ImmutableList.copyOf(errors);
    }

    private static class InstrumentationConfigOrdering
    extends Ordering<InstrumentationConfig> {
        private InstrumentationConfigOrdering() {
        }

        @Override
        public int compare(@Nullable InstrumentationConfig left, @Nullable InstrumentationConfig right) {
            Preconditions.checkNotNull(left);
            Preconditions.checkNotNull(right);
            int compare = left.className().compareToIgnoreCase(right.className());
            if (compare != 0) {
                return compare;
            }
            compare = left.methodName().compareToIgnoreCase(right.methodName());
            if (compare != 0) {
                return compare;
            }
            compare = Ints.compare(left.methodParameterTypes().size(), right.methodParameterTypes().size());
            if (compare != 0) {
                return compare;
            }
            ImmutableList<String> leftParameterTypes = left.methodParameterTypes();
            ImmutableList<String> rightParameterTypes = right.methodParameterTypes();
            for (int i = 0; i < leftParameterTypes.size(); ++i) {
                compare = ((String)leftParameterTypes.get(i)).compareToIgnoreCase((String)rightParameterTypes.get(i));
                if (compare == 0) continue;
                return compare;
            }
            return 0;
        }
    }
}

