/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.config;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.GaugeConfigBase;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;

@ParametersAreNonnullByDefault
@Immutable
public final class MBeanAttribute
extends GaugeConfigBase.MBeanAttributeBase {
    private final String name;
    private final boolean everIncreasing;

    private MBeanAttribute(String name, boolean everIncreasing) {
        this.name = name;
        this.everIncreasing = everIncreasing;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="everIncreasing")
    public boolean everIncreasing() {
        return this.everIncreasing;
    }

    public final MBeanAttribute withName(String value) {
        if (this.name == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new MBeanAttribute(newValue, this.everIncreasing);
    }

    public final MBeanAttribute withEverIncreasing(boolean value) {
        if (this.everIncreasing == value) {
            return this;
        }
        boolean newValue = value;
        return new MBeanAttribute(this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof MBeanAttribute && this.equalTo((MBeanAttribute)another);
    }

    private boolean equalTo(MBeanAttribute another) {
        return this.name.equals(another.name) && this.everIncreasing == another.everIncreasing;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + Booleans.hashCode(this.everIncreasing);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("MBeanAttribute").add("name", this.name).add("everIncreasing", this.everIncreasing).toString();
    }

    @JsonCreator
    public static MBeanAttribute fromAllAttributes(@JsonProperty(value="name") @Nullable String name, @JsonProperty(value="everIncreasing") @Nullable Boolean everIncreasing) {
        Builder builder = MBeanAttribute.builder();
        if (name != null) {
            builder.name(name);
        }
        if (everIncreasing != null) {
            builder.everIncreasing(everIncreasing);
        }
        return builder.build();
    }

    public static MBeanAttribute of(String name, boolean everIncreasing) {
        return new MBeanAttribute(name, everIncreasing);
    }

    public static MBeanAttribute copyOf(GaugeConfigBase.MBeanAttributeBase instance) {
        if (instance instanceof MBeanAttribute) {
            return (MBeanAttribute)instance;
        }
        return MBeanAttribute.builder().name(instance.name()).everIncreasing(instance.everIncreasing()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_NAME = 1L;
        private static final long INITIALIZED_BIT_EVER_INCREASING = 2L;
        private long initializedBitset;
        @Nullable
        private String name;
        private boolean everIncreasing;

        private Builder() {
        }

        public final Builder name(String name) {
            this.checkNotIsSet(this.nameIsSet(), "name");
            this.name = Preconditions.checkNotNull(name);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder everIncreasing(boolean everIncreasing) {
            this.checkNotIsSet(this.everIncreasingIsSet(), "everIncreasing");
            this.everIncreasing = everIncreasing;
            this.initializedBitset |= 2L;
            return this;
        }

        public MBeanAttribute build() {
            this.checkRequiredAttributes();
            return new MBeanAttribute(this.name, this.everIncreasing);
        }

        private boolean nameIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean everIncreasingIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of MBeanAttribute is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.everIncreasingIsSet()) {
                attributes.add("everIncreasing");
            }
            return "Cannot build MBeanAttribute, some of required attributes are not set " + attributes;
        }
    }
}

