/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.config;

import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.PluginConfigBase;
import org.glowroot.config.PropertyValue;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Optional;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableMap;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;

@ParametersAreNonnullByDefault
@Immutable
public final class PluginConfig
extends PluginConfigBase {
    private final String id;
    private final boolean enabled;
    private final ImmutableMap<String, PropertyValue> properties;
    private final ImmutableMap<String, Boolean> booleanProperties;
    private final ImmutableMap<String, String> stringProperties;
    private final ImmutableMap<String, Optional<Double>> doubleProperties;
    private final String version;

    private PluginConfig(Builder builder) {
        this.id = builder.id;
        this.properties = builder.propertiesBuilder.build();
        this.enabled = builder.enabledIsSet() ? builder.enabled : super.enabled();
        this.booleanProperties = Preconditions.checkNotNull(super.booleanProperties());
        this.stringProperties = Preconditions.checkNotNull(super.stringProperties());
        this.doubleProperties = Preconditions.checkNotNull(super.doubleProperties());
        this.version = Preconditions.checkNotNull(super.version());
    }

    private PluginConfig(String id, boolean enabled, ImmutableMap<String, PropertyValue> properties) {
        this.id = id;
        this.enabled = enabled;
        this.properties = properties;
        this.booleanProperties = Preconditions.checkNotNull(super.booleanProperties());
        this.stringProperties = Preconditions.checkNotNull(super.stringProperties());
        this.doubleProperties = Preconditions.checkNotNull(super.doubleProperties());
        this.version = Preconditions.checkNotNull(super.version());
    }

    @Override
    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="enabled")
    public boolean enabled() {
        return this.enabled;
    }

    @JsonProperty(value="properties")
    public ImmutableMap<String, PropertyValue> properties() {
        return this.properties;
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="booleanProperties")
    public ImmutableMap<String, Boolean> booleanProperties() {
        return this.booleanProperties;
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="stringProperties")
    public ImmutableMap<String, String> stringProperties() {
        return this.stringProperties;
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="doubleProperties")
    public ImmutableMap<String, Optional<Double>> doubleProperties() {
        return this.doubleProperties;
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public final PluginConfig withId(String value) {
        if (this.id == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new PluginConfig(newValue, this.enabled, this.properties);
    }

    public final PluginConfig withEnabled(boolean value) {
        if (this.enabled == value) {
            return this;
        }
        boolean newValue = value;
        return new PluginConfig(this.id, newValue, this.properties);
    }

    public final PluginConfig withProperties(Map<String, ? extends PropertyValue> entries) {
        if (this.properties == entries) {
            return this;
        }
        ImmutableMap<String, PropertyValue> newValue = ImmutableMap.copyOf(entries);
        return new PluginConfig(this.id, this.enabled, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof PluginConfig && this.equalTo((PluginConfig)another);
    }

    private boolean equalTo(PluginConfig another) {
        return this.id.equals(another.id) && this.enabled == another.enabled && this.properties.equals(another.properties) && this.booleanProperties.equals(another.booleanProperties) && this.stringProperties.equals(another.stringProperties) && this.doubleProperties.equals(another.doubleProperties) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        h = h * 17 + Booleans.hashCode(this.enabled);
        h = h * 17 + this.properties.hashCode();
        h = h * 17 + this.booleanProperties.hashCode();
        h = h * 17 + this.stringProperties.hashCode();
        h = h * 17 + this.doubleProperties.hashCode();
        h = h * 17 + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("PluginConfig").add("id", this.id).add("enabled", this.enabled).add("properties", this.properties).add("booleanProperties", this.booleanProperties).add("stringProperties", this.stringProperties).add("doubleProperties", this.doubleProperties).add("version", this.version).toString();
    }

    @JsonCreator
    public static PluginConfig fromAllAttributes(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="enabled") @Nullable Boolean enabled, @JsonProperty(value="properties") @Nullable Map<String, PropertyValue> properties) {
        Builder builder = PluginConfig.builder();
        if (id != null) {
            builder.id(id);
        }
        if (enabled != null) {
            builder.enabled(enabled);
        }
        if (properties != null) {
            builder.putAllProperties(properties);
        }
        return builder.build();
    }

    public static PluginConfig copyOf(PluginConfigBase instance) {
        if (instance instanceof PluginConfig) {
            return (PluginConfig)instance;
        }
        return PluginConfig.builder().id(instance.id()).enabled(instance.enabled()).putAllProperties(instance.properties()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 1L;
        private static final long INITIALIZED_BIT_ID = 1L;
        private static final long NONDEFAULT_BIT_ENABLED = 1L;
        private long initializedBitset;
        private long nondefaultBitset;
        @Nullable
        private String id;
        private boolean enabled;
        private ImmutableMap.Builder<String, PropertyValue> propertiesBuilder = ImmutableMap.builder();

        private Builder() {
        }

        public final Builder id(String id) {
            this.checkNotIsSet(this.idIsSet(), "id");
            this.id = Preconditions.checkNotNull(id);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder enabled(boolean enabled) {
            this.checkNotIsSet(this.enabledIsSet(), "enabled");
            this.enabled = enabled;
            this.nondefaultBitset |= 1L;
            return this;
        }

        public final Builder putProperties(String key, PropertyValue value) {
            this.propertiesBuilder.put(key, value);
            return this;
        }

        public final Builder putProperties(Map.Entry<String, ? extends PropertyValue> entry) {
            this.propertiesBuilder.put(entry);
            return this;
        }

        public final Builder putAllProperties(Map<String, ? extends PropertyValue> entries) {
            this.propertiesBuilder.putAll(entries);
            return this;
        }

        public PluginConfig build() {
            this.checkRequiredAttributes();
            return new PluginConfig(this);
        }

        private boolean enabledIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean idIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of PluginConfig is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 1L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            return "Cannot build PluginConfig, some of required attributes are not set " + attributes;
        }
    }
}

