/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.config;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.PropertyDescriptorBase;
import org.glowroot.config.PropertyType;
import org.glowroot.config.PropertyValue;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;

@ParametersAreNonnullByDefault
@Immutable
public final class PropertyDescriptor
extends PropertyDescriptorBase {
    private final String name;
    private final PropertyType type;
    @Nullable
    private final PropertyValue defaultValue;
    private final boolean hidden;
    private final String label;
    private final String checkboxLabel;
    private final String description;

    private PropertyDescriptor(Builder builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.defaultValue = builder.defaultValue;
        this.label = builder.label;
        this.hidden = builder.hiddenIsSet() ? builder.hidden : super.hidden();
        this.checkboxLabel = builder.checkboxLabel != null ? builder.checkboxLabel : Preconditions.checkNotNull(super.checkboxLabel());
        this.description = builder.description != null ? builder.description : Preconditions.checkNotNull(super.description());
    }

    private PropertyDescriptor(String name, PropertyType type, @Nullable PropertyValue defaultValue, boolean hidden, String label, String checkboxLabel, String description) {
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
        this.hidden = hidden;
        this.label = label;
        this.checkboxLabel = checkboxLabel;
        this.description = description;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="type")
    public PropertyType type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="default")
    public PropertyValue defaultValue() {
        return this.defaultValue;
    }

    @Override
    @JsonProperty(value="hidden")
    public boolean hidden() {
        return this.hidden;
    }

    @Override
    @JsonProperty(value="label")
    public String label() {
        return this.label;
    }

    @Override
    @JsonProperty(value="checkboxLabel")
    public String checkboxLabel() {
        return this.checkboxLabel;
    }

    @Override
    @JsonProperty(value="description")
    public String description() {
        return this.description;
    }

    public final PropertyDescriptor withName(String value) {
        if (this.name == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new PropertyDescriptor(newValue, this.type, this.defaultValue, this.hidden, this.label, this.checkboxLabel, this.description);
    }

    public final PropertyDescriptor withType(PropertyType value) {
        if (this.type == value) {
            return this;
        }
        PropertyType newValue = Preconditions.checkNotNull(value);
        return new PropertyDescriptor(this.name, newValue, this.defaultValue, this.hidden, this.label, this.checkboxLabel, this.description);
    }

    public final PropertyDescriptor withDefaultValue(@Nullable PropertyValue value) {
        if (this.defaultValue == value) {
            return this;
        }
        PropertyValue newValue = value;
        return new PropertyDescriptor(this.name, this.type, newValue, this.hidden, this.label, this.checkboxLabel, this.description);
    }

    public final PropertyDescriptor withHidden(boolean value) {
        if (this.hidden == value) {
            return this;
        }
        boolean newValue = value;
        return new PropertyDescriptor(this.name, this.type, this.defaultValue, newValue, this.label, this.checkboxLabel, this.description);
    }

    public final PropertyDescriptor withLabel(String value) {
        if (this.label == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new PropertyDescriptor(this.name, this.type, this.defaultValue, this.hidden, newValue, this.checkboxLabel, this.description);
    }

    public final PropertyDescriptor withCheckboxLabel(String value) {
        if (this.checkboxLabel == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new PropertyDescriptor(this.name, this.type, this.defaultValue, this.hidden, this.label, newValue, this.description);
    }

    public final PropertyDescriptor withDescription(String value) {
        if (this.description == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new PropertyDescriptor(this.name, this.type, this.defaultValue, this.hidden, this.label, this.checkboxLabel, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof PropertyDescriptor && this.equalTo((PropertyDescriptor)another);
    }

    private boolean equalTo(PropertyDescriptor another) {
        return this.name.equals(another.name) && this.type.equals((Object)another.type) && Objects.equal(this.defaultValue, another.defaultValue) && this.hidden == another.hidden && this.label.equals(another.label) && this.checkboxLabel.equals(another.checkboxLabel) && this.description.equals(another.description);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.type.hashCode();
        h = h * 17 + Objects.hashCode(this.defaultValue);
        h = h * 17 + Booleans.hashCode(this.hidden);
        h = h * 17 + this.label.hashCode();
        h = h * 17 + this.checkboxLabel.hashCode();
        h = h * 17 + this.description.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("PropertyDescriptor").add("name", this.name).add("type", (Object)this.type).add("defaultValue", this.defaultValue).add("hidden", this.hidden).add("label", this.label).add("checkboxLabel", this.checkboxLabel).add("description", this.description).toString();
    }

    @JsonCreator
    public static PropertyDescriptor fromAllAttributes(@JsonProperty(value="name") @Nullable String name, @JsonProperty(value="type") @Nullable PropertyType type, @JsonProperty(value="default") @Nullable PropertyValue defaultValue, @JsonProperty(value="hidden") @Nullable Boolean hidden, @JsonProperty(value="label") @Nullable String label, @JsonProperty(value="checkboxLabel") @Nullable String checkboxLabel, @JsonProperty(value="description") @Nullable String description) {
        Builder builder = PropertyDescriptor.builder();
        if (name != null) {
            builder.name(name);
        }
        if (type != null) {
            builder.type(type);
        }
        if (defaultValue != null) {
            builder.defaultValue(defaultValue);
        }
        if (hidden != null) {
            builder.hidden(hidden);
        }
        if (label != null) {
            builder.label(label);
        }
        if (checkboxLabel != null) {
            builder.checkboxLabel(checkboxLabel);
        }
        if (description != null) {
            builder.description(description);
        }
        return builder.build();
    }

    public static PropertyDescriptor copyOf(PropertyDescriptorBase instance) {
        if (instance instanceof PropertyDescriptor) {
            return (PropertyDescriptor)instance;
        }
        return PropertyDescriptor.builder().name(instance.name()).type(instance.type()).defaultValue(instance.defaultValue()).hidden(instance.hidden()).label(instance.label()).checkboxLabel(instance.checkboxLabel()).description(instance.description()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 7L;
        private static final long INITIALIZED_BIT_NAME = 1L;
        private static final long INITIALIZED_BIT_TYPE = 2L;
        private static final long INITIALIZED_BIT_LABEL = 4L;
        private static final long NONDEFAULT_BIT_DEFAULT_VALUE = 1L;
        private static final long NONDEFAULT_BIT_HIDDEN = 2L;
        private static final long NONDEFAULT_BIT_CHECKBOX_LABEL = 4L;
        private static final long NONDEFAULT_BIT_DESCRIPTION = 8L;
        private long initializedBitset;
        private long nondefaultBitset;
        @Nullable
        private String name;
        @Nullable
        private PropertyType type;
        @Nullable
        private PropertyValue defaultValue;
        private boolean hidden;
        @Nullable
        private String label;
        @Nullable
        private String checkboxLabel;
        @Nullable
        private String description;

        private Builder() {
        }

        public final Builder name(String name) {
            this.checkNotIsSet(this.nameIsSet(), "name");
            this.name = Preconditions.checkNotNull(name);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder type(PropertyType type) {
            this.checkNotIsSet(this.typeIsSet(), "type");
            this.type = Preconditions.checkNotNull(type);
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder defaultValue(@Nullable PropertyValue defaultValue) {
            this.checkNotIsSet(this.defaultValueIsSet(), "defaultValue");
            this.defaultValue = defaultValue;
            this.nondefaultBitset |= 1L;
            return this;
        }

        public final Builder hidden(boolean hidden) {
            this.checkNotIsSet(this.hiddenIsSet(), "hidden");
            this.hidden = hidden;
            this.nondefaultBitset |= 2L;
            return this;
        }

        public final Builder label(String label) {
            this.checkNotIsSet(this.labelIsSet(), "label");
            this.label = Preconditions.checkNotNull(label);
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder checkboxLabel(String checkboxLabel) {
            this.checkNotIsSet(this.checkboxLabelIsSet(), "checkboxLabel");
            this.checkboxLabel = Preconditions.checkNotNull(checkboxLabel);
            this.nondefaultBitset |= 4L;
            return this;
        }

        public final Builder description(String description) {
            this.checkNotIsSet(this.descriptionIsSet(), "description");
            this.description = Preconditions.checkNotNull(description);
            this.nondefaultBitset |= 8L;
            return this;
        }

        public PropertyDescriptor build() {
            this.checkRequiredAttributes();
            return new PropertyDescriptor(this);
        }

        private boolean defaultValueIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean hiddenIsSet() {
            return (this.nondefaultBitset & 2L) != 0L;
        }

        private boolean checkboxLabelIsSet() {
            return (this.nondefaultBitset & 4L) != 0L;
        }

        private boolean descriptionIsSet() {
            return (this.nondefaultBitset & 8L) != 0L;
        }

        private boolean nameIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean typeIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean labelIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of PropertyDescriptor is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 7L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.labelIsSet()) {
                attributes.add("label");
            }
            return "Cannot build PropertyDescriptor, some of required attributes are not set " + attributes;
        }
    }
}

